/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership;

import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.event.DCSExternalEvent;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSAssertException;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsNotDefinedException;
import com.ibm.ws.dcs.common.exception.DCSMessageCorruptedException;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.vri.common.AddDefinedFailedException;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.ConfigurationComparator;
import com.ibm.ws.dcs.vri.common.Downcalls;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.LayerLinkage;
import com.ibm.ws.dcs.vri.common.MemberInfo;
import com.ibm.ws.dcs.vri.common.MismatchingParamRecord;
import com.ibm.ws.dcs.vri.common.Upcalls;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRICheckFailedException;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.event.VRIDownEvent;
import com.ibm.ws.dcs.vri.common.event.VRINotifyDownEvent;
import com.ibm.ws.dcs.vri.common.event.VRIUpEvent;
import com.ibm.ws.dcs.vri.common.impl.DCSIncomingMessage;
import com.ibm.ws.dcs.vri.common.impl.DCSMessageFactory;
import com.ibm.ws.dcs.vri.common.impl.DCSOutgoingMessage;
import com.ibm.ws.dcs.vri.common.impl.TimeScaler;
import com.ibm.ws.dcs.vri.common.nls.ConfigurationProblemEvent;
import com.ibm.ws.dcs.vri.common.nls.InconsistentDefinedSetEvent;
import com.ibm.ws.dcs.vri.common.nls.LongConfigurationProblemEvent;
import com.ibm.ws.dcs.vri.common.nls.ShortConfigurationProblemEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.FFDCDumper;
import com.ibm.ws.dcs.vri.membership.MBRAbstractLayer;
import com.ibm.ws.dcs.vri.membership.messages.MBRMessage;
import com.ibm.ws.dcs.vri.membership.util.MBRAbstractAlarm;
import com.ibm.ws.dcs.vri.membership.util.MBRDenialReason;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;

public class MBRConfigChecker
extends MBRAbstractLayer
implements Upcalls,
Downcalls,
LayerLinkage,
MBRAbstractAlarm.AlarmDoit {
    private final boolean DO_CHECK;
    private static final int DEFAULT_MSG_SIZE = 4096;
    private int definedHashCode;
    private final DCSMessageFactory factory;
    private final ConfigurationComparator configComparator;
    private MemberInfo[] defineMemberInfo;
    private int errorParams;
    private int warningParams;
    private String configVersion;
    private static final byte SHORTCHECKCONNECTMSG = 91;
    private static final byte LONGCHECKCONNECTMSG = 92;
    private static final int CONFIG = 1;
    private static final int DEFINEDSET = 2;
    private static final int BADLENGTH = -1;
    private static final int OKAY = -2;
    private boolean isInViewChange = false;
    private Downcalls down;
    private Upcalls up;
    private final MCCAlarm alarm;

    public MBRConfigChecker(Globals globals) {
        super(globals, "MCC");
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "MBRConfigChecker()", null).invoke();
        }
        this.configComparator = new ConfigurationComparator(globals);
        this.factory = globals.getDCSMessageFactory();
        this.DO_CHECK = globals.getConfigParamAsBoolean("CheckConfiguration");
        this.errorParams = this.configComparator.getErrorParamsHashcode();
        this.warningParams = this.configComparator.getWarningParamsHashcode();
        this.configVersion = this.configComparator.getConfiguratorVersion();
        this.alarm = new MCCAlarm(globals, this);
        if (DCSTraceBuffer.isExitEnabled(this.getTraceComponent())) {
            DCSTraceBuffer.exit(this, "MBRConfigChecker()", null).invoke();
        }
    }

    public void setUpperLayer(Upcalls upcalls) {
        if (DCSTraceBuffer.isEntryEnabled(this.getTraceComponent())) {
            DCSTraceBuffer.entry(this, "setUpperLayer()", null).invoke();
        }
        this.up = upcalls;
        if (DCSTraceBuffer.isExitEnabled(this.getTraceComponent())) {
            DCSTraceBuffer.exit(this, "setUpperLayer()", null).invoke();
        }
    }

    public void setDownLayer(Downcalls downcalls) {
        if (DCSTraceBuffer.isEntryEnabled(this.getTraceComponent())) {
            DCSTraceBuffer.entry(this, "setDownLayer()", null).invoke();
        }
        this.down = downcalls;
        if (DCSTraceBuffer.isExitEnabled(this.getTraceComponent())) {
            DCSTraceBuffer.exit(this, "setDownLayer()", null).invoke();
        }
    }

    public VRICheckFailedException check() {
        if (DCSTraceBuffer.isEntryEnabled(this.getTraceComponent())) {
            DCSTraceBuffer.entry(this, "check()", null).invoke();
        }
        return this.up.check();
    }

    public void doConnectMembers(VRIMemberDescription[] vRIMemberDescriptionArray) {
        MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "doConnectMembers", DCSTraceBuffer.propertyList().addProperty("connectedMembers", VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray)), null);
        this.updateMemberInfo();
        if (this.DO_CHECK && this.determineIfViewLeader()) {
            MBRLogger.dcsLogMUPActionEvent(this, "mcast(ShortCheckMsg)");
            this.createAndMcastShortCheckMessage(vRIMemberDescriptionArray, false);
        } else {
            MBRLogger.dcsLogMUPActionEvent(this, "DoNothing VL=false)");
        }
        this.up.connectMembers(vRIMemberDescriptionArray);
    }

    private void updateMemberInfo() {
        VRIMemberDescription[] vRIMemberDescriptionArray = this.membersMgr.getDefinedMembers(true);
        String[] stringArray = VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray);
        Object[] objectArray = null;
        try {
            objectArray = MemberInfo.getMemberInfo(stringArray, this.g.getMemberInfoManager());
        }
        catch (DCSMemberIsNotDefinedException dCSMemberIsNotDefinedException) {
            MBRLogger.dcsWarning((DCSTraceContext)this, "Undefined Member from memberInfoManager", dCSMemberIsNotDefinedException);
        }
        if (objectArray != null && objectArray.length != 0) {
            this.definedHashCode = MBRConfigChecker.getArrayHashcode(objectArray);
        } else {
            this.definedHashCode = 0;
            MBRLogger.dcsInternalInfo((DCSTraceContext)this, "updateMemberInfo()", "DefinedSet empty ???");
        }
        this.defineMemberInfo = objectArray;
    }

    public void suspectMembers(DCSSuspectEvent[] dCSSuspectEventArray) {
        this.up.suspectMembers(dCSSuspectEventArray);
    }

    public void currentOK(CCVersion cCVersion) {
        this.up.currentOK(cCVersion);
    }

    public void newViewOK(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        this.up.newViewOK(vRIMemberDescriptionArray, viewIdImpl, map);
        this.isInViewChange = false;
        if (map != null) {
            this.createAndMcastShortCheckMessage(null, false);
        }
    }

    public void deliver(VRIMessage vRIMessage) {
        if (vRIMessage.getOriginatorLayer() == 9) {
            byte by = vRIMessage.getMessageType();
            if (this.isInViewChange) {
                return;
            }
            if (this.membersMgr.isInView(vRIMessage.getSender())) {
                return;
            }
            try {
                if (by == 91) {
                    this.processShortCheckConnectMsg((DCSIncomingMessage)vRIMessage);
                    return;
                }
                if (by == 92) {
                    if (this.determineIfViewLeader()) {
                        this.processLongCheckConnectMsg((DCSIncomingMessage)vRIMessage);
                        return;
                    }
                    return;
                }
                if (this.membersMgr.isDenied(vRIMessage.getSender())) {
                    return;
                }
                MBRLogger.dcsWarning((DCSTraceContext)this, "deliver()", new DCSException("unknown message type: " + by));
                return;
            }
            catch (Exception exception) {
                MBRLogger.dcsWarning((DCSTraceContext)this, "deliver()", exception);
                return;
            }
            catch (Throwable throwable) {
                DCSException dCSException = new DCSException(throwable);
                MBRLogger.dcsWarning((DCSTraceContext)this, "deliver()", dCSException);
                return;
            }
        }
        this.up.deliver(vRIMessage);
    }

    public void requestTermination(DCSTerminationEvent dCSTerminationEvent) {
        if (DCSTraceBuffer.isEntryEnabled(this.getTraceComponent())) {
            DCSTraceBuffer.entry(this, "requestTermination()", null).invoke();
        }
        this.up.requestTermination(dCSTerminationEvent);
        if (DCSTraceBuffer.isExitEnabled(this.getTraceComponent())) {
            DCSTraceBuffer.exit(this, "requestTermination()", null).invoke();
        }
    }

    public void proposeAgreement(VRIMessage vRIMessage) throws DCSAssertException {
        this.up.proposeAgreement(vRIMessage);
    }

    public void deliverAgreed(VRIMessage vRIMessage) throws DCSAssertException {
        this.up.deliverAgreed(vRIMessage);
    }

    public void onVRIUpEvent(VRIUpEvent vRIUpEvent) {
        vRIUpEvent.handle("MCC", this.eventHandlers, this.up);
    }

    private void processLongCheckConnectMsg(DCSIncomingMessage dCSIncomingMessage) {
        String string = dCSIncomingMessage.readString();
        Serializable serializable = dCSIncomingMessage.readObject();
        Serializable serializable2 = dCSIncomingMessage.readObject();
        MemberInfo[] memberInfoArray = (MemberInfo[])dCSIncomingMessage.readObject();
        String string2 = dCSIncomingMessage.getSender();
        MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "processLongCheckConnectMsg()", DCSTraceBuffer.propertyList().addProperty("Sender", "memberName", string2), null);
        this.updateMemberInfo();
        if (!this.configVersion.equals(string)) {
            LongConfigurationProblemEvent longConfigurationProblemEvent = new LongConfigurationProblemEvent(this, string2, "Configuration Version", this.configVersion, string, 1);
            this.notifyAndLog(longConfigurationProblemEvent);
            MBRLogger.dcsLogMUPActionEvent(this, "config version not equal");
            return;
        }
        MismatchingParamRecord[] mismatchingParamRecordArray = this.configComparator.compareErrorParams((Serializable[])serializable);
        if (mismatchingParamRecordArray.length != 0) {
            for (int i = 0; i < mismatchingParamRecordArray.length; ++i) {
                LongConfigurationProblemEvent longConfigurationProblemEvent = new LongConfigurationProblemEvent(this, string2, mismatchingParamRecordArray[i].getParamName(), mismatchingParamRecordArray[i].getLocalVal(), mismatchingParamRecordArray[i].getRemoteVal(), 1);
                MBRLogger.dcsLogMUPActionEvent(this, "bad configuration parameter - error" + mismatchingParamRecordArray[i].getParamName());
                longConfigurationProblemEvent.invokeNLSTrace();
                this.down.onVRIDownEvent(new VRINotifyDownEvent(longConfigurationProblemEvent));
            }
            return;
        }
        mismatchingParamRecordArray = this.configComparator.compareWarningParams((Serializable[])serializable2);
        if (mismatchingParamRecordArray.length != 0) {
            for (int i = 0; i < mismatchingParamRecordArray.length; ++i) {
                LongConfigurationProblemEvent longConfigurationProblemEvent = new LongConfigurationProblemEvent(this, string2, mismatchingParamRecordArray[i].getParamName(), mismatchingParamRecordArray[i].getLocalVal(), mismatchingParamRecordArray[i].getRemoteVal(), 2);
                MBRLogger.dcsLogMUPActionEvent(this, "bad configuration parameter- warning" + mismatchingParamRecordArray[i].getParamName());
                longConfigurationProblemEvent.invokeNLSTrace();
                this.down.onVRIDownEvent(new VRINotifyDownEvent(longConfigurationProblemEvent));
            }
        }
        if (this.isDefineConflict(0, memberInfoArray) != -2) {
            MBRLogger.dcsLogMUPActionEvent(this, "defineSetConflict");
        }
        MBRLogger.dcsLogMUPActionEvent(this, "Finish Checks");
    }

    private void notifyAndLog(DCSExternalEvent dCSExternalEvent) {
        dCSExternalEvent.invokeNLSTrace();
        if (dCSExternalEvent instanceof DCSSuspectEvent) {
            this.up.suspectMembers(new DCSSuspectEvent[]{(DCSSuspectEvent)dCSExternalEvent});
        } else {
            this.down.onVRIDownEvent(new VRINotifyDownEvent(dCSExternalEvent));
        }
    }

    private void processShortCheckConnectMsg(DCSIncomingMessage dCSIncomingMessage) {
        int n;
        VRIMemberDescription[] vRIMemberDescriptionArray;
        ConfigurationProblemEvent configurationProblemEvent;
        int n2;
        String string = dCSIncomingMessage.getSender();
        int n3 = dCSIncomingMessage.readInt();
        if (!MBRConfigChecker.checkVersion(n3, n2 = this.membersMgr.getProtocolVersion())) {
            this.denyMember(string, 1, "DCS Version conflict");
            LongConfigurationProblemEvent longConfigurationProblemEvent = new LongConfigurationProblemEvent(this, string, "Configuration Version", String.valueOf((float)n2 / 1000.0f), String.valueOf((float)n3 / 1000.0f), 1);
            longConfigurationProblemEvent.invokeNLSTrace();
            return;
        }
        String string2 = dCSIncomingMessage.readString();
        int n4 = dCSIncomingMessage.readInt();
        int n5 = dCSIncomingMessage.readInt();
        boolean bl = dCSIncomingMessage.readBoolean();
        int n6 = dCSIncomingMessage.readInt();
        Object[] objectArray = (String[])dCSIncomingMessage.readObject();
        MemberInfo[] memberInfoArray = (MemberInfo[])dCSIncomingMessage.readObject();
        MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "processShortCheckConnectMsg()", DCSTraceBuffer.propertyList().addProperty("Sender", string), null);
        this.updateMemberInfo();
        if (!this.configVersion.equals(string2)) {
            this.denyMember(string, 1, "Config Version conflict");
            configurationProblemEvent = new LongConfigurationProblemEvent(this, string, "Configuration Version", this.configVersion, string2, 2);
            if (this.determineIfViewLeader()) {
                this.notifyAndLog(configurationProblemEvent);
            } else {
                configurationProblemEvent.invokeNLSTrace();
            }
        }
        if (n4 != this.errorParams) {
            this.denyMember(string, 1, "Config Parameters error");
            MBRLogger.dcsLogMUPActionEvent(this, "bad configuration - error");
            configurationProblemEvent = new ShortConfigurationProblemEvent(this, string, 3);
            if (this.determineIfViewLeader()) {
                this.notifyAndLog(configurationProblemEvent);
                vRIMemberDescriptionArray = new VRIMemberDescription[]{this.membersMgr.getDefinedMember(string)};
                this.createAndMcastLongCheckMessage(vRIMemberDescriptionArray);
            } else {
                configurationProblemEvent.invokeNLSTrace();
            }
        }
        if (n5 != this.warningParams) {
            MBRLogger.dcsLogMUPActionEvent(this, "bad configuration - warning");
            configurationProblemEvent = new ShortConfigurationProblemEvent(this, string, 2);
            if (this.determineIfViewLeader()) {
                this.notifyAndLog(configurationProblemEvent);
                vRIMemberDescriptionArray = new VRIMemberDescription[]{this.membersMgr.getDefinedMember(string)};
                this.createAndMcastLongCheckMessage(vRIMemberDescriptionArray);
            }
        }
        if ((n = this.isDefineConflict(n6, memberInfoArray)) != -2) {
            int n7 = 0;
            boolean bl2 = !this.checkIfIamInView((String[])objectArray, this.myName);
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.membersMgr.isDefined((String)objectArray[i])) {
                    objectArray[i] = null;
                    ++n7;
                    continue;
                }
                if (!bl2) continue;
                this.denyMember((String)objectArray[i], 2, "DefinedSet inconsistency");
            }
            String[] stringArray = (String[])Utils.removeNulls(objectArray, n7);
            if (stringArray != null && stringArray.length == 0) {
                stringArray = null;
            }
            MBRLogger.dcsLogMUPActionEvent(this, "defineSetConflict");
            InconsistentDefinedSetEvent inconsistentDefinedSetEvent = new InconsistentDefinedSetEvent(this, this.membersMgr.getDefinedMembers(true), string, memberInfoArray, stringArray);
            if (this.determineIfViewLeader()) {
                this.notifyAndLog(inconsistentDefinedSetEvent);
            } else {
                inconsistentDefinedSetEvent.invokeNLSTrace();
            }
        } else {
            boolean bl3 = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.membersMgr.isDenied((byte)9, objectArray[i])) continue;
                this.membersMgr.unDenyMember((byte)9, (String)objectArray[i]);
                MBRLogger.dcsLogMUPActionEvent(this, "unDeny+try to connect viewMembers[i]= " + (String)objectArray[i]);
                bl3 = true;
            }
            if (bl3) {
                this.up.connectMembers(null);
            }
        }
        if (bl) {
            MBRLogger.dcsLogMUPActionEvent(this, "ReplyRequested send shortCheckMsg");
            if (this.determineIfViewLeader()) {
                this.createAndMcastShortCheckMessage(null, false);
            }
        }
        MBRLogger.dcsLogMUPActionEvent(this, "FinishChecks");
    }

    private boolean checkIfIamInView(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean checkVersion(int n, int n2) {
        int n3 = n / 1000;
        int n4 = n2 / 1000;
        return n3 == n4;
    }

    private void denyMember(String string, int n, String string2) {
        if (this.myName.equals(string)) {
            MBRLogger.dcsInternalInfo((DCSTraceContext)this, "denyMember()", "tried to deny myself");
            return;
        }
        if (this.membersMgr.isDefined(string)) {
            if (n == 2) {
                this.membersMgr.denyMember(string, MBRDenialReason.createDefinedSetConfictDR(string2));
            }
            if (n == 1) {
                this.membersMgr.denyMember(string, MBRDenialReason.createConfigConfictDR(string2));
            }
        }
    }

    private int isDefineConflict(int n, MemberInfo[] memberInfoArray) {
        if (n == this.definedHashCode) {
            return -2;
        }
        if (memberInfoArray == null) {
            return -1;
        }
        if (memberInfoArray.length != this.defineMemberInfo.length) {
            return -1;
        }
        Arrays.sort(memberInfoArray);
        Arrays.sort(this.defineMemberInfo);
        for (int i = 0; i < this.defineMemberInfo.length; ++i) {
            if (this.defineMemberInfo[i].equals(memberInfoArray[i])) continue;
            return i;
        }
        return -2;
    }

    private void createAndMcastShortCheckMessage(VRIMemberDescription[] vRIMemberDescriptionArray, boolean bl) {
        MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "createAndMcastShortCheckMessage()", DCSTraceBuffer.propertyList().addProperty("IsReplyRequested", bl), null);
        DCSOutgoingMessage dCSOutgoingMessage = (DCSOutgoingMessage)this.factory.getMessage((byte)9, this.myName, 4096);
        dCSOutgoingMessage.writeInt(this.membersMgr.getProtocolVersion());
        dCSOutgoingMessage.writeString(this.configVersion);
        dCSOutgoingMessage.writeInt(this.errorParams);
        dCSOutgoingMessage.writeInt(this.warningParams);
        dCSOutgoingMessage.writeBoolean(bl);
        dCSOutgoingMessage.writeInt(this.definedHashCode);
        dCSOutgoingMessage.writeObject((Serializable)VRIMemberUtils.getMemberNames(this.membersMgr.getViewMembers()));
        dCSOutgoingMessage.writeObject((Serializable)this.defineMemberInfo);
        dCSOutgoingMessage.setMessageType((byte)91);
        if (vRIMemberDescriptionArray == null) {
            VRIMemberDescription[] vRIMemberDescriptionArray2 = this.membersMgr.getViewMinusDenied();
            VRIMemberDescription[] vRIMemberDescriptionArray3 = this.membersMgr.getConnectedMembers(false);
            vRIMemberDescriptionArray = VRIMemberUtils.minus(vRIMemberDescriptionArray3, vRIMemberDescriptionArray2);
        }
        MBRLogger.dcsLogMUPActionEvent(this, "mcast(ShortCheckMesssage) to " + VRIMemberUtils.toString(vRIMemberDescriptionArray));
        if (vRIMemberDescriptionArray != null & vRIMemberDescriptionArray.length > 0) {
            this.sendMSXMsg(vRIMemberDescriptionArray, dCSOutgoingMessage, MBRMessage.QOS_CONNECTED);
        }
    }

    private void sendMSXMsg(VRIMemberDescription[] vRIMemberDescriptionArray, DCSOutgoingMessage dCSOutgoingMessage, QoS.QOSMulticast qOSMulticast) {
        VRIMessage vRIMessage = null;
        try {
            vRIMessage = dCSOutgoingMessage.toVRIMessage();
        }
        catch (DCSMessageCorruptedException dCSMessageCorruptedException) {
            MBRLogger.dcsWarning((DCSTraceContext)this, "sendMSXMsg()", dCSMessageCorruptedException);
        }
        if (vRIMessage != null) {
            try {
                this.down.mcastMessage(vRIMessage, vRIMemberDescriptionArray, qOSMulticast, null);
            }
            catch (DCSInvalidParametersException dCSInvalidParametersException) {
                MBRLogger.dcsWarning((DCSTraceContext)this, "sendMSXMsg()", dCSInvalidParametersException);
            }
            catch (DCSTransportLayerException dCSTransportLayerException) {
                MBRLogger.dcsWarning((DCSTraceContext)this, "sendMSXMsg()", dCSTransportLayerException);
            }
        }
    }

    private void createAndMcastLongCheckMessage(VRIMemberDescription[] vRIMemberDescriptionArray) {
        MBRLogger.dcsLogMUPEvent(this, "createAndMcastLongCheckMessage()", "");
        DCSOutgoingMessage dCSOutgoingMessage = (DCSOutgoingMessage)this.factory.getMessage((byte)9, this.myName, 4096);
        dCSOutgoingMessage.writeString(this.configVersion);
        dCSOutgoingMessage.writeObject((Serializable)this.configComparator.getErrorParams());
        dCSOutgoingMessage.writeObject((Serializable)this.configComparator.getWarningParams());
        dCSOutgoingMessage.writeObject((Serializable)this.defineMemberInfo);
        dCSOutgoingMessage.setMessageType((byte)92);
        MBRLogger.dcsLogMUPActionEvent(this, "mcast(LongCheckMesssage)");
        this.sendMSXMsg(vRIMemberDescriptionArray, dCSOutgoingMessage, MBRMessage.QOS_CONNECTED);
    }

    public void completeCurrent(VRIMemberDescription[] vRIMemberDescriptionArray, CCVersion cCVersion) {
        this.isInViewChange = true;
        this.down.completeCurrent(vRIMemberDescriptionArray, cCVersion);
    }

    public void newView(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        this.down.newView(vRIMemberDescriptionArray, viewIdImpl, map);
    }

    public void mcastMessage(VRIMessage vRIMessage, QoS.QOSMulticast qOSMulticast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        this.down.mcastMessage(vRIMessage, qOSMulticast, viewIdImpl);
    }

    public void mcastMessage(VRIMessage vRIMessage, VRIMemberDescription[] vRIMemberDescriptionArray, QoS.QOSMulticast qOSMulticast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        this.down.mcastMessage(vRIMessage, vRIMemberDescriptionArray, qOSMulticast, viewIdImpl);
    }

    public void sendMessage(VRIMessage vRIMessage, VRIMemberDescription vRIMemberDescription, QoS.QOSUnicast qOSUnicast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        this.down.sendMessage(vRIMessage, vRIMemberDescription, qOSUnicast, viewIdImpl);
    }

    public void start(ViewIdImpl viewIdImpl) {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "start()", null).addProperty(viewIdImpl).invoke();
        }
        this.down.start(viewIdImpl);
        if (DCSTraceBuffer.isExitEnabled(this.TC)) {
            DCSTraceBuffer.exit(this, "start()", null).invoke();
        }
    }

    public void terminate(boolean bl, DCSTerminationEvent dCSTerminationEvent) {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "terminate()", null).addProperty(dCSTerminationEvent).invoke();
        }
        if (this.alarm != null) {
            this.alarm.cancelTimers();
        }
        this.down.terminate(bl, dCSTerminationEvent);
    }

    public void dumpAll(FFDCDumper fFDCDumper) {
        this.down.dumpAll(fFDCDumper);
    }

    public void updateBehavor(Map map) throws DCSAssertException {
        this.down.updateBehavor(map);
    }

    public void syncCurrent() throws DCSAssertException {
        this.down.syncCurrent();
    }

    public void unblock() throws DCSAssertException {
        this.down.unblock();
    }

    public void changeDefinedMembers(String[] stringArray, String[] stringArray2) throws AddDefinedFailedException {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "changeDefinedMembers()", null).invoke();
        }
        MBRLogger.dcsLogMUPEvent(this, "changeDefinedMembers()", "");
        this.down.changeDefinedMembers(stringArray, stringArray2);
        this.updateMemberInfo();
        if (this.determineIfViewLeader()) {
            MBRLogger.dcsLogMUPActionEvent(this, "mcast(ShortCheck) VL=true RequestReply=true");
            this.createAndMcastShortCheckMessage(null, true);
        } else {
            MBRLogger.dcsLogMUPActionEvent(this, "DoNothing");
        }
        if (DCSTraceBuffer.isExitEnabled(this.TC)) {
            DCSTraceBuffer.exit(this, "changeDefinedMembers()", null).invoke();
        }
    }

    public void onVRIDownEvent(VRIDownEvent vRIDownEvent) {
        this.down.onVRIDownEvent(vRIDownEvent);
    }

    private static int getArrayHashcode(Object[] objectArray) {
        Arrays.sort(objectArray);
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
        return vector.hashCode();
    }

    public void connectMembers(VRIMemberDescription[] vRIMemberDescriptionArray) {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "connectMembers()", null).invoke();
        }
        if (!this.alarm.isConnectAlarmSet()) {
            this.alarm.setConnectAlarm();
        }
    }

    public String getAlarmContextDescription(Object object) {
        if (object == this.alarm.CONNECT_ALARM_CONTEXT) {
            return "MCC.ConnectAlarm ";
        }
        if (object == null) {
            return "null ";
        }
        return "Unknown " + String.valueOf(object);
    }

    public void handleAlarm(Object object) {
        VRIMemberDescription[] vRIMemberDescriptionArray = VRIMemberUtils.minus(this.membersMgr.getConnectedMembers(true), this.membersMgr.getViewMembers());
        if (vRIMemberDescriptionArray != null && vRIMemberDescriptionArray.length != 0) {
            this.doConnectMembers(vRIMemberDescriptionArray);
        }
    }

    private class MCCAlarm
    extends MBRAbstractAlarm {
        static final int LAYER = 30;
        public final Object CONNECT_ALARM_CONTEXT;

        protected MCCAlarm(Globals globals, MBRAbstractAlarm.AlarmDoit alarmDoit) {
            super(globals, alarmDoit, 1, 30);
            this.CONNECT_ALARM_CONTEXT = new Integer(30);
        }

        protected void cancelTimers() {
            this.cancelConnectAlarm();
        }

        final void setConnectAlarm() {
            long l = this.g.getConfigParamAsInt("MEMBERSHIP_MAX_MERGE_TIMEOUT") * 1000;
            l = TimeScaler.scaleN2(l, MBRConfigChecker.this.membersMgr.getConnectedMembersMinusDeniedSize()) / 4L;
            this.setTimer(l, this.CONNECT_ALARM_CONTEXT);
        }

        final void cancelConnectAlarm() {
            this.cancelTimer(this.CONNECT_ALARM_CONTEXT);
        }

        boolean isConnectAlarmSet() {
            return this.isTimerSet(this.CONNECT_ALARM_CONTEXT);
        }
    }
}

