/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership;

import com.ibm.ws.dcs.common.ViewId;
import com.ibm.ws.dcs.common.event.DCSExternalEvent;
import com.ibm.ws.dcs.common.event.DCSNotifyChangeDefinedDone;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.vri.common.AddDefinedFailedException;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.Downcalls;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.event.VRINotifyDownEvent;
import com.ibm.ws.dcs.vri.common.event.VRIUpEvent;
import com.ibm.ws.dcs.vri.common.nls.AbstractNLSEvent;
import com.ibm.ws.dcs.vri.common.nls.NotifyChangeDefinedDone;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.FFDCDumper;
import com.ibm.ws.dcs.vri.membership.MBRState;
import com.ibm.ws.dcs.vri.membership.messages.AddMembersMsg;
import com.ibm.ws.dcs.vri.membership.messages.CompleteCurrentMsg;
import com.ibm.ws.dcs.vri.membership.messages.MBRMessage;
import com.ibm.ws.dcs.vri.membership.messages.MergeCCOKMsg;
import com.ibm.ws.dcs.vri.membership.messages.MergeNewViewMsg;
import com.ibm.ws.dcs.vri.membership.messages.NewViewMsg;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;
import java.util.ArrayList;
import java.util.Map;

public class MBRDo {
    static final int REDO = 1;
    public static final int MAX_MULTI_LENGTH = 2;
    protected Doit action;
    private boolean redo = false;
    private MBRMessage redoMsg = null;
    private VRIUpEvent redoEvent = null;
    private MBRState.ExtendedRole redoExtendedRole = null;
    private boolean newUpEvent = false;

    public MBRDo(MBRState.RoleName roleName, MBRState.Protocol protocol2, MBRMessage mBRMessage) {
        this.action = new DoReprocessMessage(mBRMessage);
        this.redo = true;
        this.redoMsg = mBRMessage;
        this.redoExtendedRole = new MBRState.ExtendedRole(roleName, protocol2);
    }

    public MBRDo(FFDCDumper fFDCDumper) {
        this.action = new DoDump(fFDCDumper);
    }

    public MBRDo(MBRState.RoleName roleName, MBRState.Protocol protocol2, VRIUpEvent vRIUpEvent) {
        this.action = new DoReprocessEvent(vRIUpEvent);
        this.redo = true;
        this.redoEvent = vRIUpEvent;
        this.redoExtendedRole = new MBRState.ExtendedRole(roleName, protocol2);
    }

    MBRDo(ViewIdImpl viewIdImpl) {
        this.action = new DoStart(viewIdImpl);
    }

    public MBRDo(DCSExternalEvent dCSExternalEvent) {
        this.action = dCSExternalEvent != null ? new DoNotify(dCSExternalEvent) : new DoNothing("Nothing to notify");
    }

    MBRDo() {
        this.action = new DoNothing("");
    }

    public MBRDo(String string) {
        this.action = new DoNothing(string);
    }

    public MBRDo(DCSTraceContext dCSTraceContext, String string, String string2, int n) {
        this.action = new DoNothing(string, dCSTraceContext, string2, n);
    }

    public MBRDo(DCSTraceContext dCSTraceContext, Exception exception, String string, String string2) {
        this.action = new DoNothing(dCSTraceContext, exception, string, string2);
    }

    MBRDo(DCSTraceContext dCSTraceContext, MBRMessage mBRMessage) {
        this.action = new DoMcastMessage(dCSTraceContext, mBRMessage);
    }

    MBRDo(VRIMemberDescription[] vRIMemberDescriptionArray, CCVersion cCVersion) {
        this.action = new DoCompleteCurrent(vRIMemberDescriptionArray, cCVersion);
    }

    MBRDo(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        this.action = new DoNewView(vRIMemberDescriptionArray, viewIdImpl, map);
    }

    MBRDo(boolean bl, DCSTerminationEvent dCSTerminationEvent) {
        this.action = new DoTerminate(bl, dCSTerminationEvent);
    }

    MBRDo(DCSTraceContext dCSTraceContext, String[] stringArray, String[] stringArray2, VRIMembersMGR vRIMembersMGR, int n, String[] stringArray3, boolean bl) {
        this.action = new DoChangeDefined(dCSTraceContext, stringArray, stringArray2, vRIMembersMGR, stringArray3, n, bl);
    }

    private MBRDo(MBRDo[] mBRDoArray) {
        this.action = new DoMultipleActions(mBRDoArray);
    }

    public MBRDo(VRIUpEvent vRIUpEvent) {
        this.redoEvent = vRIUpEvent;
        this.newUpEvent = true;
        this.action = new DoReprocessEvent(vRIUpEvent);
    }

    public static final MBRDo setAction(MBRDo mBRDo, MBRDo mBRDo2) {
        MBRLogger.dcsAssert(mBRDo == null, "Action is not Null i.e action Set Twice", "MBRDo", "setAction", " ");
        mBRDo = mBRDo2;
        return mBRDo;
    }

    public static MBRDo addAction(MBRDo mBRDo, MBRDo mBRDo2) {
        mBRDo = !MBRDo.isaDoNothingAction(mBRDo) ? new MBRDo(new MBRDo[]{mBRDo, mBRDo2}) : mBRDo2;
        return mBRDo;
    }

    void doIt(Downcalls downcalls) {
        this.action.doIt(downcalls);
    }

    public String toString() {
        return this.action.toString();
    }

    public boolean isNewUpEvent() {
        return this.newUpEvent;
    }

    public boolean isReprocessAction() {
        return this.redo;
    }

    public boolean isMultipleAction() {
        return this.action instanceof DoMultipleActions;
    }

    public Object getReprocessObject() {
        if (this.redo) {
            if (this.redoMsg != null) {
                return this.redoMsg;
            }
            if (this.redoEvent != null) {
                return this.redoEvent;
            }
        }
        return null;
    }

    public VRIUpEvent getUpEvent() {
        if (this.newUpEvent && this.redoEvent != null) {
            return this.redoEvent;
        }
        return null;
    }

    public MBRState.ExtendedRole reprocessRole(MBRState mBRState) {
        return this.redoExtendedRole.changeRole(mBRState);
    }

    public static boolean isaDoNothingAction(MBRDo mBRDo) {
        if (mBRDo == null) {
            return true;
        }
        return mBRDo.action instanceof DoNothing;
    }

    public boolean isStartAction() {
        return this.action instanceof DoStart;
    }

    public boolean isTerminateAction() {
        return this.action instanceof DoTerminate;
    }

    public ViewId getViewId() {
        if (this.action instanceof DoStart) {
            return ((DoStart)this.action).getInitialViewId();
        }
        if (this.action instanceof DoNewView) {
            return ((DoNewView)this.action).getViewId();
        }
        return null;
    }

    public boolean isNewViewAction() {
        return this.action instanceof DoNewView;
    }

    public boolean isAddMembersMsgAction() {
        return this.action instanceof DoMcastMessage && ((DoMcastMessage)this.action).getMsg() instanceof AddMembersMsg;
    }

    public boolean isCCMsgAction() {
        return this.action instanceof DoMcastMessage && ((DoMcastMessage)this.action).getMsg() instanceof CompleteCurrentMsg;
    }

    public boolean isMergeCCOKMsgAction() {
        return this.action instanceof DoMcastMessage && ((DoMcastMessage)this.action).getMsg() instanceof MergeCCOKMsg;
    }

    public boolean isNewViewMsgAction() {
        return this.action instanceof DoMcastMessage && ((DoMcastMessage)this.action).getMsg() instanceof NewViewMsg;
    }

    public boolean isMergeNewViewMsgAction() {
        return this.action instanceof DoMcastMessage && ((DoMcastMessage)this.action).getMsg() instanceof MergeNewViewMsg;
    }

    public MBRMessage getMsg() {
        if (this.action instanceof DoMcastMessage) {
            return ((DoMcastMessage)this.action).getMsg();
        }
        return null;
    }

    public boolean isChangeDefinedAction() {
        return this.action instanceof DoChangeDefined;
    }

    public int getContext() {
        if (this.action instanceof DoChangeDefined) {
            return ((DoChangeDefined)this.action).getContext();
        }
        return -1;
    }

    public MBRDo getNextAction(int n) {
        if (this.isMultipleAction()) {
            return ((DoMultipleActions)this.action).actions[n];
        }
        return null;
    }

    class DoMultipleActions
    implements Doit {
        final MBRDo[] actions;

        public DoMultipleActions(MBRDo[] mBRDoArray) {
            this.actions = mBRDoArray;
        }

        public void doIt(Downcalls downcalls) {
            for (int i = 0; i < this.actions.length; ++i) {
                if (this.actions[i] == null) continue;
                this.actions[i].doIt(downcalls);
            }
        }

        public String toString() {
            String string = null;
            string = "MBRDo=MULTIPLEACTIONS()\t" + Utils.toString(this.actions);
            return string;
        }
    }

    public class DoDump
    implements Doit {
        FFDCDumper dumper;

        public DoDump(FFDCDumper fFDCDumper) {
            this.dumper = fFDCDumper;
        }

        public void doIt(Downcalls downcalls) {
            downcalls.dumpAll(this.dumper);
        }

        public String toString() {
            String string = null;
            string = "MBRDo=dumpAll() " + this.dumper.getReason();
            return string;
        }
    }

    class DoReprocessEvent
    implements Doit {
        private VRIUpEvent event;

        public DoReprocessEvent(VRIUpEvent vRIUpEvent) {
            this.event = vRIUpEvent;
        }

        public void doIt(Downcalls downcalls) {
        }

        public String toString() {
            String string = null;
            String string2 = this.event.getClass().getName();
            int n = string2.lastIndexOf(".");
            string2 = string2.substring(n);
            string = "MBRDo=ReprocessEvent() " + string2 + "\t " + this.event.toString();
            return string;
        }
    }

    class DoReprocessMessage
    implements Doit {
        private MBRMessage msg;

        public DoReprocessMessage(MBRMessage mBRMessage) {
            this.msg = mBRMessage;
        }

        public void doIt(Downcalls downcalls) {
        }

        public String toString() {
            String string = null;
            String string2 = this.msg.getClass().getName();
            int n = string2.lastIndexOf(".");
            string2 = string2.substring(n);
            string = "MBRDo=ReprocessMessage() " + string2 + "\t " + this.msg.toString();
            return string;
        }
    }

    class DoNotify
    implements Doit {
        private DCSExternalEvent notifyEvent;

        public DoNotify(DCSExternalEvent dCSExternalEvent) {
            this.notifyEvent = dCSExternalEvent;
        }

        public String toString() {
            String string = null;
            string = "MBRDo=notifyExternalEvent()\t" + String.valueOf(this.notifyEvent);
            return string;
        }

        public void doIt(Downcalls downcalls) {
            if (this.notifyEvent != null) {
                if (!(this.notifyEvent instanceof DCSSuspectEvent)) {
                    this.notifyEvent.invokeNLSTrace();
                }
                VRINotifyDownEvent vRINotifyDownEvent = new VRINotifyDownEvent(this.notifyEvent);
                downcalls.onVRIDownEvent(vRINotifyDownEvent);
            }
        }
    }

    class DoChangeDefined
    implements Doit {
        private final boolean isCoreStack;
        private final int context;
        private final String[] remove;
        private final String[] add;
        private final DCSTraceContext dtc;
        private ArrayList failedMembers;
        private final VRIMembersMGR membersMgr;

        DoChangeDefined(DCSTraceContext dCSTraceContext, String[] stringArray, String[] stringArray2, VRIMembersMGR vRIMembersMGR, String[] stringArray3, int n, boolean bl) {
            this.isCoreStack = bl;
            this.add = stringArray;
            this.remove = stringArray2;
            this.context = n;
            this.membersMgr = vRIMembersMGR;
            this.dtc = dCSTraceContext;
            this.failedMembers = new ArrayList();
            for (int i = 0; i < stringArray3.length; ++i) {
                this.failedMembers.add(stringArray3[i]);
            }
        }

        public void doIt(Downcalls downcalls) {
            Object object;
            try {
                downcalls.changeDefinedMembers(this.add, this.remove);
            }
            catch (AddDefinedFailedException addDefinedFailedException) {
                object = addDefinedFailedException.getFailedMembers();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    this.failedMembers.add(object[i]);
                }
            }
            String[] stringArray = VRIMemberUtils.getMemberNames(this.membersMgr.getDefinedMembers(true));
            String[] stringArray2 = null;
            if (this.add != null) {
                DCSNotifyChangeDefinedDone.ChangeDefinedActionType changeDefinedActionType = DCSNotifyChangeDefinedDone.ADD_DEFINED;
                if (!this.failedMembers.isEmpty()) {
                    changeDefinedActionType = DCSNotifyChangeDefinedDone.ADD_DEFINED_WITH_FAILURES;
                    stringArray2 = this.failedMembers.toArray(new String[this.failedMembers.size()]);
                }
                object = new NotifyChangeDefinedDone(this.dtc, this.add, stringArray, changeDefinedActionType, this.context, stringArray2);
            } else {
                object = new NotifyChangeDefinedDone(this.dtc, this.remove, stringArray, DCSNotifyChangeDefinedDone.REMOVE_DEFINED, this.context);
            }
            ((AbstractNLSEvent)object).invokeNLSTrace();
            if (this.isCoreStack) {
                downcalls.onVRIDownEvent(new VRINotifyDownEvent((DCSExternalEvent)object));
            }
        }

        public String toString() {
            String string = null;
            string = "MBRDo=changeDefinedMembers()\t" + Utils.toString(this.add) + Utils.toString(this.remove) + " context= " + this.context;
            return string;
        }

        public int getContext() {
            return this.context;
        }
    }

    class DoStart
    implements Doit {
        private final ViewIdImpl initialViewId;

        public void doIt(Downcalls downcalls) {
            downcalls.start(this.initialViewId);
        }

        public DoStart(ViewIdImpl viewIdImpl) {
            this.initialViewId = viewIdImpl;
        }

        public String toString() {
            String string = null;
            string = "MBRDo=start()\t" + this.initialViewId;
            return string;
        }

        public ViewId getInitialViewId() {
            return this.initialViewId;
        }
    }

    class DoTerminate
    implements Doit {
        private final DCSTerminationEvent terminationReason;
        private final boolean grace;

        DoTerminate(boolean bl, DCSTerminationEvent dCSTerminationEvent) {
            this.grace = bl;
            this.terminationReason = dCSTerminationEvent;
        }

        public void doIt(Downcalls downcalls) {
            downcalls.terminate(this.grace, this.terminationReason);
        }

        public String toString() {
            String string = null;
            if (this.terminationReason != null && this.terminationReason.getTerminationReason() != null) {
                string = this.terminationReason.getTerminationReason().getMessage();
            }
            String string2 = null;
            string2 = "MBRDo=terminate()\t reason= " + string + " grace= " + this.grace;
            return string2;
        }
    }

    class DoNewView
    implements Doit {
        private final ViewIdImpl viewId;
        private final VRIMemberDescription[] newViewMembers;
        private final Map newConfigMap;

        DoNewView(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
            this.newViewMembers = vRIMemberDescriptionArray;
            this.viewId = viewIdImpl;
            this.newConfigMap = map;
        }

        public void doIt(Downcalls downcalls) {
            downcalls.newView(this.newViewMembers, this.viewId, this.newConfigMap);
        }

        public String toString() {
            String string = null;
            string = "MBRDo=newView()  \t" + VRIMemberUtils.toString(this.newViewMembers) + this.viewId + " isInternal = " + this.viewId.isInternalView();
            return string;
        }

        public ViewId getViewId() {
            return this.viewId;
        }
    }

    class DoCompleteCurrent
    implements Doit {
        private final CCVersion ccv;
        private final VRIMemberDescription[] failed;

        DoCompleteCurrent(VRIMemberDescription[] vRIMemberDescriptionArray, CCVersion cCVersion) {
            this.failed = vRIMemberDescriptionArray;
            this.ccv = cCVersion;
        }

        public void doIt(Downcalls downcalls) {
            downcalls.completeCurrent(this.failed, this.ccv);
        }

        public String toString() {
            String string = null;
            string = "MBRDo=completeCurrent()  \t" + VRIMemberUtils.toString(this.failed) + this.ccv;
            return string;
        }
    }

    class DoMcastMessage
    implements Doit {
        private final MBRMessage msg;
        private final DCSTraceContext dtc;

        DoMcastMessage(DCSTraceContext dCSTraceContext, MBRMessage mBRMessage) {
            this.dtc = dCSTraceContext;
            this.msg = mBRMessage;
        }

        public void doIt(Downcalls downcalls) {
            try {
                this.msg.mcast(downcalls);
            }
            catch (DCSInvalidParametersException dCSInvalidParametersException) {
                downcalls.terminate(true, new TerminationEvent(this.dtc, "mcastMessage()", dCSInvalidParametersException));
            }
            catch (DCSTransportLayerException dCSTransportLayerException) {
                downcalls.terminate(true, new TerminationEvent(this.dtc, "mcastMessage()", dCSTransportLayerException));
            }
        }

        public String toString() {
            String string = null;
            String string2 = this.msg.getClass().getName();
            int n = string2.lastIndexOf(".");
            string2 = string2.substring(n);
            string = "MBRDo=mcast() " + string2 + "\t " + this.msg;
            return string;
        }

        public MBRMessage getMsg() {
            return this.msg;
        }
    }

    class DoNothing
    implements Doit {
        private final String explanation;
        private final DCSTraceContext dtc;
        private final String methodName;
        private final int type;
        private final Exception exception;

        DoNothing(String string) {
            this.explanation = string;
            this.dtc = null;
            this.methodName = null;
            this.type = -1;
            this.exception = null;
        }

        public DoNothing(DCSTraceContext dCSTraceContext, Exception exception, String string, String string2) {
            this.explanation = string2;
            this.dtc = dCSTraceContext;
            this.methodName = string;
            this.type = 1;
            this.exception = exception;
        }

        public DoNothing(String string, DCSTraceContext dCSTraceContext, String string2, int n) {
            this.explanation = string;
            this.dtc = dCSTraceContext;
            this.methodName = string2;
            this.type = n;
            this.exception = n == 1 ? new DCSException(string) : null;
        }

        public void doIt(Downcalls downcalls) {
            if (this.dtc != null && !DCSTraceBuffer.isFocustEventEnabled(this.dtc.getTraceComponent())) {
                switch (this.type) {
                    case 0: {
                        MBRLogger.dcsInternalInfo(this.dtc, this.methodName, this.explanation);
                        break;
                    }
                    case 1: {
                        MBRLogger.dcsWarning(this.dtc, this.methodName, this.exception);
                        break;
                    }
                }
            }
        }

        public String toString() {
            String string = null;
            string = "MBRDo=Nothing \t" + this.explanation;
            return string;
        }
    }

    protected static interface Doit {
        public void doIt(Downcalls var1);
    }
}

