/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.dcs.common.StateVersion;
import com.ibm.ws.dcs.common.ViewId;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIState;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.nls.MBRSyncStart;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.FFDCDumper;
import com.ibm.ws.dcs.vri.common.util.ThresholdCounter;
import com.ibm.ws.dcs.vri.membership.MBRAlarm;
import com.ibm.ws.dcs.vri.membership.MBRStateConstants;
import com.ibm.ws.dcs.vri.membership.MBRStateXchg;
import com.ibm.ws.dcs.vri.membership.messages.CompleteCurrentMsg;
import com.ibm.ws.dcs.vri.membership.messages.MergeCCOKMsg;
import com.ibm.ws.dcs.vri.membership.messages.MergeNewViewMsg;
import com.ibm.ws.dcs.vri.membership.messages.MergeNoMsg;
import com.ibm.ws.dcs.vri.membership.messages.NewViewMsg;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class MBRState
implements VRIState,
DCSTraceContext {
    private static final int NUMROLES = 3;
    private static final int NUMMINORPHASES = 6;
    private static final int NUMMAJORPHASES = 4;
    private static final int MAJOR = 0;
    private final String stackName;
    private static final TraceComponent TC = Tr.register(MBRState.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private static final long MIN_DUMP_INTERVAL = 3600000L;
    private static final int MAX_DUMP_COUNT__PER_INTERVAL = 20;
    private final MBRStateXchg stateExchanger;
    private final VRIMemberDescription thisMember;
    protected final String myName;
    private final byte layer = (byte)10;
    protected final VRIMembersMGR membersMgr;
    private MBRAlarm alarm;
    private Protocol protocol = MBRStateConstants.INITIALIZING;
    private RoleName roleName = MBRStateConstants.MEMBER;
    private Phase[] phase = new Phase[3];
    private MinorPhase[] minorPhase = new MinorPhase[3];
    private ViewIdImpl currentViewId;
    private long viewChangeStartTime;
    private LinkedList ccQueue = new LinkedList();
    private VRIMemberDescription viewLeader;
    private VRIMemberDescription mergeLeader;
    private CCVersion sentCCV;
    private CCVersion receivedCCV;
    private int nextProtocolVersion = 0;
    private StateVersion nextProtocolVersionContext;
    private int dumpCount = 0;
    private long lastDumpTime = 0L;
    private VRIMemberDescription[] receivedFailedList;
    private VRIMemberDescription[] ccoksYES;
    private VRIMemberDescription[] ccoksNO;
    private VRIMemberDescription[] sentFailedList;
    private long receivedMergeLeaderContext = -2L;
    private VRIMemberDescription[] mccoksYES;
    private VRIMemberDescription[] mccoksNO;
    private int mergeViewIdNum = 0;
    private VRIMemberDescription[] potentialMergeViewMembers;
    private long sentMergeLeaderContext = -1L;
    private VRIMemberDescription[] mccoksVL;
    private boolean externalViewsStarted = true;
    private List mergeNoThresholdCounters;

    protected MBRState(Globals globals) {
        this.membersMgr = globals.getVRIMembersMgr();
        this.thisMember = this.membersMgr.getThisMember();
        this.myName = this.thisMember.getName();
        this.stackName = this.membersMgr.getThisStackName();
        StateBlob stateBlob = (StateBlob)globals.getConfigParam("StateBlobInitialConfiguration");
        this.stateExchanger = new MBRStateXchg(this.membersMgr, stateBlob);
        this.reset();
        this.protocol = MBRStateConstants.INITIALIZING;
        this.mergeNoThresholdCounters = MergeNoMsg.makeThresholdCounter();
    }

    private void reset() {
        this.protocol = MBRStateConstants.MESSAGING;
        this.roleName = MBRStateConstants.MEMBER;
        this.phase[0] = MBRStateConstants.NORMAL;
        this.minorPhase[0] = MBRStateConstants.NORMAL.getFirstMinorPhase(0);
        this.phase[1] = MBRStateConstants.NORMAL;
        this.minorPhase[1] = MBRStateConstants.NORMAL.getFirstMinorPhase(1);
        this.phase[2] = MBRStateConstants.NORMAL;
        this.minorPhase[2] = MBRStateConstants.NORMAL.getFirstMinorPhase(2);
        this.sentCCV = null;
        this.receivedCCV = null;
        this.nextProtocolVersion = 0;
        this.nextProtocolVersionContext = null;
        if (this.getAlarm() != null) {
            this.getAlarm().cancelMBTimer();
        }
    }

    private void resetMergeLeaderState() {
        this.mccoksYES = null;
        this.mccoksNO = null;
        this.mccoksVL = null;
        this.mergeViewIdNum = 0;
        this.potentialMergeViewMembers = null;
        this.getAlarm().cancelMLTimer();
        this.sentMergeLeaderContext = -1L;
    }

    private void resetViewLeaderState() {
        this.ccoksYES = null;
        this.ccoksNO = null;
        this.setSentFailedList(null);
        this.getAlarm().cancelVLTimer();
        this.getAlarm().cancelVLCCTimer();
        this.receivedMergeLeaderContext = -2L;
    }

    public String toString() {
        String string = " ";
        string = this.getProtocol().toShortString() + " " + this.roleName.toShortString() + " " + this.getMajorPhase(MBRStateConstants.MEMBER).toShortString() + " " + this.getMajorPhase(MBRStateConstants.VIEWLEADER).toShortString() + " " + this.getMajorPhase(MBRStateConstants.MERGELEADER).toShortString();
        return string;
    }

    void dump(FFDCDumper fFDCDumper) {
        fFDCDumper.writeLine("==========MemberShipState");
        fFDCDumper.writeLine("State", this.toString());
        fFDCDumper.writeLine("===Member");
        fFDCDumper.writeLine("MergeLeader", this.mergeLeader != null ? this.mergeLeader.getName() : "null");
        fFDCDumper.writeLine("ViewLeader", this.viewLeader != null ? this.viewLeader.getName() : "null");
        fFDCDumper.writeLine("ViewChangeStartTime", Long.toString(this.viewChangeStartTime));
        fFDCDumper.writeLine("sentCCV", String.valueOf(this.getSentCCV()));
        fFDCDumper.writeLine("receivedCCV", String.valueOf(this.receivedCCV));
        fFDCDumper.writeLine("nextProtocolVersion", Integer.toString(this.nextProtocolVersion));
        fFDCDumper.writeLine("nextProtocolVersionContext", String.valueOf(this.nextProtocolVersionContext));
        fFDCDumper.writeLine("receivedFailedList", VRIMemberUtils.toString(this.receivedFailedList));
        fFDCDumper.writeLine("lastDumpTime", Long.toString(this.lastDumpTime));
        fFDCDumper.writeLine("dumpCount", Integer.toString(this.dumpCount));
        fFDCDumper.writeLine("===ViewLeader");
        fFDCDumper.writeLine("sentFailedList", VRIMemberUtils.toString(this.sentFailedList));
        fFDCDumper.writeLine("ccoksNO", VRIMemberUtils.toString(this.ccoksNO));
        fFDCDumper.writeLine("ccoksYES", VRIMemberUtils.toString(this.ccoksYES));
        fFDCDumper.writeLine("receivedMergeLeaderContext", Long.toString(this.receivedMergeLeaderContext));
        fFDCDumper.writeLine("===MergeLeader");
        fFDCDumper.writeLine("mccoksNO", VRIMemberUtils.toString(this.mccoksNO));
        fFDCDumper.writeLine("mccoksYES", VRIMemberUtils.toString(this.mccoksYES));
        fFDCDumper.writeLine("potentialViewMembers", VRIMemberUtils.toString(this.potentialMergeViewMembers));
        fFDCDumper.writeLine("mccoksVL", VRIMemberUtils.toString(this.mccoksVL));
        fFDCDumper.writeLine("sentMergeLeaderContext", Long.toString(this.sentMergeLeaderContext));
        fFDCDumper.writeLine("mergeViewIdNum", Integer.toString(this.mergeViewIdNum));
    }

    public void updateMinorState(byte by) {
        this.updateMinorState(this.roleName, by);
    }

    public void updateMinorState(RoleName roleName, byte by) {
    }

    private void setProtocol(Protocol protocol2) {
        boolean bl = false;
        MBRLogger.dcsLogStateChange(this, "setProtocol()", this.protocol.toString(), protocol2.toString());
        if (this.protocol == MBRStateConstants.TERMINATION) {
            // empty if block
        }
        if (this.protocol.getIndex() == 1) {
            bl = true;
        }
        this.protocol = protocol2;
        switch (this.protocol.getIndex()) {
            case 0: {
                this.reset();
                break;
            }
            case 5: {
                this.getAlarm().cancelTimers();
                break;
            }
            case 1: {
                this.reset();
                break;
            }
            case 2: 
            case 3: {
                if (!bl) break;
                this.viewChangeStartTime = System.currentTimeMillis();
            }
        }
    }

    public final boolean isState(RoleName roleName, Phase phase) {
        return phase == this.phase[roleName.getIndex()];
    }

    public int getState() {
        return this.phase[this.roleName.getIndex()].getIndex();
    }

    void updateMajorState(RoleName roleName, Phase phase) {
        MBRLogger.dcsLogStateChange(this, "updateMajorState()", roleName.toString() + " " + this.phase[roleName.getIndex()].toString(), phase.toString());
        this.phase[roleName.getIndex()] = phase;
    }

    private void setRole(RoleName roleName, Protocol protocol2) {
        this.roleName = roleName;
        this.setProtocol(protocol2);
    }

    void newView(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, VRIMemberDescription vRIMemberDescription) {
        this.currentViewId = viewIdImpl;
        if (!this.externalViewsStarted && !viewIdImpl.isInternalView()) {
            this.externalViewsStarted = true;
        }
        this.viewLeader = vRIMemberDescription;
        MBRLogger.dcsAssert(this.viewLeader != null, "viewLeader is null", "MBRState", "newView()", this.stackName);
        this.mergeLeader = null;
        this.sentCCV = null;
        this.setReceivedFailedListAndCCV(null, null);
    }

    Phase getMajorPhase(RoleName roleName) {
        return this.phase[roleName.getIndex()];
    }

    final int getMajorPhaseIndex(RoleName roleName) {
        return this.phase[roleName.getIndex()].getIndex();
    }

    VRIMemberDescription getViewLeader() {
        return this.viewLeader;
    }

    ViewIdImpl getViewId() {
        return this.currentViewId;
    }

    Protocol getProtocol() {
        return this.protocol;
    }

    CCVersion getReceivedCCV() {
        return this.receivedCCV;
    }

    CCVersion getSentCCV() {
        return this.sentCCV;
    }

    void registerCCOKNO(VRIMemberDescription[] vRIMemberDescriptionArray) {
        this.ccoksNO = VRIMemberUtils.unification(this.ccoksNO, VRIMemberUtils.intersection(vRIMemberDescriptionArray, this.membersMgr.getViewMembers()));
        this.ccoksYES = VRIMemberUtils.minus(this.ccoksYES, this.ccoksNO);
    }

    public VRIMemberDescription[] getMergeCCOKDeniedList() {
        return VRIMemberUtils.copy(this.mccoksNO);
    }

    void registerCCOK(String string, VRIMemberDescription[] vRIMemberDescriptionArray) {
        VRIMemberDescription[] vRIMemberDescriptionArray2 = new VRIMemberDescription[]{this.membersMgr.getViewMember(string)};
        this.ccoksYES = VRIMemberUtils.unification(this.ccoksYES, vRIMemberDescriptionArray2);
        this.registerCCOKNO(vRIMemberDescriptionArray);
    }

    boolean receivedAllCCOK() {
        VRIMemberDescription[] vRIMemberDescriptionArray = VRIMemberUtils.unification(this.ccoksYES, this.ccoksNO);
        return VRIMemberUtils.equals(this.membersMgr.getViewMembers(), vRIMemberDescriptionArray);
    }

    void registerMergeCCOKNO(VRIMemberDescription[] vRIMemberDescriptionArray) {
        this.mccoksNO = VRIMemberUtils.unification(this.mccoksNO, vRIMemberDescriptionArray);
    }

    void registerMergeCCOK(String string, VRIMemberDescription[] vRIMemberDescriptionArray, VRIMemberDescription[] vRIMemberDescriptionArray2, ViewId viewId) {
        this.mergeViewIdNum = Math.max(this.mergeViewIdNum, viewId.getViewMajorNumber());
        this.mccoksYES = VRIMemberUtils.unification(this.mccoksYES, vRIMemberDescriptionArray);
        this.mccoksNO = VRIMemberUtils.unification(this.mccoksNO, vRIMemberDescriptionArray2);
        VRIMemberDescription[] vRIMemberDescriptionArray3 = this.membersMgr.getDefinedMembers(new String[]{string});
        this.mccoksVL = VRIMemberUtils.unification(this.mccoksVL, vRIMemberDescriptionArray3);
    }

    public void setMergeViewToNull() {
        this.mccoksNO = this.potentialMergeViewMembers;
        this.mccoksYES = new VRIMemberDescription[0];
    }

    boolean receivedAllMergeCCOK() {
        VRIMemberDescription[] vRIMemberDescriptionArray = VRIMemberUtils.unification(this.mccoksYES, this.mccoksNO);
        return VRIMemberUtils.contains(vRIMemberDescriptionArray, this.potentialMergeViewMembers);
    }

    NewViewMsg prepareNewViewMsgForSplit() {
        NewViewMsg newViewMsg = new NewViewMsg("SPLIT", this.ccoksYES, this.getNextViewId(), null, this.myName, this.membersMgr);
        this.updateMajorState(MBRStateConstants.VIEWLEADER, MBRStateConstants.NORMAL);
        this.changeRole(MBRStateConstants.MEMBER, MBRStateConstants.SPLIT);
        return newViewMsg;
    }

    private ViewIdImpl getNextViewId() {
        int n = this.currentViewId.getViewMajorNumber() + 1;
        return new ViewIdImpl(n, this.viewLeader.getName());
    }

    MergeCCOKMsg prepareMergeCCOKMsg() {
        MergeCCOKMsg mergeCCOKMsg = new MergeCCOKMsg(this.ccoksYES, this.ccoksNO, this.currentViewId, this.mergeLeader, this.stateExchanger.getVLResponse(), this.getReceivedMergeLeaderContext(), this.myName, this.membersMgr);
        this.updateMajorState(MBRStateConstants.VIEWLEADER, MBRStateConstants.SYNCED);
        this.getAlarm().setVLTimer();
        if (this.iAmMergeLeader()) {
            this.getAlarm().setMLTimer();
        }
        return mergeCCOKMsg;
    }

    boolean isProtocol(Protocol protocol2) {
        return this.protocol == protocol2;
    }

    VRIMemberDescription getMergeLeader() {
        return this.mergeLeader;
    }

    CompleteCurrentMsg prepareCCMsg(DCSTraceContext dCSTraceContext) {
        VRIMemberDescription[] vRIMemberDescriptionArray = VRIMemberUtils.intersection(this.membersMgr.getViewMembers(), this.membersMgr.getDeniedMembers((byte)10, true));
        if (this.getSentFailedList() == null || VRIMemberUtils.minus(vRIMemberDescriptionArray, this.getSentFailedList()).length != 0) {
            this.setSentFailedList(vRIMemberDescriptionArray);
            CompleteCurrentMsg completeCurrentMsg = new CompleteCurrentMsg(this.getSentFailedList(), this.getNextCCVersion(), this.myName, this.membersMgr);
            this.updateMajorState(MBRStateConstants.VIEWLEADER, MBRStateConstants.SYNCING);
            this.ccoksYES = null;
            this.ccoksNO = null;
            if (this.getSentFailedList() == null || this.getSentFailedList().length == 0) {
                new MBRSyncStart(dCSTraceContext).invokeNLSTrace();
            } else {
                String[] stringArray = VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray);
                if (stringArray.length < 10) {
                    new MBRSyncStart(dCSTraceContext, stringArray).invokeNLSTrace();
                } else {
                    new MBRSyncStart(dCSTraceContext, this.myName, stringArray.length).invokeNLSTrace();
                }
            }
            return completeCurrentMsg;
        }
        return null;
    }

    private CCVersion getNextCCVersion() {
        CCVersion cCVersion;
        int n = 1;
        int n2 = this.membersMgr.getViewMemberIndex(this.viewLeader.getName());
        if (this.getSentCCV() != null && n2 == this.sentCCV.getLeader()) {
            n = this.sentCCV.getCCNumber() + 1;
        }
        this.sentCCV = cCVersion = new CCVersion(this.currentViewId, n2, n);
        return this.sentCCV;
    }

    byte getLayer() {
        return 10;
    }

    boolean determineIfMergeLeader(VRIMemberDescription[] vRIMemberDescriptionArray) {
        boolean bl = false;
        if (vRIMemberDescriptionArray != null && vRIMemberDescriptionArray.length != 0) {
            this.mergeLeader = VRIMemberUtils.pickLeaderFromUnsorted(vRIMemberDescriptionArray);
            if (this.mergeLeader.getName().equals(this.myName)) {
                this.potentialMergeViewMembers = vRIMemberDescriptionArray;
                bl = true;
            }
        }
        return bl;
    }

    final void changeRole(RoleName roleName) {
        this.changeRole(roleName, this.getProtocol());
    }

    final void changeRole(RoleName roleName, Protocol protocol2) {
        MBRLogger.dcsLogStateChange(this, "changeRole()", this.roleName.toString() + "  " + this.protocol.toString(), roleName.toString() + "  " + protocol2.toString());
        if (roleName == MBRStateConstants.MEMBER && this.roleName == MBRStateConstants.VIEWLEADER) {
            this.resetViewLeaderState();
        }
        if (roleName == MBRStateConstants.MEMBER && this.roleName == MBRStateConstants.MERGELEADER) {
            this.resetMergeLeaderState();
            this.resetViewLeaderState();
        }
        if (roleName == MBRStateConstants.VIEWLEADER && this.roleName == MBRStateConstants.MERGELEADER) {
            this.resetMergeLeaderState();
        }
        if (roleName == MBRStateConstants.VIEWLEADER && this.roleName == MBRStateConstants.MEMBER) {
            this.viewLeader = this.thisMember;
            this.setSentFailedList(this.getReceivedFailedList());
        }
        if (roleName == MBRStateConstants.MERGELEADER && this.roleName == MBRStateConstants.MEMBER) {
            this.viewLeader = this.thisMember;
            this.setSentFailedList(this.getReceivedFailedList());
            this.mergeLeader = this.thisMember;
        }
        if (roleName == MBRStateConstants.MERGELEADER && this.roleName == MBRStateConstants.VIEWLEADER) {
            this.mergeLeader = this.thisMember;
        }
        if (protocol2 == MBRStateConstants.TERMINATION && this.alarm != null) {
            this.alarm.cancelTimers();
        }
        this.setRole(roleName, protocol2);
    }

    boolean determineIfViewLeader(VRIMemberDescription[] vRIMemberDescriptionArray) {
        this.viewLeader = this.membersMgr.pickActiveLeader(vRIMemberDescriptionArray);
        return this.viewLeader.getName().equals(this.myName);
    }

    public boolean determineIfViewLeader() {
        return this.determineIfViewLeader(null);
    }

    RoleName getRoleName() {
        return this.roleName;
    }

    void setAlarm(MBRAlarm mBRAlarm) {
        this.alarm = mBRAlarm;
    }

    MBRAlarm getAlarm() {
        return this.alarm;
    }

    MergeNewViewMsg prepareMergeNewViewMsg() {
        MBRLogger.dcsAssert(this.mergeLeader != null, "mergeLeader is null ", "MBRState", "prepareMergeNewViewMsg()", this.stackName);
        ViewIdImpl viewIdImpl = new ViewIdImpl(this.mergeViewIdNum + 1, this.mergeLeader.getName());
        if (!this.externalViewsStarted) {
            if (this.isThisFirstExternalView()) {
                this.externalViewsStarted = true;
            }
            viewIdImpl.internalView(!this.externalViewsStarted);
        }
        MergeNewViewMsg mergeNewViewMsg = new MergeNewViewMsg(this.mccoksVL, this.mccoksYES, viewIdImpl, this.stateExchanger.getMLStateBlob(), this.myName, this.membersMgr);
        this.updateMajorState(MBRStateConstants.MERGELEADER, MBRStateConstants.NORMAL);
        this.changeRole(MBRStateConstants.VIEWLEADER, MBRStateConstants.MERGE);
        return mergeNewViewMsg;
    }

    private boolean isThisFirstExternalView() {
        return Utils.removeNulls(this.mccoksYES).length > 1;
    }

    boolean iHaveNotRespondedtoMerge() {
        return !VRIMemberUtils.contains(this.mccoksYES, this.thisMember);
    }

    boolean iHaveNotRespondedtoSync() {
        return !VRIMemberUtils.contains(this.ccoksYES, this.thisMember);
    }

    VRIMemberDescription[] getMergeNonRespondants() {
        VRIMemberDescription[] vRIMemberDescriptionArray = VRIMemberUtils.unification(this.mccoksYES, this.mccoksNO);
        return VRIMemberUtils.minus(this.potentialMergeViewMembers, vRIMemberDescriptionArray);
    }

    VRIMemberDescription[] getSyncNonRespondants() {
        VRIMemberDescription[] vRIMemberDescriptionArray = VRIMemberUtils.unification(this.ccoksYES, this.ccoksNO);
        return VRIMemberUtils.minus(this.membersMgr.getViewMembers(), vRIMemberDescriptionArray);
    }

    void setReceivedFailedListAndCCV(VRIMemberDescription[] vRIMemberDescriptionArray, CCVersion cCVersion) {
        this.receivedFailedList = VRIMemberUtils.copy(vRIMemberDescriptionArray);
        this.receivedCCV = cCVersion;
    }

    VRIMemberDescription[] getReceivedFailedList() {
        return VRIMemberUtils.copy(this.receivedFailedList);
    }

    public VRIMemberDescription[] getMergeCandidates() {
        return VRIMemberUtils.copy(this.mccoksYES);
    }

    public void check() {
    }

    public boolean iAmMergeLeader() {
        return this.thisMember.equals(this.mergeLeader);
    }

    public String getStackname() {
        return this.stackName;
    }

    public VRIMemberDescription[] getSentFailedList() {
        return VRIMemberUtils.copy(this.sentFailedList);
    }

    public void setSentFailedList(VRIMemberDescription[] vRIMemberDescriptionArray) {
        this.sentFailedList = VRIMemberUtils.copy(vRIMemberDescriptionArray);
    }

    public void queueMessage(CompleteCurrentMsg completeCurrentMsg) {
        this.ccQueue.addLast(completeCurrentMsg);
    }

    public CompleteCurrentMsg dequeueMessage() {
        if (this.ccQueue.size() != 0) {
            return (CompleteCurrentMsg)this.ccQueue.removeFirst();
        }
        return null;
    }

    public void updateProtocol(Protocol protocol2) {
        if (this.protocol == MBRStateConstants.MESSAGING) {
            this.protocol = protocol2;
        }
    }

    public VRIMembersMGR getVRIMembersMgr() {
        return this.membersMgr;
    }

    public boolean resetVLTimer() {
        boolean bl = this.getAlarm().isVLTimerSet();
        if (bl) {
            this.getAlarm().setVLTimer();
        }
        return bl;
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this.stackName;
    }

    public String getMemberName() {
        return this.myName;
    }

    public String getLayerName() {
        return "MBR";
    }

    public MBRStateXchg getStateExchanger() {
        return this.stateExchanger;
    }

    public long getReceivedMergeLeaderContext() {
        return this.receivedMergeLeaderContext;
    }

    public long getSentMergeLeaderContext() {
        return this.sentMergeLeaderContext;
    }

    public void setReceivedMergeLeaderContext(long l) {
        this.receivedMergeLeaderContext = l;
    }

    public long createSentMergeLeaderContext() {
        this.sentMergeLeaderContext = new Date().getTime();
        return this.sentMergeLeaderContext;
    }

    public int computeViewChangeTime() {
        long l = System.currentTimeMillis() - this.viewChangeStartTime;
        return (int)l;
    }

    public VRIMemberDescription[] getPotentialViewLeaders() {
        int n;
        VRIMemberDescription[] vRIMemberDescriptionArray = this.membersMgr.getViewMinusDenied();
        for (n = 0; n < vRIMemberDescriptionArray.length && !this.thisMember.equals(vRIMemberDescriptionArray[n]); ++n) {
        }
        if (n == 0) {
            return null;
        }
        VRIMemberDescription[] vRIMemberDescriptionArray2 = new VRIMemberDescription[n];
        for (int i = 0; i < vRIMemberDescriptionArray2.length; ++i) {
            vRIMemberDescriptionArray2[i] = vRIMemberDescriptionArray[i];
        }
        return vRIMemberDescriptionArray2;
    }

    public boolean externalViewsStarted() {
        return this.externalViewsStarted;
    }

    public void externalViewsStarted(boolean bl) {
        this.externalViewsStarted = bl;
    }

    public Map getNewConfigMap() {
        HashMap<String, Comparable<Integer>> hashMap = null;
        if (this.changedPV()) {
            hashMap = new HashMap<String, Comparable<Integer>>();
            hashMap.put("DCSProtocolVersion", new Integer(this.nextProtocolVersion));
            hashMap.put("DCS_PROTOCOL_VERSION_CONTEXT", this.nextProtocolVersionContext);
        }
        return hashMap;
    }

    public boolean changedPV() {
        return this.nextProtocolVersion != 0;
    }

    public int getNextProtocolVersion() {
        return this.nextProtocolVersion;
    }

    public void setNextProtocolVersion(int n, StateVersion stateVersion) {
        this.nextProtocolVersion = n;
        this.nextProtocolVersionContext = stateVersion;
    }

    public String checkProtocolVersion(int n, StateVersion stateVersion) {
        String string;
        boolean bl;
        int n2 = this.membersMgr.getProtocolVersion();
        StateVersion stateVersion2 = this.membersMgr.getProtocolVersionContext();
        boolean bl2 = bl = stateVersion2 == null || stateVersion.compareTo(stateVersion2) > 0;
        if (!this.changedPV()) {
            if (n2 != n) {
                this.setNextProtocolVersion(n, stateVersion);
                string = "Update DCS Protocol Version -UDPVyes1";
            } else if (bl) {
                this.membersMgr.setProtocolVersion(n, stateVersion);
                string = "Immeadiate update of DCS Protocol Version Context - UDPVC1";
            } else {
                string = "No need Update DCS Protocol Version- UPDVno1";
            }
        } else if (n != this.nextProtocolVersion && stateVersion.compareTo(this.nextProtocolVersionContext) > 0) {
            this.setNextProtocolVersion(n, stateVersion);
            string = "Update DCS Protocol Version -UDPVyes2";
        } else {
            string = stateVersion.compareTo(this.nextProtocolVersionContext) > 0 ? "No need Update DCS Protocol Version - UDPVno2A" : "No need Update DCS Protocol Version- UPDVno2B";
        }
        string = string + " oldPV= " + n2 + "  oldContext= " + String.valueOf(stateVersion2);
        string = string + " newPV= " + n + "  newContext= " + String.valueOf(stateVersion);
        return string;
    }

    public boolean shouldIDump() {
        boolean bl = false;
        long l = System.currentTimeMillis();
        ++this.dumpCount;
        if (l - this.lastDumpTime > 3600000L) {
            this.lastDumpTime = l;
            this.dumpCount = 0;
            bl = true;
        } else {
            bl = this.dumpCount < 20;
        }
        return bl;
    }

    public List getMergeNoThresholdCounters() {
        return this.mergeNoThresholdCounters;
    }

    public boolean shouldRequestDump() {
        if (this.mccoksNO != null && this.mccoksNO.length > 0) {
            return ((ThresholdCounter)this.mergeNoThresholdCounters.get(2)).increment();
        }
        return false;
    }

    public static final class RoleName {
        int myRolename;

        RoleName(int n) {
            this.myRolename = n;
        }

        public String toString() {
            String string = "RoleName=Unknown";
            switch (this.myRolename) {
                case 0: {
                    string = " RoleName=MEMBER     ";
                    break;
                }
                case 1: {
                    string = " RoleName=VIEWLEADER ";
                    break;
                }
                case 2: {
                    string = " RoleName=MERGELEADER ";
                }
            }
            return string;
        }

        public String toShortString() {
            String string = "U";
            switch (this.myRolename) {
                case 0: {
                    string = " MB ";
                    break;
                }
                case 1: {
                    string = " VL ";
                    break;
                }
                case 2: {
                    string = " ML ";
                }
            }
            return string;
        }

        public int getIndex() {
            return this.myRolename;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return object instanceof RoleName && this.myRolename == ((RoleName)object).myRolename;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    public static final class ExtendedRole {
        RoleName role;
        Protocol prot;

        public ExtendedRole(RoleName roleName, Protocol protocol2) {
            this.role = roleName;
            this.prot = protocol2;
        }

        public String toString() {
            return this.role.toString() + " " + this.prot.toString();
        }

        public ExtendedRole changeRole(MBRState mBRState) {
            ExtendedRole extendedRole = new ExtendedRole(mBRState.getRoleName(), mBRState.getProtocol());
            if (!this.equals(extendedRole)) {
                mBRState.changeRole(this.role, this.prot);
            }
            return extendedRole;
        }

        public boolean equals(RoleName roleName, Protocol protocol2) {
            return this.role.equals(roleName) && this.prot.equals(protocol2);
        }

        public boolean equals(Object object) {
            if (object instanceof ExtendedRole) {
                ExtendedRole extendedRole = (ExtendedRole)object;
                return extendedRole.equals(this.role, this.prot);
            }
            return false;
        }
    }

    static final class Protocol {
        int protocol;

        Protocol(int n) {
            this.protocol = n;
        }

        public String toString() {
            String string = "Protocol=Unknown";
            switch (this.protocol) {
                case 0: {
                    string = " Protocol=Initializing ";
                    break;
                }
                case 1: {
                    string = " Protocol=Messaging ";
                    break;
                }
                case 3: {
                    string = " Protocol=Merge   ";
                    break;
                }
                case 2: {
                    string = " Protocol=Split   ";
                    break;
                }
                case 5: {
                    string = " Protocol=Terminating ";
                }
            }
            return string;
        }

        public String toShortString() {
            String string = " Unknown";
            switch (this.protocol) {
                case 0: {
                    string = " Init ";
                    break;
                }
                case 1: {
                    string = " Message ";
                    break;
                }
                case 3: {
                    string = " merGe   ";
                    break;
                }
                case 2: {
                    string = " Split   ";
                    break;
                }
                case 5: {
                    string = " Terminate ";
                }
            }
            return string;
        }

        public int getIndex() {
            return this.protocol;
        }

        public static Protocol fromIndex(int n) {
            Protocol protocol2;
            switch (n) {
                case 0: {
                    protocol2 = MBRStateConstants.INITIALIZING;
                    break;
                }
                case 1: {
                    protocol2 = MBRStateConstants.MESSAGING;
                    break;
                }
                case 3: {
                    protocol2 = MBRStateConstants.MERGE;
                    break;
                }
                case 2: {
                    protocol2 = MBRStateConstants.SPLIT;
                    break;
                }
                case 5: {
                    protocol2 = MBRStateConstants.TERMINATION;
                    break;
                }
                default: {
                    protocol2 = null;
                }
            }
            return protocol2;
        }
    }

    private static final class MinorPhase {
        byte majorPhase;
        byte minorPhase;
        int role;
        String description;
        static MinorPhase[][][] MINORPHASE = new MinorPhase[3][4][6];

        MinorPhase(int n, byte by, byte by2, String string) {
            this.role = n;
            this.majorPhase = by;
            this.minorPhase = by2;
            this.description = string;
            MinorPhase.MINORPHASE[n][by][by2] = this;
        }

        public String toString() {
            return MinorPhase.MINORPHASE[this.role][this.majorPhase][this.minorPhase].description;
        }

        static MinorPhase getFirst(int n, byte by) {
            return MINORPHASE[n][by][0];
        }
    }

    static final class Phase {
        byte phase;
        int type;

        Phase(byte by) {
            this.phase = by;
            this.type = 0;
        }

        MinorPhase getFirstMinorPhase(int n) {
            return MinorPhase.getFirst(n, this.phase);
        }

        public String toString() {
            String string = "Phase=Unknown";
            if (this.type == 0) {
                switch (this.phase) {
                    case 0: {
                        string = " Phase=Normal ";
                        break;
                    }
                    case 1: {
                        string = " Phase=Syncing ";
                        break;
                    }
                    case 2: {
                        string = " Phase=synceD ";
                        break;
                    }
                    case 3: {
                        string = " Phase=Install ";
                    }
                }
            }
            return string;
        }

        public String toShortString() {
            String string = "U";
            if (this.type == 0) {
                switch (this.phase) {
                    case 0: {
                        string = " N ";
                        break;
                    }
                    case 1: {
                        string = " S ";
                        break;
                    }
                    case 2: {
                        string = " D ";
                        break;
                    }
                    case 3: {
                        string = " I ";
                    }
                }
            }
            return string;
        }

        byte getIndex() {
            return this.phase;
        }
    }
}

