/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.dcs.common.StateVersion;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.event.RequestStateChangeEvent;
import com.ibm.ws.dcs.vri.common.nls.StateXchgUpdateEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;
import com.ibm.ws.dcs.vri.membership.util.VLStateXchgResponse;

final class MBRStateXchg
implements DCSTraceContext {
    private final String stackName;
    private final String myName;
    private final VRIMemberDescription thisMember;
    private final VRIMembersMGR membersMgr;
    private StateVersion mlVersionReceived;
    private StateBlob distributeVLtoMLBlob = null;
    private boolean needDistributeToML = false;
    private boolean needUpdateFromML = false;
    private StateBlob distributeMLtoVLBlob = null;
    private boolean needUpdateToVL = false;
    private boolean updateState;
    private StateVersion newStateVersion = null;
    private StateBlob currentBlob;
    private StateBlob newBlob;
    private StateVersion currentStateVersion = null;
    private static final TraceComponent TC = Tr.register(MBRStateXchg.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");

    MBRStateXchg(VRIMembersMGR vRIMembersMGR, StateBlob stateBlob) {
        this.membersMgr = vRIMembersMGR;
        this.thisMember = this.membersMgr.getThisMember();
        this.myName = this.thisMember.getName();
        this.stackName = this.membersMgr.getThisStackName();
        if (stateBlob != null) {
            this.newBlob = stateBlob;
            this.newStateVersion = stateBlob.getVersion();
            this.currentBlob = stateBlob;
            this.currentStateVersion = stateBlob.getVersion();
        }
    }

    public boolean handleRequestStateChangeEvent(RequestStateChangeEvent requestStateChangeEvent) {
        StateBlob stateBlob = requestStateChangeEvent.getStateBlob();
        if (stateBlob == null) {
            MBRLogger.dcsInternalInfo((DCSTraceContext)this, "handleRequestStateChangeEvent()", "requested state is null");
            return false;
        }
        MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "handleRequestStateChangeEvent()", DCSTraceBuffer.propertyList().addProperty("ViewLeader", "State Version", stateBlob.getVersion()), null);
        return this.setStateBlobByRequest(stateBlob);
    }

    StateVersion getNewStateVersion() {
        this.distributeMLtoVLBlob = this.newBlob;
        this.needUpdateToVL = false;
        MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "getNewStateVersion()", DCSTraceBuffer.propertyList().addProperty("MSG->", "AddMembersMsg").addProperty("MergeLeader", "State Version", this.newStateVersion), null);
        return this.newStateVersion;
    }

    public void setMLVersion(StateVersion stateVersion) {
        this.mlVersionReceived = stateVersion;
        MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "setMLVersion()", DCSTraceBuffer.propertyList().addProperty("MSG<-", "AddMembersMsg").addProperty("MergeLeader", "State Version", stateVersion), null);
    }

    private void testMLVersion() {
        this.needDistributeToML = false;
        this.needUpdateFromML = false;
        this.distributeVLtoMLBlob = null;
        if (this.mlVersionReceived == null) {
            this.needUpdateFromML = false;
            if (this.newStateVersion != null) {
                this.needDistributeToML = true;
                this.distributeVLtoMLBlob = this.newBlob;
            } else {
                this.needDistributeToML = false;
                this.distributeVLtoMLBlob = null;
            }
        } else if (this.newStateVersion != null) {
            int n = this.newStateVersion.compareTo(this.mlVersionReceived);
            switch (n) {
                case 0: {
                    this.needDistributeToML = false;
                    this.needUpdateFromML = false;
                    break;
                }
                case 1: {
                    this.needUpdateFromML = false;
                    this.needDistributeToML = true;
                    this.distributeVLtoMLBlob = this.newBlob;
                    break;
                }
                case -1: {
                    this.needUpdateFromML = true;
                    this.needDistributeToML = false;
                    this.distributeVLtoMLBlob = null;
                    break;
                }
            }
        } else {
            this.needUpdateFromML = true;
            this.needDistributeToML = false;
        }
    }

    public VLStateXchgResponse getVLResponse() {
        this.testMLVersion();
        MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "getVLResponse()", DCSTraceBuffer.propertyList().addProperty("MSG->", "MergeCCOK").addProperty("Old", "NeedUpdateFromML", this.needUpdateFromML).addProperty("NeedDistributeToML", this.needDistributeToML).addProperty("Old", "State Version", this.distributeVLtoMLBlob == null ? null : this.distributeVLtoMLBlob.getVersion()).addProperty("New", "State Version", this.newBlob == null ? null : this.newBlob.getVersion()), null);
        return new VLStateXchgResponse(this.needUpdateFromML, this.distributeVLtoMLBlob);
    }

    public void setVLResponse(String string, VLStateXchgResponse vLStateXchgResponse) {
        if (vLStateXchgResponse == null || vLStateXchgResponse.isUpdateNeeded()) {
            String string2 = "MCCOKMsg<- response true() MLV > VLV  needToUpdateVL=true";
            MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "setVLResponse()", DCSTraceBuffer.propertyList().addProperty("InternalDetails", string2), null);
            this.needUpdateToVL = true;
            return;
        }
        StateBlob stateBlob = vLStateXchgResponse.getVlStateBlob();
        if (stateBlob == null) {
            String string3 = "MCCOKMsg<- response false(null) null == MLV no change needToUpdateVL " + Boolean.toString(this.needUpdateToVL);
            MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "setVLResponse()", DCSTraceBuffer.propertyList().addProperty("InternalDetails", string3), null);
            return;
        }
        if (this.distributeMLtoVLBlob == null) {
            this.needUpdateToVL = true;
            this.distributeMLtoVLBlob = stateBlob;
            String string4 = "MCCOKMsg<- response false(blob) null < VLV needToUpdateVL=true replaceMLBlob= " + stateBlob.getVersion();
            MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "setVLResponse()", DCSTraceBuffer.propertyList().addProperty("InternalDetails", string4), null);
            return;
        }
        StateVersion stateVersion = stateBlob.getVersion();
        StateVersion stateVersion2 = this.distributeMLtoVLBlob.getVersion();
        try {
            String string5;
            int n = stateVersion2.compareTo(stateVersion);
            switch (n) {
                case 0: {
                    string5 = "??? response false(blob) MLV == VLV no change needToUpdateVL= " + Boolean.toString(this.needUpdateToVL);
                    break;
                }
                case -1: {
                    this.needUpdateToVL = true;
                    this.distributeMLtoVLBlob = stateBlob;
                    string5 = "response false(blob) null < VLV needToUpdateVL=true replaceMLBlob= " + stateBlob.getVersion();
                    break;
                }
                case 1: {
                    this.needUpdateToVL = true;
                    string5 = "??? response true() MLV > VLV  needToUpdateVL=true";
                    break;
                }
                default: {
                    String string6 = "??? WARNING Bad answer from compareTo";
                    throw new DCSException("StateXchgVersion CompareFailure not -1,0,1");
                }
            }
            MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "setVLResponse()", DCSTraceBuffer.propertyList().addProperty("InternalDetails", string5), null);
        }
        catch (Exception exception) {
            DCSException dCSException = new DCSException("StateXchg Version compare failure sender= " + string + " mlVersion= " + stateVersion2 + " vlVersion= " + stateVersion, exception);
            MBRLogger.dcsWarning((DCSTraceContext)this, "setVLResponse()", dCSException);
            MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "setVLResponse()", DCSTraceBuffer.propertyList().addProperty("InternalDetails", "State Version Compare Failure"), null);
        }
    }

    public StateBlob getMLStateBlob() {
        if (this.needUpdateToVL) {
            MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "getMLStateBlob()", DCSTraceBuffer.propertyList().addProperty("MSG->", "NVMsg").addProperty("SendBlob", true), null);
            return this.distributeMLtoVLBlob;
        }
        MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "getMLStateBlob()", DCSTraceBuffer.propertyList().addProperty("MSG->", "NVMsg").addProperty("SendBlob", false), null);
        return null;
    }

    public StateBlob getVLStateBlob(StateBlob stateBlob) {
        if (stateBlob == null) {
            MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "getVLStateBlob()", DCSTraceBuffer.propertyList().addProperty("MSG->", "NVMsg").addProperty("SendBlob", false), null);
            return null;
        }
        if (this.newBlob == null) {
            MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "getVLStateBlob()", DCSTraceBuffer.propertyList().addProperty("MSG->", "NVMsg").addProperty("SendBlob", true), null);
            return stateBlob;
        }
        if (this.newStateVersion.compareTo(stateBlob.getVersion()) < 0) {
            MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "getVLStateBlob()", DCSTraceBuffer.propertyList().addProperty("MSG->", "NVMsg").addProperty("SendBlob", true), null);
            return stateBlob;
        }
        MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "getVLStateBlob()", DCSTraceBuffer.propertyList().addProperty("MSG->", "NVMsg").addProperty("SendBlob", false), null);
        return null;
    }

    private boolean setStateBlobByRequest(StateBlob stateBlob) {
        boolean bl = this.setStateBlobInternal(stateBlob);
        if (!bl) {
            String string = "unKnown";
            StateVersion stateVersion = null;
            string = stateBlob == null ? "StateBlob is null" : ((stateVersion = stateBlob.getVersion()) != null ? stateVersion.toString() : "null");
            MBRLogger.dcsInternalInfo((DCSTraceContext)this, "setStateBlobByRequest()", "Bad State Version: old version= " + this.newStateVersion + " new version= " + string);
            MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "setStateBlobByRequest()", DCSTraceBuffer.propertyList().addProperty("Old", "Version", this.newStateVersion).addProperty("New", "Version", stateVersion).addProperty("UpdateState", false), null);
        }
        return bl;
    }

    public boolean setStateBlob(StateBlob stateBlob) {
        boolean bl = this.setStateBlobInternal(stateBlob);
        MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "setStateBlob()", DCSTraceBuffer.propertyList().addProperty("MSG<-", "NVMsg").addProperty("UpdateState", bl), null);
        return bl;
    }

    private boolean setStateBlobInternal(StateBlob stateBlob) {
        if (stateBlob == null) {
            return false;
        }
        StateVersion stateVersion = stateBlob.getVersion();
        if (stateVersion == null || this.newStateVersion != null && stateVersion.compareTo(this.newStateVersion) <= 0) {
            return false;
        }
        this.newBlob = stateBlob;
        this.newStateVersion = stateVersion;
        this.updateState = true;
        return true;
    }

    StateXchgUpdateEvent newViewCheckAndUpdate() {
        if (this.updateState) {
            MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "newView()", DCSTraceBuffer.propertyList().addProperty("UpdateState", this.updateState), null);
            StateXchgUpdateEvent stateXchgUpdateEvent = new StateXchgUpdateEvent((DCSTraceContext)this, this.newBlob);
            this.currentBlob = this.newBlob;
            this.currentStateVersion = this.newStateVersion;
            this.updateState = false;
            return stateXchgUpdateEvent;
        }
        return null;
    }

    public String dump() {
        return "StateXChg= " + this.updateState + this.newStateVersion + this.currentBlob + this.newBlob + this.currentStateVersion;
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this.stackName;
    }

    public String getMemberName() {
        return this.myName;
    }

    public String getLayerName() {
        return "MSX";
    }
}

