/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership;

import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSAssertException;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.vri.common.AdministrativeTerminationRequest;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.Downcalls;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.LayerLinkage;
import com.ibm.ws.dcs.vri.common.MemberInfo;
import com.ibm.ws.dcs.vri.common.Upcalls;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRICheckFailedException;
import com.ibm.ws.dcs.vri.common.VRIDenialReason;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.event.RequestChangeDefinedEvent;
import com.ibm.ws.dcs.vri.common.event.VRIUpEvent;
import com.ibm.ws.dcs.vri.common.nls.MBRSuspectAdministratively;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.FFDCDumper;
import com.ibm.ws.dcs.vri.membership.ChangeDefinedRequest;
import com.ibm.ws.dcs.vri.membership.MBRAbstractLayer;
import com.ibm.ws.dcs.vri.membership.MBRDo;
import com.ibm.ws.dcs.vri.membership.MBRDowncalls;
import com.ibm.ws.dcs.vri.membership.MBRUpcalls;
import com.ibm.ws.dcs.vri.membership.MUPAlarm;
import com.ibm.ws.dcs.vri.membership.util.MBRDenialReason;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;
import java.util.Arrays;
import java.util.Map;

abstract class MBRUp
extends MBRAbstractLayer
implements MBRUpcalls,
MBRDowncalls,
LayerLinkage {
    private boolean terminated = false;
    private boolean defSetLock = false;
    private int numRetries = 0;
    Downcalls down;
    final MBRUpcalls up;
    final ChangeDefinedRequest changeDefinedRequest;
    protected final MUPAlarm alarm;
    private long beginCoalesceTime;

    public MBRUp(Globals globals, MBRUpcalls mBRUpcalls) {
        super(globals, "MUP");
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "MBRUp()", null).invoke();
        }
        this.up = mBRUpcalls;
        this.changeDefinedRequest = new ChangeDefinedRequest();
        this.alarm = new MUPAlarm(globals, this);
        if (DCSTraceBuffer.isExitEnabled(this.TC)) {
            DCSTraceBuffer.exit(this, "MBRUp()", null).invoke();
        }
    }

    public VRICheckFailedException check() {
        MBRLogger.dcsAssert(Thread.holdsLock(this.g.getMutex()), "We have dont mutex", "MBRUp", "check()", this.stackName);
        return this.up.check();
    }

    public void connectMembers(VRIMemberDescription[] vRIMemberDescriptionArray) {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "connectMembers()", null).invoke();
        }
        try {
            MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "connectMembers()", DCSTraceBuffer.propertyList().addProperty("connectedMembers", VRIMemberUtils.toString(vRIMemberDescriptionArray)), null);
            MBRLogger.dcsAssert(Thread.holdsLock(this.g.getMutex()), "We dont have mutex", "MBRUp", "connectMembers()", this.stackName);
            if (!this.alarm.isConnectAlarmSet()) {
                this.alarm.setConnectAlarm(this.computeConnections());
                this.beginCoalesceTime = System.currentTimeMillis();
                this.numRetries = 1;
                MBRLogger.dcsLogMUPActionEvent(this, "setTimer()");
            } else {
                int n = this.membersMgr.getDefinedMembersSize() - this.membersMgr.getViewMembersMinusDeniedSize() - this.membersMgr.getDeniedMembersSize();
                if (this.numRetries < (n *= this.g.getConfigParamAsInt("MEMBERSHIP_MAX_MERGE_RETRIES") / 100)) {
                    this.alarm.setConnectAlarm(this.computeConnections());
                    ++this.numRetries;
                    MBRLogger.dcsLogMUPActionEvent(this, "resetTimer()");
                } else {
                    MBRLogger.dcsLogMUPActionEvent(this, "DoNothing \t tries > maxretries= " + n);
                }
            }
        }
        catch (Throwable throwable) {
            MBRLogger.dcsLogMUPActionEvent(this, "up.requestTermination(e)");
            this.up.requestTermination(new TerminationEvent((DCSTraceContext)this, "connectMembers()", throwable));
        }
        if (DCSTraceBuffer.isExitEnabled(this.TC)) {
            DCSTraceBuffer.exit(this, "connectMembers()", null).invoke();
        }
    }

    private int computeConnections() {
        int n = this.membersMgr.getViewMembersMinusDeniedSize();
        int n2 = this.membersMgr.getConnectedMembersMinusDeniedSize() - n;
        int n3 = n * n2 + n2 * n2;
        return n3;
    }

    public void suspectMembers(DCSSuspectEvent[] dCSSuspectEventArray) {
        try {
            MBRLogger.dcsAssert(Thread.holdsLock(this.g.getMutex()), "We dont have mutex", "MBRUp", "suspectMembers()", this.stackName);
            this.up.suspectMembers(dCSSuspectEventArray);
            VRIMemberDescription[] vRIMemberDescriptionArray = this.membersMgr.getConnectedMembers(true);
            vRIMemberDescriptionArray = VRIMemberUtils.minus(vRIMemberDescriptionArray, this.membersMgr.getDeniedMembers(true));
            if (vRIMemberDescriptionArray != null && vRIMemberDescriptionArray.length != 0 && !VRIMemberUtils.contains(this.membersMgr.getViewMembers(), vRIMemberDescriptionArray)) {
                this.connectMembers(vRIMemberDescriptionArray);
            }
        }
        catch (Throwable throwable) {
            this.up.requestTermination(new TerminationEvent((DCSTraceContext)this, "connectMembers()", throwable));
        }
    }

    public void currentOK(CCVersion cCVersion) {
        try {
            MBRLogger.dcsAssert(Thread.holdsLock(this.g.getMutex()), "We have dont mutex", "MBRUp", "currentOK()", this.stackName);
            this.up.currentOK(cCVersion);
        }
        catch (Throwable throwable) {
            this.up.requestTermination(new TerminationEvent((DCSTraceContext)this, "currentOK()", throwable));
        }
    }

    public void newViewOK(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        try {
            Object[] objectArray;
            Object[] objectArray2;
            MBRLogger.dcsAssert(Thread.holdsLock(this.g.getMutex()), "We have dont mutex", "MBRUp", "newViewOK()", this.stackName);
            MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "newViewOK()", DCSTraceBuffer.propertyList().addProperty(viewIdImpl).addProperty("changeDefinedRequest.isReady()", this.changeDefinedRequest.isReady(this.membersMgr)), null);
            this.up.newViewOK(vRIMemberDescriptionArray, viewIdImpl, map);
            this.defSetLock = false;
            if (this.changeDefinedRequest.isReady(this.membersMgr)) {
                if (this.determineIfViewLeader()) {
                    objectArray2 = this.changeDefinedRequest.getRequestChangeDefinedRemovals();
                    objectArray = this.changeDefinedRequest.getRequestChangeDefinedAdds();
                    int n = this.changeDefinedRequest.getRequestChangeDefinedContext();
                    this.up.onVRIUpEvent(new RequestChangeDefinedEvent(this.stackName, this.myName, (MemberInfo[])objectArray, (String[])objectArray2, n));
                }
                this.changeDefinedRequest.clear();
            }
            if ((objectArray2 = VRIMemberUtils.intersection(this.membersMgr.getDeniedMembers(true), this.membersMgr.getViewMembers())).length != 0) {
                MBRLogger.dcsLogMUPActionEvent(this, "suspectMembers()");
                objectArray = new DCSInternalSuspectEvent[]{new DCSInternalSuspectEvent((VRIMemberDescription[])objectArray2)};
                this.suspectMembers((DCSSuspectEvent[])objectArray);
            } else {
                objectArray = this.getConnectedCandidates();
                if (objectArray.length != 0) {
                    MBRLogger.dcsLogMUPActionEvent(this, "connectedMembers()");
                    this.connectMembers((VRIMemberDescription[])objectArray);
                }
            }
        }
        catch (Throwable throwable) {
            MBRLogger.dcsLogMUPActionEvent(this, "up.requestTermination(e)");
            this.up.requestTermination(new TerminationEvent((DCSTraceContext)this, "connectMembers()", throwable));
        }
    }

    public void deliver(VRIMessage vRIMessage) {
        try {
            MBRLogger.dcsAssert(Thread.holdsLock(this.g.getMutex()), "We have dont mutex", "MBRUp", "deliver()", this.stackName);
            this.up.deliver(vRIMessage);
        }
        catch (Throwable throwable) {
            this.up.requestTermination(new TerminationEvent((DCSTraceContext)this, "deliver", throwable));
        }
    }

    public void requestTermination(DCSTerminationEvent dCSTerminationEvent) {
        try {
            this.up.requestTermination(dCSTerminationEvent);
        }
        catch (Throwable throwable) {
            MBRLogger.dcsInternalError(this, "requestTermination()", throwable);
        }
    }

    public void proposeAgreement(VRIMessage vRIMessage) throws DCSAssertException {
        try {
            MBRLogger.dcsAssert(Thread.holdsLock(this.g.getMutex()), "We have dont mutex", "MBRUp", "proposeAgreement()", this.stackName);
            this.up.proposeAgreement(vRIMessage);
        }
        catch (Throwable throwable) {
            this.up.requestTermination(new TerminationEvent((DCSTraceContext)this, "proposeAgreement", throwable));
        }
    }

    public void deliverAgreed(VRIMessage vRIMessage) throws DCSAssertException {
        try {
            MBRLogger.dcsAssert(Thread.holdsLock(this.g.getMutex()), "We have dont mutex", "MBRUp", "deliverAgreed()", this.stackName);
            this.up.deliverAgreed(vRIMessage);
        }
        catch (Throwable throwable) {
            this.up.requestTermination(new TerminationEvent((DCSTraceContext)this, "deliverAgreed", throwable));
        }
    }

    public void setUpperLayer(Upcalls upcalls) {
        if (upcalls != null) {
            throw new DCSRuntimeException("Non-Null Up layer in Membership");
        }
    }

    public void setDownLayer(Downcalls downcalls) {
        this.down = downcalls;
        this.up.setDownLayer(this);
    }

    public void setDownLayer(MBRDowncalls mBRDowncalls) {
        throw new DCSRuntimeException("Non-Null Up layer in Membership");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewIdImpl requestStart() {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "requestStart()", null).invoke();
        }
        Object object2 = object = this.g.getMutex();
        synchronized (object2) {
            ViewIdImpl viewIdImpl = this.up.requestStart();
            return viewIdImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestChangeDefined(MemberInfo[] memberInfoArray, String[] stringArray, int n) {
        Object object;
        Object object2 = object = this.g.getMutex();
        synchronized (object2) {
            MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "requestChangeDefined()", DCSTraceBuffer.propertyList().addProperty("AddedMembers", memberInfoArray).addProperty("RemovedMembers", stringArray).addProperty("Context", n), null);
            Object[] objectArray = null;
            boolean bl = true;
            if (stringArray != null && stringArray.length > 0) {
                objectArray = this.membersMgr.getDefinedMembers(stringArray);
                int n2 = Utils.countNulls(objectArray);
                objectArray = (VRIMemberDescription[])Utils.removeNulls(objectArray, n2);
                bl = VRIMemberUtils.areDisjoint((VRIMemberDescription[])objectArray, this.membersMgr.getViewMembers());
            }
            if (bl) {
                this.changeDefinedRequest.clear();
                MBRLogger.dcsLogMUPActionEvent(this, "up.onVRIEvent(RequestChangeDefinedEvent)Add members=" + Utils.toString(memberInfoArray) + ". Remove members=" + Utils.toString(stringArray));
                this.up.onVRIUpEvent(new RequestChangeDefinedEvent(this.stackName, this.myName, memberInfoArray, stringArray, n));
                return;
            }
            MBRLogger.dcsLogMUPActionEvent(this, "up.suspectMembers() Suspect members=" + VRIMemberUtils.toString((VRIMemberDescription[])objectArray));
            DCSSuspectEvent[] dCSSuspectEventArray = new DCSInternalSuspectEvent[]{new DCSInternalSuspectEvent((VRIMemberDescription[])objectArray)};
            this.up.suspectMembers(dCSSuspectEventArray);
            return;
        }
    }

    protected boolean adminDenyRemovedMembers(String[] stringArray, String string) {
        boolean bl = true;
        if (this.amIinRemoveSet(stringArray)) {
            this.up.requestTermination(new TerminationEvent((DCSTraceContext)this, "adminDenyRemovedMembers", new AdministrativeTerminationRequest("This member was administrativly denied- due to changeDefinedRequest", false)));
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.membersMgr.isDefined(stringArray[i])) continue;
            this.membersMgr.denyMember(stringArray[i], MBRDenialReason.createAdminRemovalDR(string));
            if (this.membersMgr.isInView(stringArray[i])) {
                bl = false;
            }
            MBRSuspectAdministratively mBRSuspectAdministratively = new MBRSuspectAdministratively((DCSTraceContext)this, new String[]{stringArray[i]}, string);
            this.doit(new MBRDo(mBRSuspectAdministratively));
        }
        return bl;
    }

    protected boolean amIinRemoveSet(String[] stringArray) {
        Arrays.sort(stringArray);
        int n = Arrays.binarySearch(stringArray, this.membersMgr.getThisMember().getName());
        boolean bl = n >= 0;
        return bl;
    }

    private void handleConnectMembersTimeout() {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "handleConnectMembersTimeout()", null).invoke();
        }
        MBRLogger.dcsLogMUPEvent(this, "handleConnectMembersTimeout()", "");
        try {
            VRIMemberDescription[] vRIMemberDescriptionArray = this.getConnectedCandidates();
            this.alarm.cancelConnectAlarm();
            if (vRIMemberDescriptionArray.length != 0) {
                MBRLogger.dcsLogMUPActionEvent(this, "up.connectMembers()");
                if (this.g.statsModule != null) {
                    long l = System.currentTimeMillis();
                    int n = (int)(l - this.beginCoalesceTime);
                    this.g.statsModule.onCoalsceEvent(n);
                }
                this.up.connectMembers(vRIMemberDescriptionArray);
            } else {
                MBRLogger.dcsLogMUPActionEvent(this, "Do nothing \t no candidates to add");
            }
        }
        catch (Throwable throwable) {
            MBRLogger.dcsLogMUPActionEvent(this, "up.requestTermination(e)");
            this.up.requestTermination(new TerminationEvent((DCSTraceContext)this, "handleConnectMemberstimeout()", throwable));
        }
    }

    private VRIMemberDescription[] getConnectedCandidates() {
        VRIMemberDescription[] vRIMemberDescriptionArray = VRIMemberUtils.minus(this.membersMgr.getConnectedMembers(true), this.membersMgr.getDeniedMembers(true));
        VRIMemberDescription[] vRIMemberDescriptionArray2 = VRIMemberUtils.minus(vRIMemberDescriptionArray, this.membersMgr.getViewMembers());
        return vRIMemberDescriptionArray2;
    }

    protected void adminUndenyAddedMembers(MemberInfo[] memberInfoArray) {
        for (int i = 0; i < memberInfoArray.length; ++i) {
            if (!this.membersMgr.isDefined(memberInfoArray[i].getMemberName())) continue;
            this.membersMgr.unDenyMember((byte)10, memberInfoArray[i].getMemberName());
        }
    }

    protected void adminUndenyAddedMembers(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            VRIDenialReason vRIDenialReason;
            VRIMemberDescription vRIMemberDescription;
            if (stringArray[i] == null || (vRIMemberDescription = this.membersMgr.getDefinedMember(stringArray[i])) == null || !vRIMemberDescription.isDenied() || (vRIDenialReason = vRIMemberDescription.getDenialReason((byte)10)) == null || vRIDenialReason.getDenialReasonCode() != 1) continue;
            if (DCSTraceBuffer.isEventEnabled(this.TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "adminUndenyAddedMembers", "Remove administrative denial");
                dCSTraceBuffer.addProperty("memberName", stringArray[i]);
                dCSTraceBuffer.invoke();
            }
            this.membersMgr.unDenyMember((byte)10, stringArray[i]);
        }
    }

    public void handleAlarm(Object object) {
        if (object == MUPAlarm.CONNECT_ALARM_CONTEXT) {
            this.handleConnectMembersTimeout();
        }
    }

    public String getAlarmContextDescription(Object object) {
        if (object == MUPAlarm.CONNECT_ALARM_CONTEXT) {
            return "MUP.ConnectAlarm ";
        }
        if (object == null) {
            return "null ";
        }
        return "Unknown " + String.valueOf(object);
    }

    public void onVRIUpEvent(VRIUpEvent vRIUpEvent) {
        vRIUpEvent.handle("MBRUP", this.eventHandlers, this.up);
    }

    protected boolean isDefSetBlocked() {
        return this.defSetLock;
    }

    public void dumpAll(FFDCDumper fFDCDumper) {
        this.down.dumpAll(fFDCDumper);
    }

    public void passActionDown(MBRDo mBRDo) {
        if (!this.terminated) {
            this.doit(mBRDo);
        } else {
            MBRLogger.dcsLogMUPActionEvent((DCSTraceContext)this, "Nothing -After terminate received " + mBRDo, (DCSTraceBuffer)null);
        }
    }

    protected void doit(MBRDo mBRDo) {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "doit()", null).invoke();
        }
        if (mBRDo != null && mBRDo.isMultipleAction()) {
            MBRLogger.dcsLogMUPActionEvent(this, mBRDo.toString());
            for (int i = 0; i < 2; ++i) {
                this.doit(mBRDo.getNextAction(i));
            }
            return;
        }
        if (mBRDo != null) {
            MBRLogger.dcsLogMUPActionEvent(this, mBRDo.toString());
            if (mBRDo.isCCMsgAction() || mBRDo.isAddMembersMsgAction()) {
                this.defSetLock = true;
            }
            if (mBRDo.isTerminateAction()) {
                if (this.alarm != null) {
                    this.alarm.cancelTimers();
                }
                this.terminated = true;
            }
            mBRDo.doIt(this.down);
        } else {
            MBRLogger.dcsLogMUPActionEvent(this, "MBRDo = null");
        }
    }

    class DCSInternalSuspectEvent
    implements DCSSuspectEvent {
        private final VRIMemberDescription[] suspects;

        public String[] getSuspectedMembers() {
            return VRIMemberUtils.getMemberNames(this.suspects);
        }

        public DCSInternalSuspectEvent(VRIMemberDescription[] vRIMemberDescriptionArray) {
            this.suspects = vRIMemberDescriptionArray;
        }

        public String toString() {
            return "A list of suspects that were not processed in last view change" + VRIMemberUtils.toString(this.suspects);
        }

        public void invokeNLSTrace() {
        }

        public String getStackName() {
            return MBRUp.this.getStackName();
        }

        public String getMemberName() {
            return MBRUp.this.getMemberName();
        }

        public String getLayerName() {
            return MBRUp.this.getLayerName();
        }

        public int getSeverity() {
            return 2;
        }

        public String getSeverityName() {
            return "INFO";
        }

        public String getNLSKey() {
            return "unknown";
        }

        public int getRecommendedAction() {
            return 8;
        }

        public String getRecommendedActionDescription() {
            return null;
        }

        public String getTraceName() {
            return this.getClass().getName();
        }
    }
}

