/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership;

import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.impl.TimeScaler;
import com.ibm.ws.dcs.vri.membership.util.MBRAbstractAlarm;

final class MUPAlarm
extends MBRAbstractAlarm {
    static final int LAYER = 20;
    static final Object CONNECT_ALARM_CONTEXT = new Integer(20);
    static final Object ATTEMPT_CHANGEVIEWREQUEST_ALARM_CONTEXT = new Integer(21);
    public static final Object RESETVLWAIT_ALARM_CONTEXT = new Integer(22);

    public MUPAlarm(Globals globals, MBRAbstractAlarm.AlarmDoit alarmDoit) {
        super(globals, alarmDoit, 5, 20);
    }

    final void setConnectAlarm(int n) {
        long l = this.g.getConfigParamAsInt("MEMBERSHIP_MAX_MERGE_TIMEOUT") * 1000;
        l = TimeScaler.scaleN2(l, n);
        this.setTimer(l, CONNECT_ALARM_CONTEXT);
    }

    final void cancelConnectAlarm() {
        this.cancelTimer(CONNECT_ALARM_CONTEXT);
    }

    boolean isConnectAlarmSet() {
        return this.isTimerSet(CONNECT_ALARM_CONTEXT);
    }

    void cancelAttemptRequestTimer() {
        this.cancelTimer(ATTEMPT_CHANGEVIEWREQUEST_ALARM_CONTEXT);
    }

    public void setRequestAttemptTimer() {
        long l = this.g.getConfigParamAsInt("REQUESTED_VIEW_TIMEOUT") * 1000;
        this.setTimer(l, ATTEMPT_CHANGEVIEWREQUEST_ALARM_CONTEXT);
    }

    final void setRESETVLTimer() {
        long l = this.g.getConfigParamAsInt("APPROVAL_KEEP_ALIVE") * 1000;
        this.setTimer(l, RESETVLWAIT_ALARM_CONTEXT);
    }

    final void cancelRESETVLTimer() {
        this.cancelTimer(RESETVLWAIT_ALARM_CONTEXT);
    }

    protected void cancelTimers() {
        this.cancelAttemptRequestTimer();
        this.cancelConnectAlarm();
        this.cancelRESETVLTimer();
    }
}

