/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.event.DCSExternalEvent;
import com.ibm.ws.dcs.vri.common.MemberInfo;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.event.RequestDumpEvent;
import com.ibm.ws.dcs.vri.common.event.VRIUpEvent;
import com.ibm.ws.dcs.vri.common.nls.FailedMergeAttempt;
import com.ibm.ws.dcs.vri.common.nls.InconsistentDefinedSetEvent;
import com.ibm.ws.dcs.vri.common.nls.MBRSuspect;
import com.ibm.ws.dcs.vri.common.nls.ProtocolVersionMismatchEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.ThresholdCounter;
import com.ibm.ws.dcs.vri.membership.MBRDo;
import com.ibm.ws.dcs.vri.membership.MBRState;
import com.ibm.ws.dcs.vri.membership.MBRStateConstants;
import com.ibm.ws.dcs.vri.membership.Role;
import com.ibm.ws.dcs.vri.membership.messages.AddMembersMsg;
import com.ibm.ws.dcs.vri.membership.messages.ChangeDefinedMsg;
import com.ibm.ws.dcs.vri.membership.messages.CompleteCurrentMsg;
import com.ibm.ws.dcs.vri.membership.messages.CurrentOKMsg;
import com.ibm.ws.dcs.vri.membership.messages.DumpAllMsg;
import com.ibm.ws.dcs.vri.membership.messages.MBRRequestTrivalViewChangeEvent;
import com.ibm.ws.dcs.vri.membership.messages.MergeCCOKMsg;
import com.ibm.ws.dcs.vri.membership.messages.MergeNewViewMsg;
import com.ibm.ws.dcs.vri.membership.messages.MergeNoMsg;
import com.ibm.ws.dcs.vri.membership.messages.NewViewMsg;
import com.ibm.ws.dcs.vri.membership.messages.ResetVLWaitAlarmMsg;
import com.ibm.ws.dcs.vri.membership.messages.SuspectMsg;
import com.ibm.ws.dcs.vri.membership.util.MBRDenialReason;
import com.ibm.ws.dcs.vri.membership.util.MBRDenialRecord;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;
import java.util.ArrayList;
import java.util.Map;

class RoleMember
implements Role {
    private static final String CN = "RoleMember";
    private final TraceComponent TC = Tr.register(this.getClass(), "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private static final MBRState.RoleName ROLENAME = MBRStateConstants.MEMBER;
    protected final VRIMembersMGR membersMgr;
    protected final MBRState state;
    protected final VRIMemberDescription thisMember;
    protected final String myName;
    protected final String stackName;

    public RoleMember(MBRState mBRState) {
        this.membersMgr = mBRState.getVRIMembersMgr();
        this.thisMember = this.membersMgr.getThisMember();
        this.myName = this.thisMember.getName();
        this.stackName = this.membersMgr.getThisStackName();
        this.state = mBRState;
    }

    private final int getStateIndex() {
        return this.state.getMajorPhaseIndex(ROLENAME);
    }

    final MBRDo installNewView(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl) {
        MBRLogger.dcsAssert(viewIdImpl.getViewLeader() != null, "viewId has null viewLeader", CN, "installNewView()", this.state.getStackname());
        MBRLogger.dcsAssert(this.membersMgr.getDefinedMember(viewIdImpl.getViewLeader()) != null, "viewId has null viewLeader", CN, "installNewView()", this.state.getStackname());
        this.state.newView(vRIMemberDescriptionArray, viewIdImpl, this.membersMgr.getDefinedMember(viewIdImpl.getViewLeader()));
        this.membersMgr.newView(vRIMemberDescriptionArray, viewIdImpl);
        this.membersMgr.unDenyAll(this.state.getLayer(), MBRDenialReason.ADMINREASONS, true);
        int n = this.membersMgr.getConnectedMembersMinusDeniedSize();
        int n2 = this.membersMgr.getViewMembersMinusDeniedSize();
        if (n2 == n) {
            ((ThresholdCounter)this.state.getMergeNoThresholdCounters().get(5)).reset();
            ((ThresholdCounter)this.state.getMergeNoThresholdCounters().get(2)).reset();
        }
        ((ThresholdCounter)this.state.getMergeNoThresholdCounters().get(3)).reset();
        this.state.updateMajorState(MBRStateConstants.MEMBER, MBRStateConstants.INSTALLING);
        MBRDo mBRDo = new MBRDo(this.state.getStateExchanger().newViewCheckAndUpdate());
        Map map = this.state.getNewConfigMap();
        MBRDo mBRDo2 = new MBRDo(vRIMemberDescriptionArray, viewIdImpl, map);
        mBRDo = MBRDo.addAction(mBRDo, mBRDo2);
        return mBRDo;
    }

    final MBRDo suspectAll(String string) {
        VRIMemberDescription[] vRIMemberDescriptionArray = VRIMemberUtils.minus(this.membersMgr.getViewMembers(), this.thisMember);
        MBRDenialRecord mBRDenialRecord = MBRDenialRecord.createInstallSingletonDR(this, string, vRIMemberDescriptionArray);
        mBRDenialRecord.getSuspectEvent().invokeNLSTrace();
        return this.denyMembersAndSendSuspectMsg(mBRDenialRecord);
    }

    MBRDo suspectSender(String string, String string2) {
        MBRDenialRecord mBRDenialRecord = MBRDenialRecord.createMutualDistrustDR(this, string + " - " + string2, this.membersMgr.getDefinedMember(string));
        return this.suspectSender(string, mBRDenialRecord);
    }

    MBRDo suspectSender(String string) {
        return this.suspectSender(string, " dared to suspect Me");
    }

    MBRDo suspectSenderBrokeProtocol(String string, String string2) {
        MBRDenialRecord mBRDenialRecord = MBRDenialRecord.createMBRBrokeProtocolDR(this, string + " - " + string2, new VRIMemberDescription[]{this.membersMgr.getDefinedMember(string)});
        mBRDenialRecord.getSuspectEvent().invokeNLSTrace();
        return this.suspectSender(string, mBRDenialRecord);
    }

    MBRDo suspectSender(String string, MBRDenialRecord mBRDenialRecord) {
        if (string.equals(this.myName)) {
            String string2 = "I suspected myself";
            return this.suspectAll(string2);
        }
        return this.denyMemberAndSendSuspectMsg(mBRDenialRecord);
    }

    private MBRDo denyMemberAndSendSuspectMsg(MBRDenialRecord mBRDenialRecord) {
        MBRDo mBRDo = null;
        MBRDo mBRDo2 = null;
        MBRDo mBRDo3 = null;
        boolean bl = this.membersMgr.denyMember(mBRDenialRecord.getSuspects()[0].getName(), mBRDenialRecord.getDenialReason());
        SuspectMsg suspectMsg = new SuspectMsg(mBRDenialRecord.getSuspects()[0], mBRDenialRecord.getDenialReason(), this.myName, this.membersMgr);
        mBRDo = new MBRDo(this, suspectMsg);
        if (bl) {
            MBRSuspect mBRSuspect = mBRDenialRecord.getSuspectEvent();
            mBRSuspect.invokeNLSTrace();
            mBRDo2 = new MBRDo(mBRSuspect);
            mBRDo3 = MBRDo.addAction(mBRDo2, mBRDo);
        }
        return mBRDo3;
    }

    MBRDo iAmSuspected(SuspectMsg suspectMsg) {
        MBRDo mBRDo = null;
        if (this.state.isState(this.getName(), MBRStateConstants.SYNCED) || suspectMsg.isAdminastrative(this.thisMember)) {
            String string = suspectMsg.isAdminastrative(this.thisMember) ? "Adminastratively denied" : "ViewLeader suspected me during SYNCED State";
            mBRDo = MBRDo.setAction(mBRDo, this.suspectAll(string));
        } else {
            mBRDo = MBRDo.setAction(mBRDo, this.suspectSender(suspectMsg.getSender()));
        }
        return mBRDo;
    }

    public MBRDo processSuspectMsg(SuspectMsg suspectMsg) {
        MBRDo mBRDo = null;
        if (!this.membersMgr.isInView(suspectMsg.getSender())) {
            String string = "suspect not from view Member";
            MBRLogger.dcsTrace((DCSTraceContext)this, "processSuspectMsg()", 0, string);
            mBRDo = new MBRDo(string);
            return mBRDo;
        }
        if (suspectMsg.iAmSuspected(this.thisMember)) {
            mBRDo = this.iAmSuspected(suspectMsg);
            return mBRDo;
        }
        suspectMsg.removeSuspectsAlreadyFailed(this.state.getSentFailedList());
        suspectMsg.removeSuspectsNotInView();
        if (suspectMsg.isSuspectListEmpty()) {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo("Empty suspect list"));
            return mBRDo;
        }
        switch (this.getStateIndex()) {
            case 0: 
            case 1: 
            case 2: {
                if (!this.checkIfViewLeader(suspectMsg)) break;
                mBRDo = new MBRDo(MBRStateConstants.VIEWLEADER, MBRStateConstants.SPLIT, suspectMsg);
                return mBRDo;
            }
            case 3: {
                break;
            }
            default: {
                MBRLogger.dcsWarning((DCSTraceContext)this, "processSuspectMsg()", this.illegalState());
                return mBRDo;
            }
        }
        if (suspectMsg.fromViewLeader(this.state.getViewLeader())) {
            MBRDo mBRDo2 = this.denyMembers(MBRDenialRecord.createSuspectedByVLDR(this, "Situation Normal", suspectMsg.getSuspectList(), suspectMsg.getSender()));
            MBRDo mBRDo3 = new MBRDo("denied view members suspected by view leader");
            mBRDo = MBRDo.addAction(mBRDo3, mBRDo2);
        }
        return mBRDo;
    }

    protected MBRDo denyMembers(MBRDenialRecord mBRDenialRecord) {
        MBRDo mBRDo = null;
        boolean bl = this.membersMgr.denyMembers(mBRDenialRecord.getSuspects(), mBRDenialRecord.getDenialReason());
        if (bl) {
            mBRDo = new MBRDo(mBRDenialRecord.getSuspectEvent());
        }
        return mBRDo;
    }

    protected String illegalState() {
        return new String("Unknown state " + this.getStateIndex());
    }

    private boolean checkIfViewLeader(SuspectMsg suspectMsg) {
        VRIMemberDescription vRIMemberDescription = this.state.getViewLeader();
        boolean bl = vRIMemberDescription.getName().equals(this.myName);
        MBRLogger.dcsTrace((DCSTraceContext)this, "checkIfViewLeader()", 0, "current.viewLeader=" + vRIMemberDescription);
        while (suspectMsg.isViewLeaderSuspected(vRIMemberDescription) && !bl) {
            MBRDenialReason mBRDenialReason = this.getDenialReason(suspectMsg, "Deny View Leader");
            this.denyMember(vRIMemberDescription.getName(), mBRDenialReason);
            bl = this.state.determineIfViewLeader();
            vRIMemberDescription = this.state.getViewLeader();
            MBRLogger.dcsTrace((DCSTraceContext)this, "checkIfViewLeader()", 0, "current.viewLeader=" + vRIMemberDescription);
        }
        MBRLogger.dcsTrace((DCSTraceContext)this, "checkIfViewLeader()", 0, "iAmViewleader=" + bl);
        return bl;
    }

    public MBRDo processAddMembersMsg(AddMembersMsg addMembersMsg) {
        MBRDo mBRDo = null;
        if (!addMembersMsg.intersectsMyView(this.membersMgr.getViewMinusDenied())) {
            return new MBRDo("Not for me- candidates and view disjoint");
        }
        if (this.membersMgr.isDenied(addMembersMsg.getSender())) {
            mBRDo = MBRDo.setAction(mBRDo, this.makeMergeNoMsg(addMembersMsg.getSender(), 6, addMembersMsg));
            return mBRDo;
        }
        if (addMembersMsg.isProtocolConflict()) {
            mBRDo = MBRDo.setAction(mBRDo, this.makeMergeNoMsg(addMembersMsg.getSender(), 8, addMembersMsg));
            return mBRDo;
        }
        if (!addMembersMsg.isSentByMyself(this.myName) && this.state.changedPV()) {
            mBRDo = MBRDo.setAction(mBRDo, this.makeMergeNoMsg(addMembersMsg.getSender(), 9, addMembersMsg));
            return mBRDo;
        }
        switch (this.getStateIndex()) {
            case 0: {
                if (this.state.determineIfViewLeader()) {
                    if (addMembersMsg.isDefineConflict()) {
                        String string = "InconsistentDefinedSets My= " + this.myName + VRIMemberUtils.toString(this.membersMgr.getDefinedMembers(true)) + "Sender= " + addMembersMsg.getSender() + " " + Utils.toString(MemberInfo.getNames(addMembersMsg.getDefinedSet()));
                        if (addMembersMsg.containsMe(this.membersMgr.getThisMember())) {
                            InconsistentDefinedSetEvent inconsistentDefinedSetEvent = new InconsistentDefinedSetEvent(this, this.membersMgr.getDefinedMembers(true), addMembersMsg.getSender(), addMembersMsg.getDefinedSet(), null);
                            MBRDo mBRDo2 = new MBRDo(inconsistentDefinedSetEvent);
                            MBRDo mBRDo3 = this.makeMergeNoMsg(addMembersMsg.getSender(), 1, addMembersMsg);
                            mBRDo = MBRDo.addAction(mBRDo2, mBRDo3);
                        } else {
                            mBRDo = new MBRDo("AddMembersMsg conflicting Define Sets- not intended for me" + string);
                        }
                        return mBRDo;
                    }
                    if (!addMembersMsg.containsView(this.membersMgr.getViewMinusDenied())) {
                        mBRDo = MBRDo.setAction(mBRDo, this.makeMergeNoMsg(addMembersMsg.getSender(), 2, addMembersMsg));
                        return mBRDo;
                    }
                    if (this.state.isProtocol(MBRStateConstants.SPLIT)) {
                        mBRDo = MBRDo.setAction(mBRDo, this.makeMergeNoMsg(addMembersMsg.getSender(), 0, addMembersMsg));
                        return mBRDo;
                    }
                    mBRDo = new MBRDo(MBRStateConstants.VIEWLEADER, MBRStateConstants.MERGE, addMembersMsg);
                    break;
                }
                if (!addMembersMsg.amIExpectedLeader(this.state.getPotentialViewLeaders(), this.membersMgr.getThisMember())) break;
                mBRDo = MBRDo.setAction(mBRDo, this.makeMergeNoMsg(addMembersMsg.getSender(), 2, addMembersMsg));
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (addMembersMsg.amIExpectedLeader(this.state.getPotentialViewLeaders(), this.membersMgr.getThisMember())) {
                    mBRDo = MBRDo.setAction(mBRDo, this.makeMergeNoMsg(addMembersMsg.getSender(), 3, addMembersMsg));
                    break;
                }
                mBRDo = new MBRDo("Ignore Msg not intended for Me");
                break;
            }
            default: {
                MBRLogger.dcsWarning((DCSTraceContext)this, "processAddMembersMsg()", this.illegalState());
            }
        }
        return mBRDo;
    }

    protected MBRDo makeMergeNoMsg(String string, int n, AddMembersMsg addMembersMsg) {
        DCSTraceable dCSTraceable;
        int n2;
        int n3;
        MergeNoMsg mergeNoMsg;
        MBRDo mBRDo = null;
        if (addMembersMsg != null) {
            mergeNoMsg = new MergeNoMsg(n, this.membersMgr.getViewMinusDenied(), this.state.getViewId(), string, addMembersMsg, this.myName, this.membersMgr);
            n3 = this.membersMgr.getProtocolVersion();
            n2 = addMembersMsg.getSentDCSProtocolVersion();
        } else {
            MBRLogger.dcsAssert(true, "create MergeNo not in response to addMembersMsg", this.getClass().getName(), "makeMergeNoMsg()", this.stackName);
            mergeNoMsg = new MergeNoMsg(n, this.membersMgr.getViewMinusDenied(), this.state.getViewId(), string, this.state.getReceivedMergeLeaderContext(), this.myName, this.membersMgr);
            n3 = this.state.getNextProtocolVersion();
            n2 = this.membersMgr.getProtocolVersion();
        }
        new FailedMergeAttempt((DCSTraceContext)this, new String[]{string}, mergeNoMsg.getReason()).invokeNLSTrace();
        mBRDo = new MBRDo(this, mergeNoMsg);
        if (n == 8) {
            dCSTraceable = new ProtocolVersionMismatchEvent(this, "DCS Protocol Version mismatch: " + mergeNoMsg.getReason(), n3, n2);
            mBRDo = MBRDo.addAction(mBRDo, new MBRDo((DCSExternalEvent)dCSTraceable));
        }
        if (mergeNoMsg.shouldRequestDump(this.state.getMergeNoThresholdCounters())) {
            dCSTraceable = new RequestDumpEvent(this.stackName, this.myName, mergeNoMsg.getReason(), 0);
            MBRDo mBRDo2 = new MBRDo((VRIUpEvent)dCSTraceable);
            return MBRDo.addAction(mBRDo, mBRDo2);
        }
        return mBRDo;
    }

    public final MBRDo processCompleteCurrentMsg(CompleteCurrentMsg completeCurrentMsg) {
        Object object;
        boolean bl;
        Object object2;
        MBRDo mBRDo = null;
        if (!this.membersMgr.isInView(completeCurrentMsg.getSender())) {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo("Message from Non View Member"));
            return mBRDo;
        }
        completeCurrentMsg.removeNonViewMembers(this.membersMgr.getViewMembers());
        if (completeCurrentMsg.viewIDFromFuture(this.state.getViewId())) {
            String string = "Received ViewId from Future" + completeCurrentMsg.getSender() + ": " + completeCurrentMsg.getCCV() + " Expected viewId" + this.state.getReceivedCCV();
            mBRDo = this.suspectAll(string);
            return mBRDo;
        }
        if (completeCurrentMsg.viewIDFromPast(this.state.getViewId())) {
            MBRLogger.dcsInternalInfo((DCSTraceContext)this, "processCompleteCurrentMsg()", "CCVId from past from " + completeCurrentMsg.getSender() + " sentCCV= " + completeCurrentMsg.getCCV() + " Expected: " + this.state.getReceivedCCV());
            return mBRDo;
        }
        if (!completeCurrentMsg.isFailedListEmpty()) {
            if (completeCurrentMsg.iAmFailed(this.thisMember)) {
                mBRDo = MBRDo.setAction(mBRDo, this.suspectSender(completeCurrentMsg.getSender(), "included me in CCMsg failed list"));
                return mBRDo;
            }
            if (!completeCurrentMsg.thisListContainsPreviousList(this.state.getReceivedFailedList())) {
                String string = "failed List does not contain previous failed list" + VRIMemberUtils.toString(completeCurrentMsg.getFailedList()) + " vs. " + VRIMemberUtils.toString(this.state.getReceivedFailedList());
                if (this.membersMgr.getProtocolVersion() > 51001) {
                    MBRDenialRecord mBRDenialRecord = MBRDenialRecord.createResendSuspectedDR(this, string, this.state.getReceivedFailedList());
                    mBRDo = MBRDo.setAction(mBRDo, this.denyMembersAndSendSuspectMsg(mBRDenialRecord));
                } else {
                    mBRDo = MBRDo.setAction(mBRDo, this.suspectAll(string));
                }
                return mBRDo;
            }
            if (!completeCurrentMsg.thisListGreaterThanPreviousList(this.state.getReceivedFailedList())) {
                return mBRDo;
            }
        }
        if (completeCurrentMsg.isViewLeaderAmongstFailed(this.state.getViewLeader())) {
            object2 = MBRDenialRecord.createSuspectedByOthersDR(this, "In CompleteCurrentMsg - VL denied by sender", completeCurrentMsg.getFailedList(), completeCurrentMsg.getSender());
            bl = this.denyMembers(((MBRDenialRecord)object2).getSuspects(), ((MBRDenialRecord)object2).getDenialReason());
            if (bl) {
                ((MBRDenialRecord)object2).getSuspectEvent().invokeNLSTrace();
            }
            if (this.state.determineIfViewLeader()) {
                this.state.changeRole(MBRStateConstants.VIEWLEADER);
            } else {
                if (!completeCurrentMsg.fromViewLeader(this.state.getViewLeader())) {
                    mBRDo = this.suspectSenderBrokeProtocol(completeCurrentMsg.getSender(), "CCMsg not from expected new VL");
                    return mBRDo;
                }
                if (!completeCurrentMsg.ccVViewLeaderOkay(this.state.getViewLeader())) {
                    mBRDo = this.suspectAll("Received Bad CCV in CCMsg from expected new VL");
                    return mBRDo;
                }
                if (!completeCurrentMsg.containsMyDenies(this.membersMgr.getDeniedMembers(true))) {
                    object = VRIMemberUtils.minus(this.membersMgr.getDeniedMembers(true), completeCurrentMsg.getFailedList());
                    MBRDenialRecord mBRDenialRecord = MBRDenialRecord.createResendSuspectedDR(this, "VL didn't include all my denies", (VRIMemberDescription[])object);
                    mBRDo = this.denyMembersAndSendSuspectMsg(mBRDenialRecord);
                }
            }
        }
        if (!completeCurrentMsg.fromViewLeader(this.state.getViewLeader())) {
            mBRDo = this.suspectSenderBrokeProtocol(completeCurrentMsg.getSender(), "CCMsg not from viewLeader");
            return mBRDo;
        }
        if (!completeCurrentMsg.ccVViewLeaderOkay(this.state.getViewLeader())) {
            mBRDo = this.suspectAll("Received Bad CCV in CompleteCurrentMsg ");
            return mBRDo;
        }
        switch (this.getStateIndex()) {
            case 0: 
            case 2: {
                boolean bl2;
                object2 = this.determineProtocol(this.state.getProtocol(), completeCurrentMsg);
                MBRState.RoleName roleName = this.state.getRoleName();
                if (roleName.equals(MBRStateConstants.MEMBER)) {
                    this.state.updateProtocol((MBRState.Protocol)object2);
                }
                this.state.updateMajorState(MBRStateConstants.MEMBER, MBRStateConstants.SYNCING);
                this.state.setReceivedFailedListAndCCV(completeCurrentMsg.getFailedList(), completeCurrentMsg.getCCV());
                if (!completeCurrentMsg.isFailedListEmpty() && (bl2 = this.denyMembers(((MBRDenialRecord)(object = MBRDenialRecord.createSuspectedByVLDR(this, "CC-Situation Normal", completeCurrentMsg.getFailedList(), completeCurrentMsg.getSender()))).getSuspects(), ((MBRDenialRecord)object).getDenialReason()))) {
                    ((MBRDenialRecord)object).getSuspectEvent().invokeNLSTrace();
                }
                mBRDo = MBRDo.addAction(mBRDo, new MBRDo(completeCurrentMsg.getFailedList(), completeCurrentMsg.getCCV()));
                break;
            }
            case 1: {
                this.state.setReceivedFailedListAndCCV(completeCurrentMsg.getFailedList(), completeCurrentMsg.getCCV());
                if (!completeCurrentMsg.isFailedListEmpty() && (bl = this.denyMembers(((MBRDenialRecord)(object2 = MBRDenialRecord.createSuspectedByVLDR(this, "CC-Situation Normal", completeCurrentMsg.getFailedList(), completeCurrentMsg.getSender()))).getSuspects(), ((MBRDenialRecord)object2).getDenialReason()))) {
                    ((MBRDenialRecord)object2).getSuspectEvent().invokeNLSTrace();
                }
                mBRDo = MBRDo.addAction(mBRDo, new MBRDo(completeCurrentMsg.getFailedList(), completeCurrentMsg.getCCV()));
                break;
            }
            case 3: {
                this.state.queueMessage(completeCurrentMsg);
                mBRDo = MBRDo.setAction(mBRDo, new MBRDo("CC Message from next view queueing" + completeCurrentMsg.toString()));
            }
            default: {
                MBRLogger.dcsWarning((DCSTraceContext)this, "RoleMember.processCompleteCurrentMsg()", this.illegalState());
            }
        }
        return mBRDo;
    }

    public MBRDo processCurrentOKMsg(CurrentOKMsg currentOKMsg) {
        MBRDo mBRDo = null;
        if (!this.state.determineIfViewLeader()) {
            return mBRDo;
        }
        return mBRDo;
    }

    public MBRDo processMergeCCOKMsg(MergeCCOKMsg mergeCCOKMsg) {
        MBRDo mBRDo = null;
        if (!this.state.iAmMergeLeader()) {
            mBRDo = new MBRDo();
            return mBRDo;
        }
        return mBRDo;
    }

    public MBRDo processMergeNoMsg(MergeNoMsg mergeNoMsg) {
        MBRDo mBRDo = null;
        if (!this.state.iAmMergeLeader()) {
            mBRDo = new MBRDo();
            return mBRDo;
        }
        return mBRDo;
    }

    public MBRDo processMergeNewViewMsg(MergeNewViewMsg mergeNewViewMsg) {
        MBRDo mBRDo = null;
        if (!this.state.determineIfViewLeader()) {
            mBRDo = new MBRDo();
            return mBRDo;
        }
        return mBRDo;
    }

    public MBRDo processNewViewMsg(NewViewMsg newViewMsg) {
        MBRDo mBRDo = null;
        ViewIdImpl viewIdImpl = newViewMsg.getNewViewId();
        switch (this.state.getViewId().compareTo(viewIdImpl)) {
            case 0: 
            case 1: {
                String string = "Unexpected viewId from Past";
                mBRDo = new MBRDo((DCSTraceContext)this, string, "processNewViewMsg()", 0);
                return mBRDo;
            }
        }
        if (!newViewMsg.fromViewLeader(this.state.getViewLeader())) {
            MBRLogger.dcsInternalInfo((DCSTraceContext)this, "processNewViewMsg()", "Unexpected message viewId from non-view leader");
            return mBRDo;
        }
        if (!newViewMsg.iAmInNewView(this.thisMember)) {
            mBRDo = this.suspectSenderBrokeProtocol(newViewMsg.getSender(), "NewViewMsg from viewLeader does not contain me");
            return mBRDo;
        }
        if (!newViewMsg.areAllDefined()) {
            mBRDo = this.suspectSenderBrokeProtocol(newViewMsg.getSender(), "Not all new view members defined in NewViewMsg");
            return mBRDo;
        }
        VRIMemberDescription[] vRIMemberDescriptionArray = newViewMsg.getSyncedList();
        switch (this.getStateIndex()) {
            case 0: {
                mBRDo = new MBRDo("Illegal State for New View");
                break;
            }
            case 1: {
                mBRDo = new MBRDo("Illegal State for New View");
                break;
            }
            case 2: {
                this.state.getStateExchanger().setStateBlob(newViewMsg.getVLAppStateBlob());
                this.state.getAlarm().cancelMBTimer();
                mBRDo = this.installNewView(vRIMemberDescriptionArray, viewIdImpl);
                break;
            }
            case 3: {
                MBRLogger.dcsWarning((DCSTraceContext)this, "RoleMember.processNewViewMsg()", this.illegalState());
                mBRDo = new MBRDo("Illegal State for New View");
                break;
            }
            default: {
                MBRLogger.dcsWarning((DCSTraceContext)this, "RoleMember.processNewViewMsg()", this.illegalState());
            }
        }
        return mBRDo;
    }

    public MBRDo processChangeDefinedMsg(ChangeDefinedMsg changeDefinedMsg) {
        if (this.TC.isEntryEnabled()) {
            Tr.entry(this.TC, "processChangeDefinedMsg() on " + this.stackName);
        }
        MemberInfo[] memberInfoArray = changeDefinedMsg.getAddList();
        String[] stringArray = changeDefinedMsg.getRemoveList();
        ArrayList arrayList = new ArrayList();
        VRIMemberDescription[] vRIMemberDescriptionArray = this.membersMgr.addDefinedMembers(this.state.getLayer(), memberInfoArray, arrayList);
        MBRDo mBRDo = new MBRDo(this, VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray), stringArray, this.membersMgr, changeDefinedMsg.getContext(), arrayList.toArray(new String[arrayList.size()]), changeDefinedMsg.isCoreStack());
        return mBRDo;
    }

    public MBRDo handleMLWaitForVLCCAlarm(int n) {
        MBRLogger.dcsInternalInfo((DCSTraceContext)this, "handleMLWaitForVLCCAlarm()", "alarm fired after role change");
        return null;
    }

    public MBRDo handleVLWaitForMLNVAlarm(int n) {
        MBRLogger.dcsInternalInfo((DCSTraceContext)this, "handleVLWaitForMLNVAlarm()", "alarm fired after role change");
        return null;
    }

    public MBRState.RoleName getName() {
        return MBRStateConstants.MEMBER;
    }

    public VRIMemberDescription getViewLeader() {
        return this.state.getViewLeader();
    }

    private MBRState.Protocol determineProtocol(MBRState.Protocol protocol2, CompleteCurrentMsg completeCurrentMsg) {
        MBRState.Protocol protocol3 = protocol2;
        if (protocol3 == MBRStateConstants.MESSAGING && completeCurrentMsg.isFirstCCV()) {
            protocol3 = completeCurrentMsg.isFailedListEmpty() ? MBRStateConstants.MERGE : MBRStateConstants.SPLIT;
        }
        return protocol3;
    }

    final boolean denyMembers(VRIMemberDescription[] vRIMemberDescriptionArray, MBRDenialReason mBRDenialReason) {
        return this.membersMgr.denyMembers(vRIMemberDescriptionArray, mBRDenialReason);
    }

    final MBRDo denyMembersAndSendSuspectMsg(MBRDenialRecord mBRDenialRecord) {
        MBRDo mBRDo = null;
        MBRDo mBRDo2 = null;
        MBRDo mBRDo3 = null;
        boolean bl = false;
        boolean bl2 = mBRDenialRecord.getDenialReason().isResend();
        if (!bl2) {
            bl = this.membersMgr.denyMembers(mBRDenialRecord.getSuspects(), mBRDenialRecord.getDenialReason());
        }
        SuspectMsg suspectMsg = new SuspectMsg(mBRDenialRecord.getSuspects(), mBRDenialRecord.getDenialReason(), this.myName, this.membersMgr);
        mBRDo = new MBRDo(this, suspectMsg);
        if (bl) {
            MBRSuspect mBRSuspect = mBRDenialRecord.getSuspectEvent();
            if (mBRDenialRecord.getDenialReason().getDenialReasonCode() == 2) {
                mBRSuspect.invokeNLSTrace();
            }
            mBRDo2 = new MBRDo(mBRSuspect);
            mBRDo3 = MBRDo.addAction(mBRDo2, mBRDo);
            return mBRDo3;
        }
        if (bl2) {
            return mBRDo;
        }
        return null;
    }

    final boolean denyMember(String string, MBRDenialReason mBRDenialReason) {
        return this.membersMgr.denyMember(string, mBRDenialReason);
    }

    public MBRDo processResetVLWaitAlarmMsg(ResetVLWaitAlarmMsg resetVLWaitAlarmMsg) {
        MBRLogger.dcsInternalInfo((DCSTraceContext)this, "processResetVLWaitAlarmMsg()", "Not legal msg for role");
        return null;
    }

    public TraceComponent getTraceComponent() {
        return this.getTC();
    }

    protected TraceComponent getTC() {
        return this.TC;
    }

    public String getStackName() {
        return this.state.getStackname();
    }

    public String getMemberName() {
        return this.state.myName;
    }

    public String getLayerName() {
        return "MBR";
    }

    protected MBRDenialReason getDenialReason(SuspectMsg suspectMsg, String string) {
        MBRDenialReason mBRDenialReason = suspectMsg.isSentByMyself(this.myName) ? MBRDenialReason.createSuspectedByMeDR(suspectMsg.getSender() + "(myself) " + string) : MBRDenialRecord.createSuspectedByOthersDR(this, string, null, suspectMsg.getSender()).getDenialReason();
        return mBRDenialReason;
    }

    public MBRDo proceesTrivialViewChangeEvent(MBRRequestTrivalViewChangeEvent mBRRequestTrivalViewChangeEvent) {
        MBRDo mBRDo = null;
        switch (this.getStateIndex()) {
            case 0: {
                if (!this.state.determineIfViewLeader()) break;
                mBRDo = new MBRDo(MBRStateConstants.VIEWLEADER, MBRStateConstants.SPLIT, mBRRequestTrivalViewChangeEvent);
                return mBRDo;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                MBRLogger.dcsWarning((DCSTraceContext)this, "proceesTrivialViewChangeEvent()", this.illegalState());
                return mBRDo;
            }
        }
        return null;
    }

    public MBRDo handleVLWaitForMBCCAlarm(int n) {
        MBRLogger.dcsInternalInfo((DCSTraceContext)this, "handleVLWaitForMBCCAlarm()", "alarm fired after role change");
        return null;
    }

    public MBRDo handleMBWaitForVLNVAlarm(int n) {
        MBRDo mBRDo = null;
        if (this.state.determineIfViewLeader()) {
            return new MBRDo("I am the view leader");
        }
        switch (this.getStateIndex()) {
            case 0: 
            case 1: 
            case 3: {
                MBRLogger.dcsInternalInfo((DCSTraceContext)this, "handleMBWaitForVLNVAlarm()", "Unexpected State- " + this.getStateIndex());
                break;
            }
            case 2: {
                VRIMemberDescription[] vRIMemberDescriptionArray = new VRIMemberDescription[]{this.state.getViewLeader()};
                MBRDenialRecord mBRDenialRecord = MBRDenialRecord.createExpRespTimeoutDR(this, "MB wait for VL expired ", vRIMemberDescriptionArray, n);
                mBRDenialRecord.getSuspectEvent().invokeNLSTrace();
                if (!this.state.determineIfViewLeader(vRIMemberDescriptionArray)) {
                    this.state.getAlarm().setMBTimer(this.state.isProtocol(MBRStateConstants.SPLIT));
                }
                mBRDo = MBRDo.setAction(mBRDo, this.denyMembersAndSendSuspectMsg(mBRDenialRecord));
                break;
            }
            default: {
                MBRLogger.dcsInternalInfo((DCSTraceContext)this, "handleMBWaitForVLNVAlarm()", "Bad State -" + this.getStateIndex());
            }
        }
        return mBRDo;
    }

    public MBRDo processDumpAllMsg(DumpAllMsg dumpAllMsg) {
        MBRDo mBRDo;
        int n = this.shouldDump(dumpAllMsg);
        if (n == 0) {
            RequestDumpEvent requestDumpEvent = new RequestDumpEvent(this.stackName, this.thisMember.getName(), dumpAllMsg.getDumpReason(), dumpAllMsg.getScope(), true);
            mBRDo = new MBRDo(requestDumpEvent);
        } else {
            mBRDo = new MBRDo("Don't dump, reason code=" + n);
        }
        return mBRDo;
    }

    private int shouldDump(DumpAllMsg dumpAllMsg) {
        int n;
        int n2 = n = dumpAllMsg.isSentByMyself(this.thisMember.getName()) ? 1 : 0;
        if (n != 0) {
            return n;
        }
        n = this.state.shouldIDump() ? 0 : 2;
        return n;
    }
}

