/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership;

import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.event.RequestDumpEvent;
import com.ibm.ws.dcs.vri.common.nls.FailedMergeAttempt;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.membership.MBRDo;
import com.ibm.ws.dcs.vri.membership.MBRState;
import com.ibm.ws.dcs.vri.membership.MBRStateConstants;
import com.ibm.ws.dcs.vri.membership.RoleViewLeaderMerge;
import com.ibm.ws.dcs.vri.membership.messages.MergeCCOKMsg;
import com.ibm.ws.dcs.vri.membership.messages.MergeNewViewMsg;
import com.ibm.ws.dcs.vri.membership.messages.MergeNoMsg;
import com.ibm.ws.dcs.vri.membership.messages.SuspectMsg;
import com.ibm.ws.dcs.vri.membership.util.MBRDenialRecord;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;

class RoleMergeLeader
extends RoleViewLeaderMerge {
    private static final MBRState.RoleName ROLENAME = MBRStateConstants.MERGELEADER;

    public RoleMergeLeader(MBRState mBRState) {
        super(mBRState);
    }

    private final int getStateIndex() {
        return this.state.getMajorPhaseIndex(ROLENAME);
    }

    public MBRDo handleMLWaitForVLCCAlarm(int n) {
        MBRDo mBRDo = null;
        switch (this.getStateIndex()) {
            case 0: {
                MBRLogger.dcsInternalInfo((DCSTraceContext)this, "handleMLWaitForVLCCAlarm()", "Illegal State- Normal");
                break;
            }
            case 1: {
                if (this.state.iHaveNotRespondedtoMerge()) {
                    this.state.setMergeViewToNull();
                    mBRDo = MBRDo.setAction(mBRDo, this.prepareMergeNewViewAction());
                    return mBRDo;
                }
                VRIMemberDescription[] vRIMemberDescriptionArray = this.state.getMergeNonRespondants();
                VRIMemberDescription[] vRIMemberDescriptionArray2 = this.membersMgr.removeUndefined(vRIMemberDescriptionArray);
                MBRDenialRecord mBRDenialRecord = MBRDenialRecord.createExpRespTimeoutDR(this, "ML wait for VL expired ", vRIMemberDescriptionArray2, n);
                new FailedMergeAttempt((DCSTraceContext)this, VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray), n).invokeNLSTrace();
                mBRDo = MBRDo.setAction(mBRDo, this.denyMembersAndSendSuspectMsg(mBRDenialRecord));
                break;
            }
            default: {
                MBRLogger.dcsInternalInfo((DCSTraceContext)this, "handleMLWaitForVLCCAlarm()", this.illegalState());
            }
        }
        return mBRDo;
    }

    public MBRDo processMergeCCOKMsg(MergeCCOKMsg mergeCCOKMsg) {
        MBRDo mBRDo = null;
        if (!mergeCCOKMsg.isForMe()) {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo("MergeCCOK not addressed to Me"));
            return mBRDo;
        }
        if (!mergeCCOKMsg.isCorrectContext(this.state.getSentMergeLeaderContext())) {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo("MergeCCOK bad context My= " + this.state.getSentMergeLeaderContext() + " Sent= " + mergeCCOKMsg.getMergeContext()));
            return mBRDo;
        }
        if (!mergeCCOKMsg.areAllDefinedViewList()) {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo("MergeCCOK Msg contains undefined Members"));
            return mBRDo;
        }
        switch (this.getStateIndex()) {
            case 0: {
                mBRDo = MBRDo.setAction(mBRDo, new MBRDo("Ignore MergeCCOK not in correct phase"));
                return mBRDo;
            }
            case 1: {
                if (!mergeCCOKMsg.getSender().equals(this.myName)) {
                    VRIMemberDescription[] vRIMemberDescriptionArray = this.membersMgr.getViewMinusDenied();
                    mergeCCOKMsg.handleSyncListContains(vRIMemberDescriptionArray);
                    mergeCCOKMsg.handleDeniedListContains(vRIMemberDescriptionArray);
                }
                mergeCCOKMsg.handleSyncListContains(this.state.getMergeCandidates());
                mergeCCOKMsg.handleDeniedListContains(this.state.getMergeCandidates());
                this.state.getStateExchanger().setVLResponse(mergeCCOKMsg.getSender(), mergeCCOKMsg.getVLResponse());
                this.state.registerMergeCCOK(mergeCCOKMsg.getSender(), mergeCCOKMsg.getViewList(), mergeCCOKMsg.getcombinedDeniedList(), mergeCCOKMsg.getViewID());
                if (this.state.receivedAllMergeCCOK()) {
                    mBRDo = this.prepareMergeNewViewAction();
                    return mBRDo;
                }
                mBRDo = MBRDo.setAction(mBRDo, new MBRDo(" Didn't get all of the MMCOK"));
                break;
            }
            default: {
                MBRLogger.dcsWarning((DCSTraceContext)this, "RoleMergeLeader.processMergeCCOKMsg()", this.illegalState());
            }
        }
        return mBRDo;
    }

    public MBRDo processMergeNoMsg(MergeNoMsg mergeNoMsg) {
        MBRDo mBRDo = null;
        if (!mergeNoMsg.isForMe()) {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo("MergeNo not addressed to Me"));
            return mBRDo;
        }
        if (!mergeNoMsg.isCorrectContext(this.state.getSentMergeLeaderContext())) {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo("MergeNo bad context My= " + this.state.getSentMergeLeaderContext() + " Sent= " + mergeNoMsg.getMergeContext()));
            return mBRDo;
        }
        if (mergeNoMsg.getSender().equals(this.myName)) {
            RequestDumpEvent requestDumpEvent = new RequestDumpEvent(this.stackName, this.myName, mergeNoMsg.getReason(), 0);
            MBRDo mBRDo2 = new MBRDo(requestDumpEvent);
            new FailedMergeAttempt((DCSTraceContext)this, new String[]{mergeNoMsg.getSender()}, mergeNoMsg.getReason()).invokeNLSTrace();
            this.state.setMergeViewToNull();
            mBRDo = this.prepareMergeNewViewAction();
            return MBRDo.addAction(mBRDo, mBRDo2);
        }
        switch (this.getStateIndex()) {
            case 0: {
                break;
            }
            case 1: {
                new FailedMergeAttempt((DCSTraceContext)this, new String[]{mergeNoMsg.getSender()}, mergeNoMsg.getReason()).invokeNLSTrace();
                this.state.registerMergeCCOKNO(mergeNoMsg.getViewList());
                if (this.state.receivedAllMergeCCOK()) {
                    mBRDo = this.prepareMergeNewViewAction();
                    break;
                }
                mBRDo = MBRDo.setAction(mBRDo, new MBRDo(" Didn't get all of the MMCOK"));
                break;
            }
        }
        return mBRDo;
    }

    public MBRDo processSuspectMsg(SuspectMsg suspectMsg) {
        MBRDo mBRDo = null;
        switch (this.getStateIndex()) {
            case 0: {
                mBRDo = MBRDo.setAction(mBRDo, super.processSuspectMsg(suspectMsg));
                break;
            }
            case 1: {
                if (!this.membersMgr.isInView(suspectMsg.getSender())) {
                    mBRDo = MBRDo.setAction(mBRDo, new MBRDo("Not from View Member"));
                    return mBRDo;
                }
                if (suspectMsg.iAmSuspected(this.thisMember)) {
                    if (this.state.isState(this.getName(), MBRStateConstants.SYNCED)) {
                        String string = "ViewLeader suspected me during SYNCED State";
                        mBRDo = MBRDo.setAction(mBRDo, this.suspectAll(string));
                        return mBRDo;
                    }
                    mBRDo = MBRDo.setAction(mBRDo, this.suspectSender(suspectMsg.getSender()));
                    return mBRDo;
                }
                suspectMsg.removeSuspectsAlreadyFailed(this.state.getSentFailedList());
                VRIMemberDescription[] vRIMemberDescriptionArray = suspectMsg.getMergeSuspects();
                if (vRIMemberDescriptionArray != null) {
                    this.denyMembers(MBRDenialRecord.createSuspectedByOthersDR(this, "Reason code for first suspect:" + suspectMsg.getReasonCode(vRIMemberDescriptionArray[0]), vRIMemberDescriptionArray, suspectMsg.getSender()));
                    this.state.registerMergeCCOKNO(vRIMemberDescriptionArray);
                    if (this.state.receivedAllMergeCCOK()) {
                        mBRDo = this.prepareMergeNewViewAction();
                        return mBRDo;
                    }
                }
                mBRDo = MBRDo.setAction(mBRDo, super.processSuspectMsg(suspectMsg));
                break;
            }
            default: {
                MBRLogger.dcsWarning((DCSTraceContext)this, "processSuspectMsg()", this.illegalState());
            }
        }
        return mBRDo;
    }

    MBRDo prepareMergeNewViewAction() {
        MBRDo mBRDo = null;
        MergeNewViewMsg mergeNewViewMsg = this.state.prepareMergeNewViewMsg();
        MBRDo mBRDo2 = MBRDo.setAction(mBRDo, new MBRDo(this, mergeNewViewMsg));
        if (this.state.shouldRequestDump()) {
            RequestDumpEvent requestDumpEvent = new RequestDumpEvent(this.stackName, this.myName, "Received Incomming MergeNoMsgs", 0);
            MBRDo mBRDo3 = new MBRDo(requestDumpEvent);
            mBRDo = MBRDo.addAction(mBRDo2, mBRDo3);
        } else {
            mBRDo = mBRDo2;
        }
        return mBRDo;
    }

    public MBRState.RoleName getName() {
        return MBRStateConstants.MERGELEADER;
    }
}

