/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership;

import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.membership.MBRDo;
import com.ibm.ws.dcs.vri.membership.MBRState;
import com.ibm.ws.dcs.vri.membership.MBRStateConstants;
import com.ibm.ws.dcs.vri.membership.RoleMember;
import com.ibm.ws.dcs.vri.membership.messages.CompleteCurrentMsg;
import com.ibm.ws.dcs.vri.membership.messages.CurrentOKMsg;
import com.ibm.ws.dcs.vri.membership.messages.MBRMessage;
import com.ibm.ws.dcs.vri.membership.messages.SuspectMsg;
import com.ibm.ws.dcs.vri.membership.util.MBRDenialRecord;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;

abstract class RoleViewLeader
extends RoleMember {
    private static final MBRState.RoleName ROLENAME = MBRStateConstants.VIEWLEADER;

    public RoleViewLeader(MBRState mBRState) {
        super(mBRState);
    }

    private final int getStateIndex() {
        return this.state.getMajorPhaseIndex(ROLENAME);
    }

    public MBRDo processCurrentOKMsg(CurrentOKMsg currentOKMsg) {
        MBRDo mBRDo = null;
        if (!this.membersMgr.isInView(currentOKMsg.getSender())) {
            MBRLogger.dcsInternalInfo((DCSTraceContext)this, "processCurrentOKMsg", "current OKMsg not from ViewMember " + currentOKMsg.getSender() + currentOKMsg.getCCV());
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo("Not from View Member"));
            return mBRDo;
        }
        switch (currentOKMsg.getCCV().compareTo(this.state.getSentCCV())) {
            case 0: {
                break;
            }
            case -1: {
                mBRDo = MBRDo.setAction(mBRDo, new MBRDo("Old CCV"));
                MBRLogger.dcsInternalInfo((DCSTraceContext)this, "processCurrentOKMsg", "CCV from the past sentCCV=" + currentOKMsg.getCCV() + " myCCV= " + this.state.getSentCCV());
                return mBRDo;
            }
            case 1: {
                MBRLogger.dcsInternalInfo((DCSTraceContext)this, "processCurrentOKMsg", "CCV from the future sentCCV=" + currentOKMsg.getCCV() + " myCCV= " + this.state.getSentCCV());
            }
        }
        if (currentOKMsg.iAmInCcokDeniedList()) {
            mBRDo = MBRDo.setAction(mBRDo, this.suspectSenderBrokeProtocol(currentOKMsg.getSender(), "Include me in denied list of CCOKMsg"));
            return mBRDo;
        }
        switch (this.getStateIndex()) {
            case 0: {
                break;
            }
            case 1: {
                this.state.registerCCOK(currentOKMsg.getSender(), currentOKMsg.getCcokDenied());
                if (this.state.receivedAllCCOK()) {
                    mBRDo = MBRDo.setAction(mBRDo, this.viewSyncedDoNextStep());
                    break;
                }
                mBRDo = MBRDo.setAction(mBRDo, new MBRDo("Have not yet received all CCOKs"));
                break;
            }
            default: {
                MBRLogger.dcsWarning((DCSTraceContext)this, "RoleViewLeader.processCurrentOKMsg()", this.illegalState());
            }
        }
        return mBRDo;
    }

    public MBRDo processSuspectMsg(SuspectMsg suspectMsg) {
        MBRDo mBRDo = null;
        if (!this.membersMgr.isInView(suspectMsg.getSender())) {
            MBRLogger.dcsInternalInfo((DCSTraceContext)this, "processSuspectKMsg", "suspectMsg not from ViewMember");
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo("Suspect from Non View Member"));
            return mBRDo;
        }
        if (suspectMsg.iAmSuspected(this.thisMember)) {
            mBRDo = this.iAmSuspected(suspectMsg);
            return mBRDo;
        }
        suspectMsg.removeSuspectsAlreadyFailed(this.state.getSentFailedList());
        return mBRDo;
    }

    public MBRState.RoleName getName() {
        return MBRStateConstants.VIEWLEADER;
    }

    MBRDo viewSyncedDoNextStep() {
        MBRMessage mBRMessage;
        MBRDo mBRDo = null;
        this.state.getAlarm().cancelVLCCTimer();
        if (this.state.isProtocol(MBRStateConstants.MERGE)) {
            mBRMessage = this.state.prepareMergeCCOKMsg();
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo(this, mBRMessage));
        }
        if (this.state.isProtocol(MBRStateConstants.SPLIT)) {
            mBRMessage = this.state.prepareNewViewMsgForSplit();
            MBRDo mBRDo2 = new MBRDo(this, mBRMessage);
            mBRDo = mBRDo == null ? MBRDo.setAction(mBRDo, mBRDo2) : MBRDo.addAction(mBRDo, mBRDo2);
        }
        return mBRDo;
    }

    final MBRDo startCompleteCurrent(VRIMemberDescription[] vRIMemberDescriptionArray) {
        this.state.updateMajorState(ROLENAME, MBRStateConstants.SYNCING);
        CompleteCurrentMsg completeCurrentMsg = this.state.prepareCCMsg(this);
        MBRDo mBRDo = null;
        mBRDo = completeCurrentMsg != null ? new MBRDo(this, completeCurrentMsg) : new MBRDo("No need to send CompleteCurrent list same size");
        return mBRDo;
    }

    public MBRDo handleVLWaitForMBCCAlarm(int n) {
        MBRDo mBRDo = null;
        switch (this.getStateIndex()) {
            case 0: 
            case 2: {
                MBRLogger.dcsInternalInfo((DCSTraceContext)this, "handleVLWaitForMBCCAlarm()", "Unexpected State- " + this.getStateIndex());
                break;
            }
            case 1: {
                if (this.state.iHaveNotRespondedtoSync()) {
                    this.state.changeRole(MBRStateConstants.VIEWLEADER, MBRStateConstants.SPLIT);
                    mBRDo = this.state.getMajorPhase(MBRStateConstants.VIEWLEADER) == MBRStateConstants.SYNCED ? MBRDo.setAction(mBRDo, this.viewSyncedDoNextStep()) : MBRDo.setAction(mBRDo, new MBRDo());
                    return mBRDo;
                }
                VRIMemberDescription[] vRIMemberDescriptionArray = this.state.getSyncNonRespondants();
                VRIMemberUtils.minus(vRIMemberDescriptionArray, this.thisMember);
                MBRDenialRecord mBRDenialRecord = MBRDenialRecord.createExpRespTimeoutDR(this, "VL wait for MB expired ", vRIMemberDescriptionArray, n);
                mBRDenialRecord.getSuspectEvent().invokeNLSTrace();
                mBRDo = MBRDo.setAction(mBRDo, this.denyMembersAndSendSuspectMsg(mBRDenialRecord));
                break;
            }
            default: {
                MBRLogger.dcsInternalInfo((DCSTraceContext)this, "handleVLWaitForMBCCAlarm()", "Bad State -" + this.getStateIndex());
            }
        }
        return mBRDo;
    }
}

