/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership;

import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.nls.FailedMergeAttempt;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.membership.MBRDo;
import com.ibm.ws.dcs.vri.membership.MBRState;
import com.ibm.ws.dcs.vri.membership.MBRStateConstants;
import com.ibm.ws.dcs.vri.membership.RoleViewLeader;
import com.ibm.ws.dcs.vri.membership.messages.AddMembersMsg;
import com.ibm.ws.dcs.vri.membership.messages.MergeNewViewMsg;
import com.ibm.ws.dcs.vri.membership.messages.NewViewMsg;
import com.ibm.ws.dcs.vri.membership.messages.ResetVLWaitAlarmMsg;
import com.ibm.ws.dcs.vri.membership.messages.SuspectMsg;
import com.ibm.ws.dcs.vri.membership.util.MBRDenialReason;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;

class RoleViewLeaderMerge
extends RoleViewLeader {
    private static final MBRState.RoleName ROLENAME = MBRStateConstants.VIEWLEADER;

    public RoleViewLeaderMerge(MBRState mBRState) {
        super(mBRState);
    }

    private final int getStateIndex() {
        return this.state.getMajorPhaseIndex(ROLENAME);
    }

    public MBRDo handleVLWaitForMLNVAlarm(int n) {
        MBRDo mBRDo = null;
        switch (this.getStateIndex()) {
            case 0: {
                MBRLogger.dcsWarning((DCSTraceContext)this, "handleVLWaitForMLNVAlarm()", "Illegal State - Normal");
                break;
            }
            case 1: {
                MBRLogger.dcsWarning((DCSTraceContext)this, "handleVLWaitForMLNVAlarm()", "Illegal State - Syncing");
                break;
            }
            case 2: {
                this.state.changeRole(MBRStateConstants.VIEWLEADER, MBRStateConstants.SPLIT);
                new FailedMergeAttempt((DCSTraceContext)this, new String[]{this.state.getMergeLeader().getName()}, n).invokeNLSTrace();
                mBRDo = MBRDo.setAction(mBRDo, this.viewSyncedDoNextStep());
                break;
            }
            default: {
                MBRLogger.dcsWarning((DCSTraceContext)this, "handleVLWaitForMLNVAlarm()", this.illegalState());
            }
        }
        return mBRDo;
    }

    public MBRDo processAddMembersMsg(AddMembersMsg addMembersMsg) {
        MBRDo mBRDo = null;
        if (!addMembersMsg.intersectsMyView(this.membersMgr.getViewMinusDenied())) {
            return new MBRDo("Not for me- candidates and view disjoint");
        }
        if (this.membersMgr.isDenied(addMembersMsg.getSender())) {
            mBRDo = MBRDo.setAction(mBRDo, this.makeMergeNoMsg(addMembersMsg.getSender(), 6, addMembersMsg));
            return mBRDo;
        }
        if (!addMembersMsg.isSentByMyself(this.myName) && this.state.changedPV()) {
            mBRDo = MBRDo.setAction(mBRDo, this.makeMergeNoMsg(addMembersMsg.getSender(), 9, addMembersMsg));
            return mBRDo;
        }
        switch (this.getStateIndex()) {
            case 0: {
                if (this.state.getRoleName() == MBRStateConstants.VIEWLEADER) {
                    this.state.determineIfMergeLeader(addMembersMsg.getMembers());
                }
                if (!addMembersMsg.fromMergeLeader(this.state.getMergeLeader())) {
                    this.state.changeRole(MBRStateConstants.MEMBER, MBRStateConstants.MESSAGING);
                    mBRDo = MBRDo.setAction(mBRDo, this.makeMergeNoMsg(addMembersMsg.getSender(), 4, addMembersMsg));
                    return mBRDo;
                }
                if (!addMembersMsg.containsView(this.membersMgr.getViewMinusDenied())) {
                    this.state.changeRole(MBRStateConstants.MEMBER, MBRStateConstants.MESSAGING);
                    mBRDo = MBRDo.setAction(mBRDo, this.makeMergeNoMsg(addMembersMsg.getSender(), 2, addMembersMsg));
                    return mBRDo;
                }
                if (!addMembersMsg.allConnected(this.membersMgr.getConnectedMembers(true))) {
                    this.state.changeRole(MBRStateConstants.MEMBER, MBRStateConstants.MESSAGING);
                    mBRDo = MBRDo.setAction(mBRDo, this.makeMergeNoMsg(addMembersMsg.getSender(), 5, addMembersMsg));
                    return mBRDo;
                }
                this.state.getStateExchanger().setMLVersion(addMembersMsg.getMLAppStateVersion());
                this.state.setReceivedMergeLeaderContext(addMembersMsg.getMergeContext());
                mBRDo = MBRDo.setAction(mBRDo, this.startCompleteCurrent(null));
                break;
            }
            case 1: {
                if (!addMembersMsg.isSentByMyself(this.myName)) {
                    mBRDo = MBRDo.setAction(mBRDo, this.makeMergeNoMsg(addMembersMsg.getSender(), 3, addMembersMsg));
                    break;
                }
                this.state.getStateExchanger().setMLVersion(addMembersMsg.getMLAppStateVersion());
                this.state.setReceivedMergeLeaderContext(addMembersMsg.getMergeContext());
                break;
            }
            case 2: {
                if (addMembersMsg.isSentByMyself(this.myName)) break;
                mBRDo = MBRDo.setAction(mBRDo, this.makeMergeNoMsg(addMembersMsg.getSender(), 3, addMembersMsg));
                break;
            }
            default: {
                MBRLogger.dcsWarning((DCSTraceContext)this, "processAddMembersMsg()", this.illegalState());
            }
        }
        return mBRDo;
    }

    public MBRDo processMergeNewViewMsg(MergeNewViewMsg mergeNewViewMsg) {
        MBRDo mBRDo = null;
        if (!mergeNewViewMsg.areAllMembersDefined()) {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo("Not all members in Message are defined msg=" + mergeNewViewMsg));
            return mBRDo;
        }
        if (!mergeNewViewMsg.fromMergeLeader(this.state.getMergeLeader())) {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo("Not from Merge Leader"));
            return mBRDo;
        }
        boolean bl = mergeNewViewMsg.containsViewMinusDenied();
        boolean bl2 = mergeNewViewMsg.useDeniedMembers(this.state.getMergeCCOKDeniedList());
        if (!bl || bl2) {
            if (!mergeNewViewMsg.isSentByMyself(this.state.getMemberName())) {
                mBRDo = MBRDo.setAction(mBRDo, this.suspectSenderBrokeProtocol(mergeNewViewMsg.getSender(), "MergeNewViewMessage did not contain my view= " + !bl + " or contained denied members=" + bl2));
            } else {
                switch (this.getStateIndex()) {
                    case 0: {
                        this.state.changeRole(MBRStateConstants.MEMBER, MBRStateConstants.MESSAGING);
                        mBRDo = new MBRDo("Received empty MergeNewView- back to normal");
                        break;
                    }
                    case 1: {
                        this.state.changeRole(MBRStateConstants.VIEWLEADER, MBRStateConstants.SPLIT);
                        mBRDo = new MBRDo("Received empty MergeNewView- change protocol to split");
                        break;
                    }
                    case 2: {
                        this.state.changeRole(MBRStateConstants.VIEWLEADER, MBRStateConstants.SPLIT);
                        mBRDo = MBRDo.setAction(mBRDo, this.viewSyncedDoNextStep());
                        break;
                    }
                    default: {
                        DCSException dCSException = new DCSException("Unknown state " + this.getStateIndex());
                        MBRLogger.dcsWarning((DCSTraceContext)this, "RoleViewLeaderMerge.processMergeNewViewMsg()", dCSException);
                    }
                }
            }
            return mBRDo;
        }
        if (!mergeNewViewMsg.viewIDGreaterThanCurrentViewID(this.state.getViewId())) {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo((DCSTraceContext)this, "View Id is not greater than current" + this.state.getViewId(), "processMergeNewViewMsg()", 0));
            return mBRDo;
        }
        switch (this.getStateIndex()) {
            case 0: {
                MBRLogger.dcsTrace((DCSTraceContext)this, "processMergeNewViewMsg()", 0, "illegalState");
                break;
            }
            case 1: {
                MBRLogger.dcsTrace((DCSTraceContext)this, "processMergeNewViewMsg()", 0, "illegalState");
                break;
            }
            case 2: {
                NewViewMsg newViewMsg = mergeNewViewMsg.makeNVMsg(this.myName, this.state.getStateExchanger().getVLStateBlob(mergeNewViewMsg.getMLAppStateBlob()));
                this.state.updateMajorState(ROLENAME, MBRStateConstants.NORMAL);
                this.state.changeRole(MBRStateConstants.MEMBER, MBRStateConstants.MERGE);
                mBRDo = MBRDo.setAction(mBRDo, new MBRDo(this, newViewMsg));
                break;
            }
            default: {
                DCSException dCSException = new DCSException("Unknown state " + this.getStateIndex());
                MBRLogger.dcsWarning((DCSTraceContext)this, "RoleViewLeaderMerge.processMergeNewViewMsg()", dCSException);
            }
        }
        return mBRDo;
    }

    public MBRDo processSuspectMsg(SuspectMsg suspectMsg) {
        MBRDo mBRDo = null;
        if ((mBRDo = MBRDo.setAction(mBRDo, super.processSuspectMsg(suspectMsg))) != null) {
            return mBRDo;
        }
        switch (this.getStateIndex()) {
            case 0: {
                if (suspectMsg.isMergeLeaderSuspected(this.state.getMergeLeader())) {
                    MBRLogger.dcsInternalInfo((DCSTraceContext)this, "processSuspectMsg()", "State=N I am suspected");
                }
                suspectMsg.removeSuspectsNotInView();
                if (MBRStateConstants.MERGELEADER.equals(this.state.getRoleName()) && 1 == this.state.getMajorPhaseIndex(this.state.getRoleName())) {
                    MBRDenialReason mBRDenialReason = this.getDenialReason(suspectMsg, "Normal Suspect from List");
                    this.denyMembers(suspectMsg.getSuspectList(), mBRDenialReason);
                    break;
                }
                MBRLogger.dcsInternalInfo((DCSTraceContext)this, "processSuspectMsg()", "State=N suspectMsg");
                break;
            }
            case 1: {
                if (suspectMsg.isMergeLeaderSuspected(this.state.getMergeLeader())) {
                    this.state.changeRole(MBRStateConstants.VIEWLEADER, MBRStateConstants.SPLIT);
                    MBRDenialReason mBRDenialReason = this.getDenialReason(suspectMsg, "Merge Leader Suspected");
                    this.denyMember(this.state.getMergeLeader().getName(), mBRDenialReason);
                    suspectMsg.removeSuspectsNotInView();
                    VRIMemberDescription[] vRIMemberDescriptionArray = VRIMemberUtils.minus(suspectMsg.getSuspectList(), this.state.getMergeLeader());
                    if (vRIMemberDescriptionArray != null && vRIMemberDescriptionArray.length != 0) {
                        mBRDenialReason = this.getDenialReason(suspectMsg, "Rest of Denies");
                        this.denyMembers(vRIMemberDescriptionArray, mBRDenialReason);
                    }
                    new FailedMergeAttempt((DCSTraceContext)this, VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray), "Merge leader suspected").invokeNLSTrace();
                    this.state.registerCCOKNO(suspectMsg.getSuspectList());
                    if (this.state.receivedAllCCOK()) {
                        mBRDo = MBRDo.setAction(mBRDo, this.viewSyncedDoNextStep());
                        return mBRDo;
                    }
                    return mBRDo;
                }
                suspectMsg.removeSuspectsNotInView();
                MBRDenialReason mBRDenialReason = this.getDenialReason(suspectMsg, "Normal Suspect from List");
                this.denyMembers(suspectMsg.getSuspectList(), mBRDenialReason);
                this.state.registerCCOKNO(suspectMsg.getSuspectList());
                if (this.state.receivedAllCCOK()) {
                    mBRDo = MBRDo.setAction(mBRDo, this.viewSyncedDoNextStep());
                    return mBRDo;
                }
                VRIMemberDescription[] vRIMemberDescriptionArray = this.membersMgr.getDeniedMembers(this.state.getLayer(), true);
                mBRDo = this.startCompleteCurrent(vRIMemberDescriptionArray);
                break;
            }
            case 2: {
                if (suspectMsg.isMergeLeaderSuspected(this.state.getMergeLeader())) {
                    this.state.changeRole(MBRStateConstants.VIEWLEADER, MBRStateConstants.SPLIT);
                    mBRDo = MBRDo.setAction(mBRDo, this.viewSyncedDoNextStep());
                    return mBRDo;
                }
                suspectMsg.removeSuspectsNotInView();
                MBRDenialReason mBRDenialReason = this.getDenialReason(suspectMsg, "Normal from suspect list");
                this.denyMembers(suspectMsg.getSuspectList(), mBRDenialReason);
                break;
            }
            default: {
                DCSException dCSException = new DCSException("Unknown state " + this.getStateIndex());
                MBRLogger.dcsWarning((DCSTraceContext)this, "RoleViewLeaderMerge.processSuspectMsg()", dCSException);
            }
        }
        return mBRDo;
    }

    public MBRDo processResetVLWaitAlarmMsg(ResetVLWaitAlarmMsg resetVLWaitAlarmMsg) {
        boolean bl = this.state.resetVLTimer();
        MBRDo mBRDo = bl ? new MBRDo("resetVLWaitAlarm() /t timer reset") : new MBRDo("resetVLWaitAlarm() /t timer not set");
        return mBRDo;
    }
}

