/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership;

import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.membership.MBRDo;
import com.ibm.ws.dcs.vri.membership.MBRState;
import com.ibm.ws.dcs.vri.membership.MBRStateConstants;
import com.ibm.ws.dcs.vri.membership.RoleViewLeader;
import com.ibm.ws.dcs.vri.membership.messages.MBRRequestTrivalViewChangeEvent;
import com.ibm.ws.dcs.vri.membership.messages.SuspectMsg;
import com.ibm.ws.dcs.vri.membership.util.MBRDenialReason;
import com.ibm.ws.dcs.vri.membership.util.MBRDenialRecord;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;

final class RoleViewLeaderSplit
extends RoleViewLeader {
    private static final MBRState.RoleName ROLENAME = MBRStateConstants.VIEWLEADER;

    public RoleViewLeaderSplit(MBRState mBRState) {
        super(mBRState);
    }

    private final int getStateIndex() {
        return this.state.getMajorPhaseIndex(ROLENAME);
    }

    public MBRDo processSuspectMsg(SuspectMsg suspectMsg) {
        MBRDo mBRDo = null;
        if ((mBRDo = MBRDo.setAction(mBRDo, super.processSuspectMsg(suspectMsg))) != null) {
            return mBRDo;
        }
        suspectMsg.removeSuspectsNotInView();
        if (suspectMsg.isSuspectListEmpty()) {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo());
            return mBRDo;
        }
        switch (this.getStateIndex()) {
            case 0: {
                this.state.updateMajorState(MBRStateConstants.VIEWLEADER, MBRStateConstants.SYNCING);
                this.denyMembers(suspectMsg);
                VRIMemberDescription[] vRIMemberDescriptionArray = this.membersMgr.getDeniedMembers(this.state.getLayer(), true);
                mBRDo = MBRDo.setAction(mBRDo, this.startCompleteCurrent(vRIMemberDescriptionArray));
                break;
            }
            case 1: {
                this.denyMembers(suspectMsg);
                this.state.registerCCOKNO(suspectMsg.getSuspectList());
                if (this.state.receivedAllCCOK()) {
                    mBRDo = MBRDo.setAction(mBRDo, this.viewSyncedDoNextStep());
                    break;
                }
                VRIMemberDescription[] vRIMemberDescriptionArray = this.membersMgr.getDeniedMembers(this.state.getLayer(), true);
                mBRDo = MBRDo.setAction(mBRDo, this.startCompleteCurrent(vRIMemberDescriptionArray));
                break;
            }
            default: {
                DCSException dCSException = new DCSException("Unknown state");
                MBRLogger.dcsWarning((DCSTraceContext)this, "RoleViewLeaderSplit.processSuspectMsg()", dCSException);
            }
        }
        return mBRDo;
    }

    private final void denyMembers(SuspectMsg suspectMsg) {
        MBRDenialReason mBRDenialReason;
        MBRDenialRecord mBRDenialRecord = null;
        if (suspectMsg.isSentByMyself(this.myName)) {
            mBRDenialReason = MBRDenialReason.createSuspectedByMeDR(suspectMsg.getSender());
        } else {
            mBRDenialRecord = MBRDenialRecord.createSuspectedByOthersDR(this, "SuspectMsg sent to VL", suspectMsg.getSuspectList(), suspectMsg.getSender());
            mBRDenialReason = mBRDenialRecord.getDenialReason();
        }
        boolean bl = this.denyMembers(suspectMsg.getSuspectList(), mBRDenialReason);
        if (bl && mBRDenialRecord != null) {
            mBRDenialRecord.getSuspectEvent().invokeNLSTrace();
        }
    }

    public MBRDo proceesTrivialViewChangeEvent(MBRRequestTrivalViewChangeEvent mBRRequestTrivalViewChangeEvent) {
        MBRDo mBRDo = null;
        switch (this.getStateIndex()) {
            case 0: {
                this.state.updateMajorState(MBRStateConstants.VIEWLEADER, MBRStateConstants.SYNCING);
                mBRDo = MBRDo.setAction(mBRDo, this.startCompleteCurrent(null));
                return mBRDo;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                MBRLogger.dcsWarning((DCSTraceContext)this, "proceesTrivialViewChangeEvent()", this.illegalState());
                return mBRDo;
            }
        }
        return null;
    }
}

