/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership.messages;

import com.ibm.ws.dcs.common.StateVersion;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.vri.common.Arrayable;
import com.ibm.ws.dcs.vri.common.Downcalls;
import com.ibm.ws.dcs.vri.common.Header;
import com.ibm.ws.dcs.vri.common.MemberInfo;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.impl.ArrayableObject;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.membership.MBRConfigChecker;
import com.ibm.ws.dcs.vri.membership.messages.MBRIncommingMessageException;
import com.ibm.ws.dcs.vri.membership.messages.MBRMessage;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;
import java.util.Arrays;

public final class AddMembersMsg
extends MBRMessage {
    private boolean allAddsDefined = true;
    private VRIMemberDescription[] newmembers;
    private MemberInfo[] defined;
    private StateVersion appStateVersion;
    private ArrayableObject wrappedAppStateVersion;
    private long mergeContext;
    private int dcsProtocolVersion;

    public AddMembersMsg(VRIMemberDescription[] vRIMemberDescriptionArray, MemberInfo[] memberInfoArray, StateVersion stateVersion, long l, String string, VRIMembersMGR vRIMembersMGR, int n) {
        super((byte)2, string, vRIMembersMGR);
        if (DCSTraceBuffer.isEntryEnabled(this.getTraceComponent())) {
            DCSTraceBuffer.entry(this, "AddMembersMsg()", null).invoke();
        }
        Arrays.sort(vRIMemberDescriptionArray);
        Arrays.sort(memberInfoArray);
        this.newmembers = vRIMemberDescriptionArray;
        this.defined = memberInfoArray;
        this.appStateVersion = stateVersion;
        this.wrappedAppStateVersion = new ArrayableObject(this.appStateVersion);
        this.mergeContext = l;
        this.dcsProtocolVersion = n;
        this.addHeader(new AddMembersHeader());
        if (DCSTraceBuffer.isExitEnabled(this.getTraceComponent())) {
            DCSTraceBuffer.exit(this, "AddMembersMsg()", null).invoke();
        }
    }

    AddMembersMsg(VRIMessage vRIMessage, VRIMembersMGR vRIMembersMGR) throws MBRIncommingMessageException {
        super(vRIMessage, vRIMembersMGR);
        Header header2;
        if (DCSTraceBuffer.isEntryEnabled(this.getTraceComponent())) {
            DCSTraceBuffer.entry(this, "AddMembersMsg()", null).invoke();
        }
        if ((header2 = vRIMessage.extractHeader(new AddMembersHeader())) == null) {
            throw new MBRIncommingMessageException(vRIMessage.getSender(), "AddMembersMsg Header is null");
        }
        this.allAddsDefined = vRIMembersMGR.areAllDefined(this.newmembers);
        if (DCSTraceBuffer.isExitEnabled(this.getTraceComponent())) {
            DCSTraceBuffer.exit(this, "AddMembersMsg()", null).invoke();
        }
    }

    public void mcast(Downcalls downcalls) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (DCSTraceBuffer.isEntryEnabled(this.getTraceComponent())) {
            DCSTraceBuffer.entry(this, "mcast()", null).invoke();
        }
        this.mcastConnected(downcalls);
        if (DCSTraceBuffer.isExitEnabled(this.getTraceComponent())) {
            DCSTraceBuffer.exit(this, "mcast()", null).invoke();
        }
    }

    public boolean isProtocolConflict() {
        return !MBRConfigChecker.checkVersion(this.dcsProtocolVersion, this.membersMgr.getProtocolVersion());
    }

    public int getSentDCSProtocolVersion() {
        return this.dcsProtocolVersion;
    }

    public String toString() {
        return " AddMembersMsg from:" + this.getSender() + " NewMembers- " + AddMembersMsg.toString(this.newmembers) + " Defined- " + Utils.toString(MemberInfo.getNames(this.defined)) + " mergeContext- " + this.mergeContext + " Protocol Version- " + this.dcsProtocolVersion + " State Version- " + String.valueOf(this.appStateVersion);
    }

    public long getMergeContext() {
        return this.mergeContext;
    }

    public boolean fromMergeLeader(VRIMemberDescription vRIMemberDescription) {
        return vRIMemberDescription.getName().equals(this.getSender());
    }

    public boolean isNewMemberUndefined() {
        return this.allAddsDefined;
    }

    public StateVersion getMLAppStateVersion() {
        return this.appStateVersion;
    }

    public boolean isDefineConflict() {
        VRIMemberDescription[] vRIMemberDescriptionArray = this.membersMgr.getDefinedMembers(true);
        if (this.defined.length != vRIMemberDescriptionArray.length) {
            return true;
        }
        for (int i = 0; i < this.defined.length; ++i) {
            if (this.defined[i].equals(vRIMemberDescriptionArray[i].getMemberInfo())) continue;
            return true;
        }
        return false;
    }

    public boolean containsView(VRIMemberDescription[] vRIMemberDescriptionArray) {
        return VRIMemberUtils.contains(this.newmembers, vRIMemberDescriptionArray);
    }

    public VRIMemberDescription[] getMembers() {
        return VRIMemberUtils.copy(this.newmembers);
    }

    public MemberInfo[] getDefinedSet() {
        return this.defined;
    }

    public boolean allConnected(VRIMemberDescription[] vRIMemberDescriptionArray) {
        return VRIMemberUtils.contains(vRIMemberDescriptionArray, this.newmembers);
    }

    public boolean intersectsMyView(VRIMemberDescription[] vRIMemberDescriptionArray) {
        Object[] objectArray = this.membersMgr.removeUndefined(this.newmembers);
        return !VRIMemberUtils.areDisjoint((VRIMemberDescription[])(objectArray = (VRIMemberDescription[])Utils.removeNulls(objectArray)), vRIMemberDescriptionArray);
    }

    public boolean containsMe(VRIMemberDescription vRIMemberDescription) {
        for (int i = 0; i < this.newmembers.length; ++i) {
            if (!this.newmembers[i].getName().equals(vRIMemberDescription.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean amIExpectedLeader(VRIMemberDescription[] vRIMemberDescriptionArray, VRIMemberDescription vRIMemberDescription) {
        if (this.containsMe(vRIMemberDescription)) {
            return VRIMemberUtils.areDisjoint(vRIMemberDescriptionArray, this.newmembers);
        }
        return false;
    }

    static /* synthetic */ MemberInfo[] access$202(AddMembersMsg addMembersMsg, MemberInfo[] memberInfoArray) {
        addMembersMsg.defined = memberInfoArray;
        return memberInfoArray;
    }

    static /* synthetic */ VRIMemberDescription[] access$302(AddMembersMsg addMembersMsg, VRIMemberDescription[] vRIMemberDescriptionArray) {
        addMembersMsg.newmembers = vRIMemberDescriptionArray;
        return vRIMemberDescriptionArray;
    }

    class AddMembersHeader
    extends MBRMessage.MBRHeader {
        public AddMembersHeader() {
            super(AddMembersMsg.this);
        }

        public void toArray(byte[] byArray, Utils.Offset offset) {
            super.toArray(byArray, offset);
            Utils.int2byteArray(AddMembersMsg.this.dcsProtocolVersion, byArray, offset);
            Utils.long2byteArray(AddMembersMsg.this.mergeContext, byArray, offset);
            if (AddMembersMsg.this.dcsProtocolVersion > 51001) {
                Utils.int2byteArray(AddMembersMsg.this.defined.length, byArray, offset);
                Utils.int2byteArray(AddMembersMsg.this.newmembers.length, byArray, offset);
                int n = 0;
                for (int i = 0; i < AddMembersMsg.this.defined.length; ++i) {
                    Utils.string2byteArray(AddMembersMsg.this.defined[i].getMemberName(), byArray, offset);
                    if (n < AddMembersMsg.this.newmembers.length && AddMembersMsg.this.defined[i].getMemberName().equals(AddMembersMsg.this.newmembers[n].getName())) {
                        Utils.boolean2byteArray(true, byArray, offset);
                        ++n;
                        continue;
                    }
                    Utils.boolean2byteArray(false, byArray, offset);
                }
                if (n != AddMembersMsg.this.newmembers.length) {
                    MBRLogger.dcsInternalInfo((DCSTraceContext)AddMembersMsg.this, "toArray()", "ERROR Alarm with toArray in AddMembersMsg");
                }
            } else {
                Utils.int2byteArray(AddMembersMsg.this.defined.length, byArray, offset);
                for (int i = 0; i < AddMembersMsg.this.defined.length; ++i) {
                    AddMembersMsg.this.defined[i].toArray(byArray, offset);
                }
                VRIMemberUtils.writeMemberNames(byArray, offset, AddMembersMsg.this.newmembers);
            }
            AddMembersMsg.this.wrappedAppStateVersion.toArray(byArray, offset);
        }

        public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
            if (super.fromArray(byArray, offset) == null) {
                return null;
            }
            AddMembersMsg.this.dcsProtocolVersion = Utils.byteArray2int(byArray, offset);
            AddMembersMsg.this.mergeContext = Utils.byteArray2long(byArray, offset);
            if (AddMembersMsg.this.dcsProtocolVersion > 51001) {
                int n = Utils.byteArray2int(byArray, offset);
                int n2 = Utils.byteArray2int(byArray, offset);
                AddMembersMsg.access$202(AddMembersMsg.this, new MemberInfo[n]);
                AddMembersMsg.access$302(AddMembersMsg.this, new VRIMemberDescription[n2]);
                int n3 = 0;
                for (int i = 0; i < AddMembersMsg.this.defined.length; ++i) {
                    String string = Utils.byteArray2string(byArray, offset);
                    boolean bl = Utils.byteArray2boolean(byArray, offset);
                    ((AddMembersMsg)AddMembersMsg.this).defined[i] = new MemberInfo(string, null);
                    if (!bl) continue;
                    ((AddMembersMsg)AddMembersMsg.this).newmembers[n3] = AddMembersMsg.this.membersMgr.getDefinedMember(string);
                    ++n3;
                }
                if (n3 != AddMembersMsg.this.newmembers.length) {
                    System.out.println("ERROR Alarm with fromArray in AddMembersMsg");
                }
            } else {
                int n = Utils.byteArray2int(byArray, offset);
                AddMembersMsg.access$202(AddMembersMsg.this, new MemberInfo[n]);
                for (int i = 0; i < AddMembersMsg.this.defined.length; ++i) {
                    ((AddMembersMsg)AddMembersMsg.this).defined[i] = new MemberInfo();
                    AddMembersMsg.this.defined[i].fromArray(byArray, offset);
                }
                AddMembersMsg.access$302(AddMembersMsg.this, AddMembersMsg.this.membersMgr.readDefinedMembersDescription(byArray, offset));
            }
            AddMembersMsg.this.wrappedAppStateVersion = new ArrayableObject();
            AddMembersMsg.this.wrappedAppStateVersion = (ArrayableObject)AddMembersMsg.this.wrappedAppStateVersion.fromArray(byArray, offset);
            if (AddMembersMsg.this.wrappedAppStateVersion == null) {
                AddMembersMsg.this.appStateVersion = null;
            } else {
                AddMembersMsg.this.appStateVersion = (StateVersion)AddMembersMsg.this.wrappedAppStateVersion.getObject();
            }
            return this;
        }

        public int getLength() {
            int n = 0;
            n = AddMembersMsg.this.dcsProtocolVersion > 51001 ? (n += Utils.getLength(MemberInfo.getNames(AddMembersMsg.this.defined)) + Utils.sizeOfInt() + Utils.sizeOfInt() + Utils.sizeOfBoolean() * AddMembersMsg.this.defined.length) : Utils.getLength(AddMembersMsg.this.defined) + Utils.sizeOfInt() + VRIMemberUtils.getLength(AddMembersMsg.this.newmembers);
            return super.getLength() + Utils.sizeOfLong() + AddMembersMsg.this.wrappedAppStateVersion.getLength() + n;
        }
    }
}

