/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership.messages;

import com.ibm.ejs.ras.Tr;
import com.ibm.ws.dcs.common.ViewId;
import com.ibm.ws.dcs.vri.common.Arrayable;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.Header;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.membership.messages.MBRIncommingMessageException;
import com.ibm.ws.dcs.vri.membership.messages.MBRMessage;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;

public final class CompleteCurrentMsg
extends MBRMessage {
    private VRIMemberDescription[] failedList;
    private CCVersion ccV;

    public CompleteCurrentMsg(VRIMessage vRIMessage, VRIMembersMGR vRIMembersMGR) throws MBRIncommingMessageException {
        super(vRIMessage, vRIMembersMGR);
        Header header2 = vRIMessage.extractHeader(new CompleteCurrentHeader());
        if (header2 == null) {
            throw new MBRIncommingMessageException(vRIMessage.getSender(), "CompleteCurrentMsg Header is null");
        }
        if (!vRIMembersMGR.areAllDefined(this.failedList)) {
            MBRLogger.dcsInternalInfo((DCSTraceContext)this, "CompleteCurrentMsg()", "Unexpected undefined members in failed list");
            this.failedList = vRIMembersMGR.removeUndefined(this.failedList);
        }
    }

    public CompleteCurrentMsg(VRIMemberDescription[] vRIMemberDescriptionArray, CCVersion cCVersion, String string, VRIMembersMGR vRIMembersMGR) {
        super((byte)3, string, vRIMembersMGR);
        if (this.TC.isEntryEnabled()) {
            Tr.entry(this.TC, "CompleteCurrentMsg()() on " + this.stackName + ": ", new Object[]{vRIMemberDescriptionArray, cCVersion, string, vRIMembersMGR});
        }
        this.failedList = vRIMemberDescriptionArray;
        this.ccV = cCVersion;
        this.addHeader(new CompleteCurrentHeader());
        if (this.TC.isEntryEnabled()) {
            Tr.exit(this.TC, "CompleteCurrentMsg() on " + this.stackName);
        }
    }

    public String toString() {
        return " CompleteCurrentMsg  from:" + this.getSender() + " failedList- " + CompleteCurrentMsg.toString(this.failedList) + this.ccV;
    }

    public boolean areAllFailedDefined() {
        if (this.membersMgr.areAllDefined(this.failedList)) {
            return true;
        }
        this.failedList = null;
        return false;
    }

    public boolean viewIDFromFuture(ViewId viewId) {
        boolean bl = false;
        switch (this.ccV.getViewId().compareTo(viewId)) {
            case -1: 
            case 0: {
                break;
            }
            case 1: {
                bl = true;
            }
        }
        return bl;
    }

    public boolean viewIDFromPast(ViewId viewId) {
        boolean bl = false;
        switch (this.ccV.getViewId().compareTo(viewId)) {
            case 0: 
            case 1: {
                break;
            }
            case -1: {
                bl = true;
            }
        }
        return bl;
    }

    public VRIMemberDescription[] getFailedList() {
        return this.failedList;
    }

    public CCVersion getCCV() {
        return this.ccV;
    }

    public boolean isViewLeaderAmongstFailed(VRIMemberDescription vRIMemberDescription) {
        return VRIMemberUtils.contains(this.failedList, vRIMemberDescription);
    }

    public boolean iAmFailed(VRIMemberDescription vRIMemberDescription) {
        return VRIMemberUtils.contains(this.failedList, vRIMemberDescription);
    }

    public boolean thisListContainsPreviousList(VRIMemberDescription[] vRIMemberDescriptionArray) {
        return VRIMemberUtils.contains(this.failedList, vRIMemberDescriptionArray);
    }

    public boolean thisListGreaterThanPreviousList(VRIMemberDescription[] vRIMemberDescriptionArray) {
        boolean bl = true;
        VRIMemberDescription[] vRIMemberDescriptionArray2 = VRIMemberUtils.minus(this.failedList, vRIMemberDescriptionArray);
        if (vRIMemberDescriptionArray2.length == 0) {
            bl = false;
        }
        return bl;
    }

    public void removeNonViewMembers(VRIMemberDescription[] vRIMemberDescriptionArray) {
        this.failedList = this.membersMgr.removeUndefined(this.failedList);
        this.failedList = VRIMemberUtils.intersection(vRIMemberDescriptionArray, this.failedList);
    }

    public boolean ccVViewLeaderOkay(VRIMemberDescription vRIMemberDescription) {
        boolean bl = false;
        VRIMemberDescription vRIMemberDescription2 = this.membersMgr.getViewMember(this.ccV.getLeader());
        if (vRIMemberDescription2 == vRIMemberDescription) {
            bl = true;
        }
        return bl;
    }

    public boolean isFirstCCV() {
        return this.ccV.getCCNumber() == 1;
    }

    public boolean containsMyDenies(VRIMemberDescription[] vRIMemberDescriptionArray) {
        return VRIMemberUtils.contains(this.failedList, vRIMemberDescriptionArray);
    }

    public boolean isFailedListEmpty() {
        return this.failedList == null || this.failedList.length == 0;
    }

    static /* synthetic */ VRIMemberDescription[] access$102(CompleteCurrentMsg completeCurrentMsg, VRIMemberDescription[] vRIMemberDescriptionArray) {
        completeCurrentMsg.failedList = vRIMemberDescriptionArray;
        return vRIMemberDescriptionArray;
    }

    class CompleteCurrentHeader
    extends MBRMessage.MBRHeader {
        static final int encoding = 1;

        public CompleteCurrentHeader() {
            super(CompleteCurrentMsg.this);
        }

        public void toArray(byte[] byArray, Utils.Offset offset) {
            super.toArray(byArray, offset);
            CompleteCurrentMsg.this.getCCV().toArray(byArray, offset);
            this.writeMembersDescription(byArray, offset, CompleteCurrentMsg.this.getFailedList(), 1);
        }

        public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
            if (super.fromArray(byArray, offset) == null) {
                return null;
            }
            CompleteCurrentMsg.this.ccV = (CCVersion)new CCVersion().fromArray(byArray, offset);
            CompleteCurrentMsg.access$102(CompleteCurrentMsg.this, this.readMembersDescription(byArray, offset, 1, true));
            if (CompleteCurrentMsg.this.failedList.length == 0) {
                CompleteCurrentMsg.access$102(CompleteCurrentMsg.this, null);
            }
            return this;
        }

        public int getLength() {
            return super.getLength() + this.getLength(CompleteCurrentMsg.this.getFailedList(), 1) + CompleteCurrentMsg.this.getCCV().getLength();
        }
    }
}

