/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership.messages;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.common.exception.DCSUnsupportedQoSException;
import com.ibm.ws.dcs.vri.common.Arrayable;
import com.ibm.ws.dcs.vri.common.Downcalls;
import com.ibm.ws.dcs.vri.common.Header;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import com.ibm.ws.dcs.vri.membership.messages.MBRMessageFactory;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;

public class MBRMessage
implements DCSTraceContext {
    protected final VRIMembersMGR membersMgr;
    protected final String stackName;
    protected final TraceComponent TC;
    public static final QoS.QOSMulticast QOS_VIEW;
    public static final QoS.QOSMulticast QOS_CONNECTED;
    public static final QoS.QOSMulticast QOS_VSANY;
    private static TraceComponent TC1;
    private static final DCSTraceContextImpl DTC;
    VRIMessage baseMsg;
    VRIMemberDescription[] targets;

    MBRMessage(byte by, String string, VRIMembersMGR vRIMembersMGR, VRIMemberDescription[] vRIMemberDescriptionArray) {
        this.stackName = vRIMembersMGR.getThisStackName();
        this.membersMgr = vRIMembersMGR;
        this.targets = vRIMemberDescriptionArray;
        this.baseMsg = MBRMessageFactory.getMessage(this.stackName, by, string);
        this.TC = Tr.register(this.getClass(), "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    }

    MBRMessage(byte by, String string, VRIMembersMGR vRIMembersMGR, VRIMemberDescription vRIMemberDescription) {
        this(by, string, vRIMembersMGR, new VRIMemberDescription[]{vRIMemberDescription});
    }

    MBRMessage(byte by, String string, VRIMembersMGR vRIMembersMGR) {
        this(by, string, vRIMembersMGR, (VRIMemberDescription[])null);
    }

    void addHeader(Header header2) {
        this.baseMsg.addHeader(header2);
    }

    Header getHeader(Header header2) {
        return this.baseMsg.getHeader(header2);
    }

    MBRMessage(VRIMessage vRIMessage, VRIMembersMGR vRIMembersMGR) {
        this.stackName = vRIMembersMGR.getThisStackName();
        this.membersMgr = vRIMembersMGR;
        this.baseMsg = vRIMessage;
        this.TC = Tr.register(this.getClass(), "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    }

    public int getType() {
        return this.baseMsg.getMessageType();
    }

    public String getSender() {
        return this.baseMsg.getSender();
    }

    public void mcast(Downcalls downcalls) throws DCSInvalidParametersException, DCSTransportLayerException {
        downcalls.mcastMessage(this.baseMsg, QOS_VIEW, null);
    }

    public void mcastConnected(Downcalls downcalls) throws DCSInvalidParametersException, DCSTransportLayerException {
        downcalls.mcastMessage(this.baseMsg, QOS_CONNECTED, null);
    }

    public void mcastTarget(Downcalls downcalls) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (this.membersMgr.getProtocolVersion() > 51001) {
            downcalls.mcastMessage(this.baseMsg, this.targets, QOS_VIEW, null);
        } else {
            downcalls.mcastMessage(this.baseMsg, QOS_VIEW, null);
        }
    }

    public void mcastConnectedTarget(Downcalls downcalls) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (this.membersMgr.getProtocolVersion() > 51001) {
            downcalls.mcastMessage(this.baseMsg, this.targets, QOS_CONNECTED, null);
        } else {
            downcalls.mcastMessage(this.baseMsg, QOS_CONNECTED, null);
        }
    }

    public void mcastVSAny(Downcalls downcalls) throws DCSInvalidParametersException, DCSTransportLayerException {
        downcalls.mcastMessage(this.baseMsg, QOS_VSANY, null);
    }

    public static String toString(VRIMemberDescription[] vRIMemberDescriptionArray) {
        return VRIMemberUtils.toString(vRIMemberDescriptionArray);
    }

    public boolean fromViewLeader(VRIMemberDescription vRIMemberDescription) {
        return this.getSender().equals(vRIMemberDescription.getName());
    }

    public boolean isSentByMyself(String string) {
        return string.equals(this.getSender());
    }

    int determineVersion() {
        if (this.membersMgr.getProtocolVersion() == 51001) {
            return 1;
        }
        return 2;
    }

    public TraceComponent getTraceComponent() {
        return this.TC;
    }

    public String getStackName() {
        return this.stackName;
    }

    public String getMemberName() {
        return this.membersMgr.getThisMember().getName();
    }

    public String getLayerName() {
        return "MBR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        TC1 = Tr.register(MBRMessage.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
        DTC = new DCSTraceContextImpl(TC1, null, null, "MBR");
        QoS.QOSMulticast qOSMulticast = null;
        QoS.QOSMulticast qOSMulticast2 = null;
        QoS.QOSMulticast qOSMulticast3 = null;
        try {
            qOSMulticast = QoS.getMulticastQoS(QoS.RELIABLE, QoS.FIFO);
            qOSMulticast2 = (QoS.QOSMulticast)qOSMulticast.updateType(QoS.CONNECTED);
            qOSMulticast3 = QoS.getMulticastQoS(QoS.VS_ANY, QoS.FIFO);
        }
        catch (DCSUnsupportedQoSException dCSUnsupportedQoSException) {
            MBRLogger.dcsInternalError(DTC, "MBRMessage-QoS.<static initializer>", dCSUnsupportedQoSException);
        }
        finally {
            QOS_VIEW = qOSMulticast;
            QOS_CONNECTED = qOSMulticast2;
            QOS_VSANY = qOSMulticast3;
        }
    }

    public abstract class MBRHeader
    extends Header {
        private static final int MAX_VERSION_SUPPORTED = 2;
        private final int VERSION_LENGTH;

        public MBRHeader() {
            super((byte)10, MBRMessage.this.determineVersion());
            this.VERSION_LENGTH = Utils.sizeOfInt();
        }

        public void toArray(byte[] byArray, Utils.Offset offset) {
            Utils.int2byteArray(this._version, byArray, offset);
        }

        public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
            this._version = Utils.byteArray2int(byArray, offset);
            if (this._version > 2) {
                MBRLogger.dcsInternalError(MBRMessage.this, "MBRHeader.fromArray()", new DCSException("Header version mismatch internal= 2 sent= " + this._version + " " + this.getClass().getName()));
                return null;
            }
            return this;
        }

        public int getLength() {
            return this.VERSION_LENGTH;
        }

        int getEncoding(int n) {
            if (this.getVersion() == 1) {
                return 4;
            }
            return n;
        }

        VRIMemberDescription[] readMembersDescription(byte[] byArray, Utils.Offset offset, int n, boolean bl) {
            return MBRMessage.this.membersMgr.readMembersDescription(byArray, offset, this.getEncoding(n), bl);
        }

        VRIMemberDescription[] readDefinedMembersDescription(byte[] byArray, Utils.Offset offset, int n) {
            return MBRMessage.this.membersMgr.readDefinedMembersDescription(byArray, offset, this.getEncoding(n));
        }

        void writeMembersDescription(byte[] byArray, Utils.Offset offset, VRIMemberDescription[] vRIMemberDescriptionArray, int n) {
            MBRMessage.this.membersMgr.writeMembersDescription(byArray, offset, vRIMemberDescriptionArray, this.getEncoding(n));
        }

        int getLength(VRIMemberDescription[] vRIMemberDescriptionArray, int n) {
            return MBRMessage.this.membersMgr.getLength(vRIMemberDescriptionArray, this.getEncoding(n));
        }
    }
}

