/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership.messages;

import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.event.VRIUpEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.membership.MBRDo;
import com.ibm.ws.dcs.vri.membership.Role;
import com.ibm.ws.dcs.vri.membership.messages.AddMembersMsg;
import com.ibm.ws.dcs.vri.membership.messages.ChangeDefinedMsg;
import com.ibm.ws.dcs.vri.membership.messages.CompleteCurrentMsg;
import com.ibm.ws.dcs.vri.membership.messages.CurrentOKMsg;
import com.ibm.ws.dcs.vri.membership.messages.DumpAllMsg;
import com.ibm.ws.dcs.vri.membership.messages.MBRIncommingMessageException;
import com.ibm.ws.dcs.vri.membership.messages.MBRMessage;
import com.ibm.ws.dcs.vri.membership.messages.MBRRequestTrivalViewChangeEvent;
import com.ibm.ws.dcs.vri.membership.messages.MergeCCOKMsg;
import com.ibm.ws.dcs.vri.membership.messages.MergeNewViewMsg;
import com.ibm.ws.dcs.vri.membership.messages.MergeNoMsg;
import com.ibm.ws.dcs.vri.membership.messages.NewViewMsg;
import com.ibm.ws.dcs.vri.membership.messages.ResetVLWaitAlarmMsg;
import com.ibm.ws.dcs.vri.membership.messages.SuspectMsg;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;

public final class MBRMessageProcessor {
    static final byte SUSPECT_MSGTYPE = 1;
    static final byte ADDMEMBERS_MSGTYPE = 2;
    static final byte COMPLETECURRENT_MSGTYPE = 3;
    static final byte CURRENTOK_MSGTYPE = 4;
    static final byte MERGECCOK_MSGTYPE = 5;
    static final byte MERGENEWVIEW_MSGTYPE = 6;
    static final byte NEWVIEW_MSGTYPE = 7;
    static final byte CHANGEDEFINED_MSGTYPE = 8;
    static final byte RESETVLWAITALARM_MSGTYPE = 9;
    static final byte MERGENO_MSGTYPE = 10;
    static final byte TRIVIALVIEWCHANGE_MSGTYPE = 11;
    static final byte DUMPALL_MSGTYPE = 12;

    public static MBRDo processMessage(Role role2, VRIMessage vRIMessage, String string, String string2, VRIMembersMGR vRIMembersMGR) {
        MBRDo mBRDo = null;
        if (vRIMessage.getOriginatorLayer() != 10) {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo("WARNING Message to unknown layer" + vRIMessage.getOriginatorLayer()));
            return mBRDo;
        }
        byte by = vRIMessage.getMessageType();
        if (vRIMembersMGR.isDenied(vRIMessage.getSender()) && !MBRMessageProcessor.isDeniedAllowed(by)) {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo("WARNING Message of type " + vRIMessage.getMessageType() + " from denied member " + vRIMessage.getSender()));
            return mBRDo;
        }
        try {
            switch (by) {
                case 1: {
                    SuspectMsg suspectMsg = new SuspectMsg(vRIMessage, vRIMembersMGR);
                    MBRLogger.dcsLogMBREvent(role2, string, "SuspectMsg", suspectMsg.toString());
                    mBRDo = MBRDo.setAction(mBRDo, role2.processSuspectMsg(suspectMsg));
                    break;
                }
                case 2: {
                    AddMembersMsg addMembersMsg = new AddMembersMsg(vRIMessage, vRIMembersMGR);
                    MBRLogger.dcsLogMBREvent(role2, string, "AddMembersMsg", addMembersMsg.toString());
                    mBRDo = MBRDo.setAction(mBRDo, role2.processAddMembersMsg(addMembersMsg));
                    break;
                }
                case 3: {
                    CompleteCurrentMsg completeCurrentMsg = new CompleteCurrentMsg(vRIMessage, vRIMembersMGR);
                    MBRLogger.dcsLogMBREvent(role2, string, "CompleteCurrentMsg", completeCurrentMsg.toString());
                    mBRDo = MBRDo.setAction(mBRDo, role2.processCompleteCurrentMsg(completeCurrentMsg));
                    break;
                }
                case 4: {
                    CurrentOKMsg currentOKMsg;
                    try {
                        currentOKMsg = new CurrentOKMsg(vRIMessage, vRIMembersMGR);
                    }
                    catch (Exception exception) {
                        MBRLogger.dcsWarning((DCSTraceContext)role2, "processMessage()", exception);
                        return new MBRDo("cokm with exception" + exception);
                    }
                    MBRLogger.dcsLogMBREvent(role2, string, "CurrentOKMsg", currentOKMsg.toString());
                    mBRDo = MBRDo.setAction(mBRDo, role2.processCurrentOKMsg(currentOKMsg));
                    break;
                }
                case 5: {
                    MergeCCOKMsg mergeCCOKMsg = new MergeCCOKMsg(vRIMessage, vRIMembersMGR);
                    MBRLogger.dcsLogMBREvent(role2, string, "MergeCCOKMsg", mergeCCOKMsg.toString());
                    mBRDo = MBRDo.setAction(mBRDo, role2.processMergeCCOKMsg(mergeCCOKMsg));
                    break;
                }
                case 10: {
                    MergeNoMsg mergeNoMsg = new MergeNoMsg(vRIMessage, vRIMembersMGR);
                    MBRLogger.dcsLogMBREvent(role2, string, "MergeNoMsg", mergeNoMsg.toString());
                    mBRDo = MBRDo.setAction(mBRDo, role2.processMergeNoMsg(mergeNoMsg));
                    break;
                }
                case 6: {
                    MergeNewViewMsg mergeNewViewMsg = new MergeNewViewMsg(vRIMessage, vRIMembersMGR);
                    MBRLogger.dcsLogMBREvent(role2, string, "MergeNewViewMsg", mergeNewViewMsg.toString());
                    mBRDo = MBRDo.setAction(mBRDo, role2.processMergeNewViewMsg(mergeNewViewMsg));
                    break;
                }
                case 7: {
                    NewViewMsg newViewMsg = new NewViewMsg(vRIMessage, vRIMembersMGR);
                    MBRLogger.dcsLogMBREvent(role2, string, "NewViewMsg", newViewMsg.toString());
                    mBRDo = MBRDo.setAction(mBRDo, role2.processNewViewMsg(newViewMsg));
                    break;
                }
                case 8: {
                    ChangeDefinedMsg changeDefinedMsg = new ChangeDefinedMsg(vRIMessage, vRIMembersMGR);
                    MBRLogger.dcsLogMBREvent(role2, string, "ChangeDefinedMsg", changeDefinedMsg.toString());
                    mBRDo = MBRDo.setAction(mBRDo, role2.processChangeDefinedMsg(changeDefinedMsg));
                    break;
                }
                case 9: {
                    ResetVLWaitAlarmMsg resetVLWaitAlarmMsg = new ResetVLWaitAlarmMsg(vRIMessage, vRIMembersMGR);
                    MBRLogger.dcsLogMBREvent(role2, string, "ResetVLWaitAlarmMsg", resetVLWaitAlarmMsg.toString());
                    mBRDo = MBRDo.setAction(mBRDo, role2.processResetVLWaitAlarmMsg(resetVLWaitAlarmMsg));
                    break;
                }
                case 12: {
                    DumpAllMsg dumpAllMsg = new DumpAllMsg(vRIMessage, vRIMembersMGR);
                    MBRLogger.dcsLogMBREvent(role2, string, "DumpAllMsg", dumpAllMsg.toString());
                    mBRDo = MBRDo.setAction(mBRDo, role2.processDumpAllMsg(dumpAllMsg));
                    break;
                }
                default: {
                    MBRLogger.dcsLogMBREvent(role2, string, "Unknown Msg", " message type" + vRIMessage.getMessageType() + " from " + vRIMessage.getSender());
                    mBRDo = MBRDo.setAction(mBRDo, new MBRDo("WARNING Unknown Message Type " + vRIMessage.getMessageType() + " from " + vRIMessage.getSender()));
                    break;
                }
            }
        }
        catch (MBRIncommingMessageException mBRIncommingMessageException) {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo((DCSTraceContext)role2, mBRIncommingMessageException, "processMsg()", "Msg Header is null from" + mBRIncommingMessageException.getProblematicSender()));
        }
        return mBRDo;
    }

    public static MBRDo reprocessMsgOrEvent(Role role2, Object object, String string, String string2) {
        MBRDo mBRDo = null;
        MBRMessage mBRMessage = null;
        VRIUpEvent vRIUpEvent = null;
        if (object instanceof MBRMessage) {
            mBRMessage = (MBRMessage)object;
            int n = mBRMessage.getType();
            switch (n) {
                case 1: {
                    SuspectMsg suspectMsg = (SuspectMsg)mBRMessage;
                    MBRLogger.dcsLogMBREvent(role2, string, "SuspectMsg", suspectMsg.toString());
                    mBRDo = MBRDo.setAction(mBRDo, role2.processSuspectMsg(suspectMsg));
                    break;
                }
                case 2: {
                    AddMembersMsg addMembersMsg = (AddMembersMsg)mBRMessage;
                    MBRLogger.dcsLogMBREvent(role2, string, "AddMembersMsg", addMembersMsg.toString());
                    mBRDo = MBRDo.setAction(mBRDo, role2.processAddMembersMsg(addMembersMsg));
                    break;
                }
                case 3: {
                    CompleteCurrentMsg completeCurrentMsg = (CompleteCurrentMsg)mBRMessage;
                    MBRLogger.dcsLogMBREvent(role2, string, "CompleteCurrentMsg", completeCurrentMsg.toString());
                    mBRDo = MBRDo.setAction(mBRDo, role2.processCompleteCurrentMsg(completeCurrentMsg));
                    break;
                }
                default: {
                    MBRLogger.dcsLogMBREvent(role2, string, "Unknown reprocessed Msg", " message type" + mBRMessage.getType() + " from " + mBRMessage.getSender());
                    mBRDo = MBRDo.setAction(mBRDo, new MBRDo("WARNING Unknown Reprocessed Message Type " + mBRMessage.getType() + " from " + mBRMessage.getSender()));
                }
            }
        }
        if (object instanceof VRIUpEvent) {
            vRIUpEvent = (VRIUpEvent)object;
            mBRDo = role2.proceesTrivialViewChangeEvent((MBRRequestTrivalViewChangeEvent)vRIUpEvent);
        }
        return mBRDo;
    }

    public static boolean isMergeNOMsg(MBRMessage mBRMessage) {
        return mBRMessage.getType() == 10;
    }

    public static boolean isMergeNewViewMsgType(VRIMessage vRIMessage) {
        return vRIMessage.getOriginatorLayer() == 10 && vRIMessage.getMessageType() == 6;
    }

    public static boolean isMergeCCOKMsgType(VRIMessage vRIMessage) {
        return vRIMessage.getOriginatorLayer() == 10 && vRIMessage.getMessageType() == 5;
    }

    public static boolean isNewViewMsgType(VRIMessage vRIMessage) {
        return vRIMessage.getOriginatorLayer() == 10 && vRIMessage.getMessageType() == 7;
    }

    private static boolean isDeniedAllowed(int n) {
        if (n == 8) {
            return true;
        }
        return n == 2;
    }
}

