/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership.messages;

import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.vri.common.Arrayable;
import com.ibm.ws.dcs.vri.common.Downcalls;
import com.ibm.ws.dcs.vri.common.Header;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.impl.ArrayableObject;
import com.ibm.ws.dcs.vri.membership.messages.MBRIncommingMessageException;
import com.ibm.ws.dcs.vri.membership.messages.MBRMessage;
import com.ibm.ws.dcs.vri.membership.messages.NewViewMsg;
import com.ibm.ws.dcs.vri.membership.messages.ViewMsg;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;

public final class MergeNewViewMsg
extends ViewMsg {
    private StateBlob appStateBlob;
    private ArrayableObject appState;
    private boolean areAllDefined = true;

    public MergeNewViewMsg(VRIMemberDescription[] vRIMemberDescriptionArray, VRIMemberDescription[] vRIMemberDescriptionArray2, ViewIdImpl viewIdImpl, StateBlob stateBlob, String string, VRIMembersMGR vRIMembersMGR) {
        super((byte)6, string, vRIMembersMGR, vRIMemberDescriptionArray);
        this.syncedList = vRIMemberDescriptionArray2;
        this.newViewId = viewIdImpl;
        this.appState = new ArrayableObject(stateBlob);
        this.appStateBlob = stateBlob;
        MBRLogger.dcsAssert(this.newViewId != null, "newViewId is null ", "MergeNewViewMsg", "MergeNewViewMsg()", "unknown");
        this.addHeader(new MergeNewViewHeader());
    }

    public MergeNewViewMsg(VRIMessage vRIMessage, VRIMembersMGR vRIMembersMGR) throws MBRIncommingMessageException {
        super(vRIMessage, vRIMembersMGR);
        Header header2 = vRIMessage.extractHeader(new MergeNewViewHeader());
        if (header2 == null) {
            throw new MBRIncommingMessageException(vRIMessage.getSender(), "MergeNewViewMsg Header is null");
        }
        this.areAllDefined = vRIMembersMGR.areAllDefined(this.syncedList);
    }

    public void mcast(Downcalls downcalls) throws DCSInvalidParametersException, DCSTransportLayerException {
        this.mcastConnected(downcalls);
    }

    public NewViewMsg makeNVMsg(String string, StateBlob stateBlob) {
        MBRLogger.dcsAssert(this.newViewId != null, "newViewId is null ", "MergeNewViewMsg", "makeNVMsg()", "unknown");
        MBRLogger.dcsAssert(this.newViewId.getViewLeader() != null, "newViewId has null viewLeader", "MergeNewViewMsg", "makenvMsg()", "unknown");
        return new NewViewMsg("MERGE", this.syncedList, this.newViewId, stateBlob, string, this.membersMgr);
    }

    public String toString() {
        return " MergeNewViewMsg from:" + this.getSender() + " SyncList= " + MergeNewViewMsg.toString(this.syncedList) + this.newViewId + " isInternal= " + this.newViewId.isInternalView() + "  allDefined= " + this.areAllDefined + " StateXchg Version- " + (this.appStateBlob == null ? "Blob is null" : String.valueOf(this.appStateBlob.getVersion()));
    }

    public StateBlob getMLAppStateBlob() {
        return this.appStateBlob;
    }

    public boolean viewIDGreaterThanCurrentViewID(ViewIdImpl viewIdImpl) {
        boolean bl = true;
        int n = viewIdImpl.compareTo(this.newViewId);
        if (n > 0) {
            bl = false;
        }
        return bl;
    }

    public boolean fromMergeLeader(VRIMemberDescription vRIMemberDescription) {
        MBRLogger.dcsAssert(this.getSender() != null, "Sender is Null", "MergeNewViewMsg", "fromMergeLeader()", this.stackName);
        MBRLogger.dcsAssert(vRIMemberDescription != null, "MergeLeader is Null", "MergeNewViewMsg", "fromMergeLeader()", this.stackName);
        if (this.getSender() == null || vRIMemberDescription == null) {
            return false;
        }
        return this.getSender().equals(vRIMemberDescription.getName());
    }

    public boolean containsViewMinusDenied() {
        VRIMemberDescription[] vRIMemberDescriptionArray = this.membersMgr.getViewMinusDenied();
        boolean bl = false;
        if (VRIMemberUtils.contains(this.syncedList, vRIMemberDescriptionArray)) {
            bl = true;
        }
        return bl;
    }

    public boolean useDeniedMembers(VRIMemberDescription[] vRIMemberDescriptionArray) {
        boolean bl = true;
        VRIMemberDescription[] vRIMemberDescriptionArray2 = VRIMemberUtils.intersection(this.syncedList, vRIMemberDescriptionArray);
        if (vRIMemberDescriptionArray2.length == 0) {
            bl = false;
        }
        return bl;
    }

    class MergeNewViewHeader
    extends MBRMessage.MBRHeader {
        public void toArray(byte[] byArray, Utils.Offset offset) {
            super.toArray(byArray, offset);
            this.writeMembersDescription(byArray, offset, MergeNewViewMsg.this.syncedList, 2);
            MergeNewViewMsg.this.newViewId.toArray(byArray, offset);
            MergeNewViewMsg.this.appState.toArray(byArray, offset);
        }

        public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
            if (super.fromArray(byArray, offset) == null) {
                return null;
            }
            MergeNewViewMsg.this.syncedList = this.readDefinedMembersDescription(byArray, offset, 2);
            MergeNewViewMsg.this.newViewId = (ViewIdImpl)new ViewIdImpl().fromArray(byArray, offset);
            MergeNewViewMsg.this.appState = new ArrayableObject();
            MergeNewViewMsg.this.appState = (ArrayableObject)MergeNewViewMsg.this.appState.fromArray(byArray, offset);
            if (MergeNewViewMsg.this.appState == null) {
                MergeNewViewMsg.this.appStateBlob = null;
            } else {
                MergeNewViewMsg.this.appStateBlob = (StateBlob)MergeNewViewMsg.this.appState.getObject();
            }
            return this;
        }

        public int getLength() {
            return super.getLength() + this.getLength(MergeNewViewMsg.this.syncedList, 2) + MergeNewViewMsg.this.newViewId.getLength() + MergeNewViewMsg.this.appState.getLength();
        }
    }
}

