/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership.messages;

import com.ibm.ws.dcs.common.ViewId;
import com.ibm.ws.dcs.common.exception.DCSAssertException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.vri.common.Arrayable;
import com.ibm.ws.dcs.vri.common.Downcalls;
import com.ibm.ws.dcs.vri.common.Header;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.ThresholdCounter;
import com.ibm.ws.dcs.vri.membership.messages.AddMembersMsg;
import com.ibm.ws.dcs.vri.membership.messages.MBRIncommingMessageException;
import com.ibm.ws.dcs.vri.membership.messages.MBRMessage;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;
import java.util.ArrayList;
import java.util.List;

public final class MergeNoMsg
extends MBRMessage {
    private String intendedMergeLeader;
    private ViewIdImpl viewID;
    private long mergeContext;
    private AddMembersMsg receivedAddMembersMsg;
    private int reason;
    private final boolean incomming;
    private VRIMemberDescription[] viewList;
    public static final int BUSY = 0;
    public static final int INCONSISTENTDEFINEDSET = 1;
    public static final int DOESNT_CONTAIN_VIEW = 2;
    public static final int IMPROPERSTATE = 3;
    public static final int NOTMERGELEADER = 4;
    public static final int NOT_ALL_CONNECTED = 5;
    public static final int DENIED = 6;
    public static final int DOESNT_CONTAIN_ME = 7;
    public static final int DCS_VERSION_MISMATCH = 8;
    public static final int BUSY_PROTOCOL_CHANGE = 9;
    public static final int INCOMMING = 2;

    public MergeNoMsg(int n, VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, String string, AddMembersMsg addMembersMsg, String string2, VRIMembersMGR vRIMembersMGR) {
        super((byte)10, string2, vRIMembersMGR, vRIMembersMGR.getDefinedMember(string));
        this.reason = n;
        this.viewList = vRIMemberDescriptionArray;
        this.viewID = viewIdImpl;
        this.intendedMergeLeader = string;
        this.incomming = false;
        this.receivedAddMembersMsg = addMembersMsg;
        this.mergeContext = addMembersMsg.getMergeContext();
        this.addHeader(new MergeNoHeader());
    }

    public MergeNoMsg(int n, VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, String string, long l, String string2, VRIMembersMGR vRIMembersMGR) {
        super((byte)10, string2, vRIMembersMGR, vRIMembersMGR.getDefinedMember(string));
        this.reason = n;
        this.viewList = vRIMemberDescriptionArray;
        this.viewID = viewIdImpl;
        this.intendedMergeLeader = string;
        this.incomming = false;
        this.receivedAddMembersMsg = null;
        this.mergeContext = l;
        if (n != 9) {
            throw new DCSAssertException("non  non busy protocol change");
        }
        this.addHeader(new MergeNoHeader());
    }

    public MergeNoMsg(VRIMessage vRIMessage, VRIMembersMGR vRIMembersMGR) throws MBRIncommingMessageException {
        super(vRIMessage, vRIMembersMGR);
        this.targets = new VRIMemberDescription[]{vRIMembersMGR.getThisMember()};
        this.incomming = true;
        Header header2 = vRIMessage.extractHeader(new MergeNoHeader());
        if (header2 == null) {
            throw new MBRIncommingMessageException(vRIMessage.getSender(), "MergeNoMsg Header is null");
        }
    }

    public void mcast(Downcalls downcalls) throws DCSInvalidParametersException, DCSTransportLayerException {
        this.mcastConnectedTarget(downcalls);
    }

    public String toString() {
        return " MergeNoMsg from:" + this.getSender() + " viewList- " + MergeNoMsg.toString(this.viewList) + " reason- " + this.toString(this.reason, true) + this.viewID + " intendedML- " + this.intendedMergeLeader + " mergeContext- " + this.mergeContext;
    }

    public String getReason() {
        String string = "";
        if (this.incomming) {
            string = "Sender's reason: ";
        }
        return string + this.toString(this.reason, this.incomming);
    }

    private String toString(int n, boolean bl) {
        String string;
        String string2 = " ";
        switch (n) {
            case 6: {
                string = "Received Merge request from a denied member";
                break;
            }
            case 7: {
                string = "Merge Set did not contain me in view";
                break;
            }
            case 2: {
                string = "Merge Set did not contain all of target view";
                break;
            }
            case 0: {
                string = "Busy in middle of split protocol";
                break;
            }
            case 1: {
                string = "Inconsistent defined set";
                break;
            }
            case 3: {
                string = "Improper state to do merge";
                break;
            }
            case 5: {
                string = "Not all candidates are connected";
                break;
            }
            case 4: {
                string = "Merge Attempt by someone who I don't think is merge leader";
                break;
            }
            case 8: {
                string = "DCS Protocol Version Mismatch";
                break;
            }
            case 9: {
                string = "In the middle of a DCS Protocol Change";
            }
            default: {
                string = "Unknown";
            }
        }
        if (!bl) {
            switch (n) {
                case 2: {
                    string2 = " Missing members= " + MergeNoMsg.toString(VRIMemberUtils.minus(this.viewList, this.receivedAddMembersMsg.getMembers()));
                    break;
                }
                case 1: {
                    string2 = " See inconsistent defined message in log  for details";
                    break;
                }
                case 5: {
                    string2 = " ConnectedSetMissing=  " + MergeNoMsg.toString(VRIMemberUtils.minus(this.membersMgr.getConnectedMembers(true), this.receivedAddMembersMsg.getMembers())) + " ConnectedSetAdditional" + MergeNoMsg.toString(VRIMemberUtils.minus(this.receivedAddMembersMsg.getMembers(), this.membersMgr.getConnectedMembers(true)));
                    break;
                }
                case 8: {
                    string2 = " My DCS Protocol Version is " + this.membersMgr.getProtocolVersion() + " Sent DCS Protocol Version is " + this.receivedAddMembersMsg.getSentDCSProtocolVersion();
                    break;
                }
                case 9: {
                    string2 = " My DCS Protocol Version is " + this.membersMgr.getProtocolVersion();
                    break;
                }
                default: {
                    string2 = "  ";
                }
            }
            string = string + string2;
        }
        return string;
    }

    public boolean isCorrectContext(long l) {
        return l == this.mergeContext;
    }

    public VRIMemberDescription[] getViewList() {
        return this.viewList;
    }

    public ViewId getViewID() {
        return this.viewID;
    }

    public long getMergeContext() {
        return this.mergeContext;
    }

    public boolean isForMe() {
        if (this.intendedMergeLeader == null) {
            MBRLogger.dcsInternalInfo((DCSTraceContext)this, "isForMe()", "Intended Merge Leader is null");
            return false;
        }
        boolean bl = VRIMemberUtils.contains(this.getViewList(), this.membersMgr.getThisMember());
        boolean bl2 = this.intendedMergeLeader.equals(this.membersMgr.getThisMember().getName());
        if (bl) {
            if (bl2 && this.getSender().equals(this.membersMgr.getThisMember().getName())) {
                MBRLogger.dcsInternalInfo((DCSTraceContext)this, "isForMe()", "I am in rejected set");
            }
            return false;
        }
        return bl2;
    }

    public boolean shouldRequestDump(List list) {
        boolean bl = false;
        switch (this.reason) {
            case 2: 
            case 5: {
                bl = ((ThresholdCounter)list.get(5)).increment();
                break;
            }
            case 3: {
                bl = ((ThresholdCounter)list.get(3)).increment();
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static List makeThresholdCounter() {
        int n = 10;
        ArrayList<ThresholdCounter> arrayList = new ArrayList<ThresholdCounter>(n);
        arrayList.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(i, null);
        }
        ThresholdCounter thresholdCounter = new ThresholdCounter(10, 3);
        ThresholdCounter thresholdCounter2 = new ThresholdCounter(15, 5);
        ThresholdCounter thresholdCounter3 = new ThresholdCounter(15, 4);
        arrayList.set(5, thresholdCounter);
        arrayList.set(3, thresholdCounter2);
        arrayList.set(2, thresholdCounter3);
        return arrayList;
    }

    static /* synthetic */ VRIMemberDescription[] access$202(MergeNoMsg mergeNoMsg, VRIMemberDescription[] vRIMemberDescriptionArray) {
        mergeNoMsg.viewList = vRIMemberDescriptionArray;
        return vRIMemberDescriptionArray;
    }

    class MergeNoHeader
    extends MBRMessage.MBRHeader {
        public void toArray(byte[] byArray, Utils.Offset offset) {
            super.toArray(byArray, offset);
            Utils.long2byteArray(MergeNoMsg.this.mergeContext, byArray, offset);
            Utils.int2byteArray(MergeNoMsg.this.reason, byArray, offset);
            MergeNoMsg.this.membersMgr.writeMembersDescription(byArray, offset, MergeNoMsg.this.viewList);
            MergeNoMsg.this.viewID.toArray(byArray, offset);
            Utils.string2byteArray(MergeNoMsg.this.intendedMergeLeader, byArray, offset);
        }

        public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
            if (super.fromArray(byArray, offset) == null) {
                return null;
            }
            MergeNoMsg.this.mergeContext = Utils.byteArray2long(byArray, offset);
            MergeNoMsg.this.reason = Utils.byteArray2int(byArray, offset);
            MergeNoMsg.access$202(MergeNoMsg.this, MergeNoMsg.this.membersMgr.readDefinedMembersDescription(byArray, offset));
            MergeNoMsg.this.viewID = (ViewIdImpl)new ViewIdImpl().fromArray(byArray, offset);
            MergeNoMsg.this.intendedMergeLeader = Utils.byteArray2string(byArray, offset);
            return this;
        }

        public int getLength() {
            return super.getLength() + Utils.sizeOfLong() + Utils.sizeOfInt() + MergeNoMsg.this.membersMgr.getLength(MergeNoMsg.this.viewList) + Utils.sizeOfString(MergeNoMsg.this.intendedMergeLeader) + MergeNoMsg.this.viewID.getLength();
        }
    }
}

