/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership.messages;

import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.dcs.vri.common.Arrayable;
import com.ibm.ws.dcs.vri.common.Header;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.impl.ArrayableObject;
import com.ibm.ws.dcs.vri.membership.messages.MBRIncommingMessageException;
import com.ibm.ws.dcs.vri.membership.messages.MBRMessage;
import com.ibm.ws.dcs.vri.membership.messages.ViewMsg;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;

public final class NewViewMsg
extends ViewMsg {
    private StateBlob appStateBlob;
    private ArrayableObject appState;
    private boolean areAllDefined;
    private String p;

    public NewViewMsg(VRIMessage vRIMessage, VRIMembersMGR vRIMembersMGR) throws MBRIncommingMessageException {
        super(vRIMessage, vRIMembersMGR);
        Header header2 = vRIMessage.extractHeader(new NewViewHeader());
        if (header2 == null) {
            throw new MBRIncommingMessageException(vRIMessage.getSender(), "NewViewMsg Header is null");
        }
    }

    public NewViewMsg(String string, VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, StateBlob stateBlob, String string2, VRIMembersMGR vRIMembersMGR) {
        super((byte)7, string2, vRIMembersMGR);
        this.p = string;
        this.syncedList = vRIMemberDescriptionArray;
        this.newViewId = viewIdImpl;
        this.appState = new ArrayableObject(stateBlob);
        this.appStateBlob = stateBlob;
        this.areAllDefined = true;
        MBRLogger.dcsAssert(this.newViewId.getViewLeader() != null, "viewId has null viewLeader", "NewViewMsg", "NewViewMsg()", "unknown");
        this.addHeader(new NewViewHeader());
    }

    public String toString() {
        return " NewViewMsg from:" + this.getSender() + " viewList " + NewViewMsg.toString(this.syncedList) + " Protocol " + this.p + " newViewId " + this.newViewId + " isInternal= " + this.newViewId.isInternalView() + " All defined " + this.areAllDefined + " StateXchg Version- " + (this.appStateBlob == null ? "Blob is null" : String.valueOf(this.appStateBlob.getVersion()));
    }

    public boolean areAllDefined() {
        return this.areAllDefined;
    }

    public StateBlob getVLAppStateBlob() {
        return this.appStateBlob;
    }

    public boolean iAmInNewView(VRIMemberDescription vRIMemberDescription) {
        boolean bl = false;
        if (VRIMemberUtils.contains(this.syncedList, vRIMemberDescription)) {
            bl = true;
        }
        return bl;
    }

    class NewViewHeader
    extends MBRMessage.MBRHeader {
        public void toArray(byte[] byArray, Utils.Offset offset) {
            super.toArray(byArray, offset);
            this.writeMembersDescription(byArray, offset, NewViewMsg.this.syncedList, 2);
            NewViewMsg.this.newViewId.toArray(byArray, offset);
            Utils.string2byteArray(NewViewMsg.this.p, byArray, offset);
            NewViewMsg.this.appState.toArray(byArray, offset);
        }

        public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
            if (super.fromArray(byArray, offset) == null) {
                return null;
            }
            NewViewMsg.this.syncedList = this.readDefinedMembersDescription(byArray, offset, 2);
            NewViewMsg.this.areAllDefined = NewViewMsg.this.membersMgr.areAllDefined(NewViewMsg.this.syncedList);
            NewViewMsg.this.newViewId = (ViewIdImpl)new ViewIdImpl().fromArray(byArray, offset);
            NewViewMsg.this.p = Utils.byteArray2string(byArray, offset);
            NewViewMsg.this.appState = new ArrayableObject();
            NewViewMsg.this.appState = (ArrayableObject)NewViewMsg.this.appState.fromArray(byArray, offset);
            if (NewViewMsg.this.appState == null) {
                NewViewMsg.this.appStateBlob = null;
            } else {
                NewViewMsg.this.appStateBlob = (StateBlob)NewViewMsg.this.appState.getObject();
            }
            return this;
        }

        public int getLength() {
            return super.getLength() + this.getLength(NewViewMsg.this.syncedList, 2) + NewViewMsg.this.newViewId.getLength() + Utils.sizeOfString(NewViewMsg.this.p) + NewViewMsg.this.appState.getLength();
        }
    }
}

