/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership.messages;

import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.vri.common.Arrayable;
import com.ibm.ws.dcs.vri.common.Downcalls;
import com.ibm.ws.dcs.vri.common.Header;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.membership.messages.MBRIncommingMessageException;
import com.ibm.ws.dcs.vri.membership.messages.MBRMessage;
import com.ibm.ws.dcs.vri.membership.util.MBRDenialReason;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;

public final class SuspectMsg
extends MBRMessage {
    private boolean allSuspectsDefined = true;
    private VRIMemberDescription[] suspectList;
    private int[] reasonCodes;

    public SuspectMsg(VRIMemberDescription[] vRIMemberDescriptionArray, MBRDenialReason mBRDenialReason, String string, VRIMembersMGR vRIMembersMGR) {
        this(vRIMemberDescriptionArray, new MBRDenialReason[]{mBRDenialReason}, string, vRIMembersMGR);
    }

    public SuspectMsg(VRIMemberDescription vRIMemberDescription, MBRDenialReason mBRDenialReason, String string, VRIMembersMGR vRIMembersMGR) {
        this(new VRIMemberDescription[]{vRIMemberDescription}, new MBRDenialReason[]{mBRDenialReason}, string, vRIMembersMGR);
    }

    public SuspectMsg(VRIMemberDescription[] vRIMemberDescriptionArray, MBRDenialReason[] mBRDenialReasonArray, String string, VRIMembersMGR vRIMembersMGR) {
        super((byte)1, string, vRIMembersMGR, SuspectMsg.makeTargets(vRIMemberDescriptionArray, vRIMembersMGR));
        this.suspectList = vRIMemberDescriptionArray;
        this.reasonCodes = MBRDenialReason.createReasonCodes(mBRDenialReasonArray, 1000);
        this.addHeader(new SuspectHeader());
    }

    private static VRIMemberDescription[] makeTargets(VRIMemberDescription[] vRIMemberDescriptionArray, VRIMembersMGR vRIMembersMGR) {
        VRIMemberDescription[] vRIMemberDescriptionArray2 = new VRIMemberDescription[]{vRIMembersMGR.pickActiveLeader(vRIMemberDescriptionArray)};
        VRIMemberDescription[] vRIMemberDescriptionArray3 = VRIMemberUtils.intersection(vRIMemberDescriptionArray, vRIMembersMGR.getViewMembers());
        return VRIMemberUtils.unification(vRIMemberDescriptionArray2, vRIMemberDescriptionArray3);
    }

    public SuspectMsg(VRIMessage vRIMessage, VRIMembersMGR vRIMembersMGR) throws MBRIncommingMessageException {
        super(vRIMessage, vRIMembersMGR);
        this.targets = new VRIMemberDescription[]{vRIMembersMGR.getThisMember()};
        Header header2 = vRIMessage.extractHeader(new SuspectHeader());
        if (header2 == null) {
            throw new MBRIncommingMessageException(vRIMessage.getSender(), "Suspect Header is null");
        }
        this.allSuspectsDefined = vRIMembersMGR.areAllDefined(this.suspectList);
        if (!this.allSuspectsDefined) {
            MBRLogger.dcsInternalInfo((DCSTraceContext)this, "SuspectMsg()", "suspectList has undefined members");
            this.suspectList = vRIMembersMGR.removeUndefined(this.suspectList);
        }
    }

    public String toString() {
        return " SuspectMsg from:" + this.getSender() + " to " + SuspectMsg.toString(this.targets) + "  " + SuspectMsg.toString(this.suspectList) + this.reasonCodes[0];
    }

    public boolean iAmSuspected(VRIMemberDescription vRIMemberDescription) {
        return VRIMemberUtils.contains(this.suspectList, vRIMemberDescription);
    }

    public boolean areAllSuspectsDefined() {
        return this.allSuspectsDefined;
    }

    private int numOfSuspects() {
        if (this.suspectList == null) {
            return 0;
        }
        return this.suspectList.length;
    }

    public int getReasonCode(VRIMemberDescription vRIMemberDescription) {
        int n = 0;
        if (this.reasonCodes != null && this.reasonCodes.length == 1) {
            n = this.reasonCodes[0];
        } else {
            for (int i = 0; i < this.suspectList.length; ++i) {
                if (!this.suspectList[i].equals(vRIMemberDescription)) continue;
                n = this.reasonCodes[i];
                break;
            }
        }
        return n;
    }

    public boolean isAdminastrative(VRIMemberDescription vRIMemberDescription) {
        int n = this.getReasonCode(vRIMemberDescription);
        return n == 0 || n == 1;
    }

    public boolean isSuspectListEmpty() {
        return this.numOfSuspects() == 0;
    }

    public VRIMemberDescription[] getSuspectList() {
        return this.suspectList;
    }

    public void removeFromSuspectList(VRIMemberDescription vRIMemberDescription) {
        this.suspectList = VRIMemberUtils.minus(this.suspectList, vRIMemberDescription);
    }

    public final void removeSuspectsAlreadyFailed(VRIMemberDescription[] vRIMemberDescriptionArray) {
        this.suspectList = VRIMemberUtils.minus(this.suspectList, vRIMemberDescriptionArray);
    }

    public final void removeSuspectsNotInView() {
        this.suspectList = VRIMemberUtils.intersection(this.suspectList, this.membersMgr.getViewMembers());
    }

    public boolean isViewLeaderSuspected(VRIMemberDescription vRIMemberDescription) {
        return VRIMemberUtils.contains(this.suspectList, vRIMemberDescription);
    }

    public boolean isMergeLeaderSuspected(VRIMemberDescription vRIMemberDescription) {
        return VRIMemberUtils.contains(this.suspectList, vRIMemberDescription);
    }

    public VRIMemberDescription[] getMergeSuspects() {
        VRIMemberDescription[] vRIMemberDescriptionArray = VRIMemberUtils.minus(this.suspectList, this.membersMgr.getViewMembers());
        if (vRIMemberDescriptionArray != null && vRIMemberDescriptionArray.length == 0) {
            vRIMemberDescriptionArray = null;
        }
        return vRIMemberDescriptionArray;
    }

    public void mcast(Downcalls downcalls) throws DCSInvalidParametersException, DCSTransportLayerException {
        super.mcastTarget(downcalls);
    }

    static /* synthetic */ int[] access$102(SuspectMsg suspectMsg, int[] nArray) {
        suspectMsg.reasonCodes = nArray;
        return nArray;
    }

    static /* synthetic */ VRIMemberDescription[] access$002(SuspectMsg suspectMsg, VRIMemberDescription[] vRIMemberDescriptionArray) {
        suspectMsg.suspectList = vRIMemberDescriptionArray;
        return vRIMemberDescriptionArray;
    }

    class SuspectHeader
    extends MBRMessage.MBRHeader {
        public void toArray(byte[] byArray, Utils.Offset offset) {
            super.toArray(byArray, offset);
            SuspectMsg.this.membersMgr.writeMembersDescription(byArray, offset, SuspectMsg.this.suspectList);
            if (SuspectMsg.this.reasonCodes == null) {
                SuspectMsg.access$102(SuspectMsg.this, new int[0]);
            }
            Utils.int2byteArray(SuspectMsg.this.reasonCodes.length, byArray, offset);
            for (int i = 0; i < SuspectMsg.this.reasonCodes.length; ++i) {
                Utils.int2byteArray(SuspectMsg.this.reasonCodes[i], byArray, offset);
            }
        }

        public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
            if (super.fromArray(byArray, offset) == null) {
                return null;
            }
            SuspectMsg.access$002(SuspectMsg.this, SuspectMsg.this.membersMgr.readDefinedMembersDescription(byArray, offset));
            int n = Utils.byteArray2int(byArray, offset);
            SuspectMsg.access$102(SuspectMsg.this, new int[n]);
            for (int i = 0; i < SuspectMsg.this.reasonCodes.length; ++i) {
                ((SuspectMsg)SuspectMsg.this).reasonCodes[i] = Utils.byteArray2int(byArray, offset);
            }
            if (SuspectMsg.this.reasonCodes.length == 0) {
                SuspectMsg.access$102(SuspectMsg.this, null);
            }
            return this;
        }

        public int getLength() {
            return super.getLength() + SuspectMsg.this.membersMgr.getLength(SuspectMsg.this.suspectList) + Utils.sizeOfInt() + Utils.sizeOfInt() * SuspectMsg.this.reasonCodes.length;
        }
    }
}

