/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.utils.Alarm;
import com.ibm.ws.dcs.utils.AlarmListener;
import com.ibm.ws.dcs.utils.AlarmManager;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;

public abstract class MBRAbstractAlarm {
    private static final TraceComponent TC = Tr.register(MBRAbstractAlarm.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    protected final Globals g;
    protected final int layer;
    private final AlarmDoit aDoIt;
    private final Alarm[] alarmTable;
    private final int MAXALARMS;
    private final int[] waitTimes;
    private final DCSTraceContext dtc;

    protected MBRAbstractAlarm(Globals globals, AlarmDoit alarmDoit, int n, int n2) {
        this.g = globals;
        this.aDoIt = alarmDoit;
        this.MAXALARMS = n;
        this.alarmTable = new Alarm[this.MAXALARMS];
        this.waitTimes = new int[this.MAXALARMS];
        this.dtc = new DCSTraceContextImpl(TC, alarmDoit);
        this.layer = n2;
    }

    protected abstract void cancelTimers();

    private Alarm getAlarm(Object object) {
        return this.alarmTable[(Integer)object - this.layer];
    }

    public int getWaitTimes(Object object) {
        return this.waitTimes[(Integer)object - this.layer];
    }

    void initTimer(Object object) {
        this.alarmTable[((Integer)object).intValue() - this.layer] = null;
    }

    protected final void cancelTimer(Object object) {
        Alarm alarm = this.getAlarm(object);
        if (alarm != null) {
            alarm.cancel();
            this.initTimer(object);
        }
    }

    protected final boolean isTimerSet(Object object) {
        return this.getAlarm(object) != null;
    }

    protected final void setTimer(long l, Object object) {
        this.cancelTimer(object);
        Alarm alarm = null;
        this.waitTimes[((Integer)object).intValue() - this.layer] = (int)l;
        this.alarmTable[((Integer)object).intValue() - this.layer] = alarm = AlarmManager.create(AlarmManager.GENERAL_ALARM, l, this.g.getMutex(), new AlarmListener(){

            public void alarm(Object object) {
                if (MBRAbstractAlarm.this.isTimerSet(object)) {
                    MBRAbstractAlarm.this.initTimer(object);
                    MBRAbstractAlarm.this.checkStats(object);
                    MBRAbstractAlarm.this.aDoIt.handleAlarm(object);
                } else {
                    MBRLogger.dcsInternalInfo(MBRAbstractAlarm.this.dtc, "alarm()", "Alarm " + MBRAbstractAlarm.this.aDoIt.getAlarmContextDescription(object) + " has been canceled - do nothing");
                }
            }
        }, object);
    }

    public void checkStats(Object object) {
    }

    public void updateStats() {
        if (this.g.statsModule != null) {
            this.g.statsModule.onMbrTimeout();
        }
    }

    public static interface AlarmDoit
    extends DCSTraceContext {
        public String getAlarmContextDescription(Object var1);

        public void handleAlarm(Object var1);
    }
}

