/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership.util;

import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIDenialReason;

public final class MBRDenialReason
extends VRIDenialReason {
    public static final int UNKNOWN = 1000;
    public static final int ADMINASTRATIVE = 0;
    public static final int ADMINASTRATIVE_REMOVAL = 1;
    public static final int INSTALL_SINGLETON = 2;
    public static final int MEMBER_BROKE_PROTOCOL = 3;
    public static final int EXPECTED_RESPONSE_FROM_MEMBER_TIMEDOUT = 4;
    public static final int SUSPECTED_BY_OTHER_VIEWMEMBER = 5;
    public static final int SUSPECTED_BY_VIEWLEADER = 6;
    public static final int DARED_TO_SUSPECT_ME = 7;
    public static final int SUSPECT_BY_ME = 8;
    public static final int CONFIG_CONFLICT = 9;
    public static final int DEFINEDSET_CONFLICT = 10;
    public static final int RESEND_LIST_TO_VIEWLEADER = 11;
    public static final int[] ADMINREASONS = new int[]{0, 1};
    private static final byte MYLAYER = 10;
    private static final byte MSXLAYER = 9;

    private MBRDenialReason(int n, String string) {
        this(10, n, string);
    }

    private MBRDenialReason(byte by, int n, String string) {
        super(by, n, string);
    }

    public static int[] createReasonCodes(VRIDenialReason[] vRIDenialReasonArray, int n) {
        return VRIDenialReason.createReasonCodes(vRIDenialReasonArray, n);
    }

    static MBRDenialReason createAdminDR(String string) {
        return new MBRDenialReason(0, "Denied by Adminastrator: " + string);
    }

    public static MBRDenialReason createAdminRemovalDR(String string) {
        return new MBRDenialReason(1, "Removed by Adminastrator: " + string);
    }

    public static MBRDenialReason createConfigConfictDR(String string) {
        return new MBRDenialReason(9, 9, "Configuration Conflict: " + string);
    }

    public static MBRDenialReason createDefinedSetConfictDR(String string) {
        return new MBRDenialReason(9, 10, "Defined Set Inconsistency: " + string);
    }

    static MBRDenialReason createInstallSingletonDR(String string) {
        String string2 = Utils.getStackTraceAsString();
        String string3 = "Installing Singleton deny all others: " + string + string2;
        return new MBRDenialReason(2, string3);
    }

    static MBRDenialReason createMBRBrokeProcoolDR(String string) {
        return new MBRDenialReason(3, "Member Broke Protocol: " + string);
    }

    static MBRDenialReason createExpRespTimeoutDR(String string) {
        return new MBRDenialReason(4, "Did not receive expected response from Member: " + string);
    }

    static MBRDenialReason createSuspectedByOthersDR(String string) {
        return new MBRDenialReason(5, "Suspected by other view Member " + string);
    }

    static MBRDenialReason createSuspectedByVLDR(String string) {
        return new MBRDenialReason(6, "Suspected by  view Leader " + string);
    }

    static MBRDenialReason createMutualDistrustDR(String string) {
        return new MBRDenialReason(7, "View Member dared to suspect me! " + string);
    }

    public static MBRDenialReason createSuspectedByMeDR(String string) {
        return new MBRDenialReason(8, "Suspected by one of my lower layers " + string);
    }

    public static MBRDenialReason createResendSuspected(String string) {
        return new MBRDenialReason(11, "ViewLeader missing following suspects " + string);
    }

    public boolean isSticky(VRIDenialReason vRIDenialReason) {
        boolean bl = false;
        if (this.getDenialReasonCode() == 0 || this.getDenialReasonCode() == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isResend() {
        return this.getDenialReasonCode() == 11;
    }

    public static MBRDenialReason[] convert(VRIDenialReason[] vRIDenialReasonArray) {
        if (vRIDenialReasonArray == null) {
            return new MBRDenialReason[0];
        }
        MBRDenialReason[] mBRDenialReasonArray = new MBRDenialReason[vRIDenialReasonArray.length];
        for (int i = 0; i < vRIDenialReasonArray.length; ++i) {
            mBRDenialReasonArray[i] = (MBRDenialReason)vRIDenialReasonArray[i];
        }
        return mBRDenialReasonArray;
    }
}

