/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership.util;

import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.nls.MBRSuspect;
import com.ibm.ws.dcs.vri.common.nls.MBRSuspectBrokeProtocol;
import com.ibm.ws.dcs.vri.common.nls.MBRSuspectByOthers;
import com.ibm.ws.dcs.vri.common.nls.MBRSuspectInstallSingleton;
import com.ibm.ws.dcs.vri.common.nls.MBRSuspectMBRTimedout;
import com.ibm.ws.dcs.vri.common.nls.MBRSuspectMutualSuspicion;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.membership.util.MBRDenialReason;

public final class MBRDenialRecord {
    private MBRDenialReason mbrDenialReason;
    private MBRSuspect mbrSuspectEvent;
    private VRIMemberDescription[] suspects;

    private MBRDenialRecord(MBRDenialReason mBRDenialReason, MBRSuspect mBRSuspect, VRIMemberDescription[] vRIMemberDescriptionArray) {
        this.mbrDenialReason = mBRDenialReason;
        this.mbrSuspectEvent = mBRSuspect;
        this.suspects = vRIMemberDescriptionArray;
    }

    public static MBRDenialRecord createAdminDR(DCSTraceContext dCSTraceContext, String string, VRIMemberDescription[] vRIMemberDescriptionArray) {
        return new MBRDenialRecord(MBRDenialReason.createAdminDR(string), null, vRIMemberDescriptionArray);
    }

    public static MBRDenialRecord createAdminRemovalDR(DCSTraceContext dCSTraceContext, String string, VRIMemberDescription[] vRIMemberDescriptionArray) {
        return new MBRDenialRecord(MBRDenialReason.createAdminRemovalDR(string), null, vRIMemberDescriptionArray);
    }

    public static MBRDenialRecord createConfigConfictDR(DCSTraceContext dCSTraceContext, String string, VRIMemberDescription[] vRIMemberDescriptionArray) {
        return new MBRDenialRecord(MBRDenialReason.createConfigConfictDR(string), null, vRIMemberDescriptionArray);
    }

    public static MBRDenialRecord createDefinedSetConfictDR(DCSTraceContext dCSTraceContext, String string, VRIMemberDescription[] vRIMemberDescriptionArray) {
        return new MBRDenialRecord(MBRDenialReason.createDefinedSetConfictDR(string), null, vRIMemberDescriptionArray);
    }

    public static MBRDenialRecord createInstallSingletonDR(DCSTraceContext dCSTraceContext, String string, VRIMemberDescription[] vRIMemberDescriptionArray) {
        String string2 = Utils.getStackTraceAsString();
        String string3 = "Installing Singleton deny all others: " + string + string2;
        MBRSuspectInstallSingleton mBRSuspectInstallSingleton = new MBRSuspectInstallSingleton(dCSTraceContext, string3, VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray));
        return new MBRDenialRecord(MBRDenialReason.createInstallSingletonDR(string), mBRSuspectInstallSingleton, vRIMemberDescriptionArray);
    }

    public static MBRDenialRecord createMBRBrokeProtocolDR(DCSTraceContext dCSTraceContext, String string, VRIMemberDescription[] vRIMemberDescriptionArray) {
        String[] stringArray = VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray);
        return new MBRDenialRecord(MBRDenialReason.createMBRBrokeProcoolDR(string), new MBRSuspectBrokeProtocol(dCSTraceContext, stringArray, string), vRIMemberDescriptionArray);
    }

    public static MBRDenialRecord createExpRespTimeoutDR(DCSTraceContext dCSTraceContext, String string, VRIMemberDescription[] vRIMemberDescriptionArray, int n) {
        return new MBRDenialRecord(MBRDenialReason.createExpRespTimeoutDR(string), new MBRSuspectMBRTimedout(dCSTraceContext, VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray), n, string), vRIMemberDescriptionArray);
    }

    public static MBRDenialRecord createSuspectedByOthersDR(DCSTraceContext dCSTraceContext, String string, VRIMemberDescription[] vRIMemberDescriptionArray, String string2) {
        return new MBRDenialRecord(MBRDenialReason.createSuspectedByOthersDR(string), new MBRSuspectByOthers(dCSTraceContext, VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray), string2, "VL suspects others: " + string), vRIMemberDescriptionArray);
    }

    public static MBRDenialRecord createSuspectedByVLDR(DCSTraceContext dCSTraceContext, String string, VRIMemberDescription[] vRIMemberDescriptionArray, String string2) {
        return new MBRDenialRecord(MBRDenialReason.createSuspectedByVLDR(string), new MBRSuspectByOthers(dCSTraceContext, VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray), string2, "VL suspects others: " + string), vRIMemberDescriptionArray);
    }

    public static MBRDenialRecord createMutualDistrustDR(DCSTraceContext dCSTraceContext, String string, VRIMemberDescription vRIMemberDescription) {
        return new MBRDenialRecord(MBRDenialReason.createMutualDistrustDR(string), new MBRSuspectMutualSuspicion(dCSTraceContext, new String[]{vRIMemberDescription.getName()}), new VRIMemberDescription[]{vRIMemberDescription});
    }

    public static MBRDenialRecord createSuspectedByMeDR(DCSTraceContext dCSTraceContext, String string, VRIMemberDescription[] vRIMemberDescriptionArray) {
        return new MBRDenialRecord(MBRDenialReason.createSuspectedByMeDR(string), null, vRIMemberDescriptionArray);
    }

    public static MBRDenialRecord createResendSuspectedDR(DCSTraceContext dCSTraceContext, String string, VRIMemberDescription[] vRIMemberDescriptionArray) {
        return new MBRDenialRecord(MBRDenialReason.createResendSuspected(string), null, vRIMemberDescriptionArray);
    }

    public MBRDenialReason getDenialReason() {
        return this.mbrDenialReason;
    }

    public MBRSuspect getSuspectEvent() {
        return this.mbrSuspectEvent;
    }

    public VRIMemberDescription[] getSuspects() {
        return this.suspects;
    }

    public String toString() {
        String string = null;
        string = string + "Denial Record:  denial reason code= " + this.getDenialReason().getDenialReasonCode() + " description= " + this.getDenialReason().getDenialReasonDescription() + " suspects= " + VRIMemberUtils.toString(this.getSuspects()) + " trace= " + String.valueOf(this.getSuspectEvent());
        return string;
    }
}

