/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.testerlayer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import com.ibm.ws.dcs.vri.testerlayer.TLViewData;
import com.ibm.ws.dcs.vri.testerlayer.TUtils;
import java.util.Iterator;
import java.util.LinkedList;

public class MemberData {
    private static final String LAYER_NAME = DCSConstants.TRACE_LAYER_NAMES[7];
    public static final int IS_IN_VIEW_STATE = 0;
    public static final int IS_CONNECTED_STATE = 1;
    private boolean[] _states = new boolean[2];
    private static final TraceComponent TC = Tr.register(QOSInfo.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private final DCSTraceContext _traceContext;
    private String _thisMemberName = "";
    public QOSInfo[] infos = new QOSInfo[9];

    public MemberData(String string, String string2) {
        this._thisMemberName = string;
        this._traceContext = new DCSTraceContextImpl(TC, string2, this._thisMemberName, LAYER_NAME);
        this.setIsInView(false);
        this.setIsConnected(false);
        for (int i = 1; i <= 9; ++i) {
            this.infos[i - 1] = new QOSInfo(i);
        }
    }

    MemberData(MemberData memberData) {
        this._thisMemberName = memberData._thisMemberName;
        this._traceContext = new DCSTraceContextImpl(TC, memberData._traceContext);
        this.setIsInView(memberData.getIsInView());
        this.setIsConnected(memberData.getIsConnected());
        for (int i = 0; i < this.infos.length; ++i) {
            if (memberData.infos[i].isType(5)) {
                if (memberData.getIsConnected()) {
                    this.infos[i] = new QOSInfo(memberData.infos[i]);
                    continue;
                }
                this.infos[i] = new QOSInfo(memberData.infos[i].getType());
                continue;
            }
            this.infos[i] = memberData.getIsInView() ? new QOSInfo(memberData.infos[i]) : new QOSInfo(memberData.infos[i].getType());
        }
    }

    public String getName() {
        return this._thisMemberName;
    }

    public QOSInfo get_MCAST_CONNECTED_QOSInfo() {
        return this.getQOSInfo(5);
    }

    public QOSInfo getQOSInfo(int n) {
        TUtils.assertMethod(QOSInfo.isLegalType(n), "QOSInfo.isLegalType(type)", null);
        for (int i = 0; i < this.infos.length; ++i) {
            if (!this.infos[i].isType(n)) continue;
            return this.infos[i];
        }
        String string = "";
        for (int i = 0; i < this.infos.length; ++i) {
            string = string + this.infos[i].getType() + " ";
        }
        TUtils.assertMethod(false, "UNKNOWN TYPE " + n + " at MemberData.getQOSInfo(). All are: " + string, null);
        return null;
    }

    public void setIsInView(boolean bl) {
        this._states[0] = bl;
    }

    public void setIsConnected(boolean bl) {
        this._states[1] = bl;
    }

    public boolean getIsInView() {
        return this._states[0];
    }

    public boolean getIsConnected() {
        return this._states[1];
    }

    public boolean getIsOfState(int n) {
        TUtils.assertMethod(n >= 0 && n <= 1, "state>=IS_IN_VIEW_STATE && state<=IS_CONNECTED_STATE", null);
        return this._states[n];
    }

    public void addNotSelfDelivered(int n, int n2, QoS.QOSMulticast qOSMulticast) {
        this.getQOSInfo(n).addNotSelfDelivered(n2, qOSMulticast);
    }

    public void advanceNotSelfDelivered(int n, int n2, MemberData memberData, ViewIdImpl viewIdImpl) {
        if (memberData.getName().equals(this.getName())) {
            this.getQOSInfo(n).advanceNotSelfDelivered(n2, viewIdImpl, this._traceContext);
        }
    }

    public boolean checkNotSelfDelivered(ViewIdImpl viewIdImpl) {
        boolean bl = true;
        for (int i = 0; i < this.infos.length; ++i) {
            if (!this.infos[i].isMcastType()) continue;
            bl = bl && this.infos[i].checkNotSelfDelivered(viewIdImpl, this._traceContext);
        }
        return bl;
    }

    public boolean checkNotSelfDelivered(int n, ViewIdImpl viewIdImpl) {
        return this.getQOSInfo(n).checkNotSelfDelivered(viewIdImpl, this._traceContext);
    }

    void check() {
        for (int i = 0; i < this.infos.length; ++i) {
            if (!this.infos[i].isMcastType()) continue;
            this.infos[i].check(this._traceContext);
        }
    }

    public static class QOSInfo {
        public static final short MCAST_VS_CURR_CHANNEL_TYPE = 1;
        public static final short MCAST_VS_ANY_CHANNEL_TYPE = 2;
        public static final short MCAST_VS_TOTAL_CHANNEL_TYPE = 3;
        public static final short MCAST_FIFO_VIEW_CHANNEL_TYPE = 4;
        public static final short MCAST_FIFO_CONNECTED_CHANNEL_TYPE = 5;
        public static final short P2P_VS_CURR_CHANNEL_TYPE = 6;
        public static final short P2P_FIFO_CHANNEL_TYPE = 7;
        public static final short P2P_TOTAL_CHANNEL_TYPE = 8;
        public static final short MCAST_FIFO_SUBGROUP_CHANNEL_TYPE = 9;
        public static final short MIN_CHANNEL_TYPE = 1;
        public static final short MAX_CHANNEL_TYPE = 9;
        public static final short NUM_CHANNELS = 9;
        public static boolean DEBUG = true;
        public static final String[] QOS_TYPE_NAMES = new String[]{"NOT DEFINED", "MCAST_VS_CURR_CHANNEL_TYPE", "MCAST_VS_ANY_CHANNEL_TYPE", "MCAST_VS_TOTAL_CHANNEL_TYPE", "MCAST_FIFO_VIEW_CHANNEL_TYPE", "MCAST_FIFO_CONNECTED_CHANNEL_TYPE", "P2P_VS_CURR_CHANNEL_TYPE", "P2P_FIFO_CHANNEL_TYPE", "P2P_TOTAL_CHANNEL_TYPE", "MCAST_FIFO_SUBGROUP_CHANNEL_TYPE"};
        public static final String[] QOS_TYPE_SHORT_NAMES = new String[]{"NOT DEFINED", "MCAST_VS_CURR", "MCAST_VS_ANY", "MCAST_VS_TOTAL", "MCAST_FIFO_VIEW", "MCAST_FIFO_CON", "P2P_VS_CURR", "P2P_FIFO", "P2P_TOTAL", "SUBGROUP_SEND"};
        private int _firstR = 0;
        private int _lastR = 0;
        private int _firstSent = 0;
        private int _lastSent = 0;
        private int _type = -1;
        private boolean _alreadySentFirstInView = false;
        private boolean _alreadyReceivedFirstInView = false;
        private LinkedList notSelfDeliveredMsgs = null;

        QOSInfo(QOSInfo qOSInfo) {
            this._type = qOSInfo._type;
            this._alreadySentFirstInView = false;
            this._alreadyReceivedFirstInView = false;
            this._firstR = 0;
            this._lastR = qOSInfo._lastR;
            this._firstSent = 0;
            this._lastSent = qOSInfo._lastSent;
            if (this.isMcastType()) {
                this.notSelfDeliveredMsgs = (LinkedList)qOSInfo.notSelfDeliveredMsgs.clone();
            }
        }

        QOSInfo(int n) {
            this._alreadySentFirstInView = false;
            this._alreadyReceivedFirstInView = false;
            this._type = n;
            this._firstR = 0;
            this._lastR = 0;
            this._firstSent = 0;
            this._lastSent = 0;
            if (this.isMcastType()) {
                this.notSelfDeliveredMsgs = new LinkedList();
            }
        }

        public QOSInfo(int n, int n2, int n3, int n4, int n5) {
            this._alreadySentFirstInView = false;
            this._alreadyReceivedFirstInView = false;
            this._type = n;
            this._firstR = n4;
            this._lastR = n5;
            this._firstSent = n2;
            this._lastSent = n3;
            if (TLViewData._versionNum <= 5) {
                if (this._firstSent < this._lastSent) {
                    this._alreadySentFirstInView = true;
                }
            } else {
                TUtils.assertMethod(TLViewData._versionNum >= 6);
                if (this._firstSent > 0) {
                    TUtils.assertMethod(this._firstSent <= this._lastSent, "_firstSent < _lastSent" + this._firstSent + " " + this._lastSent);
                    this._alreadySentFirstInView = true;
                }
            }
            if (this._firstR > 0) {
                TUtils.assertMethod(this._firstR <= this._lastR, "_firstR < _lastR " + this._firstR + " " + this._lastR);
                this._alreadyReceivedFirstInView = true;
            }
        }

        public static boolean isLegalType(int n) {
            return n >= 1 && n <= 9;
        }

        public static int getMatchingTotalType(int n) {
            switch (n) {
                case 1: 
                case 2: {
                    return 3;
                }
                case 6: 
                case 7: {
                    return 8;
                }
            }
            return -1;
        }

        public String getShortName() {
            if (QOSInfo.isLegalType(this._type)) {
                return QOS_TYPE_SHORT_NAMES[this._type];
            }
            return QOS_TYPE_SHORT_NAMES[0];
        }

        public int getType() {
            return this._type;
        }

        public boolean isType(int n) {
            return this._type == n;
        }

        public boolean isMcastType() {
            return this.isType(1) || this.isType(2) || this.isType(4) || this.isType(5) || this.isType(3);
        }

        public boolean isP2PType() {
            return this.isType(6) || this.isType(7) || this.isType(8);
        }

        boolean checkFIFO(int n) {
            if (!this._alreadyReceivedFirstInView) {
                this._alreadyReceivedFirstInView = true;
                this._firstR = n;
            }
            return this._lastR == 0 || this._lastR + 1 == n;
        }

        public int lastSent() {
            return this._lastSent;
        }

        public int lastReceived() {
            return this._lastR;
        }

        public int firstSent() {
            return this._firstSent;
        }

        public int firstReceived() {
            return this._firstR;
        }

        public boolean sentInView() {
            return this._alreadySentFirstInView;
        }

        public boolean receivedInView() {
            return this._alreadyReceivedFirstInView;
        }

        int nextSent() {
            return this.lastSent() + 1;
        }

        void updateLastSent() {
            if (!this._alreadySentFirstInView) {
                this._alreadySentFirstInView = true;
                ++this._lastSent;
                this._firstSent = this._lastSent;
            } else {
                ++this._lastSent;
            }
        }

        void updateLastSent(int n) {
            if (!this._alreadySentFirstInView) {
                this._alreadySentFirstInView = true;
                this._firstSent = this._lastSent = n;
            } else {
                ++this._lastSent;
            }
        }

        void setLastR(int n) {
            this._lastR = n;
        }

        void setLastSent(int n) {
            this._lastSent = n;
        }

        public void addNotSelfDelivered(int n, QoS.QOSMulticast qOSMulticast) {
            if (!this.isMcastType()) {
                TUtils.assertMethod(false, "addNotSelfDelivered(int ind, QoS.QOSMulticast msgQoS) : type= " + this._type + " is not isMcastType()");
            }
            if (!qOSMulticast.isSelfDelivered()) {
                if (DEBUG) {
                    System.err.println("@@@ Addiding NOT SELF DELIVERED");
                }
                this.notSelfDeliveredMsgs.addLast(new Integer(n));
            }
        }

        public void advanceNotSelfDelivered(int n, ViewIdImpl viewIdImpl, DCSTraceContext dCSTraceContext) {
            int n2 = this.lastReceived();
            if (this.notSelfDeliveredMsgs.contains(new Integer(n)) && DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(dCSTraceContext, "advanceNotSelfDelivered()", "### " + dCSTraceContext.getLayerName() + " ERROR: ");
                dCSTraceBuffer.addProperty(viewIdImpl);
                dCSTraceBuffer.addProperty("Error_description", "Receieved NOT SELF DELIVERED Msg " + n + " from " + dCSTraceContext.getMemberName() + " : previous id = " + n2 + " QOSInfo " + QOS_TYPE_NAMES[this.getType()]);
                dCSTraceBuffer.invoke();
                if (DEBUG) {
                    System.err.println(dCSTraceBuffer.toString());
                }
            }
            for (int i = n2 + 1; i < n; ++i) {
                Integer n3 = null;
                if (!this.notSelfDeliveredMsgs.isEmpty()) {
                    n3 = (Integer)this.notSelfDeliveredMsgs.getFirst();
                }
                if (n3 != null && n3 == i) {
                    this.notSelfDeliveredMsgs.removeFirst();
                    boolean bl = this.checkFIFO(i);
                    if (!bl && DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(dCSTraceContext, "advanceNotSelfDelivered()", "### " + dCSTraceContext.getLayerName() + " ERROR: ");
                        dCSTraceBuffer.addProperty(viewIdImpl);
                        dCSTraceBuffer.addProperty("Error_description", "notSelfDeliveredMsg from " + dCSTraceContext.getMemberName() + " is out of order" + " : previous id = " + this.lastReceived() + " curr id = " + i + " QOSInfo " + QOS_TYPE_NAMES[this.getType()] + (viewIdImpl != null ? " msg was sent in view " + viewIdImpl : ""));
                        dCSTraceBuffer.invoke();
                        if (DEBUG) {
                            System.err.println(dCSTraceBuffer.toString());
                        }
                    }
                } else {
                    return;
                }
                this.setLastR(i);
            }
        }

        public boolean checkNotSelfDelivered(ViewIdImpl viewIdImpl, DCSTraceContext dCSTraceContext) {
            boolean bl = true;
            int n = this.lastReceived();
            Iterator iterator = this.notSelfDeliveredMsgs.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                if (n2 > n) continue;
                bl = false;
                if (!DCSTraceBuffer.isEventEnabled(TC)) continue;
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(dCSTraceContext, "checkNotSelfDelivered()", "### " + dCSTraceContext.getLayerName() + " ERROR: ");
                dCSTraceBuffer.addProperty(viewIdImpl);
                dCSTraceBuffer.addProperty("Error_description", "Still has notSelfDeliveredMsg in DB number " + n2 + " but last received is already: " + n + " QOSInfo " + QOS_TYPE_NAMES[this._type]);
                dCSTraceBuffer.invoke();
                if (!DEBUG) continue;
                System.err.println(dCSTraceBuffer.toString());
            }
            return bl;
        }

        void check(DCSTraceContext dCSTraceContext) {
            if (this.notSelfDeliveredMsgs.size() > 0 && DCSTraceBuffer.isEventEnabled(TC) && this.notSelfDeliveredMsgs != null && DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(dCSTraceContext, "check()", "there are " + this.notSelfDeliveredMsgs.size() + " msgs in the notSelfDeliveredMsgs list of " + QOS_TYPE_NAMES[this._type]);
                dCSTraceBuffer.invoke();
                if (DEBUG) {
                    System.err.println(dCSTraceBuffer.toString());
                }
            }
        }
    }
}

