/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.testerlayer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSAssertException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.vri.common.AddDefinedFailedException;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.Downcalls;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.LayerLinkage;
import com.ibm.ws.dcs.vri.common.Upcalls;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRICheckFailedException;
import com.ibm.ws.dcs.vri.common.VRIIllegalStateException;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.event.VRIDownEvent;
import com.ibm.ws.dcs.vri.common.event.VRIEventHandlersMap;
import com.ibm.ws.dcs.vri.common.event.VRIUpEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import com.ibm.ws.dcs.vri.common.util.FFDCDumper;
import com.ibm.ws.dcs.vri.testerlayer.MemberData;
import com.ibm.ws.dcs.vri.testerlayer.TLViewData;
import com.ibm.ws.dcs.vri.testerlayer.TUtils;
import com.ibm.ws.dcs.vri.testerlayer.TesterHeader;
import com.ibm.ws.dcs.vri.testerlayer.ThreadDumper;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class TesterLayer
implements Downcalls,
Upcalls,
LayerLinkage {
    private static final String LAYER_NAME = DCSConstants.TRACE_LAYER_NAMES[7];
    VRIMemberDescription _thisMember = null;
    String _thisStackName = null;
    private ViewIdImpl _curViewId = null;
    private CCVersion _ccv = null;
    private VRIMemberDescription[] _curViewMembers = null;
    private VRIMemberDescription[] _connectedMembers = null;
    private HashMap _membersData = new HashMap();
    static final int INITIALIZING = 1;
    static final int NORMAL = 2;
    static final int CC = 3;
    static final int TERMINATED = 4;
    private static final String[] STATE_NAMES = new String[]{"NOT DEFINED", "INITIALIZING", "NORMAL", "CC", "TERMINATED"};
    private int _state = 0;
    static final int VERSION = 0x1000000;
    public static final String DELIMITER_PROP_NAME = "DCS.TESTER.MSGDELIMITER";
    private static final String DELIM_STRING = System.getProperty("DCS.TESTER.MSGDELIMITER", "");
    private static final String LS = System.getProperty("line.separator", "\n");
    private static final TraceComponent TC = Tr.register(TesterLayer.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private final DCSTraceContext _traceContext;
    Downcalls _down;
    Upcalls _up;
    private Globals _globals;
    private VRIMembersMGR _membersMgr;
    private final VRIEventHandlersMap _eventHandlers = null;
    private final boolean DEBUG = false;
    volatile long _lastCheckTime;
    private final long _checkTime;
    private LivenessCheckThread _lct;

    public TesterLayer(Globals globals) {
        this._globals = globals;
        this._checkTime = this._globals.getConfigParamAsInt("DCS_CHECK_TIME_SEC") * 1000;
        this._membersMgr = globals.getVRIMembersMgr();
        this._thisMember = this._membersMgr.getThisMember();
        this._thisStackName = this._membersMgr.getThisStackName();
        this._state = 1;
        this._traceContext = new DCSTraceContextImpl(TC, this._thisStackName, this._thisMember.getName(), LAYER_NAME);
        this._lct = new LivenessCheckThread(this._thisStackName);
    }

    private void printMessage(String string) {
    }

    void focusError(String string, String string2) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, string, "### " + this._traceContext.getLayerName() + " ERROR: ");
            dCSTraceBuffer.addProperty(this._curViewId);
            dCSTraceBuffer.addProperty("state", STATE_NAMES[this._state]);
            dCSTraceBuffer.addProperty("Error_description", string2);
            dCSTraceBuffer.invoke();
        }
    }

    public void start(ViewIdImpl viewIdImpl) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "start()", "TesterLayer is being started");
            dCSTraceBuffer.invoke();
        }
        if (this._up == null) {
            throw new VRIIllegalStateException(7, "start: up is null");
        }
        if (this._down == null) {
            throw new VRIIllegalStateException(7, "start: down is null");
        }
        this._connectedMembers = new VRIMemberDescription[this._membersMgr.getConnectedMembersSize()];
        System.arraycopy(this._membersMgr.getConnectedMembers(false), 0, this._connectedMembers, 0, this._membersMgr.getConnectedMembersSize());
        this._state = 2;
        this.initConnectedScopedVariables(this._membersMgr.getConnectedMembers(false));
        this.initViewScopedVariables(this._membersMgr.getViewMembers(), viewIdImpl);
        this._down.start(viewIdImpl);
        this._lastCheckTime = System.currentTimeMillis();
        this._lct.start();
    }

    private void initViewScopedVariables(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl) {
        Object object;
        Iterator iterator = this._membersData.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object = (MemberData)this._membersData.get(string);
            if (TUtils.contains(VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray), string)) continue;
            ((MemberData)object).setIsInView(false);
            if (((MemberData)object).getIsConnected()) continue;
            iterator.remove();
        }
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            object = vRIMemberDescriptionArray[i].getName();
            MemberData memberData = (MemberData)this._membersData.get(object);
            MemberData memberData2 = null;
            memberData2 = memberData == null ? new MemberData((String)object, this._thisStackName) : new MemberData(memberData);
            memberData2.setIsInView(true);
            this._membersData.put(object, memberData2);
        }
        this._curViewId = viewIdImpl;
        this._curViewMembers = new VRIMemberDescription[vRIMemberDescriptionArray.length];
        System.arraycopy(vRIMemberDescriptionArray, 0, this._curViewMembers, 0, vRIMemberDescriptionArray.length);
        MemberData memberData = (MemberData)this._membersData.get(this._thisMember.getName());
        memberData.checkNotSelfDelivered(this._curViewId);
    }

    private void initConnectedScopedVariables(VRIMemberDescription[] vRIMemberDescriptionArray) {
        Object object;
        String[] stringArray = VRIMemberUtils.getMemberNames(this._membersMgr.getConnectedMembers(false));
        Iterator iterator = this._membersData.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object = (MemberData)this._membersData.get(string);
            if (TUtils.contains(stringArray, string)) continue;
            ((MemberData)object).setIsConnected(false);
            if (((MemberData)object).getIsInView()) continue;
            iterator.remove();
        }
        for (int i = 0; vRIMemberDescriptionArray != null && i < vRIMemberDescriptionArray.length; ++i) {
            object = vRIMemberDescriptionArray[i].getName();
            MemberData memberData = (MemberData)this._membersData.get(object);
            if (memberData == null) {
                MemberData memberData2 = new MemberData((String)object, this._thisStackName);
                memberData2.setIsConnected(true);
                memberData2.setIsInView(false);
                this._membersData.put(object, memberData2);
                continue;
            }
            memberData.setIsConnected(true);
        }
        VRIMemberDescription[] vRIMemberDescriptionArray2 = this._membersMgr.getConnectedMembers(false);
        this._connectedMembers = new VRIMemberDescription[vRIMemberDescriptionArray2.length];
        System.arraycopy(vRIMemberDescriptionArray2, 0, this._connectedMembers, 0, vRIMemberDescriptionArray2.length);
        object = (MemberData)this._membersData.get(this._thisMember.getName());
        ((MemberData)object).checkNotSelfDelivered(5, this._curViewId);
    }

    private void writeViewData(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl) {
        String[] stringArray = VRIMemberUtils.getMemberNames(this._curViewMembers);
        String[] stringArray2 = VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray);
        String[] stringArray3 = VRIMemberUtils.getMemberNames(this._connectedMembers);
        TLViewData tLViewData = new TLViewData(this._thisMember.getName(), this._thisStackName, this._curViewId, stringArray, viewIdImpl, stringArray2, stringArray3, this._membersData);
        String string = tLViewData.toString();
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "writeViewData()", string);
            dCSTraceBuffer.invoke();
        }
        System.err.println(DELIM_STRING + string + LS + DELIM_STRING);
        System.err.flush();
    }

    public void newView(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "newView()", "");
            dCSTraceBuffer.addProperty(viewIdImpl);
            dCSTraceBuffer.addProperty("viewMembers", VRIMemberUtils.toString(vRIMemberDescriptionArray));
            dCSTraceBuffer.addProperty("connectedMembers", VRIMemberUtils.toString(this._membersMgr.getConnectedMembers(false)));
            dCSTraceBuffer.invoke();
        }
        this.checkStackLock("newView()");
        if (this._curViewId.getViewNum() >= viewIdImpl.getViewNum()) {
            this.focusError("newView()", " got newViewId " + viewIdImpl.toString());
        }
        this._state = 2;
        this.writeViewData(vRIMemberDescriptionArray, viewIdImpl);
        this.initViewScopedVariables(vRIMemberDescriptionArray, viewIdImpl);
        this.performCheck();
        this._down.newView(vRIMemberDescriptionArray, viewIdImpl, map);
    }

    public void newViewOK(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "newViewOK()", "");
            dCSTraceBuffer.addProperty(viewIdImpl);
            dCSTraceBuffer.addProperty("viewMembers", VRIMemberUtils.toString(vRIMemberDescriptionArray));
            dCSTraceBuffer.addProperty("connectedMembers", VRIMemberUtils.toString(this._membersMgr.getConnectedMembers(false)));
            dCSTraceBuffer.invoke();
        }
        this.checkStackLock("newViewOK()");
        if (this._curViewId.getViewNum() != viewIdImpl.getViewNum()) {
            this.focusError("newViewOK()", " new ViewId of newViewOK " + viewIdImpl.toString());
        }
        this.performCheck();
        this._up.newViewOK(vRIMemberDescriptionArray, viewIdImpl, map);
    }

    public void connectMembers(VRIMemberDescription[] vRIMemberDescriptionArray) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "connectMembers()", "");
            dCSTraceBuffer.addProperty(this._curViewId);
            dCSTraceBuffer.addProperty("memberNames", VRIMemberUtils.toString(vRIMemberDescriptionArray));
            dCSTraceBuffer.addProperty("connectedMembers", VRIMemberUtils.toString(this._membersMgr.getConnectedMembers(false)));
            dCSTraceBuffer.invoke();
        }
        this.checkStackLock("connectMembers");
        this.initConnectedScopedVariables(vRIMemberDescriptionArray);
        this.performCheck();
        this._up.connectMembers(vRIMemberDescriptionArray);
    }

    public void suspectMembers(DCSSuspectEvent[] dCSSuspectEventArray) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "suspectMembers()", "");
            dCSTraceBuffer.addProperty(this._curViewId);
            dCSTraceBuffer.addProperty("SuspectedMembers", VRIMemberUtils.toString(VRIMemberUtils.getSuspectedMembersDescription(this._membersMgr, dCSSuspectEventArray, true)));
            dCSTraceBuffer.addProperty("connectedMembers", VRIMemberUtils.toString(this._membersMgr.getConnectedMembers(false)));
            dCSTraceBuffer.invoke();
        }
        this.checkStackLock("suspectMembers()");
        this.initConnectedScopedVariables(null);
        this.performCheck();
        this._up.suspectMembers(dCSSuspectEventArray);
    }

    private void updateLastSentMulticast(int n) {
        MemberData memberData = (MemberData)this._membersData.get(this._thisMember.getName());
        memberData.getQOSInfo(n).updateLastSent();
        int n2 = memberData.getQOSInfo(n).lastSent();
        Iterator iterator = this._membersData.keySet().iterator();
        while (iterator.hasNext()) {
            MemberData memberData2 = (MemberData)this._membersData.get((String)iterator.next());
            if (memberData2.getName().equals(memberData.getName())) continue;
            if (n == 5) {
                if (!memberData2.getIsConnected()) continue;
                memberData2.get_MCAST_CONNECTED_QOSInfo().updateLastSent(n2);
                continue;
            }
            if (!memberData2.getIsInView()) continue;
            memberData2.getQOSInfo(n).updateLastSent(n2);
        }
    }

    public void mcastMessage(VRIMessage vRIMessage, QoS.QOSMulticast qOSMulticast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        this.printMessage("TesterLayer: mcastMessage()");
        this.performCheck();
        this.checkStackLock("mcastMessage()");
        MemberData memberData = (MemberData)this._membersData.get(this._thisMember.getName());
        TUtils.assertMethod(memberData != null, "me==null in mcastMessage", this._traceContext);
        if (qOSMulticast.getChannelType() == QoS.CONNECTED) {
            if (qOSMulticast.isVS()) {
                this.focusError("mcastMessage()", "Can't send VS message in the connected channel");
            }
            short s = 5;
            TesterHeader testerHeader = new TesterHeader(s, this._curViewId, memberData.getQOSInfo(s).nextSent());
            vRIMessage.addHeader(testerHeader);
            this._down.mcastMessage(vRIMessage, qOSMulticast, viewIdImpl);
            memberData.getQOSInfo(s).addNotSelfDelivered(memberData.getQOSInfo(s).nextSent(), qOSMulticast);
            this.updateLastSentMulticast(s);
            return;
        }
        if (qOSMulticast.getChannelType() == QoS.VIEW) {
            if (qOSMulticast.getGuaranteeType() == QoS.VS_CURRENT || qOSMulticast.getGuaranteeType() == QoS.VS_ANY) {
                short s = qOSMulticast.getGuaranteeType() == QoS.VS_CURRENT ? (short)1 : 2;
                int n = 3;
                TesterHeader testerHeader = new TesterHeader(s, this._curViewId, memberData.getQOSInfo(s).nextSent(), memberData.getQOSInfo(n).nextSent());
                vRIMessage.addHeader(testerHeader);
                this._down.mcastMessage(vRIMessage, qOSMulticast, viewIdImpl);
                memberData.getQOSInfo(s).addNotSelfDelivered(memberData.getQOSInfo(s).nextSent(), qOSMulticast);
                memberData.getQOSInfo(n).addNotSelfDelivered(memberData.getQOSInfo(n).nextSent(), qOSMulticast);
                if (qOSMulticast.getGuaranteeType() == QoS.VS_CURRENT) {
                    if (!this._curViewId.equals(viewIdImpl)) {
                        this.focusError("mcastMessage()", "Sending VS_CURRENT msg in the wrong view. msgViewId: " + viewIdImpl + " BUT no DCSInvalidViewIDException was thrown");
                    }
                } else if (viewIdImpl != null) {
                    this.focusError("mcastMessage()", "VS_ANY should be sent with null view");
                }
                this.updateLastSentMulticast(s);
                this.updateLastSentMulticast(n);
                return;
            }
            if (qOSMulticast.getGuaranteeType() == QoS.RELIABLE) {
                short s = 4;
                TesterHeader testerHeader = new TesterHeader(s, this._curViewId, memberData.getQOSInfo(s).nextSent());
                vRIMessage.addHeader(testerHeader);
                this._down.mcastMessage(vRIMessage, qOSMulticast, viewIdImpl);
                memberData.getQOSInfo(s).addNotSelfDelivered(memberData.getQOSInfo(s).nextSent(), qOSMulticast);
                this.updateLastSentMulticast(s);
                return;
            }
        }
        this.focusError("mcastMessage()", "Unrecognized GuaranteeType: " + qOSMulticast.getGuaranteeType() + " or ChannelType: " + qOSMulticast.getChannelType());
        this._down.mcastMessage(vRIMessage, qOSMulticast, viewIdImpl);
    }

    public void mcastMessage(VRIMessage vRIMessage, VRIMemberDescription[] vRIMemberDescriptionArray, QoS.QOSMulticast qOSMulticast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (qOSMulticast.getGuaranteeType() == QoS.RELIABLE) {
            short s = 9;
            TesterHeader testerHeader = new TesterHeader(s, this._curViewId, 0, 0);
            vRIMessage.addHeader(testerHeader);
        } else {
            this.focusError("mcastMessage()", "Only FIFO QoS is allowed in subgroup send");
        }
        this._down.mcastMessage(vRIMessage, vRIMemberDescriptionArray, qOSMulticast, viewIdImpl);
    }

    public void sendMessage(VRIMessage vRIMessage, VRIMemberDescription vRIMemberDescription, QoS.QOSUnicast qOSUnicast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        this.printMessage("TesterLayer: sendMessage()");
        this.performCheck();
        this.checkStackLock("sendMessage()");
        MemberData memberData = (MemberData)this._membersData.get(this._thisMember.getName());
        TUtils.assertMethod(memberData != null, "me==null in sendMessage", this._traceContext);
        MemberData memberData2 = (MemberData)this._membersData.get(vRIMemberDescription.getName());
        if (memberData2 == null) {
            this.focusError("sendMessage()", "sending p2p message of " + qOSUnicast.getChannelType() + qOSUnicast.getGuaranteeType() + " to member " + vRIMemberDescription.getName() + " which is not in TESTER_LAYER membersData set");
            this._down.sendMessage(vRIMessage, vRIMemberDescription, qOSUnicast, viewIdImpl);
            return;
        }
        if (qOSUnicast.getChannelType() == QoS.CONNECTED) {
            this.focusError("sendMessage()", "can't send p2p in the connected channel");
            this._down.sendMessage(vRIMessage, vRIMemberDescription, qOSUnicast, viewIdImpl);
            return;
        }
        if (qOSUnicast.getGuaranteeType() == QoS.VS_CURRENT) {
            if (!vRIMemberDescription.isInView()) {
                this.focusError("sendMessage()", "sending p2p VS_CURRENT message to member " + vRIMemberDescription.getName() + " which is not IsInView member according to membersMgr. " + " msg ViewID" + "=" + viewIdImpl + ", " + "viewMembers" + "=" + VRIMemberUtils.getMemberNames(this._curViewMembers));
            }
            if (!memberData2.getIsInView()) {
                this.focusError("sendMessage()", "sending p2p VS_CURRENT message to member " + vRIMemberDescription.getName() + " which is not IsInView member according to TESTER_LAYER membersData set" + " msg ViewID" + "=" + viewIdImpl + ", " + "viewMembers" + "=" + Utils.toString(TUtils.getMembersSuchAs(this._membersData, 0)));
            }
            short s = 6;
            int n = 8;
            TesterHeader testerHeader = new TesterHeader(s, this._curViewId, memberData2.getQOSInfo(s).nextSent(), memberData2.getQOSInfo(n).nextSent());
            vRIMessage.addHeader(testerHeader);
            this._down.sendMessage(vRIMessage, vRIMemberDescription, qOSUnicast, viewIdImpl);
            if (!this._curViewId.equals(viewIdImpl)) {
                this.focusError("sendMessage()", "Sending VS_CURRENT msg in the wrong view. msgViewId: " + viewIdImpl + " BUT no DCSInvalidViewIDException was thrown");
            }
            memberData2.getQOSInfo(n).updateLastSent();
            memberData2.getQOSInfo(s).updateLastSent();
        } else if (qOSUnicast.getGuaranteeType() == QoS.RELIABLE) {
            short s = 7;
            int n = 8;
            TesterHeader testerHeader = new TesterHeader(s, this._curViewId, memberData2.getQOSInfo(s).nextSent(), memberData2.getQOSInfo(n).nextSent());
            vRIMessage.addHeader(testerHeader);
            this._down.sendMessage(vRIMessage, vRIMemberDescription, qOSUnicast, viewIdImpl);
            memberData2.getQOSInfo(n).updateLastSent();
            memberData2.getQOSInfo(s).updateLastSent();
        } else {
            this.focusError("sendMessage()", "asked to send point to point GuaranteeType: " + qOSUnicast.getGuaranteeType() + " msg");
            this._down.sendMessage(vRIMessage, vRIMemberDescription, qOSUnicast, viewIdImpl);
        }
    }

    public void deliver(VRIMessage vRIMessage) {
        String string;
        this.printMessage("TesterLayer: deliver()");
        this.performCheck();
        this.checkStackLock("deliver()");
        if (!vRIMessage.hasHeader((byte)7)) {
            this.focusError("deliver", "Could not find TesterHeader.");
            this._up.deliver(vRIMessage);
            return;
        }
        TesterHeader testerHeader = (TesterHeader)vRIMessage.extractHeader(new TesterHeader());
        if (testerHeader == null) {
            this.focusError("deliver", "Could not retreive TesterHeader.");
            this._up.deliver(vRIMessage);
            return;
        }
        if (testerHeader.getType() == 9) {
            this._up.deliver(vRIMessage);
            return;
        }
        int n = testerHeader.getChannelCounter();
        int n2 = testerHeader.getTotalChannelCounter();
        ViewIdImpl viewIdImpl = testerHeader.getViewId();
        String string2 = vRIMessage.getSender();
        short s = testerHeader.getType();
        MemberData memberData = (MemberData)this._membersData.get(this._thisMember.getName());
        TUtils.assertMethod(memberData != null, "me==null in deliver", this._traceContext);
        MemberData memberData2 = (MemberData)this._membersData.get(string2);
        if (memberData2 == null) {
            this.focusError("deliver", "Got message from member that is not in membersData DB: senderName " + string2 + "msg ViewID" + "=" + viewIdImpl + ", " + "viewMembers" + "=" + VRIMemberUtils.getMemberNames(this._curViewMembers));
            this._up.deliver(vRIMessage);
            return;
        }
        TUtils.assertMethod(MemberData.QOSInfo.isLegalType(s), "QOSInfo.isLegalType(). type=" + s, this._traceContext);
        MemberData.QOSInfo qOSInfo = memberData2.getQOSInfo(s);
        memberData.advanceNotSelfDelivered(s, n, memberData2, this._curViewId);
        boolean bl = qOSInfo.checkFIFO(n);
        if (!bl) {
            string = "deliver 1: Unconsecutive " + MemberData.QOSInfo.QOS_TYPE_NAMES[s] + " message from " + string2 + " : previous id = " + qOSInfo.lastReceived() + " curr id = " + n;
            string = string + (viewIdImpl != null ? " msg was sent in view " + viewIdImpl.toString() : "");
            this.focusError("deliver()", string);
        }
        qOSInfo.setLastR(n);
        switch (s) {
            case 1: 
            case 6: {
                if (!this._curViewId.equals(viewIdImpl)) {
                    string = "deliver 2: got " + MemberData.QOSInfo.QOS_TYPE_NAMES[s] + " msg in wrong view from " + string2 + " : previous id = " + qOSInfo.lastReceived() + " curr id = " + n;
                    string = string + (viewIdImpl != null ? " msg was sent in view " + viewIdImpl.toString() : "");
                    this.focusError("deliver()", string);
                }
            }
            case 2: 
            case 7: {
                int n3 = MemberData.QOSInfo.getMatchingTotalType(s);
                MemberData.QOSInfo qOSInfo2 = memberData2.getQOSInfo(n3);
                memberData.advanceNotSelfDelivered(s, n3, memberData2, this._curViewId);
                bl = qOSInfo2.checkFIFO(n2);
                if (!bl) {
                    String string3 = "deliver 3: Unconsecutive " + MemberData.QOSInfo.QOS_TYPE_NAMES[s] + " message from " + string2 + " : previous id = " + qOSInfo2.lastReceived() + " curr id = " + n2;
                    string3 = string3 + (viewIdImpl != null ? " msg was sent in view " + viewIdImpl.toString() : "");
                    this.focusError("deliver()", string3);
                }
                qOSInfo2.setLastR(n2);
                break;
            }
        }
        this._up.deliver(vRIMessage);
    }

    boolean checkStackLock(String string) {
        if (!Thread.holdsLock(this._globals.getMutex())) {
            this.focusError("checkStackLock()", "No stack mutex hold in " + string + " function.");
            Exception exception = new Exception("No stack mutex hold in " + string + " function.");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void terminate(boolean bl, DCSTerminationEvent dCSTerminationEvent) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "terminate()", "");
            dCSTraceBuffer.addProperty(this._curViewId);
            dCSTraceBuffer.invoke();
        }
        this.checkStackLock("terminate()");
        this._state = 4;
        this._lct.terminate();
        this._down.terminate(bl, dCSTerminationEvent);
    }

    public void dumpAll(FFDCDumper fFDCDumper) {
        this.checkStackLock("dump()");
        this._down.dumpAll(fFDCDumper);
    }

    public Object getMutex() {
        return this._globals.getMutex();
    }

    public void syncCurrent() {
        this.checkStackLock("syncCurrent()");
        this._down.syncCurrent();
    }

    public VRICheckFailedException check() {
        this.checkStackLock("check()");
        this._lastCheckTime = System.currentTimeMillis();
        this.performCheck();
        MemberData memberData = (MemberData)this._membersData.get(this._thisMember.getName());
        memberData.check();
        return this._up.check();
    }

    private void performCheck() {
        String[] stringArray = VRIMemberUtils.getMemberNames(this._curViewMembers);
        String[] stringArray2 = VRIMemberUtils.getMemberNames(this._connectedMembers);
        TLViewData tLViewData = new TLViewData(this._thisMember.getName(), this._thisStackName, this._curViewId, stringArray, this._curViewId, stringArray, stringArray2, this._membersData);
        tLViewData.checkMyself(this._traceContext);
        TUtils.assertMethod(VRIMemberUtils.equals(this._connectedMembers, this._membersMgr.getConnectedMembers(false)), "VRIMemberUtils.equals( _connectedMembers, _membersMgr.getConnectedMembers(false) )", this._traceContext);
        MemberData memberData = (MemberData)this._membersData.get(this._thisMember.getName());
        memberData.checkNotSelfDelivered(this._curViewId);
    }

    public void requestTermination(DCSTerminationEvent dCSTerminationEvent) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "requestTermination()", "");
            dCSTraceBuffer.addProperty(this._curViewId);
            dCSTraceBuffer.invoke();
        }
        this.checkStackLock("requestTermination()");
        this._up.requestTermination(dCSTerminationEvent);
    }

    public void proposeAgreement(VRIMessage vRIMessage) {
        this.checkStackLock("proposeAgreement()");
        this._up.proposeAgreement(vRIMessage);
    }

    public void deliverAgreed(VRIMessage vRIMessage) {
        this.checkStackLock("deliverAgreed()");
        this._up.deliverAgreed(vRIMessage);
    }

    public void setDownLayer(Downcalls downcalls) {
        this._down = downcalls;
    }

    public void setUpperLayer(Upcalls upcalls) {
        this._up = upcalls;
    }

    public void unblock() throws DCSAssertException {
        this.checkStackLock("unblock()");
        this._down.unblock();
    }

    public void updateBehavor(Map map) throws DCSAssertException {
        this.checkStackLock("updateBehavor()");
        this._down.updateBehavor(map);
    }

    public void completeCurrent(VRIMemberDescription[] vRIMemberDescriptionArray, CCVersion cCVersion) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "completeCurrent()", "");
            dCSTraceBuffer.addProperty(cCVersion);
            dCSTraceBuffer.addProperty("failedMembers", VRIMemberUtils.toString(vRIMemberDescriptionArray));
            dCSTraceBuffer.invoke();
        }
        this.checkStackLock("completeCurrent()");
        this.performCheck();
        this._state = 3;
        if (this._ccv == null) {
            this._ccv = new CCVersion(cCVersion);
        } else if (this._ccv.compareTo(cCVersion) != -1) {
            this.focusError("completeCurrent()", "current _ccv " + this._ccv.toString() + "  ccv of completeCurrent" + cCVersion.toString());
        }
        this._ccv = new CCVersion(cCVersion);
        this._down.completeCurrent(vRIMemberDescriptionArray, cCVersion);
    }

    public void currentOK(CCVersion cCVersion) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "currentOK()", "");
            dCSTraceBuffer.addProperty(cCVersion);
            dCSTraceBuffer.invoke();
        }
        this.checkStackLock("currentOK");
        this.performCheck();
        if (this._ccv.compareTo(cCVersion) != 0) {
            this.focusError("currentOK", "current _ccv " + this._ccv.toString() + "  ccv of currentOK" + cCVersion.toString());
        }
        this._up.currentOK(cCVersion);
    }

    public void changeDefinedMembers(String[] stringArray, String[] stringArray2) throws AddDefinedFailedException {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "changeDefinedMembers()", "ENTRY");
            dCSTraceBuffer.addProperty(this._curViewId);
            dCSTraceBuffer.addProperty("AddedMembers", Utils.toString(stringArray));
            dCSTraceBuffer.addProperty("RemovedMembers", Utils.toString(stringArray2));
            dCSTraceBuffer.addProperty("Before", "definedMembers", VRIMemberUtils.toString(this._membersMgr.getDefinedMembers(true)));
            dCSTraceBuffer.invoke();
        }
        this.checkStackLock("changeDefinedMembers()");
        try {
            this._down.changeDefinedMembers(stringArray, stringArray2);
        }
        catch (AddDefinedFailedException addDefinedFailedException) {
            this.focusError("changeDefinedMembers()", "Events: " + Utils.toString(addDefinedFailedException.getEvents()) + "." + "failedMembers" + "=" + Utils.toString(addDefinedFailedException.getFailedMembers()) + " " + DCSTraceBuffer.throwableToString(addDefinedFailedException));
            throw addDefinedFailedException;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "changeDefinedMembers()", "EXIT");
            dCSTraceBuffer.addProperty(this._curViewId);
            dCSTraceBuffer.addProperty("After", "definedMembers", VRIMemberUtils.toString(this._membersMgr.getDefinedMembers(true)));
            dCSTraceBuffer.invoke();
        }
        this.initConnectedScopedVariables(null);
        this.performCheck();
    }

    public void onVRIDownEvent(VRIDownEvent vRIDownEvent) {
        vRIDownEvent.handle(LAYER_NAME, this._eventHandlers, this._down);
    }

    public void onVRIUpEvent(VRIUpEvent vRIUpEvent) {
        vRIUpEvent.handle(LAYER_NAME, this._eventHandlers, this._up);
    }

    private class LivenessCheckThread
    extends Thread {
        private volatile boolean _terminated;

        LivenessCheckThread(String string) {
            super(string + ".LivenessCheckThread");
            this._terminated = false;
        }

        public synchronized void terminate() {
            this._terminated = true;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = TesterLayer.this._checkTime + 15000L;
            long l2 = TesterLayer.this._checkTime;
            long l3 = System.currentTimeMillis();
            while (!this._terminated) {
                try {
                    Object object;
                    long l4 = System.currentTimeMillis();
                    long l5 = TesterLayer.this._lastCheckTime;
                    if (l4 - l5 > l) {
                        object = new StringBuffer("ERROR:   ").append(TesterLayer.this._thisMember.getName()).append(".").append(TesterLayer.this._thisStackName).append("  looks dead. Last stack check time is: ").append(TUtils.formatter.format(new Date(l5))).append("Last liveness check time is: ").append(Globals.formatter.format(new Date(l3))).append("   Current time is: ").append(Globals.formatter.format(new Date(l4))).append("  ");
                        l *= 2L;
                        if (ThreadDumper.available()) {
                            ((StringBuffer)object).append("Performing thread dump");
                            ThreadDumper.dumpAllThreads();
                        } else {
                            ((StringBuffer)object).append("ThreadDumper is not available");
                        }
                        String string = ((StringBuffer)object).toString();
                        System.err.println(string);
                        if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(TesterLayer.this._traceContext, string, "LivenessCheckThread.run", null);
                            dCSTraceBuffer.invoke();
                        }
                    } else {
                        l = TesterLayer.this._checkTime + 15000L;
                    }
                    l3 = l4;
                    object = this;
                    synchronized (object) {
                        if (!this._terminated) {
                            this.wait(l2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (this._terminated) continue;
                    throwable.printStackTrace();
                }
            }
        }
    }
}

