/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter;

import com.ibm.ws.dcs.vri.common.Job;
import com.ibm.ws.dcs.vri.common.JobsProcessorThread;
import com.ibm.ws.dcs.vri.common.ThreadManager;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.transportAdapter.SelfDeliveryThreadListener;
import com.ibm.ws.dcs.vri.transportAdapter.TransportAdapter;
import com.ibm.ws.dcs.vri.transportAdapter.TransportInternalException;

public class SelfDeliveryThread {
    private boolean _terminate;
    private String _name;
    private JobsProcessorThread _thread;
    private SelfDeliveryThreadListener _listener;

    public SelfDeliveryThread(String string, SelfDeliveryThreadListener selfDeliveryThreadListener) {
        this._name = string;
        this._listener = selfDeliveryThreadListener;
        this._terminate = false;
        this._thread = ThreadManager.getThread(this._name, ThreadManager.INTERNAL_THREAD, 5);
        if (this._thread == null) {
            throw new TransportInternalException("SelfDeliveryThread.SelfDeliveryThread: " + string + ": Failed to create thread");
        }
    }

    void submitSelfMessage(VRIMessage vRIMessage) {
        if (!this._terminate) {
            this._thread.enqueueJob(new SelfMsg(vRIMessage));
        }
    }

    void submitNVOKJob(TransportAdapter.TANewViewOKJob tANewViewOKJob) {
        if (this._terminate) {
            return;
        }
        tANewViewOKJob.setOwner(this._name);
        this._thread.enqueueJob(tANewViewOKJob);
    }

    public void terminate() {
        ThreadManager.releaseThread(this._name);
        this._terminate = true;
    }

    String dump() {
        return "";
    }

    protected final class SelfMsg
    implements Job {
        VRIMessage _msg;

        private SelfMsg(VRIMessage vRIMessage) {
            this._msg = vRIMessage;
        }

        public void process() {
            SelfDeliveryThread.this._listener.deliverSelfMsg(this._msg);
            this._msg = null;
        }

        public void cancel() {
        }

        public void handleError(Throwable throwable) {
            SelfDeliveryThread.this._listener.requestTermination(throwable, "SelfMsg.handleError()");
        }

        public String getOwner() {
            return SelfDeliveryThread.this._name;
        }
    }
}

