/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSAssertException;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSIllegalParameterException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSInvalidQoSException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsDeniedException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsNotInViewException;
import com.ibm.ws.dcs.common.exception.DCSMessageCorruptedException;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.utils.Alarm;
import com.ibm.ws.dcs.utils.AlarmListener;
import com.ibm.ws.dcs.utils.AlarmManager;
import com.ibm.ws.dcs.vri.common.AddDefinedFailedException;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.Downcalls;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.Job;
import com.ibm.ws.dcs.vri.common.LayerLinkage;
import com.ibm.ws.dcs.vri.common.MetaMessageFactory;
import com.ibm.ws.dcs.vri.common.Upcalls;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRICheckFailedException;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.event.CongestionControlEvent;
import com.ibm.ws.dcs.vri.common.event.VRIDownEvent;
import com.ibm.ws.dcs.vri.common.event.VRINotifyUpEvent;
import com.ibm.ws.dcs.vri.common.event.VRIUpEvent;
import com.ibm.ws.dcs.vri.common.impl.BaseVRIMessageFactory;
import com.ibm.ws.dcs.vri.common.impl.SubgroupMcastHeader;
import com.ibm.ws.dcs.vri.common.nls.AbstractNLSEvent;
import com.ibm.ws.dcs.vri.common.nls.ConnectedMemberEvent;
import com.ibm.ws.dcs.vri.common.nls.RcvBadMemberEvent;
import com.ibm.ws.dcs.vri.common.nls.RcvNonDefinedMemberEvent;
import com.ibm.ws.dcs.vri.common.nls.TAConnectionClosingEvent;
import com.ibm.ws.dcs.vri.common.nls.TASuspectNewViewFailed;
import com.ibm.ws.dcs.vri.common.nls.TASuspectViewMemberDenied;
import com.ibm.ws.dcs.vri.common.nls.TASuspectViewMemberNotConnected;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.FFDCDumpable;
import com.ibm.ws.dcs.vri.common.util.FFDCDumper;
import com.ibm.ws.dcs.vri.transportAdapter.ConnectedChannel;
import com.ibm.ws.dcs.vri.transportAdapter.ConnectedChannelListener;
import com.ibm.ws.dcs.vri.transportAdapter.SelfDeliveryThread;
import com.ibm.ws.dcs.vri.transportAdapter.SelfDeliveryThreadListener;
import com.ibm.ws.dcs.vri.transportAdapter.TransportDenialReason;
import com.ibm.ws.dcs.vri.transportAdapter.TransportInternalException;
import com.ibm.ws.dcs.vri.transportAdapter.TransportNode;
import com.ibm.ws.dcs.vri.transportAdapter.ViewChannel;
import com.ibm.ws.dcs.vri.transportAdapter.ViewChannelListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RMMHeader;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.RmmAdapter;
import java.net.UnknownHostException;
import java.util.AbstractSequentialList;
import java.util.LinkedList;
import java.util.Map;

public abstract class TransportAdapter
implements Downcalls,
ViewChannelListener,
ConnectedChannelListener,
AlarmListener,
LayerLinkage,
SelfDeliveryThreadListener,
DCSTraceContext,
FFDCDumpable {
    private LinkedList _futureViewSuspectMsgs;
    private ViewIdImpl _curViewId;
    private static final TraceComponent TC = Tr.register(TransportAdapter.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private static final byte VIEW_SUSPECT_MSG = 2;
    private TANewViewOKJob _nvOKJob = null;
    protected String _thisStackName;
    protected String _thisMemberName;
    protected boolean _terminated;
    protected VRIMemberDescription _thisMember;
    protected Upcalls _up;
    protected ConnectedChannel _conChannel;
    protected ViewChannel _viewChannel;
    protected VRIMembersMGR _mmgr;
    protected Alarm _checkAlarm;
    protected Object _stackMutex;
    protected String _rmmVersion;
    public static final String TA_LAYER_NAME = DCSConstants.TRACE_LAYER_NAMES[1];
    protected final Object CHECK_ALARM_CONTEXT = new Object();
    protected SelfDeliveryThread _selfDeliveryThread;
    protected Globals _g;
    private final long _checkTime;
    protected final long COMPLETE_CURRENT_TIMEOUT;
    private final MetaMessageFactory _msgFactory;

    public static TransportAdapter getInstance(Globals globals) throws UnknownHostException {
        return RmmAdapter.getInstance(globals);
    }

    protected TransportAdapter(Globals globals) {
        this._g = globals;
        this._mmgr = globals.getVRIMembersMgr();
        this._thisStackName = this._mmgr.getThisStackName();
        this._thisMember = this._mmgr.getThisMember();
        this._thisMemberName = this._thisMember.getName();
        this._terminated = false;
        this._stackMutex = this._g.getMutex();
        this.COMPLETE_CURRENT_TIMEOUT = this._g.getConfigParamAsInt("TA_CC_TIMEOUT_SEC");
        this.focus("TA ctor");
        this._msgFactory = this._g.getMetaMessageFactory();
        this._futureViewSuspectMsgs = new LinkedList();
        this._checkTime = this._g.getConfigParamAsInt("DCS_CHECK_TIME_SEC") * 1000;
        this._selfDeliveryThread = new SelfDeliveryThread(this._mmgr.getThisStackName() + ":" + "Self Delivery", this);
    }

    public void changeDefinedMembers(String[] stringArray, String[] stringArray2) throws AddDefinedFailedException {
        VRIMemberDescription vRIMemberDescription;
        String string;
        int n;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("AddedMembers", stringArray);
        dCSTraceBuffer.addProperty("RemovedMembers", stringArray2);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.entry(this, "TransportAdapter.changeDefinedMembers()", null);
            dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer2.invoke();
        }
        this.focus("ChangeDefinedMembers", dCSTraceBuffer);
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        for (n = 0; n < stringArray2.length; ++n) {
            string = stringArray2[n];
            vRIMemberDescription = this._mmgr.getDefinedMember(string);
            if (vRIMemberDescription == null) continue;
            this._conChannel.removeDefinedMember(vRIMemberDescription);
        }
        this._mmgr.removeDefinedMembers((byte)1, stringArray2);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (n = 0; n < stringArray.length; ++n) {
            DCSTraceBuffer dCSTraceBuffer3;
            string = stringArray[n];
            vRIMemberDescription = this._mmgr.getDefinedMember(string);
            if (vRIMemberDescription == null) {
                if (!DCSTraceBuffer.isInternalWarningEnabled(TC)) continue;
                dCSTraceBuffer3 = DCSTraceBuffer.internalWarning(this, "Failed to add member becuase its member description is not available", "TransportAdapter.changeDefinedMembers()", null);
                dCSTraceBuffer3.addProperty("memberName", string);
                dCSTraceBuffer3.invoke();
                continue;
            }
            if (string.equals(this._thisMemberName)) {
                if (!DCSTraceBuffer.isInternalWarningEnabled(TC)) continue;
                dCSTraceBuffer3 = DCSTraceBuffer.internalWarning(this, "Ignore request to add this member", "TransportAdapter.changeDefinedMembers()", null);
                dCSTraceBuffer3.invoke();
                continue;
            }
            this._conChannel.addDefinedMember(vRIMemberDescription);
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer4 = DCSTraceBuffer.exit(this, "TransportAdapter.changeDefinedMembers()", null);
            dCSTraceBuffer4.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer4.invoke();
        }
    }

    public void completeCurrent(VRIMemberDescription[] vRIMemberDescriptionArray, CCVersion cCVersion) {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("failedMembers", Utils.toString(vRIMemberDescriptionArray));
        dCSTraceBuffer.addProperty(cCVersion);
        this.focus("completeCurrent", dCSTraceBuffer);
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            VRIMemberDescription vRIMemberDescription = vRIMemberDescriptionArray[i];
            this.denyMemberFromView(vRIMemberDescription, 1);
        }
        this._viewChannel.completeCurrent(cCVersion, this.COMPLETE_CURRENT_TIMEOUT);
    }

    private boolean denyMemberFromView(VRIMemberDescription vRIMemberDescription, int n) {
        block6: {
            Object object;
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty("memberName", vRIMemberDescription.getName());
            dCSTraceBuffer.addProperty("ViewID", this._curViewId);
            if (DCSTraceBuffer.isEntryEnabled(TC)) {
                object = DCSTraceBuffer.entry(this, "TransportAdapter.denyMemberFromView()", null);
                ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
                ((DCSTraceBuffer)object).invoke();
            }
            if (!vRIMemberDescription.isInView() || vRIMemberDescription.isDenied((byte)1)) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    object = DCSTraceBuffer.event(this, "TransportAdapter.denyMemberFromView()", "Member should not be denied");
                    ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
                    ((DCSTraceBuffer)object).addProperty("IsDeniedMember", vRIMemberDescription.isDenied((byte)1));
                    ((DCSTraceBuffer)object).addProperty("IsViewMember", vRIMemberDescription.isInView());
                    ((DCSTraceBuffer)object).invoke();
                }
                return false;
            }
            this._viewChannel.removeMember(vRIMemberDescription);
            this._mmgr.denyMember(vRIMemberDescription.getName(), new TransportDenialReason(n));
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this, "TransportAdapter.denyMemberFromView()", "Going to send view suspect message");
                ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
                ((DCSTraceBuffer)object).invoke();
            }
            try {
                object = this.createViewSuspectMsg(this._curViewId, vRIMemberDescription);
                this._conChannel.sendViewSuspectMsg((VRIMessage)object, vRIMemberDescription);
            }
            catch (Throwable throwable) {
                if (!DCSTraceBuffer.isInternalWarningEnabled(TC)) break block6;
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.internalWarning(this, "Failed to send view suspect message", "TransportAdapter.denyMemberFromView()", throwable);
                dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer2.invoke();
            }
        }
        return true;
    }

    private VRIMessage createViewSuspectMsg(ViewIdImpl viewIdImpl, VRIMemberDescription vRIMemberDescription) {
        RMMHeader rMMHeader = new RMMHeader(this._mmgr, viewIdImpl, new VRIMemberDescription[]{vRIMemberDescription});
        VRIMessage vRIMessage = BaseVRIMessageFactory.getInstance(this._g).getMessage((byte)2, (byte)1, this._thisMember.getName());
        vRIMessage.addHeader(rMMHeader);
        return vRIMessage;
    }

    public void dump() {
    }

    public void dumpAll(FFDCDumper fFDCDumper) {
        String string = "\n*************** TransportAdapter::dump *******************\n";
        string = string + "\n Members manager: \n" + this._mmgr.dump();
        string = string + "\n Connected channel: \n" + this._conChannel.dump();
        string = string + "\n View channel: \n" + this._viewChannel.dump();
        fFDCDumper.writeLine(string);
    }

    public Object getMutex() {
        return this._g.getMutex();
    }

    public final void mcastMessage(VRIMessage vRIMessage, QoS.QOSMulticast qOSMulticast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (this._terminated) {
            return;
        }
        if (this._g.statsModule != null) {
            this._g.statsModule.onMsgSent(vRIMessage.getLength());
        }
        int n = vRIMessage.prepareBuffer();
        byte[] byArray = vRIMessage.getDataBuffer();
        if (qOSMulticast.isSelfDelivered()) {
            VRIMessage vRIMessage2 = null;
            try {
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                vRIMessage2 = this._msgFactory.getMessage(this._thisMemberName, byArray2, 0, n);
            }
            catch (DCSMessageCorruptedException dCSMessageCorruptedException) {
                this.requestTermination(dCSMessageCorruptedException, "mcastMessage");
                return;
            }
            this._selfDeliveryThread.submitSelfMessage(vRIMessage2);
        }
        boolean bl = false;
        bl = qOSMulticast.getChannelType() == QoS.VIEW ? this._viewChannel.mcastMessage(byArray, 0, n) : this._conChannel.mcastMessage(byArray, 0, n);
        if (!bl) {
            throw new DCSTransportLayerException("TransportAdapter.mcastMessage:" + this._thisStackName + ":failed to mcast message");
        }
    }

    public void requestTermination(DCSTerminationEvent dCSTerminationEvent) {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("Reason", dCSTerminationEvent);
        this.focus("callRequestTermination", dCSTraceBuffer);
        AlarmManager.create(AlarmManager.GENERAL_ALARM, 1L, this._stackMutex, this, dCSTerminationEvent);
    }

    public final void newView(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        Object object;
        VRIMemberDescription[] vRIMemberDescriptionArray2;
        Object object2;
        Object object3;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("viewMembers", Utils.toString(vRIMemberDescriptionArray));
        dCSTraceBuffer.addProperty(viewIdImpl);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object3 = DCSTraceBuffer.entry(this, "TransportAdapter.newView()", null);
            ((DCSTraceBuffer)object3).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object3).invoke();
        }
        this.focus("newView", "Method start", dCSTraceBuffer);
        if (map != null) {
            this._nvOKJob = new TANewViewOKJob(this, viewIdImpl, map);
            this._selfDeliveryThread.submitNVOKJob(this._nvOKJob);
        }
        this._curViewId = viewIdImpl;
        this._mmgr.unDenyAll((byte)1, null, true);
        object3 = new LinkedList();
        Object[] objectArray = this._mmgr.getDeniedMembers((byte)1, true);
        if (objectArray != null && objectArray.length != 0) {
            object2 = DCSTraceBuffer.propertyList();
            ((DCSTraceBuffer)object2).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object2).addProperty("failedMembers", Utils.toString(objectArray));
            this.focus("newView", "Caught prviously View Denied members", (DCSTraceBuffer)object2);
            for (int i = 0; i < objectArray.length; ++i) {
                vRIMemberDescriptionArray2 = new TASuspectViewMemberDenied((DCSTraceContext)this, objectArray[i].getName(), viewIdImpl);
                ((LinkedList)object3).addLast(vRIMemberDescriptionArray2);
            }
        }
        object2 = objectArray;
        Object[] objectArray2 = VRIMemberUtils.minus(vRIMemberDescriptionArray, this._mmgr.getConnectedMembers(true));
        if (objectArray2 != null && objectArray2.length != 0) {
            vRIMemberDescriptionArray2 = DCSTraceBuffer.propertyList();
            vRIMemberDescriptionArray2.mergePropertyList(dCSTraceBuffer);
            vRIMemberDescriptionArray2.addProperty("failedMembers", Utils.toString(objectArray2));
            this.focus("newView", "Caught View Not connected members", (DCSTraceBuffer)vRIMemberDescriptionArray2);
            for (int i = 0; i < objectArray2.length; ++i) {
                if (VRIMemberUtils.contains((VRIMemberDescription[])objectArray, (VRIMemberDescription)objectArray2[i])) continue;
                TASuspectViewMemberNotConnected tASuspectViewMemberNotConnected = new TASuspectViewMemberNotConnected((DCSTraceContext)this, objectArray2[i].getName(), viewIdImpl);
                ((LinkedList)object3).addLast(tASuspectViewMemberNotConnected);
            }
        }
        this._mmgr.denyMembers((VRIMemberDescription[])objectArray2, new TransportDenialReason(3));
        object2 = VRIMemberUtils.unification((VRIMemberDescription[])object2, (VRIMemberDescription[])objectArray2);
        vRIMemberDescriptionArray2 = VRIMemberUtils.minus(vRIMemberDescriptionArray, (VRIMemberDescription[])object2);
        VRIMemberDescription[] vRIMemberDescriptionArray3 = this._viewChannel.newView(vRIMemberDescriptionArray2, viewIdImpl, map);
        for (int i = 0; i < vRIMemberDescriptionArray3.length; ++i) {
            this.denyMemberFromView(vRIMemberDescriptionArray3[i], 2);
            object = new TASuspectNewViewFailed((DCSTraceContext)this, vRIMemberDescriptionArray3[i].getName(), viewIdImpl);
            ((LinkedList)object3).addLast(object);
        }
        object2 = VRIMemberUtils.unification((VRIMemberDescription[])object2, vRIMemberDescriptionArray3);
        vRIMemberDescriptionArray2 = VRIMemberUtils.minus(vRIMemberDescriptionArray, (VRIMemberDescription[])object2);
        if (((Object)object2).length != ((LinkedList)object3).size()) {
            throw new TransportInternalException("TransportAdapter.newView: Failing new view members are " + Utils.toString((Object[])object2) + ", suspect events are " + object3);
        }
        if (((Object)object2).length != 0) {
            DCSSuspectEvent[] dCSSuspectEventArray = new DCSSuspectEvent[((LinkedList)object3).size()];
            object = ((AbstractSequentialList)object3).iterator();
            int n = 0;
            while (object.hasNext()) {
                dCSSuspectEventArray[n] = (DCSSuspectEvent)object.next();
                dCSSuspectEventArray[n].invokeNLSTrace();
                ++n;
            }
            this._up.suspectMembers(dCSSuspectEventArray);
        }
        if (map == null) {
            this._up.newViewOK(vRIMemberDescriptionArray2, viewIdImpl, map);
        }
        int n = this._futureViewSuspectMsgs.size();
        for (int i = 0; i < n; ++i) {
            VRIMessage vRIMessage = (VRIMessage)this._futureViewSuspectMsgs.removeFirst();
            this.handleViewSuspectMsg(vRIMessage);
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "TransportAdapter.newView()", null);
            dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer2.invoke();
        }
    }

    public final void sendMessage(VRIMessage vRIMessage, VRIMemberDescription vRIMemberDescription, QoS.QOSUnicast qOSUnicast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (this._terminated) {
            return;
        }
        if (this._g.statsModule != null) {
            this._g.statsModule.onMsgSent(vRIMessage.getLength());
        }
        int n = vRIMessage.prepareBuffer();
        byte[] byArray = vRIMessage.getDataBuffer();
        if (vRIMemberDescription.equals(this._thisMember)) {
            VRIMessage vRIMessage2 = null;
            try {
                vRIMessage2 = this._msgFactory.getMessage(this._thisMemberName, byArray, 0, n);
            }
            catch (DCSMessageCorruptedException dCSMessageCorruptedException) {
                this.requestTermination(dCSMessageCorruptedException, "sendMessage");
                return;
            }
            this._selfDeliveryThread.submitSelfMessage(vRIMessage2);
            return;
        }
        if (vRIMemberDescription.isDenied((byte)1)) {
            throw new DCSMemberIsDeniedException(vRIMemberDescription.getName(), VRIMemberUtils.getMemberNames(this._mmgr.getViewMinusDenied((byte)1)));
        }
        if (!vRIMemberDescription.isInView()) {
            throw new DCSMemberIsNotInViewException(vRIMemberDescription.getName(), VRIMemberUtils.getMemberNames(this._mmgr.getViewMinusDenied((byte)1)));
        }
        boolean bl = this._viewChannel.sendMessage(byArray, 0, n, vRIMemberDescription);
        if (!bl) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "sendMessage", "Send message failed");
                dCSTraceBuffer.addProperty("memberName", vRIMemberDescription.getName());
                dCSTraceBuffer.invoke();
            }
            throw new DCSTransportLayerException("TransportAdapter.sendMessage:" + this._thisStackName + ":failed to send message to " + vRIMemberDescription.getName());
        }
    }

    protected void filterTargets(byte[] byArray, int n, VRIMemberDescription[] vRIMemberDescriptionArray, boolean bl) {
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            if (vRIMemberDescriptionArray[i].getName().equals(this._thisMemberName)) {
                VRIMessage vRIMessage = null;
                try {
                    vRIMessage = this._msgFactory.getMessage(this._thisMemberName, byArray, 0, n);
                }
                catch (DCSMessageCorruptedException dCSMessageCorruptedException) {
                    this.requestTermination(dCSMessageCorruptedException, "selfDeliveryFailed");
                    return;
                }
                this._selfDeliveryThread.submitSelfMessage(vRIMessage);
                vRIMemberDescriptionArray[i] = null;
                continue;
            }
            if (!bl || !vRIMemberDescriptionArray[i].isDenied((byte)1)) continue;
            this.focus("Group send: got a denied member as a target");
            vRIMemberDescriptionArray[i] = null;
        }
    }

    public void start(ViewIdImpl viewIdImpl) {
        VRIMemberDescription[] vRIMemberDescriptionArray;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty(viewIdImpl);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            vRIMemberDescriptionArray = DCSTraceBuffer.entry(this, "TransportAdapter.start()", null);
            vRIMemberDescriptionArray.mergePropertyList(dCSTraceBuffer);
            vRIMemberDescriptionArray.invoke();
        }
        this.focus("start", dCSTraceBuffer);
        this._curViewId = viewIdImpl;
        vRIMemberDescriptionArray = VRIMemberUtils.minus(this._mmgr.getDefinedMembers(true), this._thisMember);
        this._conChannel.start(vRIMemberDescriptionArray);
        this._viewChannel.newView(new VRIMemberDescription[]{this._thisMember}, viewIdImpl, null);
        this.setCheckTimer();
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "TransportAdapter.start()", null);
            dCSTraceBuffer2.invoke();
        }
    }

    public void syncCurrent() throws DCSAssertException {
    }

    public void terminate(boolean bl, DCSTerminationEvent dCSTerminationEvent) {
        DCSTraceBuffer dCSTraceBuffer;
        DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.propertyList();
        dCSTraceBuffer2.addProperty("Reason", dCSTerminationEvent);
        dCSTraceBuffer2.addProperty("Graceful", bl);
        dCSTraceBuffer2.addProperty("Flag", this._terminated);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "TransportAdapter.terminate()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
        this.focus("terminate", dCSTraceBuffer2);
        if (this._terminated) {
            return;
        }
        this._terminated = true;
        if (this._checkAlarm != null) {
            this._checkAlarm.cancel();
        }
        this._selfDeliveryThread.terminate();
        this._viewChannel.close();
        this._conChannel.close();
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "TransportAdapter.terminate()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
    }

    public void unblock() throws DCSAssertException {
    }

    public void updateBehavor(Map map) throws DCSAssertException {
    }

    public final void deliver(VRIMessage vRIMessage) {
        this.deliver(vRIMessage, false);
    }

    public final void deliver(VRIMessage vRIMessage, boolean bl) {
        if (!this._terminated) {
            if (this._nvOKJob != null && this._nvOKJob.addMessage(vRIMessage, bl)) {
                return;
            }
            this.deliverUp(vRIMessage);
        }
    }

    private void deliverUp(VRIMessage vRIMessage) {
        SubgroupMcastHeader subgroupMcastHeader;
        if (this._g.statsModule != null) {
            this._g.statsModule.onMsgReceived(vRIMessage.getLength());
        }
        if (vRIMessage.getOriginatorLayer() == 1) {
            if (vRIMessage.getMessageType() == 2) {
                this.handleViewSuspectMsg(vRIMessage);
            } else if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Ignore TA unknown (future version?) message", "TransportAdapter.deliver()", null);
                dCSTraceBuffer.addProperty("TypeCode", vRIMessage.getMessageType());
                dCSTraceBuffer.invoke();
            }
            return;
        }
        if (vRIMessage.hasHeader((byte)1) && vRIMessage.extractHeader(subgroupMcastHeader = new SubgroupMcastHeader()) != null && !subgroupMcastHeader.isInTargets(this._thisMemberName)) {
            return;
        }
        this._up.deliver(vRIMessage);
    }

    private void handleViewSuspectMsg(VRIMessage vRIMessage) {
        try {
            Object object;
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty("Sender", vRIMessage.getSender());
            dCSTraceBuffer.addProperty("ViewID", this._curViewId);
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this, "TransportAdapter.handleViewSuspectMsg()", "Start");
                ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
                ((DCSTraceBuffer)object).invoke();
            }
            if ((object = this._mmgr.getDefinedMember(vRIMessage.getSender())) == null) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this, "TransportAdapter.handleViewSuspectMsg()", "Sender has null member description");
                    dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                    dCSTraceBuffer2.invoke();
                }
                return;
            }
            RMMHeader rMMHeader = (RMMHeader)vRIMessage.getHeader(new RMMHeader(this._mmgr));
            if (rMMHeader == null) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.internalWarning(this, "Null header", "TransportAdapter.handleViewSuspectMsg()", null);
                    dCSTraceBuffer3.mergePropertyList(dCSTraceBuffer);
                    dCSTraceBuffer3.invoke();
                }
                return;
            }
            Object[] objectArray = rMMHeader.getNewViewMembers();
            if (objectArray == null || objectArray.length != 1) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer4 = DCSTraceBuffer.internalWarning(this, "Illegal suspect members", "TransportAdapter.handleViewSuspectMsg()", null);
                    dCSTraceBuffer4.mergePropertyList(dCSTraceBuffer);
                    dCSTraceBuffer4.addProperty("memberNames", Utils.toString(objectArray));
                    dCSTraceBuffer4.invoke();
                }
                return;
            }
            String string = objectArray[0].getName();
            dCSTraceBuffer.addProperty("Target", string);
            if (!string.equals(this._thisMemberName)) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer5 = DCSTraceBuffer.event(this, "TransportAdapter.handleViewSuspectMsg()", "Ignore suspect msg not for me");
                    dCSTraceBuffer5.mergePropertyList(dCSTraceBuffer);
                    dCSTraceBuffer5.invoke();
                }
                return;
            }
            ViewIdImpl viewIdImpl = rMMHeader.getNewViewId();
            if (viewIdImpl == null) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer6 = DCSTraceBuffer.internalWarning(this, "Received null view id", "TransportAdapter.handleViewSuspectMsg()", null);
                    dCSTraceBuffer6.mergePropertyList(dCSTraceBuffer);
                    dCSTraceBuffer6.invoke();
                }
                return;
            }
            dCSTraceBuffer.addProperty("Received", "ViewID", viewIdImpl);
            if (viewIdImpl.equals(this._curViewId)) {
                boolean bl;
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer7 = DCSTraceBuffer.event(this, "TransportAdapter.handleViewSuspectMsg()", "Got suspect msg for me, with the current view id");
                    dCSTraceBuffer7.mergePropertyList(dCSTraceBuffer);
                    dCSTraceBuffer7.invoke();
                }
                if (bl = this.denyMemberFromView((VRIMemberDescription)object, 2)) {
                    TAConnectionClosingEvent tAConnectionClosingEvent = new TAConnectionClosingEvent((DCSTraceContext)this, object.getName(), new DCSLogicalChannel("View", "Gossip").toString() + ", this member is suspected by the other member");
                    tAConnectionClosingEvent.invokeNLSTrace();
                    this._up.suspectMembers(new DCSSuspectEvent[]{tAConnectionClosingEvent});
                }
                return;
            }
            if (this._curViewId.isPossibleFromFuture(viewIdImpl)) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer8 = DCSTraceBuffer.event(this, "TransportAdapter.handleViewSuspectMsg()", "Save future message");
                    dCSTraceBuffer8.mergePropertyList(dCSTraceBuffer);
                    dCSTraceBuffer8.invoke();
                }
                this._futureViewSuspectMsgs.addLast(vRIMessage);
                return;
            }
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer9 = DCSTraceBuffer.event(this, "TransportAdapter.handleViewSuspectMsg()", "Ignore past view id");
                dCSTraceBuffer9.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer9.invoke();
            }
            return;
        }
        catch (Throwable throwable) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Got exception, ignore call", "TransportAdapter.handleViewSuspectMsg()", throwable);
                dCSTraceBuffer.invoke();
            }
            return;
        }
    }

    public void currentOK(Object object) {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("Context", object);
        this.focus("currentOK", dCSTraceBuffer);
        this._up.currentOK((CCVersion)object);
    }

    public final void viewMemberRemoved(VRIMemberDescription vRIMemberDescription, DCSSuspectEvent dCSSuspectEvent) {
        if (this._terminated) {
            return;
        }
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("memberName", vRIMemberDescription.getName());
        dCSTraceBuffer.addProperty("Reason", dCSSuspectEvent);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.entry(this, "TransportAdapter.viewMemberRemoved()", null);
            dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer2.invoke();
        }
        this.focus("viewMemberRemoved", dCSTraceBuffer);
        boolean bl = this.denyMemberFromView(vRIMemberDescription, 2);
        if (bl) {
            dCSSuspectEvent.invokeNLSTrace();
            this._up.suspectMembers(new DCSSuspectEvent[]{dCSSuspectEvent});
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.exit(this, "TransportAdapter.viewMemberRemoved()", null);
            dCSTraceBuffer3.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer3.invoke();
        }
    }

    public void connectedMemberRemoved(VRIMemberDescription vRIMemberDescription, DCSSuspectEvent dCSSuspectEvent) {
        if (this._terminated) {
            return;
        }
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("memberName", vRIMemberDescription.getName());
        dCSTraceBuffer.addProperty("Reason", dCSSuspectEvent);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.entry(this, "TransportAdapter.connectedMemberRemoved()", null);
            dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer2.invoke();
        }
        this.focus("connectedMemberRemoved", dCSTraceBuffer);
        boolean bl = this.denyMemberFromView(vRIMemberDescription, 3);
        this._mmgr.removeConnectedMember(vRIMemberDescription.getName());
        this._mmgr.resetMemberLayerData(vRIMemberDescription.getName(), (byte)1);
        if (bl) {
            dCSSuspectEvent.invokeNLSTrace();
        }
        this._up.suspectMembers(new DCSSuspectEvent[]{dCSSuspectEvent});
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.exit(this, "TransportAdapter.connectedMemberRemoved()", null);
            dCSTraceBuffer3.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer3.invoke();
        }
    }

    public void newConnectedMember(VRIMemberDescription vRIMemberDescription, TransportNode transportNode) {
        DCSTraceable dCSTraceable;
        if (this._terminated) {
            return;
        }
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("memberName", vRIMemberDescription.getName());
        dCSTraceBuffer.addProperty(transportNode);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceable = DCSTraceBuffer.entry(this, "TransportAdapter.newConnectedMember()", null);
            ((DCSTraceBuffer)dCSTraceable).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)dCSTraceable).invoke();
        }
        this.focus("newConnectedMember", dCSTraceBuffer);
        dCSTraceable = new ConnectedMemberEvent((DCSTraceContext)this, vRIMemberDescription.toString());
        ((AbstractNLSEvent)dCSTraceable).invokeNLSTrace();
        this._mmgr.setMemberLayerData(vRIMemberDescription.getName(), transportNode);
        this._mmgr.addConnectedMember(vRIMemberDescription.getName());
        this._up.connectMembers(new VRIMemberDescription[]{vRIMemberDescription});
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "TransportAdapter.newConnectedMember()", null);
            dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer2.invoke();
        }
    }

    private void checkOutMsgQoS(VRIMessage vRIMessage, QoS qoS) throws DCSInvalidQoSException {
        if (vRIMessage == null) {
            throw new DCSAssertException("TransportAdapter.checkOutMsgQoS:" + this._thisStackName + ":null msg");
        }
        if (qoS == null) {
            throw new DCSAssertException("TransportAdapter.checkOutMsgQoS:" + this._thisStackName + ":null qos");
        }
        if (qoS.getChannelType() != QoS.VIEW && qoS.getChannelType() != QoS.CONNECTED) {
            throw new DCSInvalidQoSException("TransportAdapter.checkOutMsgQoS:" + this._thisStackName + ":channel type is " + qoS.getChannelType());
        }
        if (qoS.getGuaranteeType() != QoS.RELIABLE && qoS.getGuaranteeType() != QoS.UNRELIABLE) {
            throw new DCSInvalidQoSException("TransportAdapter.checkOutMsgQoS:" + this._thisStackName + ":guarantee type is " + qoS.getGuaranteeType());
        }
        if (qoS.getOrderType() != QoS.FIFO && qoS.getOrderType() != QoS.UNORDERED) {
            throw new DCSInvalidQoSException("TransportAdapter.checkOutMsgQoS:" + this._thisStackName + ":order type is " + qoS.getOrderType());
        }
        if (qoS.getSyncType() != QoS.NO_REAL_SYNC) {
            throw new DCSInvalidQoSException("TransportAdapter.checkOutMsgQoS:" + this._thisStackName + ":sync type is " + qoS.getSyncType());
        }
        if (qoS.getSecurityType() != QoS.UNSECURE) {
            throw new DCSInvalidQoSException("TransportAdapter.checkOutMsgQoS:" + this._thisStackName + ":security type is " + qoS.getSecurityType());
        }
    }

    private void setCheckTimer() {
        this._checkAlarm = AlarmManager.create(AlarmManager.GENERAL_ALARM, this._checkTime, this._stackMutex, this, this.CHECK_ALARM_CONTEXT);
        if (this._checkAlarm == null) {
            this.requestTermination(new DCSException("TransportAdapter.setCheckTimer: Failed to set the alarm"), "setCheckTimer()");
        }
    }

    public void alarm(Object object) {
        if (this._terminated) {
            return;
        }
        if (object == this.CHECK_ALARM_CONTEXT) {
            VRICheckFailedException vRICheckFailedException = null;
            try {
                vRICheckFailedException = this.check();
            }
            catch (RuntimeException runtimeException) {
                this.requestTermination(runtimeException, "alarm()");
            }
            if (vRICheckFailedException != null) {
                this.requestTermination(vRICheckFailedException, "alarm()");
            } else {
                this.setCheckTimer();
            }
            return;
        }
        if (object instanceof DCSTerminationEvent) {
            DCSTerminationEvent dCSTerminationEvent = (DCSTerminationEvent)object;
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty("Reason", dCSTerminationEvent);
            this.focus("alarmRequestTermination", dCSTraceBuffer);
            this._up.requestTermination(dCSTerminationEvent);
            return;
        }
        if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Got Unknown alarm context", "TransportAdapter.alarm()", null);
            dCSTraceBuffer.addProperty("AlarmContext", object);
            dCSTraceBuffer.invoke();
        }
    }

    public VRICheckFailedException check() {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "TransportAdapter.check()", "Start");
            dCSTraceBuffer.invoke();
        }
        dCSTraceBuffer = null;
        VRICheckFailedException vRICheckFailedException = this._up.check();
        if (dCSTraceBuffer == null) {
            return vRICheckFailedException;
        }
        ((VRICheckFailedException)((Object)dCSTraceBuffer)).setUpperLayerExcetion(vRICheckFailedException);
        return dCSTraceBuffer;
    }

    public void focus(String string) {
        this.focus(string, null, null);
    }

    public void focus(String string, DCSTraceBuffer dCSTraceBuffer) {
        this.focus(string, null, dCSTraceBuffer);
    }

    public void focus(String string, String string2, DCSTraceBuffer dCSTraceBuffer) {
        if (DCSTraceBuffer.isFocustEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.focusEvent(this, null, string, string2);
            dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer2.invoke();
        }
    }

    public void setUpperLayer(Upcalls upcalls) {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "TransportAdapter.setUpperLayer()", null);
            dCSTraceBuffer.addProperty("Layer", upcalls);
            dCSTraceBuffer.invoke();
        }
        this._up = upcalls;
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "TransportAdapter.setUpperLayer()", null);
            dCSTraceBuffer.invoke();
        }
    }

    public void setDownLayer(Downcalls downcalls) {
        if (downcalls != null) {
            throw new DCSIllegalParameterException("TransportAdapter.setDownLayer: should not be called with not null down. down is " + downcalls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCongestionControlEvent(CongestionControlEvent congestionControlEvent) {
        Object object = this._stackMutex;
        synchronized (object) {
            try {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "TransportAdapter.onCongestionControlEvent()", "Has Lock");
                    dCSTraceBuffer.addProperty("Reason", congestionControlEvent);
                    dCSTraceBuffer.invoke();
                }
                if (!this._terminated) {
                    this._up.onVRIUpEvent(congestionControlEvent);
                }
            }
            catch (Throwable throwable) {
                this.requestTermination(new DCSRuntimeException(throwable), "onCongestionControlEvent()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverSelfMsg(VRIMessage vRIMessage) {
        Object object = this._stackMutex;
        synchronized (object) {
            try {
                this.deliver(vRIMessage, true);
            }
            catch (Throwable throwable) {
                this.requestTermination(throwable, "deliverSelfMsg()");
            }
        }
    }

    public void onVRIDownEvent(VRIDownEvent vRIDownEvent) {
        vRIDownEvent.handle("TA", null, null);
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._thisStackName;
    }

    public String getRmmVersion() {
        return this._rmmVersion;
    }

    public String getMemberName() {
        return this._thisMemberName;
    }

    public String getLayerName() {
        return TA_LAYER_NAME;
    }

    public void requestTermination(Throwable throwable, String string) {
        this.requestTermination(new TerminationEvent((DCSTraceContext)this, string, throwable));
    }

    public void rcvBadMember(RcvBadMemberEvent rcvBadMemberEvent) {
        DCSTraceable dCSTraceable;
        if (this._terminated) {
            return;
        }
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("Reason", rcvBadMemberEvent);
        this.focus("rcvBadMember", "MethodStart", dCSTraceBuffer);
        rcvBadMemberEvent.invokeNLSTrace();
        if (rcvBadMemberEvent instanceof RcvNonDefinedMemberEvent && this._mmgr.isDefined(((RcvBadMemberEvent)(dCSTraceable = (RcvNonDefinedMemberEvent)rcvBadMemberEvent)).getBadMemberName())) {
            this.focus("rcvBadMember", "Member is already defined", dCSTraceBuffer);
            return;
        }
        if (this._g.isCoreStack()) {
            dCSTraceable = new VRINotifyUpEvent(rcvBadMemberEvent);
            ((VRIUpEvent)dCSTraceable).startHandling(this._stackMutex, this._up);
        }
    }

    public void newViewOK(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "newViewOK", "");
            dCSTraceBuffer.addProperty(viewIdImpl);
            dCSTraceBuffer.addProperty("NewViewMembers", VRIMemberUtils.toString(vRIMemberDescriptionArray));
            dCSTraceBuffer.addProperty("isWaiting", this._nvOKJob != null);
            dCSTraceBuffer.invoke();
        }
        if (this._nvOKJob != null) {
            this._nvOKJob.channelNVOKDone(vRIMemberDescriptionArray, viewIdImpl);
        }
    }

    final class TANewViewOKJob
    implements Job {
        private final DCSTraceContext _traceContext;
        private final ViewIdImpl _vid;
        private final Map _configMap;
        private final LinkedList _msgList = new LinkedList();
        private boolean _sdDone = false;
        private boolean _channelDone = false;
        private VRIMemberDescription[] _nvMembersSucced = null;
        private String _owner = null;

        TANewViewOKJob(DCSTraceContext dCSTraceContext, ViewIdImpl viewIdImpl, Map map) {
            this._traceContext = dCSTraceContext;
            this._vid = viewIdImpl;
            this._configMap = map;
        }

        public void process() {
            this.sdNVOKDone();
        }

        public void cancel() {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "cancel", "TANewViewOKJob was caceled");
                dCSTraceBuffer.addProperty(this._vid);
                dCSTraceBuffer.invoke();
            }
        }

        public void handleError(Throwable throwable) {
            TransportAdapter.this.requestTermination(throwable, "TANewViewOKJob.process");
        }

        public String getOwner() {
            return this._owner;
        }

        void setOwner(String string) {
            this._owner = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sdNVOKDone() {
            Object object = TransportAdapter.this._stackMutex;
            synchronized (object) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "sdNVOKDone", "");
                    dCSTraceBuffer.addProperty(this._vid);
                    dCSTraceBuffer.addProperty("SDDone", this._sdDone);
                    dCSTraceBuffer.addProperty("ChannelDone", this._channelDone);
                    dCSTraceBuffer.invoke();
                }
                this._sdDone = true;
                if (this._sdDone && this._channelDone) {
                    this.newViewOKDone();
                }
            }
        }

        void channelNVOKDone(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl) {
            if (!this._vid.equals(viewIdImpl)) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._traceContext, "channelNVOKDone called with wrong vid", null);
                    dCSTraceBuffer.addProperty("My", this._vid);
                    dCSTraceBuffer.addProperty("Called", viewIdImpl);
                    dCSTraceBuffer.invoke();
                }
                return;
            }
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "channelNVOKDone", "");
                dCSTraceBuffer.addProperty(this._vid);
                dCSTraceBuffer.addProperty("NewViewMembers", VRIMemberUtils.toString(vRIMemberDescriptionArray));
                dCSTraceBuffer.addProperty("SDDone", this._sdDone);
                dCSTraceBuffer.addProperty("ChannelDone", this._channelDone);
                dCSTraceBuffer.invoke();
            }
            this._nvMembersSucced = vRIMemberDescriptionArray;
            this._channelDone = true;
            if (this._sdDone && this._channelDone) {
                this.newViewOKDone();
            }
        }

        boolean addMessage(VRIMessage vRIMessage, boolean bl) {
            if (bl && this._sdDone || !bl && this._channelDone) {
                this._msgList.addLast(vRIMessage);
                return true;
            }
            return false;
        }

        void newViewOKDone() {
            Object object;
            if (TransportAdapter.this._terminated) {
                return;
            }
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this._traceContext, "newViewOKDone", "");
                ((DCSTraceBuffer)object).addProperty(this._vid);
                ((DCSTraceBuffer)object).addProperty("NewViewMembers", VRIMemberUtils.toString(this._nvMembersSucced));
                ((DCSTraceBuffer)object).invoke();
            }
            TransportAdapter.this._up.newViewOK(this._nvMembersSucced, this._vid, this._configMap);
            TransportAdapter.this._nvOKJob = null;
            while (!this._msgList.isEmpty()) {
                object = (VRIMessage)this._msgList.removeFirst();
                TransportAdapter.this.deliverUp((VRIMessage)object);
            }
        }
    }
}

