/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter;

import com.ibm.ws.dcs.vri.common.Job;
import com.ibm.ws.dcs.vri.common.JobsProcessorThread;
import com.ibm.ws.dcs.vri.common.ThreadManager;
import com.ibm.ws.dcs.vri.common.impl.BaseVRIMessage;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.TransportGroupEvent;
import com.ibm.ws.dcs.vri.transportAdapter.TransportGroupListener;
import com.ibm.ws.dcs.vri.transportAdapter.TransportInternalException;

public final class TransportGroupThread {
    private boolean _terminated = false;
    private final TransportGroupListener _listener;
    private final String _name;
    private final JobsProcessorThread _jobsThread;
    private final DCSTraceContext _dtc;

    public TransportGroupThread(String string, TransportGroupListener transportGroupListener, DCSTraceContext dCSTraceContext) {
        this._name = string;
        this._listener = transportGroupListener;
        this._dtc = dCSTraceContext;
        this._jobsThread = ThreadManager.getThread(string, ThreadManager.INTERNAL_THREAD, 7);
        if (this._jobsThread == null) {
            throw new TransportInternalException("TransportGroupThread.TransportGroupThread: " + string + ": Failed to create thread");
        }
    }

    public void terminate() {
        this._terminated = true;
        ThreadManager.releaseThread(this._name);
    }

    public String dump() {
        return "";
    }

    public void queueObject(Object object) {
        InJob inJob = null;
        if (object instanceof BaseVRIMessage) {
            BaseVRIMessage baseVRIMessage = (BaseVRIMessage)object;
            inJob = new InMessageJob(baseVRIMessage);
        } else {
            TransportGroupEvent transportGroupEvent = (TransportGroupEvent)object;
            inJob = new InEventJob(transportGroupEvent);
        }
        this._jobsThread.enqueueJob(inJob);
    }

    protected final class InEventJob
    extends InJob {
        private final TransportGroupEvent _event;

        public InEventJob(TransportGroupEvent transportGroupEvent) {
            this._event = transportGroupEvent;
        }

        public void process() {
            TransportGroupThread.this._listener.onEvent(this._event);
        }
    }

    protected final class InMessageJob
    extends InJob {
        private BaseVRIMessage _msg;

        public InMessageJob(BaseVRIMessage baseVRIMessage) {
            this._msg = baseVRIMessage;
        }

        public void process() {
            TransportGroupThread.this._listener.onMessage(this._msg);
            this._msg = null;
        }
    }

    protected abstract class InJob
    implements Job {
        protected InJob() {
        }

        public void cancel() {
            if (!TransportGroupThread.this._terminated && DCSTraceBuffer.isInternalWarningEnabled(TransportGroupThread.this._dtc.getTraceComponent())) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(TransportGroupThread.this._dtc, "Job was cancelled", "InJob.enclosing_method()", null);
                dCSTraceBuffer.invoke();
            }
        }

        public void handleError(Throwable throwable) {
            TransportGroupThread.this._listener.onError(new TerminationEvent(TransportGroupThread.this._dtc, "InJob.handleError()", throwable));
        }

        public String getOwner() {
            return TransportGroupThread.this._name;
        }
    }
}

