/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmm.util.ExtendedLogEventListener;
import com.ibm.rmm.util.RmmLogger;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.utils.AlarmListener;
import com.ibm.ws.dcs.utils.AlarmManager;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.nls.RmmErrorEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.LogAdapterListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LogAdapter
implements ExtendedLogEventListener,
DCSTraceContext,
AlarmListener {
    private final Globals _globals;
    private static int FILTER_BASIC_TIMEOUT_SEC = 600;
    private final String _thisStackName;
    private final String _thisMemberName;
    private final LogAdapterListener _listener;
    private boolean _initializing;
    private RmmErrorEvent _initError;
    private Set _filterKeys;
    private static final Map _nlsMap = new HashMap();
    private static TraceComponent TC;

    public LogAdapter(LogAdapterListener logAdapterListener, String string, String string2, Globals globals) {
        this._listener = logAdapterListener;
        this._initializing = true;
        this._thisMemberName = string;
        this._thisStackName = string2;
        this._initError = null;
        this._filterKeys = new HashSet();
        this._globals = globals;
    }

    public synchronized RmmErrorEvent start() {
        this._initializing = false;
        return this._initError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLogEvent(int n, Object[] objectArray, Throwable throwable, String string) {
        boolean bl;
        StackTraceElement[] stackTraceElementArray;
        String string2 = RmmLogger.rmmLogMessages[n];
        String string3 = MessageFormat.format(string2, objectArray);
        string3 = string3 + " Module Name: " + string + " ";
        if (throwable != null) {
            string3 = string3 + "\n" + throwable + "\n";
            stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                string3 = string3 + "\t" + stackTraceElementArray[i].toString() + "\n";
            }
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            stackTraceElementArray = DCSTraceBuffer.event(this, "LogAdapter.onLogEvent()", string3);
            stackTraceElementArray.invoke();
        }
        if (bl = this.handleNls(n, objectArray, throwable)) {
            RmmErrorEvent rmmErrorEvent = new RmmErrorEvent((DCSTraceContext)this, throwable, n);
            LogAdapter logAdapter = this;
            synchronized (logAdapter) {
                if (this._initializing) {
                    this._initError = rmmErrorEvent;
                    return;
                }
            }
            this._listener.onLogError(rmmErrorEvent);
        }
    }

    private boolean handleNls(int n, Object[] objectArray, Throwable throwable) {
        String string = this.getNlsKey(n);
        NlsKeyProps nlsKeyProps = (NlsKeyProps)_nlsMap.get(string);
        if (nlsKeyProps == null) {
            return false;
        }
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        if (string.equals("DCSV9416")) {
            return this.handle9416(nlsKeyProps, objectArray, throwable);
        }
        int n2 = nlsKeyProps.getParamsNum();
        if (objectArray.length + 1 != n2) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "RMM NLS message has illegal number of parameters", "LogAdapter.handleNls()", throwable);
                dCSTraceBuffer.addProperty("NLSKey", string);
                dCSTraceBuffer.addProperty("Bad", "ParamsNumber", objectArray.length + 1);
                dCSTraceBuffer.addProperty("Supposed", "ParamsNumber", n2);
                dCSTraceBuffer.invoke();
            }
            return false;
        }
        if (this.filterKey(string, nlsKeyProps)) {
            return false;
        }
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray.length] = throwable;
        Integer n3 = nlsKeyProps.getType();
        if (n3.equals(NlsKeyProps.INFO)) {
            Tr.info(TC, string, objectArray2);
            return false;
        }
        if (n3.equals(NlsKeyProps.WARNING)) {
            Tr.warning(TC, string, objectArray2);
            return false;
        }
        if (n3.equals(NlsKeyProps.ERROR)) {
            Tr.error(TC, string, objectArray2);
            return true;
        }
        if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "RMM message has wrong NLS type", "LogAdapter.handleNls()", null);
            dCSTraceBuffer.addProperty("TypeCode", n3);
            dCSTraceBuffer.invoke();
        }
        return false;
    }

    private boolean handle9416(NlsKeyProps nlsKeyProps, Object[] objectArray, Throwable throwable) {
        Object[] objectArray2 = new Object[1];
        String string = objectArray == null || objectArray.length == 0 || objectArray[0] == null ? "null" : objectArray[0].toString();
        if (throwable != null) {
            throwable = new DCSTransportLayerException(string, throwable);
            objectArray2[0] = throwable;
        } else {
            objectArray2[0] = string;
        }
        if (this.filterKey("DCSV9416", nlsKeyProps)) {
            return false;
        }
        Tr.error(TC, "DCSV9416", objectArray2);
        return true;
    }

    private synchronized boolean filterKey(String string, NlsKeyProps nlsKeyProps) {
        if (this.isTerminated() && nlsKeyProps.isFilterAfterClose()) {
            return true;
        }
        Integer n = nlsKeyProps.getTimeout();
        if (n == null) {
            return false;
        }
        if (this._filterKeys.contains(string)) {
            return true;
        }
        this._filterKeys.add(string);
        this.setAlarm(string, n.intValue());
        return false;
    }

    private boolean isTerminated() {
        return this._globals.goingToTerminate();
    }

    public void onDebugEvent(int n, Object[] objectArray, Object object, String string) {
        String string2 = RmmLogger.rmmLogMessages[n];
        String string3 = MessageFormat.format(string2, objectArray);
        string3 = string3 + " Module Name: " + string + " ";
        string3 = object != null ? "Caller " + object.getClass() + ": " + string3 : "Static context call: " + string3;
        if (DCSTraceBuffer.isDebugEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.debug(this, "LogAdapter.onDebugEvent()", string3);
            dCSTraceBuffer.invoke();
        }
    }

    private String getNlsKey(int n) {
        return "DCSV9" + n;
    }

    private static void initNlsMap() {
        LogAdapter.putInMap("DCSV9403", NlsKeyProps.ERROR, 3);
        LogAdapter.putInMap("DCSV9404", NlsKeyProps.ERROR, 2);
        LogAdapter.putInMap("DCSV9405", NlsKeyProps.ERROR, 2);
        LogAdapter.putInMap("DCSV9407", NlsKeyProps.ERROR, 2);
        LogAdapter.putInMap("DCSV9408", NlsKeyProps.WARNING, 2);
        LogAdapter.putInMap("DCSV9409", NlsKeyProps.WARNING, 2);
        LogAdapter.putInMap("DCSV9410", NlsKeyProps.WARNING, 2);
        LogAdapter.putInMap("DCSV9411", NlsKeyProps.ERROR, 2);
        LogAdapter.putInMap("DCSV9412", NlsKeyProps.WARNING, 2);
        LogAdapter.putInMap("DCSV9413", NlsKeyProps.WARNING, 3, FILTER_BASIC_TIMEOUT_SEC);
        LogAdapter.putInMap("DCSV9414", NlsKeyProps.ERROR, 2);
        LogAdapter.putInMap("DCSV9415", NlsKeyProps.WARNING, 3);
        LogAdapter.putInMap("DCSV9416", NlsKeyProps.ERROR, 1, true);
        LogAdapter.putInMap("DCSV9417", NlsKeyProps.WARNING, 2);
        LogAdapter.putInMap("DCSV9419", NlsKeyProps.WARNING, 3);
        LogAdapter.putInMap("DCSV9420", NlsKeyProps.WARNING, 4);
        LogAdapter.putInMap("DCSV9421", NlsKeyProps.WARNING, 2);
    }

    private static void putInMap(String string, Integer n, int n2) {
        _nlsMap.put(string, new NlsKeyProps(n, n2));
    }

    private static void putInMap(String string, Integer n, int n2, int n3) {
        _nlsMap.put(string, new NlsKeyProps(n, n2, n3));
    }

    private static void putInMap(String string, Integer n, int n2, boolean bl) {
        _nlsMap.put(string, new NlsKeyProps(n, n2, bl));
    }

    public static void main(String[] stringArray) throws IOException {
        String string;
        String string2 = "com.ibm.ws.dcs.common.event.nls.dcs".replace('.', '/');
        string2 = string2 + ".nlsprops";
        System.out.println("File name is " + string2);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        int n = 0;
        System.out.println("Starting to analyze " + bufferedReader.toString());
        while ((string = bufferedReader.readLine()) != null) {
            int n2 = string.indexOf("=DCSV9");
            if (n2 == -1) continue;
            ++n;
            String string3 = string.substring(n2 + 1, n2 + 9);
            char c = string.charAt(n2 + 9);
            int n3 = string.lastIndexOf(123);
            int n4 = Character.getNumericValue(string.charAt(n3 + 1)) + 1;
            if (!_nlsMap.containsKey(string3)) {
                System.err.println("Map does not contain " + string3);
                System.exit(1);
            }
            NlsKeyProps nlsKeyProps = (NlsKeyProps)_nlsMap.get(string3);
            if (c == 'E' && !nlsKeyProps.getType().equals(NlsKeyProps.ERROR)) {
                System.err.println("WRONG SEVERITY FOR " + string3);
                System.exit(1);
            } else if (c == 'W' && !nlsKeyProps.getType().equals(NlsKeyProps.WARNING)) {
                System.err.println("WRONG SEVERITY FOR " + string3);
                System.exit(1);
            } else if (c == 'I' && !nlsKeyProps.getType().equals(NlsKeyProps.INFO)) {
                System.err.println("WRONG SEVERITY FOR " + string3);
                System.exit(1);
            } else if (c != 'E' && c != 'W' && c != 'I') {
                System.err.println("Unknown severity " + c);
                System.exit(1);
            }
            if (n4 != nlsKeyProps.getParamsNum()) {
                System.err.println("Wrong param num for " + string3);
                System.exit(1);
            }
            System.out.println("Key is fine " + string3);
        }
        if (n != _nlsMap.size()) {
            System.err.println("Inconsistent map size " + _nlsMap.size() + ". Should be " + n);
        } else {
            System.out.println("Test succeeded");
        }
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._thisStackName;
    }

    public String getMemberName() {
        return this._thisMemberName;
    }

    public String getLayerName() {
        return DCSConstants.TRACE_LAYER_NAMES[1];
    }

    public void alarm(Object object) {
        String string = (String)object;
        this._filterKeys.remove(string);
    }

    private void setAlarm(String string, long l) {
        AlarmManager.create(AlarmManager.GENERAL_ALARM, l * 1000L, this, this, string);
    }

    public int getLogLevel() {
        return DCSTraceBuffer.isEventEnabled(TC) ? 2 : 1;
    }

    static {
        LogAdapter.initNlsMap();
        TC = Tr.register(LogAdapter.class, "RMM", "com.ibm.ws.dcs.common.event.nls.dcs");
    }

    private static class NlsKeyProps {
        private final int _paramsNum;
        private final Integer _type;
        private final Integer _filterTimeout;
        private final boolean _filterAfterClose;
        private static final Integer INFO = new Integer(1);
        private static final Integer WARNING = new Integer(2);
        private static final Integer ERROR = new Integer(3);

        private NlsKeyProps(Integer n, int n2) {
            this._paramsNum = n2;
            this._type = n;
            this._filterTimeout = null;
            this._filterAfterClose = false;
        }

        private NlsKeyProps(Integer n, int n2, int n3) {
            this._paramsNum = n2;
            this._type = n;
            this._filterTimeout = new Integer(n3);
            this._filterAfterClose = false;
        }

        private NlsKeyProps(Integer n, int n2, boolean bl) {
            this._paramsNum = n2;
            this._type = n;
            this._filterTimeout = null;
            this._filterAfterClose = bl;
        }

        public int getParamsNum() {
            return this._paramsNum;
        }

        public Integer getType() {
            return this._type;
        }

        public Integer getTimeout() {
            return this._filterTimeout;
        }

        public boolean isFilterAfterClose() {
            return this._filterAfterClose;
        }
    }
}

