/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common;

import com.ibm.ws.dcs.common.AddressResolver;
import com.ibm.ws.dcs.common.MemberAddress;
import com.ibm.ws.dcs.common.config.DCSIllegalConfigurationException;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.PtpRmmNode;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MyAddressResolver {
    private final AddressResolver _addressResolver;
    private final String _myIp;
    private final int _myPortInt;
    private final String _myPortStr;
    private final String _myTopicStr;
    private final boolean _iAmPassive;
    private final boolean _inBindAll;
    public static final String ASTERISK = "*";

    public MyAddressResolver(AddressResolver addressResolver, String string) {
        String string2;
        this._addressResolver = addressResolver;
        MemberAddress memberAddress = this._addressResolver.getAddress(string);
        if (memberAddress == null) {
            throw new DCSIllegalConfigurationException("Address Resolver returns null for the local member address");
        }
        int n = this._addressResolver.getLocalBindingOption();
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new DCSIllegalConfigurationException("Address Resolver returns illegal binding option - " + n);
            }
        }
        if (n == 3) {
            this._myIp = ASTERISK;
            string2 = ASTERISK;
        } else {
            this._myIp = memberAddress.getIp();
            if (this._myIp == null) {
                throw new DCSIllegalConfigurationException("Address Resolver returns null for the local member IP");
            }
            string2 = this.getAddressAsIa(this._myIp);
        }
        this._inBindAll = n != 1;
        this._myPortInt = memberAddress.getPort();
        if (this._myPortInt <= 0) {
            throw new DCSIllegalConfigurationException("Address Resolver returns illegal port number - " + this._myPortInt);
        }
        this._myPortStr = String.valueOf(this._myPortInt);
        char c = '|';
        this._iAmPassive = this._addressResolver.isPassiveDiscovery(string);
        this._myTopicStr = Utils.getShortClassName(PtpRmmNode.class) + c + string + c + string2 + c + this._myPortStr + (this._iAmPassive ? c + "P" : "");
    }

    public String getMyIpAsString() {
        return this._myIp;
    }

    public String getMyPortAsString() {
        return this._myPortStr;
    }

    public int getMyPortAsInt() {
        return this._myPortInt;
    }

    public String getMyNodeTopicStr() {
        return this._myTopicStr;
    }

    public boolean getMyPassiveDiscovery() {
        return this._iAmPassive;
    }

    private String getAddressAsIa(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new DCSIllegalConfigurationException("Local IP is illegal. Got " + unknownHostException);
        }
        return inetAddress.getHostAddress();
    }

    public String isBindAll() {
        return String.valueOf(this._inBindAll);
    }
}

