/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.connected;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmm.receiver.RMReceiver;
import com.ibm.rmm.transmitter.RMTransmitter;
import com.ibm.rmm.util.UnicastConnectionIf;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.config.DCSIllegalConfigurationException;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.utils.AlarmListener;
import com.ibm.ws.dcs.utils.AlarmManager;
import com.ibm.ws.dcs.vri.common.MetaMessageFactory;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberLayerData;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.nls.TASuspectDownUpCase;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.ConnectedChannelListener;
import com.ibm.ws.dcs.vri.transportAdapter.TransportGroupEvent;
import com.ibm.ws.dcs.vri.transportAdapter.TransportNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.MyAddressResolver;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RmmNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.connected.RmmConnectedChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmPtpTransmitterEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmReceiverEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryServer;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.PtpRmmNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.PtpNodeData;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.DiscoveryRmmPtpGroup;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.RmmPtpGroup;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.TransmitterThread;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Set;

public final class PtpConnectedChannel
extends RmmConnectedChannel
implements AlarmListener {
    private long ASYM_CON_PING_TIMEOUT = 2000L;
    static final DCSLogicalChannel CONNECTED_PTP_CHANNEL = new DCSLogicalChannel("Connected", "Ptp");
    private final boolean _isCore;
    protected DiscoveryServer _discoveryServer;
    private static TraceComponent TC = Tr.register(PtpConnectedChannel.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");

    public PtpConnectedChannel(ConnectedChannelListener connectedChannelListener, VRIMembersMGR vRIMembersMGR, VRIMemberDescription vRIMemberDescription, String string, Object object, RMTransmitter rMTransmitter, RMReceiver rMReceiver, long l, TransmitterThread transmitterThread, MetaMessageFactory metaMessageFactory, DiscoveryServer discoveryServer, boolean bl, int n, MyAddressResolver myAddressResolver) {
        super(connectedChannelListener, vRIMembersMGR, vRIMemberDescription, string, object, rMTransmitter, rMReceiver, l, transmitterThread, metaMessageFactory, n, myAddressResolver);
        this._discoveryServer = discoveryServer;
        this._isCore = bl;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this, "PtpConnectedChannel.PtpConnectedChannel()", null);
            dCSTraceBuffer.invoke();
        }
    }

    public void start(VRIMemberDescription[] vRIMemberDescriptionArray) {
        Object object;
        super.start(vRIMemberDescriptionArray);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "PtpConnectedChannel.start()", null);
            ((DCSTraceBuffer)object).addProperty("DefinedSet", Utils.toString(vRIMemberDescriptionArray));
            ((DCSTraceBuffer)object).invoke();
        }
        object = new HashSet();
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            VRIMemberDescription vRIMemberDescription = vRIMemberDescriptionArray[i];
            if (vRIMemberDescription.equals(this._thisMember)) continue;
            object.add(vRIMemberDescription.getName());
        }
        this._group = new DiscoveryRmmPtpGroup(this, CONNECTED_PTP_CHANNEL, this._rmr, this._rmt, this, this._thisStackName, this._transCloseWaitTime, (Set)object, this.CONNECTED_TOPIC_NAME, this._transmitter, this._inMsgFactory, this._discoveryServer, this._isCore, this, this._thisMember.getName(), this._hbtTimeout, this);
        this._group.refreshReceiverRejectedStreams();
    }

    protected PtpNodeData createRmmNodeData(InetAddress inetAddress, int n, String string, Object object) {
        PtpRmmNode ptpRmmNode;
        try {
            ptpRmmNode = new PtpRmmNode(string, (UnicastConnectionIf)object);
        }
        catch (ClassCastException classCastException) {
            Tr.warning(TC, "DCSV0002", new Object[]{this._thisStackName, this._thisMember.getName(), "PtpConnectedChannel.createRmmNodeData", classCastException});
            ptpRmmNode = new PtpRmmNode(string);
        }
        return new PtpNodeData(string, ptpRmmNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(TransportGroupEvent transportGroupEvent) {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "PtpConnectedChannel.onEvent()", null);
            ((DCSTraceBuffer)object).addProperty("RmmEvent", transportGroupEvent.getDescription());
            ((DCSTraceBuffer)object).addProperty("TypeCode", transportGroupEvent.getType());
            ((DCSTraceBuffer)object).addProperty("ClassName", transportGroupEvent.getClass().getName());
            ((DCSTraceBuffer)object).invoke();
        }
        object = this._stackMutex;
        synchronized (object) {
            if (transportGroupEvent instanceof RmmPtpTransmitterEvent) {
                RmmPtpTransmitterEvent rmmPtpTransmitterEvent = (RmmPtpTransmitterEvent)transportGroupEvent;
                String string = rmmPtpTransmitterEvent.getSourceNode().getName();
                PtpRmmNode ptpRmmNode = rmmPtpTransmitterEvent.getSourceNode();
                this.handleDeadMember(string, ptpRmmNode.getRmmConnection(), rmmPtpTransmitterEvent.toSuspectEvent());
                if (rmmPtpTransmitterEvent.getType() == 5) {
                    PtpRmmNode ptpRmmNode2 = new PtpRmmNode(string, ((DiscoveryRmmPtpGroup)this._group).getCurrentConnection(string));
                    this.addNodeToGroup(new PtpNodeData(string, ptpRmmNode2));
                }
                return;
            }
            RmmReceiverEvent rmmReceiverEvent = null;
            if (!(transportGroupEvent instanceof RmmReceiverEvent)) {
                Tr.warning(TC, "DCSV0003", new Object[]{this._thisStackName, this._thisMember.getName(), "onEvent() - Undefined event " + transportGroupEvent});
                return;
            }
            rmmReceiverEvent = (RmmReceiverEvent)transportGroupEvent;
            try {
                if (rmmReceiverEvent.isCongestion()) {
                    Tr.warning(TC, "DCSV0003", new Object[]{this._thisStackName, this._thisMember.getName(), "onEvent() - Congestion event " + transportGroupEvent});
                    return;
                }
                String string = this.getName(rmmReceiverEvent.getTopicName());
                rmmReceiverEvent.setSource(string);
                if (string == null) {
                    Tr.warning(TC, "DCSV0003", new Object[]{this._thisStackName, this._thisMember.getName(), "onEvent() - null member " + transportGroupEvent});
                    return;
                }
                if (rmmReceiverEvent.getType() == 10) {
                    this.onNewSource(rmmReceiverEvent, string);
                    return;
                }
                if (rmmReceiverEvent.getType() == 2 || rmmReceiverEvent.getType() == 20 || rmmReceiverEvent.getType() == 5 || rmmReceiverEvent.getType() == 1) {
                    if (this.isStreamActive(rmmReceiverEvent.getStreamId(), string)) {
                        Object object2;
                        if (DCSTraceBuffer.isEventEnabled(TC)) {
                            object2 = DCSTraceBuffer.event(this, "PtpConnectedChannel.onEvent()", string);
                            ((DCSTraceBuffer)object2).addProperty("Report", "Stream is active, calling handleDeadMember()");
                            ((DCSTraceBuffer)object2).addProperty("StreamId", rmmReceiverEvent.getStreamId());
                            ((DCSTraceBuffer)object2).addProperty("Type", rmmReceiverEvent.getType());
                            ((DCSTraceBuffer)object2).invoke();
                        }
                        object2 = (UnicastConnectionIf)this.getConnectionForMember(string);
                        this.handleDeadMember(string, (UnicastConnectionIf)object2, rmmReceiverEvent.toSuspectEvent());
                    } else {
                        boolean bl = this.removeFromCandidatesMap(rmmReceiverEvent.getSourceName(), rmmReceiverEvent.getStreamId());
                        if (DCSTraceBuffer.isEventEnabled(TC)) {
                            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "PtpConnectedChannel.onEvent()", "Stream is not active");
                            dCSTraceBuffer.addProperty("memberName", string);
                            dCSTraceBuffer.addProperty("StreamId", rmmReceiverEvent.getStreamId());
                            dCSTraceBuffer.addProperty("Removed from candidates", bl);
                            dCSTraceBuffer.addProperty("Type", rmmReceiverEvent.getType());
                            dCSTraceBuffer.invoke();
                        }
                    }
                    return;
                }
            }
            catch (RuntimeException runtimeException) {
                this._adapter.requestTermination(new TerminationEvent((DCSTraceContext)this, "onEvent()", runtimeException));
            }
        }
    }

    private void onNewSource(RmmReceiverEvent rmmReceiverEvent, String string) {
        DCSTraceBuffer dCSTraceBuffer;
        Object object;
        Object object2;
        String string2 = rmmReceiverEvent.getTopicName();
        InetAddress inetAddress = rmmReceiverEvent.getSourceAddress();
        int n = rmmReceiverEvent.getSourcePort();
        long l = rmmReceiverEvent.getStreamId();
        Object object3 = rmmReceiverEvent.getObjectId();
        VRIMemberDescription vRIMemberDescription = this._mmgr.getDefinedMember(string);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object2 = DCSTraceBuffer.entry(this, "PtpConnectedChannel.onNewSource()", string);
            ((DCSTraceBuffer)object2).addProperty("TopicName", Utils.toPrintableString(string2));
            ((DCSTraceBuffer)object2).addProperty("InetAddress", inetAddress);
            ((DCSTraceBuffer)object2).addProperty("Port", n);
            ((DCSTraceBuffer)object2).addProperty("Received", "StreamId", l);
            ((DCSTraceBuffer)object2).invoke();
        }
        if (inetAddress == null) {
            object2 = "PtpConnectedChannel.onNewSource() - Null source address " + rmmReceiverEvent;
            Tr.warning(TC, "DCSV0003", new Object[]{this._thisStackName, this._thisMember.getName(), object2});
            this._group.rejectReceiverStream(l);
            return;
        }
        if (!this._rcvDefinedMembers.isMemberDefined(string)) {
            object2 = "PtpConnectedChannel.onNewSource() - The member is not defined anymore - Ignore event " + string;
            Tr.warning(TC, "DCSV0003", new Object[]{this._thisStackName, this._thisMember.getName(), object2});
            this._group.rejectReceiverStream(l);
            return;
        }
        object2 = this.getStreamForMember(string);
        if (object2 != null) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this, "PtpConnectedChannel.onNewSource() - existing stream", string);
                ((DCSTraceBuffer)object).addProperty("Current", "StreamId", object2);
                ((DCSTraceBuffer)object).addProperty("Received", "StreamId", l);
                ((DCSTraceBuffer)object).invoke();
            }
            if (this.isOldStream((Long)object2, new Long(l))) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    object = DCSTraceBuffer.event(this, "PtpConnectedChannel.onNewSource() - old stream", string);
                    ((DCSTraceBuffer)object).invoke();
                }
                this._group.rejectReceiverStream(l);
                return;
            }
            if ((Long)object2 == l) {
                object = "PtpConnectedChannel.onNewSource() - Redundant new source " + string;
                Tr.warning(TC, "DSV0003", new Object[]{this._thisStackName, this._thisMember.getName(), object});
                return;
            }
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this, "PtpConnectedChannel.onNewSource()", string);
                ((DCSTraceBuffer)object).addProperty("Reason", "Identified Down/Up case");
                ((DCSTraceBuffer)object).invoke();
            }
            object = (UnicastConnectionIf)this.getConnectionForMember(string);
            this.handleDeadMember(string, (UnicastConnectionIf)object, new TASuspectDownUpCase((DCSTraceContext)this, string, this.getDcsChannel()));
        }
        object = this.createRmmNodeData(inetAddress, n, string, object3);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "PtpConnectedChannel.onNewSource()", string);
            dCSTraceBuffer.addProperty("Report", "Created RMM node data. Proceed to addNodeToGroup");
            dCSTraceBuffer.addProperty((DCSTraceable)object);
            dCSTraceBuffer.invoke();
        }
        if (this.addNodeToGroup((PtpNodeData)object)) {
            this._mmgr.setMemberLayerData(string, (VRIMemberLayerData)object);
            this.addStreamForMember(string, l, object3);
            this._adapter.newConnectedMember(vRIMemberDescription, (TransportNode)object);
        } else {
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.exit(this, "PtpConnectedChannel.onNewSource()", string);
                dCSTraceBuffer.addProperty("Report", "Failed to add node");
                dCSTraceBuffer.invoke();
            }
            this._group.rejectReceiverStream(l);
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "PtpConnectedChannel.onNewSource()", string);
            dCSTraceBuffer.invoke();
        }
    }

    public void removeDefinedMember(VRIMemberDescription vRIMemberDescription) {
        try {
            String string = vRIMemberDescription.getName();
            ((DiscoveryRmmPtpGroup)this._group).removeDefinedNode(vRIMemberDescription.getName());
            Long l = this.removeStreamForMember(string);
            if (l != null) {
                this._group.rejectReceiverStream(l);
            }
            this._rcvDefinedMembers.removeDefinedMember(vRIMemberDescription);
        }
        catch (DCSIllegalConfigurationException dCSIllegalConfigurationException) {
            String string = "PtpConnectedChannel.removeDefinedMember() : Exception while removing member " + vRIMemberDescription.getName();
            Tr.warning(TC, "DCSV0002", new Object[]{this._thisStackName, this._thisMember.getName(), string, dCSIllegalConfigurationException});
            return;
        }
    }

    public void addDefinedMember(VRIMemberDescription vRIMemberDescription) {
        super.addDefinedMember(vRIMemberDescription);
        ((DiscoveryRmmPtpGroup)this._group).addDefinedNode(vRIMemberDescription.getName());
        this.triggerAsymConCheck(vRIMemberDescription.getName());
    }

    protected String getTransType() {
        return "PTP";
    }

    protected RmmNode toRmmNode(String string) {
        return this.toPtpRmmNode(string);
    }

    protected boolean addNodeToGroup(PtpNodeData ptpNodeData) {
        boolean bl = this._group.addNode(ptpNodeData.getPtpNode());
        if (!bl && DCSTraceBuffer.isInternalWarningEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Failed to add node", "PtpConnectedChannel.addNodeToGroup()", null);
            dCSTraceBuffer.addProperty(ptpNodeData);
            dCSTraceBuffer.invoke();
        }
        this.triggerAsymConCheck(ptpNodeData.getName());
        return bl;
    }

    protected DCSLogicalChannel getDcsChannel() {
        return CONNECTED_PTP_CHANNEL;
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public void sendViewSuspectMsg(VRIMessage vRIMessage, VRIMemberDescription vRIMemberDescription) {
        int n = vRIMessage.prepareBuffer();
        byte[] byArray = vRIMessage.getDataBuffer();
        PtpRmmNode ptpRmmNode = this.toPtpRmmNode(vRIMemberDescription);
        if (ptpRmmNode == null) {
            return;
        }
        ((RmmPtpGroup)this._group).send(byArray, 0, n, ptpRmmNode);
    }

    public void triggerAsymConCheck(String string) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "PtpConnectedChannel.triggerAsymConCheck()", "Creating alarm");
            dCSTraceBuffer.addProperty("memberName", string);
            dCSTraceBuffer.addProperty("Timeout", this.ASYM_CON_PING_TIMEOUT);
            dCSTraceBuffer.invoke();
        }
        AlarmManager.create(AlarmManager.TA_ALARM, this.ASYM_CON_PING_TIMEOUT, this._stackMutex, this, string);
    }

    public void alarm(Object object) {
        String string = (String)object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this._mmgr.isDefined(string);
        boolean bl4 = false;
        if (bl3) {
            bl = ((RmmPtpGroup)this._group).contains(string);
            bl2 = this._sourceStreamMap.containsKey(string);
            if (bl && !bl2) {
                ((DiscoveryRmmPtpGroup)this._group).ping(string);
                bl4 = true;
                this.triggerAsymConCheck(string);
            }
        }
        String string2 = "Out " + (bl ? "Live" : "Dead");
        string2 = string2 + ", In " + (bl2 ? "Live" : "Dead");
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "PtpConnectedChannel.alarm()", "Checked Async Connected");
            dCSTraceBuffer.addProperty("memberName", string);
            dCSTraceBuffer.addProperty("IsNodeDefined", bl3);
            dCSTraceBuffer.addProperty("Report", string2);
            dCSTraceBuffer.addProperty("Ack", bl4);
            dCSTraceBuffer.invoke();
        }
    }

    protected boolean removeFromCandidatesMap(String string, long l) {
        return ((DiscoveryRmmPtpGroup)this._group).removeFromCandidatesMap(string, l);
    }

    private boolean isOldStream(Long l, Long l2) {
        return l - l2 > 0L;
    }

    private void handleDeadMember(String string, UnicastConnectionIf unicastConnectionIf, DCSSuspectEvent dCSSuspectEvent) {
        VRIMemberDescription vRIMemberDescription = this.toMember(string);
        if (string == null || vRIMemberDescription == null) {
            Tr.warning(TC, "DCSV0003", new Object[]{this._thisStackName, this._thisMember.getName(), "handleDeadSourceEvent() - Undefined member " + string});
            return;
        }
        if (unicastConnectionIf == null) {
            Tr.warning(TC, "DCSV0003", new Object[]{this._thisStackName, this._thisMember.getName(), "handleDeadSourceEvent() - null connection " + string});
            return;
        }
        boolean bl = this.removeNode(string, unicastConnectionIf);
        if (bl) {
            this._adapter.connectedMemberRemoved(vRIMemberDescription, dCSSuspectEvent);
        }
    }

    private boolean removeNode(String string, UnicastConnectionIf unicastConnectionIf) {
        boolean bl;
        boolean bl2 = false;
        UnicastConnectionIf unicastConnectionIf2 = (UnicastConnectionIf)this.getConnectionForMember(string);
        if (unicastConnectionIf.equals(unicastConnectionIf2)) {
            Long l = this.removeStreamForMember(string);
            this._group.rejectReceiverStream(l);
            bl2 = true;
        }
        if (bl = ((DiscoveryRmmPtpGroup)this._group).removeNode(string, unicastConnectionIf)) {
            bl2 = true;
        }
        return bl2;
    }
}

