/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.connected;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.receiver.RMReceiver;
import com.ibm.rmm.receiver.StreamSelector;
import com.ibm.rmm.transmitter.RMTransmitter;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.Job;
import com.ibm.ws.dcs.vri.common.JobsProcessorThread;
import com.ibm.ws.dcs.vri.common.MetaMessageFactory;
import com.ibm.ws.dcs.vri.common.ThreadManager;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberLayerData;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.impl.BaseVRIMessage;
import com.ibm.ws.dcs.vri.common.nls.RcvBadMemberEvent;
import com.ibm.ws.dcs.vri.common.nls.RcvNonDefinedMemberEvent;
import com.ibm.ws.dcs.vri.common.nls.TASuspectDownUpCase;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.ConnectedChannel;
import com.ibm.ws.dcs.vri.transportAdapter.ConnectedChannelListener;
import com.ibm.ws.dcs.vri.transportAdapter.TransportGroupEvent;
import com.ibm.ws.dcs.vri.transportAdapter.TransportInternalException;
import com.ibm.ws.dcs.vri.transportAdapter.TransportNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.MyAddressResolver;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RcvBadMemberListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RmmChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RmmNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.connected.ConnectedTopicNameAnalyzer;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.connected.RcvMembersDefinedSet;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmReceiverEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.PtpNodeData;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.RMMGroup;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.RmmGroupListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.TransmitterThread;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;

public abstract class RmmConnectedChannel
extends RmmChannel
implements ConnectedChannel,
RmmGroupListener,
StreamSelector,
RcvBadMemberListener,
DCSTraceContext {
    private boolean _closed = false;
    protected int _hbtTimeout;
    private final JobsProcessorThread _rcvBadMemberThread;
    protected final MetaMessageFactory _inMsgFactory;
    protected Object _stackMutex;
    private static TraceComponent TC = Tr.register(RmmConnectedChannel.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    final String CONNECTED_TOPIC_NAME;
    protected RcvMembersDefinedSet _rcvDefinedMembers;
    protected ConnectedChannelListener _adapter;
    protected RMMGroup _group;
    protected ConnectedTopicNameAnalyzer _topicAnalyzer;
    protected HashMap _sourceStreamMap;
    protected RMReceiver _rmr;
    protected RMTransmitter _rmt;
    protected long _transCloseWaitTime;
    protected TransmitterThread _transmitter;
    private final String _threadName;
    protected final MyAddressResolver _myAddressResolver;

    public RmmConnectedChannel(ConnectedChannelListener connectedChannelListener, VRIMembersMGR vRIMembersMGR, VRIMemberDescription vRIMemberDescription, String string, Object object, RMTransmitter rMTransmitter, RMReceiver rMReceiver, long l, TransmitterThread transmitterThread, MetaMessageFactory metaMessageFactory, int n, MyAddressResolver myAddressResolver) {
        super(vRIMembersMGR, vRIMemberDescription, string);
        this._hbtTimeout = n;
        this._adapter = connectedChannelListener;
        this._stackMutex = object;
        this._sourceStreamMap = new HashMap();
        this._rmr = rMReceiver;
        this._rmt = rMTransmitter;
        this._transmitter = transmitterThread;
        this._myAddressResolver = myAddressResolver;
        this._topicAnalyzer = new ConnectedTopicNameAnalyzer(this.getTransType(), string, this._thisMember.getName(), this._myAddressResolver.getMyNodeTopicStr());
        this.CONNECTED_TOPIC_NAME = this._topicAnalyzer.createTopicName();
        this._transCloseWaitTime = l;
        this._inMsgFactory = metaMessageFactory;
        this._threadName = this.getClass().getName() + "|" + this._thisMember.getName() + "|" + this._thisStackName;
        this._rcvBadMemberThread = ThreadManager.getThread(this._threadName, ThreadManager.INTERNAL_THREAD, 5);
        if (this._rcvBadMemberThread == null) {
            throw new TransportInternalException("RmmConnectedChannel.RmmConnectedChannel failed To Get Thread");
        }
    }

    protected abstract String getTransType();

    public void removeDefinedMember(VRIMemberDescription vRIMemberDescription) {
        this._rcvDefinedMembers.removeDefinedMember(vRIMemberDescription);
        this.removeNode(vRIMemberDescription.getName());
    }

    protected abstract RmmNode toRmmNode(String var1);

    protected RmmNode toRmmNode(VRIMemberDescription vRIMemberDescription) {
        if (vRIMemberDescription == null) {
            return null;
        }
        return this.toRmmNode(vRIMemberDescription.getName());
    }

    protected void removeNode(String string) {
        RmmNode rmmNode;
        if (string == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "The removed node is null", "RmmConnectedChannel.removeNode()", null);
                dCSTraceBuffer.invoke();
            }
            return;
        }
        Long l = this.removeStreamForMember(string);
        if (l != null) {
            this._group.rejectReceiverStream(l);
        }
        if ((rmmNode = this.toRmmNode(string)) != null) {
            this._group.removeNode(this.toRmmNode(string));
        }
    }

    public boolean mcastMessage(byte[] byArray, int n, int n2) {
        return this._group.mcast(byArray, n, n2);
    }

    public boolean mcastMessage(byte[] byArray, int n, int n2, VRIMemberDescription[] vRIMemberDescriptionArray) {
        return this._group.mcast(byArray, n, n2, vRIMemberDescriptionArray);
    }

    public void close() {
        this._closed = true;
        this._group.close();
        ThreadManager.releaseThread(this._threadName);
    }

    public void synced() {
        if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Sync is not supported in the connected channel", "RmmConnectedChannel.synced()", null);
            dCSTraceBuffer.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(BaseVRIMessage baseVRIMessage) {
        Object object = this._stackMutex;
        synchronized (object) {
            String string = this.getName(baseVRIMessage.getSourceTopicName());
            if (string == null) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Null sender", "RmmConnectedChannel.onMessage()", null);
                    dCSTraceBuffer.addProperty("TopicName", Utils.toPrintableString(baseVRIMessage.getSourceTopicName()));
                    dCSTraceBuffer.invoke();
                }
                return;
            }
            if (!this.isStreamActive(baseVRIMessage.getSourceStreamID(), string)) {
                return;
            }
            try {
                VRIMemberDescription vRIMemberDescription = this.toMember(string);
                if (vRIMemberDescription == null) {
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmConnectedChannel.onMessage()", "Member has null member description");
                        dCSTraceBuffer.addProperty("InetAddress", baseVRIMessage.getSourceAddress());
                        dCSTraceBuffer.addProperty("Port", baseVRIMessage.getSourcePort());
                        dCSTraceBuffer.addProperty("Sender", string);
                        dCSTraceBuffer.invoke();
                    }
                    return;
                }
                if (!vRIMemberDescription.isConnected()) {
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmConnectedChannel.onMessage()", "Sender is not connected");
                        dCSTraceBuffer.addProperty("Sender", string);
                        dCSTraceBuffer.invoke();
                    }
                    return;
                }
                baseVRIMessage.changeSender(string);
                this._adapter.deliver(baseVRIMessage);
            }
            catch (RuntimeException runtimeException) {
                this._adapter.requestTermination(new TerminationEvent((DCSTraceContext)this, "onMessage()", runtimeException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(TransportGroupEvent transportGroupEvent) {
        Object object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("RmmEvent", transportGroupEvent.getDescription());
        dCSTraceBuffer.addProperty("ClassName", transportGroupEvent.getClass().getName());
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "RmmConnectedChannel.onEvent()", null);
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).invoke();
        }
        object = null;
        if (!(transportGroupEvent instanceof RmmReceiverEvent)) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.internalWarning(this, "Got unknown event type", "RmmConnectedChannel.onEvent()", null);
                dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer2.invoke();
            }
            return;
        }
        object = (RmmReceiverEvent)transportGroupEvent;
        Object object2 = this._stackMutex;
        synchronized (object2) {
            try {
                if (((RmmReceiverEvent)object).isCongestion()) {
                    if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.internalWarning(this, "Congestion event is not handled in the connected", "RmmConnectedChannel.onEvent()", null);
                        dCSTraceBuffer3.mergePropertyList(dCSTraceBuffer);
                        dCSTraceBuffer3.invoke();
                    }
                    return;
                }
                String string = this.getName(((RmmReceiverEvent)object).getTopicName());
                ((RmmEvent)object).setSource(string);
                if (string == null) {
                    if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer4 = DCSTraceBuffer.internalWarning(this, "Null Sender", "RmmConnectedChannel.onEvent()", null);
                        dCSTraceBuffer4.mergePropertyList(dCSTraceBuffer);
                        dCSTraceBuffer4.invoke();
                    }
                    return;
                }
                if (((TransportGroupEvent)object).getType() == 10) {
                    this.handleNewSource((RmmReceiverEvent)object, string);
                    return;
                }
                if (((TransportGroupEvent)object).getType() == 2 || ((TransportGroupEvent)object).getType() == 1 || ((TransportGroupEvent)object).getType() == 5 || ((TransportGroupEvent)object).getType() == 20) {
                    if (this.isStreamActive(((RmmEvent)object).getStreamId(), ((RmmReceiverEvent)object).getSourceName())) {
                        this.handleDeadSourceEvent(string, ((RmmEvent)object).toSuspectEvent());
                        if (DCSTraceBuffer.isEventEnabled(TC)) {
                            DCSTraceBuffer dCSTraceBuffer5 = DCSTraceBuffer.event(this, "RmmConnectedChannel.onEvent()", "Stream is active, called handleDeadSource()");
                            dCSTraceBuffer5.addProperty("memberName", string);
                            dCSTraceBuffer5.addProperty("StreamId", ((RmmEvent)object).getStreamId());
                            dCSTraceBuffer5.addProperty("Type", ((TransportGroupEvent)object).getType());
                            dCSTraceBuffer5.invoke();
                        }
                    } else {
                        boolean bl = this.removeFromCandidatesMap(((RmmReceiverEvent)object).getSourceName(), ((RmmEvent)object).getStreamId());
                        if (DCSTraceBuffer.isEventEnabled(TC)) {
                            DCSTraceBuffer dCSTraceBuffer6 = DCSTraceBuffer.event(this, "RmmConnectedChannel.onEvent()", "Stream is not active");
                            dCSTraceBuffer6.addProperty("memberName", string);
                            dCSTraceBuffer6.addProperty("StreamId", ((RmmEvent)object).getStreamId());
                            dCSTraceBuffer6.addProperty("Removed from candidates", bl);
                            dCSTraceBuffer6.addProperty("Type", ((TransportGroupEvent)object).getType());
                            dCSTraceBuffer6.invoke();
                        }
                    }
                    return;
                }
                if (((TransportGroupEvent)object).getType() == 20) {
                    this._group.rejectReceiverStream(((RmmEvent)object).getStreamId());
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer7 = DCSTraceBuffer.event(this, "RmmConnectedChannel.onEvent()", "Stream is not present at source");
                        dCSTraceBuffer7.addProperty("memberName", string);
                        dCSTraceBuffer7.addProperty("StreamId", ((RmmEvent)object).getStreamId());
                        dCSTraceBuffer7.addProperty("Type", ((TransportGroupEvent)object).getType());
                        dCSTraceBuffer7.invoke();
                    }
                    return;
                }
            }
            catch (RuntimeException runtimeException) {
                this._adapter.requestTermination(new TerminationEvent((DCSTraceContext)this, "onEvent()", runtimeException));
            }
        }
    }

    protected boolean isStreamActive(long l, String string) {
        Long l2 = new Long(l);
        Long l3 = this.getStreamForMember(string);
        boolean bl = l2.equals(l3);
        if (!bl && DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmConnectedChannel.isStreamActive()", "Got event/message on an inactive stream");
            dCSTraceBuffer.addProperty("Received", "StreamId", l2);
            dCSTraceBuffer.addProperty("Current", "StreamId", l3);
            dCSTraceBuffer.addProperty("Sender", string);
            dCSTraceBuffer.invoke();
        }
        return bl;
    }

    protected String getName(String string) {
        return this._topicAnalyzer.parseSenderName(string);
    }

    protected void handleDeadSourceEvent(String string, DCSSuspectEvent dCSSuspectEvent) {
        VRIMemberDescription vRIMemberDescription = this.toMember(string);
        if (string == null || vRIMemberDescription == null) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmConnectedChannel.handleDeadSourceEvent()", "Member has been already removed from connected");
                dCSTraceBuffer.addProperty("memberName", string);
                dCSTraceBuffer.addProperty("Reason", dCSSuspectEvent);
                dCSTraceBuffer.invoke();
            }
            return;
        }
        this.removeNode(string);
        this._adapter.connectedMemberRemoved(vRIMemberDescription, dCSSuspectEvent);
    }

    private void handleNewSource(RmmReceiverEvent rmmReceiverEvent, String string) {
        DCSTraceBuffer dCSTraceBuffer;
        Object object;
        String string2 = rmmReceiverEvent.getTopicName();
        InetAddress inetAddress = rmmReceiverEvent.getSourceAddress();
        int n = rmmReceiverEvent.getSourcePort();
        long l = rmmReceiverEvent.getStreamId();
        Object object2 = rmmReceiverEvent.getObjectId();
        VRIMemberDescription vRIMemberDescription = this._mmgr.getDefinedMember(string);
        DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.propertyList();
        dCSTraceBuffer2.addProperty("TopicName", Utils.toPrintableString(string2));
        dCSTraceBuffer2.addProperty("InetAddress", inetAddress);
        dCSTraceBuffer2.addProperty("Port", n);
        dCSTraceBuffer2.addProperty("Received", "StreamId", l);
        dCSTraceBuffer2.addProperty("memberName", string);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "RmmConnectedChannel.handleNewSource()", null);
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer2);
            ((DCSTraceBuffer)object).invoke();
        }
        if (inetAddress == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object = DCSTraceBuffer.internalWarning(this, "Null source address", "RmmConnectedChannel.handleNewSource()", null);
                ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer2);
                ((DCSTraceBuffer)object).invoke();
            }
            return;
        }
        if (!this.acceptStream(string2, l, inetAddress, n)) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object = DCSTraceBuffer.internalWarning(this, "The stream is not accepted anymore - Ignore event", "RmmConnectedChannel.handleNewSource()", null);
                ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer2);
                ((DCSTraceBuffer)object).invoke();
            }
            return;
        }
        if (this._sourceStreamMap.containsKey(string)) {
            object = (Long)this._sourceStreamMap.get(string);
            dCSTraceBuffer2.addProperty("Current", "StreamId", object);
            if ((Long)object == l) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.internalWarning(this, "Ignore redundant new source call", "RmmConnectedChannel.handleNewSource()", null);
                    dCSTraceBuffer3.mergePropertyList(dCSTraceBuffer2);
                    dCSTraceBuffer3.invoke();
                }
                return;
            }
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmConnectedChannel.handleNewSource()", "Identified Down/Up case");
                dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
                dCSTraceBuffer.invoke();
            }
            this.removeNode(string);
            this._adapter.connectedMemberRemoved(vRIMemberDescription, new TASuspectDownUpCase((DCSTraceContext)this, string, this.getDcsChannel()));
        }
        object = this.createRmmNodeData(inetAddress, n, string, object2);
        dCSTraceBuffer2.addProperty((DCSTraceable)object);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmConnectedChannel.handleNewSource()", "Created RMM node data");
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
        if (this.addNodeToGroup((PtpNodeData)object)) {
            this._mmgr.setMemberLayerData(string, (VRIMemberLayerData)object);
            this._sourceStreamMap.put(string, new Long(l));
            this._adapter.newConnectedMember(vRIMemberDescription, (TransportNode)object);
        } else {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Failed to add node", "RmmConnectedChannel.handleNewSource()", null);
                dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
                dCSTraceBuffer.invoke();
            }
            this._group.rejectReceiverStream(l);
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "RmmConnectedChannel.handleNewSource()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
    }

    protected abstract DCSLogicalChannel getDcsChannel();

    protected abstract boolean addNodeToGroup(PtpNodeData var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(DCSTerminationEvent dCSTerminationEvent) {
        Object object = this._stackMutex;
        synchronized (object) {
            this._adapter.requestTermination(dCSTerminationEvent);
        }
    }

    public void start(VRIMemberDescription[] vRIMemberDescriptionArray) {
        this._rcvDefinedMembers = new RcvMembersDefinedSet(this._thisMember.getName(), this._thisStackName);
        try {
            this._rcvDefinedMembers.setDefinedMembers(vRIMemberDescriptionArray);
        }
        catch (UnknownHostException unknownHostException) {
            this._adapter.requestTermination(new TerminationEvent((DCSTraceContext)this, "start()", unknownHostException));
        }
    }

    public void addDefinedMember(VRIMemberDescription vRIMemberDescription) {
        try {
            this._rcvDefinedMembers.addDefinedMember(vRIMemberDescription);
        }
        catch (UnknownHostException unknownHostException) {
            this._adapter.requestTermination(new TerminationEvent((DCSTraceContext)this, "addDefinedMembers", unknownHostException));
        }
        this._group.refreshReceiverRejectedStreams();
    }

    public boolean acceptStream(byte[] byArray, int n, long l, InetAddress inetAddress, int n2) {
        Object object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("InetAddress", inetAddress);
        dCSTraceBuffer.addProperty("Port", n2);
        dCSTraceBuffer.addProperty("StreamId", l);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "RmmConnectedChannel.acceptStream()", null);
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).invoke();
        }
        if (inetAddress == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object = DCSTraceBuffer.internalWarning(this, "Null source address", "RmmConnectedChannel.acceptStream()", null);
                ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
                ((DCSTraceBuffer)object).invoke();
            }
            return false;
        }
        object = null;
        try {
            object = Sutils.bytesToString(byArray, n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.internalWarning(this, "Got Exception", "RmmConnectedChannel.acceptStream()", unsupportedEncodingException);
                dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer2.invoke();
            }
            return false;
        }
        return this.acceptStream((String)object, l, inetAddress, n2);
    }

    protected boolean acceptStream(String string, long l, InetAddress inetAddress, int n) {
        Object object;
        boolean bl = true;
        String string2 = null;
        if (!this._topicAnalyzer.parseIsSameStackPrefix(string)) {
            bl = false;
            string2 = "Stream is not of CONNECTED topic of this stack";
        }
        String string3 = null;
        if (bl && !this._rcvDefinedMembers.isMemberDefined(string3 = this._topicAnalyzer.parseSenderName(string))) {
            bl = false;
            string2 = "Sender name is not defined";
            if (!this._thisMember.getName().equals(string3)) {
                object = new RcvNonDefinedMemberEvent(this, string3, inetAddress, null);
                this.notifyRcvBadMember((RcvBadMemberEvent)object);
            }
        }
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("memberName", string3);
        dCSTraceBuffer.addProperty("TopicName", Utils.toPrintableString(string));
        dCSTraceBuffer.addProperty("StreamId", l);
        dCSTraceBuffer.addProperty("InetAddress", inetAddress.getHostAddress());
        dCSTraceBuffer.addProperty("Port", n);
        dCSTraceBuffer.addProperty("MethodResult", bl);
        if (bl) {
            object = "Accept";
        } else {
            object = "Reject";
            dCSTraceBuffer.addProperty("RejectReason", string2);
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this, "RmmConnectedChannel.acceptStream()", (String)object);
            dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer2.invoke();
        }
        if (bl) {
            this._adapter.focus("acceptStream", (String)object, dCSTraceBuffer);
        }
        return bl;
    }

    protected abstract PtpNodeData createRmmNodeData(InetAddress var1, int var2, String var3, Object var4);

    public String dump() {
        return "\n**************** RmmConnectedChannel.dump: **************************\n" + this._thisStackName + ", definedMembers: " + this._rcvDefinedMembers.toString() + ", sourceStreamMap: " + this._sourceStreamMap.toString() + this._group.dump();
    }

    public void notifyRcvBadMember(RcvBadMemberEvent rcvBadMemberEvent) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmConnectedChannel.notifyRcvBadMember()", "Raising event on a different thread");
            dCSTraceBuffer.addProperty(rcvBadMemberEvent);
            dCSTraceBuffer.invoke();
        }
        this._rcvBadMemberThread.enqueueJob(new ConnectedRcvBadMemberJob(rcvBadMemberEvent, this._threadName, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rcvBadMember(RcvBadMemberEvent rcvBadMemberEvent) {
        Object object = this._stackMutex;
        synchronized (object) {
            try {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmConnectedChannel.rcvBadMember()", "After lock");
                    dCSTraceBuffer.addProperty(rcvBadMemberEvent);
                    dCSTraceBuffer.invoke();
                }
                this._adapter.rcvBadMember(rcvBadMemberEvent);
            }
            catch (RuntimeException runtimeException) {
                this._adapter.requestTermination(new TerminationEvent((DCSTraceContext)this, "rcvBadMember", runtimeException));
            }
        }
    }

    public String getLayerName() {
        return DCSConstants.TRACE_LAYER_NAMES[1];
    }

    public String getMemberName() {
        return this._thisMember.getName();
    }

    public String getStackName() {
        return this._thisStackName;
    }

    public void focus(String string, DCSTraceBuffer dCSTraceBuffer) {
        this._adapter.focus(string, dCSTraceBuffer);
    }

    public void focus(String string, String string2, DCSTraceBuffer dCSTraceBuffer) {
        this._adapter.focus(string, string2, dCSTraceBuffer);
    }

    public void focus(String string) {
        this._adapter.focus(string);
    }

    protected boolean removeFromCandidatesMap(String string, long l) {
        return false;
    }

    protected final Long removeStreamForMember(String string) {
        StreamData streamData = (StreamData)this._sourceStreamMap.remove(string);
        if (streamData == null) {
            return null;
        }
        return streamData._sid;
    }

    protected final Long getStreamForMember(String string) {
        StreamData streamData = (StreamData)this._sourceStreamMap.get(string);
        if (streamData == null) {
            return null;
        }
        return streamData._sid;
    }

    protected final Object getConnectionForMember(String string) {
        StreamData streamData = (StreamData)this._sourceStreamMap.get(string);
        if (streamData == null) {
            return null;
        }
        return streamData._connection;
    }

    protected void addStreamForMember(String string, long l, Object object) {
        this._sourceStreamMap.put(string, new StreamData(new Long(l), object));
    }

    private class StreamData {
        final Long _sid;
        final Object _connection;

        private StreamData(Long l, Object object) {
            this._sid = l;
            this._connection = object;
        }
    }

    protected final class ConnectedRcvBadMemberJob
    implements Job {
        private final String _owner;
        private final RcvBadMemberEvent _event;
        private final DCSTraceContext _dtc;

        public ConnectedRcvBadMemberJob(RcvBadMemberEvent rcvBadMemberEvent, String string, DCSTraceContext dCSTraceContext) {
            this._event = rcvBadMemberEvent;
            this._owner = string;
            this._dtc = dCSTraceContext;
        }

        public void process() {
            RmmConnectedChannel.this.rcvBadMember(this._event);
        }

        public void cancel() {
            if (!RmmConnectedChannel.this._closed && DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._dtc, "Job was canceled", "ConnectedRcvBadMemberJob.cancel()", null);
                dCSTraceBuffer.addProperty("Owner", this._owner);
                dCSTraceBuffer.invoke();
            }
        }

        public void handleError(Throwable throwable) {
            RmmConnectedChannel.this._adapter.requestTermination(new TerminationEvent(this._dtc, "ConnectedRcvBadMemberJob", throwable));
        }

        public String getOwner() {
            return this._owner;
        }
    }
}

