/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events;

import com.ibm.rmm.receiver.Event;
import com.ibm.ws.dcs.common.event.DCSNLSEvent;
import com.ibm.ws.dcs.vri.common.nls.IncomingCongestionNormal;
import com.ibm.ws.dcs.vri.common.nls.IncomingCongestionWarning;
import com.ibm.ws.dcs.vri.common.nls.SouthLayersNLSEvent;
import com.ibm.ws.dcs.vri.common.nls.TAConnectionClosingEvent;
import com.ibm.ws.dcs.vri.common.nls.TASuspectHbtTimeout;
import com.ibm.ws.dcs.vri.common.nls.TASuspectHeavySender;
import com.ibm.ws.dcs.vri.common.nls.TASuspectUnrecoverablePacket;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmEvent;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.Properties;

public abstract class RmmReceiverEvent
extends RmmEvent {
    protected Event _event;
    public static final int PACKET_LOSS = 1;
    public static final int HEARTBEAT_TIMEOUT = 2;
    public static final int CLOSED_TRANS = 5;
    public static final int NEW_SOURCE = 10;
    public static final int MEMORY_ALERT_ON = 101;
    public static final int MEMORY_ALERT_OFF = 102;
    public static final int MESSAGE_OUT_OF_MEMORY = 103;
    public static final int BUFFER_OVERFLOW = 100;
    public static final int STREAM_NOT_PRESENT_AT_SOURCE = 20;
    private Properties _details;
    private final DCSLogicalChannel _logicalDCSChannel;
    private final int _configHbtTimeout;

    protected RmmReceiverEvent(Event event2, DCSLogicalChannel dCSLogicalChannel, DCSTraceContext dCSTraceContext, int n) {
        super(event2.getType(), event2.getStreamId(), dCSTraceContext);
        this._event = event2;
        this._logicalDCSChannel = dCSLogicalChannel;
        this._configHbtTimeout = n;
    }

    public String getTopicName() {
        try {
            return this._event.getTopicName();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String getDescription() {
        return this._event.getDescription();
    }

    public long getLongField() {
        return this._event.getLongField();
    }

    public int getIntField() {
        return this._event.getIntField();
    }

    public Object getObjectId() {
        return this._event.getObjectField();
    }

    public InetAddress getSourceAddress() {
        return this._event.getSourceAddress();
    }

    public int getSourcePort() {
        return this._event.getSourcePort();
    }

    public String getSourceName() {
        return (String)this.getSource();
    }

    public boolean isCongestion() {
        switch (this._type) {
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return true;
            }
        }
        return false;
    }

    public Properties getDetails() {
        return this._details;
    }

    public void setDetails(Properties properties) {
        this._details = properties;
    }

    public DCSNLSEvent toNLSEvent() {
        SouthLayersNLSEvent southLayersNLSEvent = null;
        switch (this._type) {
            case 1: {
                southLayersNLSEvent = new TASuspectUnrecoverablePacket(this._dcsTC, this.getSourceName(), this._logicalDCSChannel);
                break;
            }
            case 2: {
                southLayersNLSEvent = new TASuspectHbtTimeout(this._dcsTC, this.getSourceName(), this._configHbtTimeout, this._logicalDCSChannel);
                break;
            }
            case 5: {
                southLayersNLSEvent = new TAConnectionClosingEvent(this._dcsTC, this.getSourceName(), this._logicalDCSChannel.toString() + ", receiver closed");
                break;
            }
            case 20: {
                southLayersNLSEvent = new TAConnectionClosingEvent(this._dcsTC, this.getSourceName(), this._logicalDCSChannel.toString() + ", STREAM_NOT_PRESENT_AT_SOURCE");
                break;
            }
            case 101: {
                southLayersNLSEvent = new IncomingCongestionWarning(this._dcsTC, this.getSourceName(), this.getDetails());
                break;
            }
            case 100: 
            case 103: {
                southLayersNLSEvent = new TASuspectHeavySender(this._dcsTC, this.getSourceName(), this.getDetails());
                break;
            }
            case 102: {
                southLayersNLSEvent = new IncomingCongestionNormal(this._dcsTC);
                break;
            }
            default: {
                southLayersNLSEvent = null;
            }
        }
        return southLayersNLSEvent;
    }
}

