/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.mcastUtils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.config.DCSIllegalConfigurationException;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class McastIpAllocator
implements DCSTraceContext {
    private static TraceComponent TC = Tr.register(McastIpAllocator.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private final InetAddress _start;
    private final int _range;
    private final String _thisMemberName;
    private final String _thisStackName;

    public McastIpAllocator(InetAddress inetAddress, InetAddress inetAddress2, String string, String string2) {
        this._thisMemberName = string;
        this._thisStackName = string2;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "McastIpAllocator.McastIpAllocator()", "Created Multicast address range");
            dCSTraceBuffer.addProperty("Start", "McastAddress", inetAddress);
            dCSTraceBuffer.addProperty("End", "McastAddress", inetAddress2);
            dCSTraceBuffer.invoke();
        }
        this.assertAddressesValidity(inetAddress2, inetAddress);
        this._start = inetAddress;
        this._range = this.minus(inetAddress2, inetAddress) + 1;
    }

    private void assertAddressesValidity(InetAddress inetAddress, InetAddress inetAddress2) {
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = inetAddress2.getAddress();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = this.toUnsigned(byArray[i]);
            if (n3 < (n2 = this.toUnsigned(byArray2[i]))) {
                throw new DCSIllegalConfigurationException("McastIpAllocator: End range address - " + inetAddress + " - is smaller than Start range address - " + inetAddress2);
            }
            if (n3 > n2) break;
        }
    }

    public InetAddress allocateFirstIp() {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "McastIpAllocator.allocateFirstIp()", "Allocated the first Multicast IP address");
            dCSTraceBuffer.addProperty("McastAddress", this._start);
            dCSTraceBuffer.invoke();
        }
        return this._start;
    }

    public InetAddress allocateIp(String string) throws UnknownHostException {
        InetAddress inetAddress = this.plus(this._start, Math.abs(string.hashCode()) % this._range);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "McastIpAllocator.allocateIp()", "Allocated multicast group for client");
            dCSTraceBuffer.addProperty("McastGroupClient", string);
            dCSTraceBuffer.addProperty("McastAddress", inetAddress);
            dCSTraceBuffer.invoke();
        }
        return inetAddress;
    }

    private int minus(InetAddress inetAddress, InetAddress inetAddress2) {
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = inetAddress2.getAddress();
        int n = byArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            int n2 = this.toUnsigned(byArray[i]);
            int n3 = this.toUnsigned(byArray2[i]);
            double d2 = n2 - n3;
            d += d2 * Math.pow(256.0, n - i - 1);
        }
        if (d > 2.147483647E9 || d < 0.0) {
            return Integer.MAX_VALUE;
        }
        return (int)d;
    }

    private InetAddress plus(InetAddress inetAddress, int n) throws UnknownHostException {
        byte[] byArray = new byte[inetAddress.getAddress().length];
        System.arraycopy(inetAddress.getAddress(), 0, byArray, 0, byArray.length);
        byte[] byArray2 = new byte[4];
        int n2 = 3;
        byArray2[n2--] = (byte)(n & 0xFF);
        byArray2[n2--] = (byte)((n >>>= 8) & 0xFF);
        byArray2[n2--] = (byte)((n >>>= 8) & 0xFF);
        byArray2[n2--] = (byte)((n >>>= 8) & 0xFF);
        int n3 = byArray.length - 1;
        int n4 = 0;
        for (int i = 3; i >= 0; --i) {
            int n5 = this.toUnsigned(byArray[n3]);
            int n6 = this.toUnsigned(byArray2[i]);
            int n7 = n5 + n6 + n4;
            byArray[n3] = (byte)(n7 % 256);
            n4 = n7 / 256;
            --n3;
        }
        return InetAddress.getByAddress(byArray);
    }

    public int toUnsigned(byte n) {
        return n < 0 ? 256 + n : n;
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._thisStackName;
    }

    public String getMemberName() {
        return this._thisMemberName;
    }

    public String getLayerName() {
        return DCSConstants.TRACE_LAYER_NAMES[1];
    }
}

