/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery;

import com.ibm.ws.dcs.utils.Alarm;
import com.ibm.ws.dcs.vri.common.Utils;
import java.util.Random;

public abstract class DiscoveryNodePolicy {
    Alarm _alarm;
    private static final Random _rand = new Random();
    private static final double RAND_COEF = 0.1;
    private int ACCELERATE_TIMES = 20;
    private int _acceleratedCounter = this.ACCELERATE_TIMES + 1;
    private static final double ACCELERATE_FACTOR = 0.2;
    private static final long MIN_ACCELERATION_INTERVAL_MSEC = 5000L;

    abstract long getNextTime();

    abstract long getBaseTime();

    public synchronized void setAlarm(Alarm alarm) {
        this._alarm = alarm;
    }

    public synchronized void cancelAlarm() {
        if (this._alarm != null) {
            this._alarm.cancel();
            this._alarm = null;
        }
        this._acceleratedCounter = 0;
    }

    private synchronized long randomizeTime(long l) {
        int n = (int)(0.1 * (double)l);
        int n2 = _rand.nextInt(n);
        return l + (long)(n2 -= (int)((double)n * 0.5));
    }

    public synchronized boolean accelerate() {
        if (this._alarm == null || this._acceleratedCounter >= this.ACCELERATE_TIMES) {
            this._acceleratedCounter = 0;
            return true;
        }
        return false;
    }

    private synchronized boolean isAccelerated() {
        if (this._acceleratedCounter > this.ACCELERATE_TIMES) {
            return false;
        }
        ++this._acceleratedCounter;
        return true;
    }

    private synchronized long getAcceleratedTime(long l) {
        return (long)Math.min(0.2 * (double)l, 5000.0);
    }

    protected long getNextTime(long l) {
        if (this._acceleratedCounter == 0) {
            this._acceleratedCounter = 1;
            return 1L;
        }
        if (this.isAccelerated()) {
            return this.randomizeTime(this.getAcceleratedTime(l));
        }
        return this.randomizeTime(l);
    }

    public String toString() {
        return Utils.getShortClassName(this.getClass()) + " BaseTime= " + this.getBaseTime();
    }
}

