/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmm.receiver.AdvancedMessageListener;
import com.ibm.rmm.receiver.Event;
import com.ibm.rmm.receiver.Message;
import com.ibm.rmm.receiver.QueueR;
import com.ibm.rmm.receiver.RMReceiver;
import com.ibm.rmm.receiver.StreamSelector;
import com.ibm.rmm.util.RMMRejectAndCloseConnectionException;
import com.ibm.rmm.util.UnicastConnectionIf;
import com.ibm.ws.dcs.common.MemberAuthenticator;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.vri.common.Job;
import com.ibm.ws.dcs.vri.common.JobsProcessorThread;
import com.ibm.ws.dcs.vri.common.ThreadManager;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.nls.RcvNonDefinedMemberEvent;
import com.ibm.ws.dcs.vri.common.nls.TASuspectDownUpCase;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import com.ibm.ws.dcs.vri.transportAdapter.TransportAdapter;
import com.ibm.ws.dcs.vri.transportAdapter.TransportInternalException;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RmmUtils;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmPtpReceiverEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryServerMgr;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoverySubServer;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryTopicNameAnalyzer;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.PtpRmmNode;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;

public class DiscoveryRcv
extends DiscoverySubServer
implements StreamSelector,
AdvancedMessageListener {
    private static final TraceComponent TC = Tr.register(DiscoveryRcv.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private JobsProcessorThread _thread;
    private final String _threadName;
    private final int _hbtTimeout;
    private Map _liveRcvNodesStreams = new HashMap();
    private RMReceiver _rmr;
    private final QueueR _queueR;
    private final int _version;
    private final DCSTraceContext _dtc;

    public DiscoveryRcv(DiscoveryServerMgr discoveryServerMgr, RMReceiver rMReceiver, DiscoveryTopicNameAnalyzer discoveryTopicNameAnalyzer, MemberAuthenticator memberAuthenticator, String string, String string2, DCSLogicalChannel dCSLogicalChannel, int n, int n2) {
        super(discoveryServerMgr, string, string2, memberAuthenticator, discoveryTopicNameAnalyzer, dCSLogicalChannel);
        this._dtc = new DCSTraceContextImpl(TC, string, string2, TransportAdapter.TA_LAYER_NAME);
        this._rmr = rMReceiver;
        this._hbtTimeout = n;
        this._version = n2;
        this._threadName = "DiscoveryRcv|" + string;
        this._thread = ThreadManager.getThread(this._threadName, ThreadManager.DISCOVERY_THREAD, 5);
        if (this._thread == null) {
            throw new TransportInternalException("DiscoveryRcv.DiscoveryRcv(): " + string + ": Failed to create thread");
        }
        this._queueR = this._rmr.createQueueReceiver(this);
        if (this._queueR == null) {
            throw new TransportInternalException("DiscoveryServerImpl.DiscoveryServerImpl: Failed to open QueueR");
        }
        this._queueR.setAdvancedMessageListener(this);
        this._queueR.refreshStreamList();
    }

    public void onMessage(Message message) {
        DiscoverRcvMsgJob discoverRcvMsgJob = new DiscoverRcvMsgJob(message);
        this._thread.enqueueJob(discoverRcvMsgJob);
    }

    public void onEvent(Event event2) {
        DiscoverRcvEventJob discoverRcvEventJob = new DiscoverRcvEventJob(event2);
        this._thread.enqueueJob(discoverRcvEventJob);
    }

    public boolean acceptStream(byte[] byArray, int n, long l, InetAddress inetAddress, int n2) {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._dtc, "DiscoverRcv.acceptStream() - Starting", null);
            ((DCSTraceBuffer)object).addProperty("StreamId", l);
            ((DCSTraceBuffer)object).addProperty("InetAddress", inetAddress);
            ((DCSTraceBuffer)object).addProperty("My", "Version", this.printVersion(this._version));
            ((DCSTraceBuffer)object).invoke();
        }
        if (!this._topicAnalyzer.parseIsSameStackPrefix(byArray, 0, n)) {
            return false;
        }
        object = this._topicAnalyzer.parseSenderName(byArray, 0, n);
        Integer n3 = this._topicAnalyzer.parseVersion(byArray, 0, n);
        if (n3 == null) {
            Tr.warning(TC, "DCSV0003", new Object[]{this._coreStackName, this._memberName, "acceptStream() - Failed to get discovery version"});
            return false;
        }
        if (this._version != n3) {
            Tr.warning(TC, "DCSV0003", new Object[]{this._coreStackName, this._memberName, "acceptStream() - Incompatible discovery version " + n3});
            return false;
        }
        byte[] byArray2 = this._topicAnalyzer.parseToken(byArray, 0, n);
        if (object == null) {
            Tr.warning(TC, "DCSV0003", new Object[]{this._coreStackName, this._memberName, "acceptStream() - null sender"});
            return false;
        }
        boolean bl = this._authenticator.authenticateMember(this._coreStackName, (String)object, byArray2, inetAddress);
        if (!bl) {
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._dtc, "DiscoverRcv.acceptStream()", (String)object);
                dCSTraceBuffer.addProperty("Report", "Authentication Failed - Reject stream and close connection");
                dCSTraceBuffer.invoke();
            }
            throw new RMMRejectAndCloseConnectionException("Authentication Failed");
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._dtc, "DiscoverRcv.acceptStream()", (String)object);
            dCSTraceBuffer.addProperty("Report", "Authentication Succeeded - accept stream");
            dCSTraceBuffer.invoke();
        }
        return true;
    }

    boolean isLive(String string) {
        return this._liveRcvNodesStreams.containsKey(string);
    }

    Long getLifeId(String string) {
        return this.getInStreamId(string);
    }

    void addDefined(PtpRmmNode ptpRmmNode) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._dtc, "DiscoverRcv.addDefined", null);
            ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)object).addProperty("ID", ptpRmmNode.getId());
            ((DCSTraceBuffer)object).addProperty("IsNodeLive", this.isLive(ptpRmmNode.getName()));
            ((DCSTraceBuffer)object).invoke();
        }
        super.addDefined(ptpRmmNode);
        object = (InData)this._liveRcvNodesStreams.get(ptpRmmNode.getName());
        if (object != null) {
            ptpRmmNode.setRmmConnection(((InData)object)._connection);
            this._dsm.live(ptpRmmNode.getName());
        }
    }

    void removeDefined(String string) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._dtc, "DiscoverRcv.removeDefined", string);
            ((DCSTraceBuffer)object).invoke();
        }
        super.removeDefined(string);
        object = (InData)this._liveRcvNodesStreams.remove(string);
        if (object != null) {
            this._queueR.rejectStream(((InData)object)._sid);
            if (((InData)object)._connection != null) {
                ((InData)object)._connection.closeConnection(0);
            }
        }
    }

    public UnicastConnectionIf getConnection(String string) {
        InData inData = (InData)this._liveRcvNodesStreams.get(string);
        if (inData == null) {
            return null;
        }
        return inData._connection;
    }

    void removeStreamMapping(String string) {
        InData inData = (InData)this._liveRcvNodesStreams.remove(string);
        if (inData == null) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverRcv.closeConnection - no connection", string);
                dCSTraceBuffer.invoke();
            }
            return;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverRcv.closeConnection", string);
            dCSTraceBuffer.addProperty("StreamId", inData._sid);
            dCSTraceBuffer.addProperty("RmmConnection", inData._connection);
            dCSTraceBuffer.invoke();
        }
        this._queueR.rejectStream(inData._sid);
        inData._connection.closeConnection(0);
    }

    public String dump() {
        return "DiscoveryRcv - no data";
    }

    void close() {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._dtc, "DiscoverRcv.close", null);
            ((DCSTraceBuffer)object).invoke();
        }
        super.close();
        object = this._liveRcvNodesStreams.values().iterator();
        while (object.hasNext()) {
            InData inData = (InData)object.next();
            UnicastConnectionIf unicastConnectionIf = inData._connection;
            boolean bl = unicastConnectionIf.closeConnection(0);
            if (!DCSTraceBuffer.isEventEnabled(TC)) continue;
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverRcv.closing connection", null);
            dCSTraceBuffer.addProperty("StreamId", inData._sid);
            dCSTraceBuffer.addProperty("RmmConnection", unicastConnectionIf);
            dCSTraceBuffer.addProperty("Flag", bl);
            dCSTraceBuffer.invoke();
        }
        this._liveRcvNodesStreams.clear();
        this._queueR.close();
        if (this._thread != null) {
            ThreadManager.releaseThread(this._threadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEvent(Event event2) {
        DiscoveryServerMgr discoveryServerMgr = this._dsm;
        synchronized (discoveryServerMgr) {
            Object object;
            if (this.isClosed()) {
                return;
            }
            try {
                Object object2;
                object = event2.getStreamTag();
                String string = this._topicAnalyzer.parseSenderName((byte[])object);
                if (DCSTraceBuffer.isEntryEnabled(TC)) {
                    object2 = DCSTraceBuffer.entry(this._dtc, "DiscoverRcv.doEvent", string);
                    ((DCSTraceBuffer)object2).addProperty("RmmEvent", event2.getDescription());
                    ((DCSTraceBuffer)object2).addProperty("StreamId", event2.getStreamId());
                    ((DCSTraceBuffer)object2).addProperty("InetAddress", event2.getSourceAddress());
                    ((DCSTraceBuffer)object2).addProperty("Port", event2.getSourcePort());
                    ((DCSTraceBuffer)object2).addProperty("Rmm", "Connection", event2.getObjectField());
                    ((DCSTraceBuffer)object2).invoke();
                }
                object2 = this._topicAnalyzer.parseToken((byte[])object);
                if (string == null) {
                    Tr.warning(TC, "DCSV0003", new Object[]{this._coreStackName, this._memberName, "doEvent() - got null sender"});
                    return;
                }
                Long l = new Long(event2.getStreamId());
                if (event2.getType() == 10) {
                    this.onNewSource(string, l, (byte[])object2, event2.getSourceAddress(), (UnicastConnectionIf)event2.getObjectField());
                    return;
                }
                if (this.isStreamActive(string, l)) {
                    RmmPtpReceiverEvent rmmPtpReceiverEvent = new RmmPtpReceiverEvent(event2, this._channelName, this._dtc, this._hbtTimeout);
                    rmmPtpReceiverEvent.setSource(string);
                    this.nodeDied(string, rmmPtpReceiverEvent.toSuspectEvent());
                } else if (event2.getType() == 20) {
                    this._queueR.rejectStream(event2.getStreamId());
                }
            }
            catch (Throwable throwable) {
                Tr.warning(TC, "DCSV0002", new Object[]{this._coreStackName, this._memberName, "doEvent() - got exception", throwable});
            }
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                object = DCSTraceBuffer.exit(this._dtc, "DiscoverRcv.doEvent", null);
                ((DCSTraceBuffer)object).invoke();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMessage(byte[] byArray, byte[] byArray2, long l) {
        DiscoveryServerMgr discoveryServerMgr = this._dsm;
        synchronized (discoveryServerMgr) {
            if (this.isClosed()) {
                return;
            }
            try {
                String string = this._topicAnalyzer.parseSenderName(byArray);
                PtpRmmNode ptpRmmNode = this.toNode(string);
                if (ptpRmmNode == null) {
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverRcv.doMessage", string);
                        dCSTraceBuffer.addProperty("Report", "Ignore - member is not defined");
                        dCSTraceBuffer.addProperty("Message", "StreamId", l);
                        dCSTraceBuffer.invoke();
                    }
                    return;
                }
                if (!this.isStreamActive(string, new Long(l))) {
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverRcv.doMessage", string);
                        dCSTraceBuffer.addProperty("Report", "Ignore - stream is inactive");
                        dCSTraceBuffer.addProperty("Message", "StreamId", l);
                        dCSTraceBuffer.invoke();
                    }
                    return;
                }
                if (RmmUtils.isDCSHbt(byArray2)) {
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverRcv.doMessage", string);
                        dCSTraceBuffer.addProperty("Report", "Report Ping");
                        dCSTraceBuffer.addProperty("Message", "StreamId", l);
                        dCSTraceBuffer.invoke();
                    }
                    this._dsm.reportPing(ptpRmmNode);
                    return;
                }
                Long l2 = new Long(Utils.byteArray2long(byArray2));
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverRcv.doMessage", string);
                    dCSTraceBuffer.addProperty("Report", "Life Message");
                    dCSTraceBuffer.addProperty("Message", "StreamId", l);
                    dCSTraceBuffer.addProperty("LifeId", l2);
                    dCSTraceBuffer.invoke();
                }
                this._dsm.onLifeMessage(string, l2);
            }
            catch (Throwable throwable) {
                Tr.warning(TC, "DCSV0002", new Object[]{this._coreStackName, this._memberName, "doMessage() - Got exception", throwable});
            }
        }
    }

    private void nodeDied(String string, DCSSuspectEvent dCSSuspectEvent) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverRcv.nodeDied", string);
            dCSTraceBuffer.addProperty("Received", "StreamId", this.getInStreamId(string));
            dCSTraceBuffer.addProperty(this.toNode(string));
            dCSTraceBuffer.addProperty("Reason", dCSSuspectEvent);
            dCSTraceBuffer.invoke();
        }
        this._liveRcvNodesStreams.remove(string);
        if (this.isDefined(string)) {
            this._dsm.dead(string, dCSSuspectEvent);
        }
    }

    private void onNewSource(String string, Long l, byte[] byArray, InetAddress inetAddress, UnicastConnectionIf unicastConnectionIf) {
        Object object;
        Object object2;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object2 = DCSTraceBuffer.event(this._dtc, "DiscoverRcv.onNewSource", string);
            ((DCSTraceBuffer)object2).addProperty("Source", "InetAddress", inetAddress);
            ((DCSTraceBuffer)object2).addProperty("New", "StreamId", l);
            ((DCSTraceBuffer)object2).addProperty("New", "RmmConnection", unicastConnectionIf);
            object = (InData)this._liveRcvNodesStreams.get(string);
            if (object != null) {
                ((DCSTraceBuffer)object2).addProperty("Old", "StreamId", ((InData)object)._sid);
                ((DCSTraceBuffer)object2).addProperty("Old", "RmmConnection", ((InData)object)._connection);
            } else {
                ((DCSTraceBuffer)object2).addProperty("Report", "No old stream");
            }
            ((DCSTraceBuffer)object2).addProperty("Token", (Object)byArray);
            ((DCSTraceBuffer)object2).invoke();
        }
        if ((object2 = (InData)this._liveRcvNodesStreams.get(string)) == null) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this._dtc, "DiscoverRcv.onNewSource - Down case", string);
                ((DCSTraceBuffer)object).invoke();
            }
        } else {
            if (l.equals(((InData)object2)._sid)) {
                Tr.warning(TC, "DSV0003", new Object[]{this._coreStackName, this._memberName, "DiscoverRcv.onNewSource() - Redundant new source " + string});
                return;
            }
            if (this.isOldStream(((InData)object2)._sid, l)) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    object = DCSTraceBuffer.event(this._dtc, "DiscoverRcv.onNewSource - old stream", string);
                    ((DCSTraceBuffer)object).invoke();
                }
                this._queueR.rejectStream(l);
                if (!unicastConnectionIf.equals(((InData)object2)._connection)) {
                    unicastConnectionIf.closeConnection(0);
                }
                return;
            }
            object = new TASuspectDownUpCase(this._dtc, string, this._channelName);
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverRcv.onNewSource - Down/Up case", string);
                dCSTraceBuffer.invoke();
            }
            this._queueR.rejectStream(((InData)object2)._sid);
            if (((InData)object2)._connection != null && !unicastConnectionIf.equals(((InData)object2)._connection)) {
                ((InData)object2)._connection.closeConnection(0);
            }
            this.nodeDied(string, (DCSSuspectEvent)object);
        }
        this._liveRcvNodesStreams.put(string, new InData(l, unicastConnectionIf));
        object = this.toNode(string);
        if (object != null) {
            ((PtpRmmNode)object).resetCounterPingsWithBothConnections();
            ((PtpRmmNode)object).setRmmConnection(unicastConnectionIf);
            this._dsm.live(string);
        } else {
            this._dsm.rcvBadMember(new RcvNonDefinedMemberEvent(this._dtc, string, inetAddress, byArray));
        }
    }

    private boolean isOldStream(Long l, Long l2) {
        return l - l2 > 0L;
    }

    private boolean isStreamActive(String string, Long l) {
        Long l2 = this.getInStreamId(string);
        if (l2 == null) {
            return false;
        }
        return l.equals(l2);
    }

    private Long getInStreamId(String string) {
        InData inData = (InData)this._liveRcvNodesStreams.get(string);
        if (inData == null) {
            return null;
        }
        return inData._sid;
    }

    private String printVersion(int n) {
        return Utils.getVersionAsString(Utils.int2byteArray(n));
    }

    private final class DiscoverRcvMsgJob
    extends DiscoverRcvJob {
        private byte[] _topicName;
        private final byte[] _data;
        private final long _msgSid;

        public DiscoverRcvMsgJob(Message message) {
            byte[] byArray = message.getStreamTag();
            this._data = message.getData();
            this._topicName = new byte[byArray.length];
            System.arraycopy(byArray, 0, this._topicName, 0, byArray.length);
            this._msgSid = message.streamId;
        }

        public void process() {
            DiscoveryRcv.this.doMessage(this._topicName, this._data, this._msgSid);
        }
    }

    private final class DiscoverRcvEventJob
    extends DiscoverRcvJob {
        private final Event _event;

        public DiscoverRcvEventJob(Event event2) {
            this._event = event2;
        }

        public void process() {
            DiscoveryRcv.this.doEvent(this._event);
        }
    }

    private abstract class DiscoverRcvJob
    implements Job {
        private DiscoverRcvJob() {
        }

        public void cancel() {
            if (!DiscoveryRcv.this.isClosed()) {
                Tr.warning(TC, "DSV0003", new Object[]{DiscoveryRcv.this._coreStackName, DiscoveryRcv.this._memberName, "DiscoverRcvJob.cancel - Job was cancelled"});
            }
        }

        public void handleError(Throwable throwable) {
            Tr.warning(TC, "DSV0002", new Object[]{DiscoveryRcv.this._coreStackName, DiscoveryRcv.this._memberName, "DiscoverRcvJob.handleError() - got exception", throwable});
        }

        public String getOwner() {
            return DiscoveryRcv.this._threadName;
        }
    }

    private static class InData {
        private final Long _sid;
        private final UnicastConnectionIf _connection;

        private InData(Long l, UnicastConnectionIf unicastConnectionIf) {
            this._sid = l;
            this._connection = unicastConnectionIf;
        }
    }
}

