/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmm.receiver.RMReceiver;
import com.ibm.rmm.transmitter.RMTransmitter;
import com.ibm.rmm.util.UnicastConnectionIf;
import com.ibm.ws.dcs.common.AddressResolver;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.MemberAuthenticator;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.utils.AlarmListener;
import com.ibm.ws.dcs.utils.AlarmManager;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.Job;
import com.ibm.ws.dcs.vri.common.JobsProcessorThread;
import com.ibm.ws.dcs.vri.common.ThreadManager;
import com.ibm.ws.dcs.vri.common.nls.AbstractNLSEvent;
import com.ibm.ws.dcs.vri.common.nls.ConnectivityInfoEvent;
import com.ibm.ws.dcs.vri.common.nls.ConnectivityWarningEvent;
import com.ibm.ws.dcs.vri.common.nls.RcvBadMemberEvent;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.FFDCDumpable;
import com.ibm.ws.dcs.vri.common.util.FFDCDumper;
import com.ibm.ws.dcs.vri.transportAdapter.TransportInternalException;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.MyAddressResolver;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RcvBadMemberListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryRcv;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryServer;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryServerListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryTopicNameAnalyzer;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryTx;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.PtpRmmNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.TransmitterThread;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DiscoveryServerMgr
implements DiscoveryServer,
DCSTraceContext,
AlarmListener,
FFDCDumpable {
    private static TraceComponent TC = Tr.register(DiscoveryServerMgr.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private static final int DISCOVERY_VERSION = 0x1000001;
    private static final long PING_TIMEOUT = 2000L;
    private final MyAddressResolver _myAddressResolver;
    private final AddressResolver _addressResolver;
    private MemberAuthenticator _memberAuthenticator;
    private final int _maxTokenLength;
    private final int _hbtTimeout;
    private long _highFreqTimeout;
    private long _baseTimeout;
    private RMReceiver _rmr;
    private RMTransmitter _rmt;
    private String _thisMemberName;
    private String _coreStackName;
    private boolean _closed = false;
    private String _dbgName;
    private final boolean _iAmPassive;
    private final DCSLogicalChannel DISCOVERY_CHANNEL = new DCSLogicalChannel("Discovery", "Ptp");
    private DiscoveryTx _discoveryTx;
    private DiscoveryRcv _discoveryRcv;
    private TransmitterThread _transmitter;
    private Map _definedNodesListeners = new HashMap();
    private JobsProcessorThread _notifyThread;
    private RcvBadMemberListener _rcvBadMemberListener;
    private Map _connectedNodes = new HashMap();
    private Map _queuedLifeMessages = new HashMap();

    public DiscoveryServerMgr(long l, long l2, RMTransmitter rMTransmitter, RMReceiver rMReceiver, String string, TransmitterThread transmitterThread, MemberAuthenticator memberAuthenticator, int n, int n2, AddressResolver addressResolver, MyAddressResolver myAddressResolver) {
        this._baseTimeout = l;
        this._highFreqTimeout = l2;
        this._rmt = rMTransmitter;
        this._rmr = rMReceiver;
        this._thisMemberName = string;
        this._transmitter = transmitterThread;
        this._memberAuthenticator = memberAuthenticator;
        this._maxTokenLength = n;
        this._hbtTimeout = n2;
        this._addressResolver = addressResolver;
        this._myAddressResolver = myAddressResolver;
        this._iAmPassive = this._myAddressResolver.getMyPassiveDiscovery();
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoverServer.constructor()", null);
            dCSTraceBuffer.addProperty("Basic", "Timeout", l);
            dCSTraceBuffer.addProperty("FireWall", "Timeout", l2);
            dCSTraceBuffer.addProperty("TokenLength", n);
            if (this._memberAuthenticator != null) {
                dCSTraceBuffer.addProperty("MemberAuthenticator", memberAuthenticator.getClass().getName());
            } else {
                dCSTraceBuffer.addProperty("MemberAuthenticator", "null");
            }
            dCSTraceBuffer.invoke();
        }
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._coreStackName;
    }

    public String getMemberName() {
        return this._thisMemberName;
    }

    public String getLayerName() {
        return "DISCOV";
    }

    public synchronized String getListenerID() {
        return this._dbgName;
    }

    public Object getMutex() {
        return null;
    }

    public synchronized void start(RcvBadMemberListener rcvBadMemberListener, String string) {
        Object object;
        this._dbgName = "DISC|" + string;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "DiscoverServer.start()", string);
            ((DCSTraceBuffer)object).invoke();
        }
        if (this.isStarted()) {
            throw new TransportInternalException("DiscoveryServerMgr.start: Called twice " + string);
        }
        this._coreStackName = string;
        this._rcvBadMemberListener = rcvBadMemberListener;
        this._notifyThread = ThreadManager.getThread(this._dbgName, ThreadManager.INTERNAL_THREAD, 5);
        if (this._notifyThread == null) {
            throw new TransportInternalException("DiscoveryServerMgr.start: Failed To Get Notify Thread");
        }
        object = this._myAddressResolver.getMyNodeTopicStr();
        DiscoveryTopicNameAnalyzer discoveryTopicNameAnalyzer = new DiscoveryTopicNameAnalyzer(this._coreStackName, this._thisMemberName, (String)object, this);
        this._discoveryTx = new DiscoveryTx(this, this._baseTimeout, this._highFreqTimeout, this._rmt, this._thisMemberName, discoveryTopicNameAnalyzer, this._transmitter, this._memberAuthenticator, this._coreStackName, this._maxTokenLength, this.DISCOVERY_CHANNEL, 0x1000001, this._iAmPassive, this._addressResolver);
        this._discoveryRcv = new DiscoveryRcv(this, this._rmr, discoveryTopicNameAnalyzer, this._memberAuthenticator, this._coreStackName, this._thisMemberName, this.DISCOVERY_CHANNEL, this._hbtTimeout, 0x1000001);
    }

    public synchronized void close() {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoverServer.close()", this._coreStackName);
            dCSTraceBuffer.invoke();
        }
        this.assertDiscoveryStarted();
        this._closed = true;
        if (!this._definedNodesListeners.isEmpty()) {
            Tr.warning(TC, "DCSV0003", new Object[]{this._coreStackName, this._thisMemberName, "DiscoveryRcv.close() : Defined map not empty at close"});
        }
        this._definedNodesListeners.clear();
        this._connectedNodes.clear();
        this._discoveryRcv.close();
        this._discoveryTx.close();
        ThreadManager.releaseThread(this._dbgName);
    }

    public synchronized boolean isDefined(DiscoveryServerListener discoveryServerListener, String string) {
        this.assertDiscoveryStarted();
        Set set = (Set)this._definedNodesListeners.get(string);
        if (set == null) {
            return false;
        }
        return set.contains(discoveryServerListener);
    }

    public synchronized PtpRmmNode addDefined(DiscoveryServerListener discoveryServerListener, String string) {
        PtpRmmNode ptpRmmNode;
        if (string == null) {
            Tr.warning(TC, "DCSV0003", new Object[]{this._coreStackName, this._thisMemberName, "DiscoveryServer.addDefined() called with a null member name"});
            return null;
        }
        PtpRmmNode ptpRmmNode2 = new PtpRmmNode(string);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this, "DiscoverServer.addDefined()", null);
            dCSTraceBuffer.addProperty("ID", ptpRmmNode2.getId());
            dCSTraceBuffer.addProperty(ptpRmmNode2);
            dCSTraceBuffer.addProperty("DiscoveryState", this.getNodeState(string));
            dCSTraceBuffer.addProperty("DiscoveryListener", discoveryServerListener);
            dCSTraceBuffer.invoke();
        }
        this.assertDiscoveryStarted();
        boolean bl = this.addListenerToDefinedMap(string, discoveryServerListener);
        if (bl) {
            if (this.shouldDiscoveryNode(string)) {
                this._discoveryTx.addDefined(string, null);
            }
            this._discoveryRcv.addDefined(ptpRmmNode2);
        }
        if ((ptpRmmNode = (PtpRmmNode)this._connectedNodes.get(string)) != null) {
            ptpRmmNode = new PtpRmmNode(ptpRmmNode);
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "DiscoverServer.addDefined()", string);
            if (ptpRmmNode != null) {
                dCSTraceBuffer.addProperty(ptpRmmNode);
            } else {
                dCSTraceBuffer.addProperty("Report", "member is not connected");
            }
            dCSTraceBuffer.invoke();
        }
        return ptpRmmNode;
    }

    public synchronized void removeDefined(DiscoveryServerListener discoveryServerListener, String string) {
        if (string == null) {
            Tr.warning(TC, "DCSV0003", new Object[]{this._coreStackName, this._thisMemberName, "DiscoveryServer.removeDefined() called with a null member name"});
            return;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoverServer.removeDefined()", string);
            dCSTraceBuffer.addProperty("DiscoveryState", this.getNodeState(string));
            dCSTraceBuffer.addProperty("DiscoveryListener", discoveryServerListener);
            dCSTraceBuffer.invoke();
        }
        this.assertDiscoveryStarted();
        if (!this._definedNodesListeners.containsKey(string)) {
            return;
        }
        boolean bl = this.removeListenerFromDefinedMap(string, discoveryServerListener);
        if (bl) {
            this._connectedNodes.remove(string);
            this._discoveryRcv.removeDefined(string);
            this._discoveryTx.removeDefined(string);
        }
    }

    public synchronized Set addListener(DiscoveryServerListener discoveryServerListener, Set set) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "DiscoverServer.addListener()", null);
            ((DCSTraceBuffer)object).addProperty("DiscoveryListener", discoveryServerListener);
            ((DCSTraceBuffer)object).addProperty("RmmNodes", set);
            ((DCSTraceBuffer)object).invoke();
        }
        object = new HashSet();
        this.assertDiscoveryStarted();
        if (set == null) {
            String string = "DiscoveryServer.addListener(): Listener passed an empty defined set to addListener()";
            Tr.warning(TC, "DCSV0003", new Object[]{this._coreStackName, this._thisMemberName, string});
            return object;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            PtpRmmNode ptpRmmNode = this.addDefined(discoveryServerListener, string);
            if (ptpRmmNode == null) continue;
            object.add(ptpRmmNode);
        }
        return object;
    }

    public synchronized void removeListener(DiscoveryServerListener discoveryServerListener) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "DiscoverServer.removeListener()", null);
            ((DCSTraceBuffer)object).addProperty("DiscoveryListener", discoveryServerListener);
            ((DCSTraceBuffer)object).invoke();
        }
        this.assertDiscoveryStarted();
        object = new HashSet(this._definedNodesListeners.entrySet());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            if (!set.contains(discoveryServerListener)) continue;
            this.removeDefined(discoveryServerListener, string);
        }
    }

    public synchronized void alarm(Object object) {
        Object object2;
        Object object3;
        Object object4;
        if (this._closed) {
            return;
        }
        PtpRmmNode ptpRmmNode = (PtpRmmNode)object;
        if (ptpRmmNode == null) {
            Tr.warning(TC, "DCSV0003", new Object[]{this._coreStackName, this._thisMemberName, "DiscoveryServer.alarm() : Null alarm context"});
            return;
        }
        String string = ptpRmmNode.getName();
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object4 = DCSTraceBuffer.event(this, "DiscoveryServerMgr.alarm()", "start");
            ((DCSTraceBuffer)object4).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)object4).addProperty("ID", ptpRmmNode.getId());
            object3 = this._discoveryTx.getConnection(string);
            object2 = this._discoveryRcv.getConnection(string);
            ((DCSTraceBuffer)object4).addProperty("Outgoing", "RmmConnection", object3);
            ((DCSTraceBuffer)object4).addProperty("Incoming", "RmmConnection", object2);
            ((DCSTraceBuffer)object4).addProperty("DiscoveryState", this.getNodeState(string));
            ((DCSTraceBuffer)object4).invoke();
        }
        if (this._discoveryTx.isLive(string) && !this._connectedNodes.containsKey(string)) {
            boolean bl = ptpRmmNode.incrementCounterPingsWithBothConnections();
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object3 = DCSTraceBuffer.event(this, "DiscoveryServerMgr.alarm()", "Not Connected");
                ((DCSTraceBuffer)object3).addProperty("Report", "tryPing = " + bl);
                ((DCSTraceBuffer)object3).invoke();
            }
            if (bl) {
                this._discoveryTx.ping(string);
                this.setPingAlarm(ptpRmmNode);
            } else {
                object3 = "alarm(): Closing the connection because members did not manage to connect";
                object2 = new ConnectivityWarningEvent((DCSTraceContext)this, string, (String)object3);
                ((AbstractNLSEvent)object2).invokeNLSTrace();
                UnicastConnectionIf unicastConnectionIf = this._discoveryRcv.getConnection(string);
                UnicastConnectionIf unicastConnectionIf2 = this._discoveryTx.getConnection(string);
                this._discoveryTx.removeDefined(string);
                this._discoveryTx.addDefined(string, null);
                if (unicastConnectionIf2 != null && unicastConnectionIf != null && unicastConnectionIf2.equals(unicastConnectionIf)) {
                    this._discoveryRcv.removeStreamMapping(string);
                }
                ptpRmmNode.resetCounterPingsWithBothConnections();
            }
        } else {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object4 = "Ignore - node's state is " + this._discoveryTx.isLive(ptpRmmNode.getName()) + ':' + this._connectedNodes.containsKey(ptpRmmNode.getName());
                object3 = DCSTraceBuffer.event(this, "DiscoveryServerMgr.alarm()", null);
                ((DCSTraceBuffer)object3).addProperty("Report", object4);
                ((DCSTraceBuffer)object3).addProperty(ptpRmmNode);
                ((DCSTraceBuffer)object3).addProperty("ID", ptpRmmNode.getId());
                ((DCSTraceBuffer)object3).addProperty("DiscoveryState", this.getNodeState(string));
                ((DCSTraceBuffer)object3).invoke();
            }
            ptpRmmNode.resetCounterPingsWithBothConnections();
        }
    }

    void rcvBadMember(RcvBadMemberEvent rcvBadMemberEvent) {
        this._notifyThread.enqueueJob(new DiscoveryRcvBadMemberJob(rcvBadMemberEvent, this._rcvBadMemberListener, this));
    }

    synchronized void onError(DCSTerminationEvent dCSTerminationEvent) {
        Set set = this.getAllListeners();
        this._notifyThread.enqueueJob(new DiscoveryErrorJob(dCSTerminationEvent, set, this));
    }

    /*
     * Enabled aggressive block sorting
     */
    synchronized void live(String string) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoverServer.live()", string);
            dCSTraceBuffer.addProperty("DiscoveryState", this.getNodeState(string));
            dCSTraceBuffer.invoke();
        }
        boolean bl = this._discoveryTx.isLive(string);
        boolean bl2 = this._discoveryRcv.isLive(string);
        UnicastConnectionIf unicastConnectionIf = this._discoveryTx.getConnection(string);
        UnicastConnectionIf unicastConnectionIf2 = this._discoveryRcv.getConnection(string);
        Long l = this._discoveryRcv.getLifeId(string);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "DiscoverServer.live()", string);
            ((DCSTraceBuffer)object).addProperty("Incoming", "State", bl2);
            ((DCSTraceBuffer)object).addProperty("Outgoing", "State", bl);
            ((DCSTraceBuffer)object).addProperty("My", "LifeId", l);
            ((DCSTraceBuffer)object).addProperty("Queued", "LifeId", this._queuedLifeMessages.get(string));
            ((DCSTraceBuffer)object).addProperty("Incoming", "RmmConnection", unicastConnectionIf2);
            ((DCSTraceBuffer)object).addProperty("Outgoing", "RmmConnection", unicastConnectionIf);
            ((DCSTraceBuffer)object).invoke();
        }
        if (bl && bl2) {
            if (unicastConnectionIf == null || unicastConnectionIf2 == null) {
                object = new Exception("Execution Stack Trace for member " + string);
                Tr.warning(TC, "DCSV0002", new Object[]{this._coreStackName, this._thisMemberName, "Two way live with at least one null connection", object});
                return;
            }
            if (unicastConnectionIf.equals(unicastConnectionIf2)) {
                this._discoveryTx.sendLifeMessage(string, l);
                object = (Long)this._queuedLifeMessages.remove(string);
                if (object == null) return;
                this.onLifeMessage(string, (Long)object);
                return;
            }
            if (this._thisMemberName.compareTo(string) <= 0) {
                if (!DCSTraceBuffer.isEventEnabled(TC)) return;
                object = DCSTraceBuffer.event(this, "DiscoverServer.live()", "DoubleConnectSmall");
                ((DCSTraceBuffer)object).addProperty("memberName", string);
                ((DCSTraceBuffer)object).invoke();
                return;
            }
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this, "DiscoverServer.live()", "DoubleConnectBig");
                ((DCSTraceBuffer)object).addProperty("memberName", string);
                ((DCSTraceBuffer)object).invoke();
            }
            this._discoveryTx.removeDefined(string);
            this._discoveryTx.addDefined(string, unicastConnectionIf2);
            return;
        }
        if (!bl && bl2) {
            if (!this.shouldDiscoveryNode(string)) {
                this._discoveryTx.addDefined(string, unicastConnectionIf2);
                return;
            }
            this._discoveryTx.accelerateDiscovery(string, unicastConnectionIf2);
            return;
        }
        if (bl && !bl2) {
            object = new PtpRmmNode(string);
            this.setPingAlarm((PtpRmmNode)object);
            return;
        }
        object = this.getNodeState(string);
        Tr.warning(TC, "DCSV0003", new Object[]{this._coreStackName, this._thisMemberName, "DiscoveryServer.live() callback in illegal state " + (String)object});
    }

    synchronized void dead(String string, DCSSuspectEvent dCSSuspectEvent) {
        DCSTraceable dCSTraceable;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceable = DCSTraceBuffer.event(this, "DiscoverServer.dead()", string);
            ((DCSTraceBuffer)dCSTraceable).addProperty("DiscoveryState", this.getNodeState(string));
            ((DCSTraceBuffer)dCSTraceable).invoke();
        }
        this._queuedLifeMessages.remove(string);
        dCSTraceable = (PtpRmmNode)this._connectedNodes.remove(string);
        if (dCSTraceable != null) {
            dCSSuspectEvent.invokeNLSTrace();
            this._notifyThread.enqueueJob(new DiscoveryNotifyLivenessJob((PtpRmmNode)dCSTraceable, false, (Set)this._definedNodesListeners.get(string), dCSSuspectEvent, this));
        }
        this._discoveryTx.clearConnection(string);
        if (!this.shouldDiscoveryNode(string)) {
            this._discoveryTx.removeDefined(string);
        }
    }

    synchronized void onLifeMessage(String string, Long l) {
        Object object;
        boolean bl = false;
        if (this._queuedLifeMessages.containsKey(string)) {
            this._queuedLifeMessages.remove(string);
            bl = true;
        }
        Long l2 = this._discoveryTx.getLifeId(string);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoverServer.onLifeMessage()", string);
            dCSTraceBuffer.addProperty("My", "LifeId", l2);
            dCSTraceBuffer.addProperty("Received", "LifeId", l);
            dCSTraceBuffer.addProperty("Flag", bl);
            dCSTraceBuffer.addProperty("DiscoveryState", this.getNodeState(string));
            dCSTraceBuffer.invoke();
        }
        if (l2 == null) {
            this._queuedLifeMessages.put(string, l);
            return;
        }
        boolean bl2 = this._discoveryTx.isLive(string);
        boolean bl3 = this._discoveryRcv.isLive(string);
        UnicastConnectionIf unicastConnectionIf = this._discoveryTx.getConnection(string);
        UnicastConnectionIf unicastConnectionIf2 = this._discoveryRcv.getConnection(string);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "DiscoverServer.onLifeMessage()", string);
            ((DCSTraceBuffer)object).addProperty("Incoming", "State", bl3);
            ((DCSTraceBuffer)object).addProperty("Outgoing", "State", bl2);
            ((DCSTraceBuffer)object).addProperty("Incoming", "RmmConnection", unicastConnectionIf2);
            ((DCSTraceBuffer)object).addProperty("Outgoing", "RmmConnection", unicastConnectionIf);
            ((DCSTraceBuffer)object).invoke();
        }
        if (bl2 && bl3) {
            if (!l.equals(l2)) {
                return;
            }
            if (unicastConnectionIf == null || unicastConnectionIf2 == null) {
                object = new Exception("Execution Stack Trace");
                Tr.warning(TC, "DCSV0002", new Object[]{this._coreStackName, this._thisMemberName, "Two way live with at least one null connection", object});
                return;
            }
            if (!unicastConnectionIf.equals(unicastConnectionIf2)) {
                object = "DiscoveryServer.onLiveMessage() : Double Connection case - other member is probably a prior version of DCS";
                Tr.warning(TC, "DCSV0003", new Object[]{this._coreStackName, this._thisMemberName, object});
                if (this._thisMemberName.compareTo(string) > 0) {
                    return;
                }
                ConnectivityInfoEvent connectivityInfoEvent = new ConnectivityInfoEvent((DCSTraceContext)this, string, "Received double connection, will close the outgoing connection and use the incoming connection");
                connectivityInfoEvent.invokeNLSTrace();
                this._discoveryTx.removeDefined(string);
                this._discoveryTx.addDefined(string, unicastConnectionIf2);
                return;
            }
            object = new PtpRmmNode(string, unicastConnectionIf);
            this._connectedNodes.put(string, object);
            this._notifyThread.enqueueJob(new DiscoveryNotifyLivenessJob((PtpRmmNode)object, true, (Set)this._definedNodesListeners.get(string), null, this));
        }
    }

    synchronized void reportPing(PtpRmmNode ptpRmmNode) {
        Object object;
        String string = ptpRmmNode.getName();
        boolean bl = this._discoveryTx.isLive(string);
        boolean bl2 = this._discoveryRcv.isLive(string);
        UnicastConnectionIf unicastConnectionIf = this._discoveryTx.getConnection(string);
        UnicastConnectionIf unicastConnectionIf2 = this._discoveryRcv.getConnection(string);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "DiscoverServer.reportPing()", string);
            ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)object).addProperty("Incoming", "State", bl2);
            ((DCSTraceBuffer)object).addProperty("Outgoing", "State", bl);
            ((DCSTraceBuffer)object).addProperty("Incoming", "RmmConnection", unicastConnectionIf2);
            ((DCSTraceBuffer)object).addProperty("Outgoing", "RmmConnection", unicastConnectionIf);
            ((DCSTraceBuffer)object).addProperty("DiscoveryState", this.getNodeState(string));
            ((DCSTraceBuffer)object).invoke();
        }
        if (!bl2 || bl) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this, "DiscoverServer.reportPing()", string);
                ((DCSTraceBuffer)object).addProperty("Report", "Got ping in an unusual state");
                ((DCSTraceBuffer)object).invoke();
            }
            if (bl2 && bl && unicastConnectionIf2 != null && !unicastConnectionIf2.equals(unicastConnectionIf) && !ptpRmmNode.incrementCounterPingsWithBothConnections()) {
                object = "reportPing(): Closing the connection because members did not manage to connect";
                ConnectivityWarningEvent connectivityWarningEvent = new ConnectivityWarningEvent((DCSTraceContext)this, string, (String)object);
                connectivityWarningEvent.invokeNLSTrace();
                Globals.causeDump((FFDCDumpable)this, "Closing the connection because this member did not manage to connect with " + string);
                this._discoveryTx.removeDefined(string);
                this._discoveryTx.addDefined(string, null);
                ptpRmmNode.resetCounterPingsWithBothConnections();
            }
        }
    }

    private Set getAllListeners() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this._definedNodesListeners.values().iterator();
        while (iterator.hasNext()) {
            Set set = (Set)iterator.next();
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private boolean shouldDiscoveryNode(String string) {
        boolean bl = !this._addressResolver.isPassiveDiscovery(string);
        return !this._iAmPassive || !bl;
    }

    private boolean addListenerToDefinedMap(String string, DiscoveryServerListener discoveryServerListener) {
        Set<DiscoveryServerListener> set;
        boolean bl = false;
        if (!this._definedNodesListeners.containsKey(string)) {
            set = new HashSet();
            this._definedNodesListeners.put(string, set);
            bl = true;
        }
        set = (Set)this._definedNodesListeners.get(string);
        set.add(discoveryServerListener);
        return bl;
    }

    private boolean removeListenerFromDefinedMap(String string, DiscoveryServerListener discoveryServerListener) {
        if (!this._definedNodesListeners.containsKey(string)) {
            return true;
        }
        Set set = (Set)this._definedNodesListeners.get(string);
        set.remove(discoveryServerListener);
        if (set.isEmpty()) {
            this._definedNodesListeners.remove(string);
            return true;
        }
        return false;
    }

    private String getNodeState(String string) {
        if (string == null) {
            return "null";
        }
        boolean bl = this._definedNodesListeners.containsKey(string);
        boolean bl2 = this._discoveryTx.isLive(string);
        boolean bl3 = this._discoveryRcv.isLive(string);
        boolean bl4 = this._connectedNodes.containsKey(string);
        String string2 = "ILLEGAL: Defined? " + bl + ", txLive? " + bl2 + ", rcvLive? " + bl3 + ", connected? " + bl4;
        if (!(bl || bl2 || bl4)) {
            string2 = "NOT_DEFINED_RCV_" + (bl3 ? "LIVE" : "DEAD");
        } else if (bl) {
            if (bl2 && bl3 && bl4) {
                string2 = "CONNECTED";
            } else if (bl4) {
                string2 = "ILLEGAL";
            } else if (!bl3 && !bl2) {
                string2 = "RCV_DEAD_TX_DEAD";
            } else if (!bl3 && bl2) {
                string2 = "RCV_DEAD_TX_LIVE";
            } else if (bl3 && !bl2) {
                string2 = "RCV_LIVE_TX_DEAD";
            } else if (bl3 && bl2) {
                string2 = "RCV_LIVE_TX_LIVE";
            }
        }
        return string2;
    }

    private void setPingAlarm(PtpRmmNode ptpRmmNode) {
        if (ptpRmmNode == null) {
            Tr.warning(TC, "DCSV0003", new Object[]{this._coreStackName, this._thisMemberName, "DiscoveryRcv.setPingAlarm for member " + ptpRmmNode});
            return;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoverServer.setPingAlarm()", null);
            dCSTraceBuffer.addProperty(ptpRmmNode);
            dCSTraceBuffer.addProperty("DiscoveryState", this.getNodeState(ptpRmmNode.getName()));
            dCSTraceBuffer.invoke();
        }
        AlarmManager.create(AlarmManager.DISCOVERY_ALARM, 2000L, this, this, ptpRmmNode);
    }

    private boolean isStarted() {
        return this._coreStackName != null;
    }

    private void assertDiscoveryStarted() {
        if (!this.isStarted()) {
            throw new TransportInternalException("Discovery server has not been started");
        }
    }

    public String dump() {
        return "DiscoveryServerMgr - no data";
    }

    public void dumpAll(FFDCDumper fFDCDumper) {
        fFDCDumper.writeLine(this.dump());
    }

    protected final class DiscoveryErrorJob
    extends DiscoveryJob {
        private final DCSTerminationEvent _te;
        private final Set _listeners;

        public DiscoveryErrorJob(DCSTerminationEvent dCSTerminationEvent, Set set, DCSTraceContext dCSTraceContext) {
            super(dCSTraceContext);
            this._te = dCSTerminationEvent;
            this._listeners = set;
        }

        public void process() {
            if (this._listeners == null) {
                Tr.warning(TC, "DCSV0003", new Object[]{DiscoveryServerMgr.this._coreStackName, DiscoveryServerMgr.this._thisMemberName, "DiscoveryErrorJob.process() : No listeners."});
                return;
            }
            Iterator iterator = this._listeners.iterator();
            while (iterator.hasNext()) {
                DiscoveryServerListener discoveryServerListener = (DiscoveryServerListener)iterator.next();
                discoveryServerListener.onError(this._te);
            }
        }
    }

    protected final class DiscoveryRcvBadMemberJob
    extends DiscoveryJob {
        private final RcvBadMemberEvent _event;
        private final RcvBadMemberListener _listener;

        public DiscoveryRcvBadMemberJob(RcvBadMemberEvent rcvBadMemberEvent, RcvBadMemberListener rcvBadMemberListener, DCSTraceContext dCSTraceContext) {
            super(dCSTraceContext);
            this._event = rcvBadMemberEvent;
            this._listener = rcvBadMemberListener;
        }

        public void process() {
            this._listener.rcvBadMember(this._event);
        }
    }

    protected final class DiscoveryNotifyLivenessJob
    extends DiscoveryJob {
        private PtpRmmNode _node;
        private boolean _live;
        private Set _listeners;
        private DCSSuspectEvent _reason;

        public DiscoveryNotifyLivenessJob(PtpRmmNode ptpRmmNode, boolean bl, Set set, DCSSuspectEvent dCSSuspectEvent, DCSTraceContext dCSTraceContext) {
            super(dCSTraceContext);
            this._node = ptpRmmNode;
            this._live = bl;
            this._listeners = new HashSet(set);
            this._reason = dCSSuspectEvent;
        }

        public void process() {
            Object object;
            String string = "Notify " + (this._live ? "Live" : "Dead");
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty("DiscoveryListeners", this._listeners);
            if (this._listeners == null) {
                Tr.warning(TC, "DCSV0003", new Object[]{DiscoveryServerMgr.this._coreStackName, DiscoveryServerMgr.this._thisMemberName, "DiscoveryLivenessJob.process() : No listeners."});
                return;
            }
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(DiscoveryServerMgr.this, "DiscoveryLivenessJob.process()", string);
                ((DCSTraceBuffer)object).addProperty(this._node);
                ((DCSTraceBuffer)object).invoke();
            }
            object = this._listeners.iterator();
            while (object.hasNext()) {
                DiscoveryServerListener discoveryServerListener = (DiscoveryServerListener)object.next();
                if (this._live) {
                    discoveryServerListener.live(this._node);
                    continue;
                }
                discoveryServerListener.dead(this._node, this._reason);
            }
        }
    }

    protected abstract class DiscoveryJob
    implements Job {
        private final DCSTraceContext _dtc;

        public DiscoveryJob(DCSTraceContext dCSTraceContext) {
            this._dtc = dCSTraceContext;
        }

        public void cancel() {
            if (!DiscoveryServerMgr.this._closed) {
                Tr.warning(TC, "DCSV0003", new Object[]{DiscoveryServerMgr.this._coreStackName, DiscoveryServerMgr.this._thisMemberName, "DiscoveryJob.cancel() : Job cancelled whiile Discovery not closed"});
            }
        }

        public void handleError(Throwable throwable) {
            DiscoveryServerMgr.this.onError(new TerminationEvent(this._dtc, "DiscoveryJob.handleError()", throwable));
        }

        public String getOwner() {
            return DiscoveryServerMgr.this._dbgName;
        }
    }
}

