/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery;

import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.TransportInternalException;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.TopicNameAnalyzer;
import java.io.UnsupportedEncodingException;

public class DiscoveryTopicNameAnalyzer
extends TopicNameAnalyzer {
    private final byte[] _stackByteArray;
    private final String _myNodeTopicString;
    private final String _member;
    private final DCSTraceContext _dtc;

    public DiscoveryTopicNameAnalyzer(String string, String string2, String string3, DCSTraceContext dCSTraceContext) {
        super("PTP", "DISC", string);
        try {
            this._stackByteArray = this._stackString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TransportInternalException("Failed to create Discovery Topic Name Analyzer: " + unsupportedEncodingException);
        }
        this._dtc = dCSTraceContext;
        this._myNodeTopicString = string3;
        this._member = string2;
    }

    private byte[] createTopicName(byte[] byArray, int n, int n2, int n3) {
        String string = super.createTopicName(this._member, this._myNodeTopicString);
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TransportInternalException("Failed to create byte array from String " + unsupportedEncodingException);
        }
        byte[] byArray3 = Utils.short2byteArray((short)n2);
        byte[] byArray4 = Utils.int2byteArray(n3);
        byte[] byArray5 = new byte[byArray4.length + byArray3.length + n2 + byArray2.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        System.arraycopy(byArray3, 0, byArray5, byArray4.length, byArray3.length);
        System.arraycopy(byArray, n, byArray5, byArray4.length + byArray3.length, n2);
        System.arraycopy(byArray2, 0, byArray5, byArray4.length + byArray3.length + n2, byArray2.length);
        return byArray5;
    }

    public byte[] createTopicName(byte[] byArray, int n) {
        return this.createTopicName(byArray, 0, byArray.length, n);
    }

    public byte[] parseToken(byte[] byArray, int n, int n2) {
        if (this.parseIsSameStackPrefix(byArray, n, n2)) {
            short s = Utils.byteArray2short(byArray, new Utils.Offset(n + Utils.sizeOfInt()));
            byte[] byArray2 = new byte[s];
            System.arraycopy(byArray, n + Utils.sizeOfInt() + Utils.sizeOfShort(), byArray2, 0, s);
            return byArray2;
        }
        return null;
    }

    public boolean parseIsSameStackPrefix(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return false;
        }
        if (n2 <= Utils.sizeOfInt() + Utils.sizeOfShort() + this._stackByteArray.length) {
            return false;
        }
        short s = Utils.byteArray2short(byArray, new Utils.Offset(n + Utils.sizeOfInt()));
        if (s > n2 - Utils.sizeOfInt() - Utils.sizeOfShort() - this._stackByteArray.length) {
            return false;
        }
        String string = this.getPost(byArray, n, n2);
        if (string == null) {
            return false;
        }
        return super.parseIsSameStackPrefix(string);
    }

    public String parseSenderName(byte[] byArray, int n, int n2) {
        if (this.parseIsSameStackPrefix(byArray, n, n2)) {
            return super.parseSenderName(this.getPost(byArray, n, n2));
        }
        return null;
    }

    private String getPost(byte[] byArray, int n, int n2) {
        short s = Utils.byteArray2short(byArray, new Utils.Offset(Utils.sizeOfInt()));
        int n3 = n + Utils.sizeOfInt() + Utils.sizeOfShort() + s;
        String string = null;
        try {
            string = new String(byArray, n3, n2 - n3, "UTF-8");
        }
        catch (Throwable throwable) {
            if (DCSTraceBuffer.isInternalWarningEnabled(this._dtc.getTraceComponent())) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._dtc, "Discovery analyzer failed to get a String from the byte array", "DiscoveryTopicNameAnalyzer.getPost()", throwable);
                dCSTraceBuffer.addProperty("TopicName", (Object)byArray);
                dCSTraceBuffer.invoke();
            }
            return null;
        }
        return string;
    }

    public boolean parseIsSameStackPrefix(byte[] byArray) {
        return this.parseIsSameStackPrefix(byArray, 0, byArray.length);
    }

    public String parseSenderName(byte[] byArray) {
        return this.parseSenderName(byArray, 0, byArray.length);
    }

    public byte[] parseToken(byte[] byArray) {
        return this.parseToken(byArray, 0, byArray.length);
    }

    public Integer parseVersion(byte[] byArray, int n, int n2) {
        if (this.parseIsSameStackPrefix(byArray, n, n2)) {
            int n3 = Utils.byteArray2int(byArray, new Utils.Offset());
            return new Integer(n3);
        }
        return null;
    }
}

