/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmm.transmitter.Event;
import com.ibm.rmm.transmitter.RMTransmitter;
import com.ibm.rmm.util.UnicastConnectionIf;
import com.ibm.ws.dcs.common.AddressResolver;
import com.ibm.ws.dcs.common.MemberAuthenticator;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.utils.Alarm;
import com.ibm.ws.dcs.utils.AlarmListener;
import com.ibm.ws.dcs.utils.AlarmManager;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.nls.ReceivedIllegalTokenEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import com.ibm.ws.dcs.vri.transportAdapter.TransportAdapter;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RmmUtils;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmQueueTransmitterEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryConstantPolicy;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryDisconnectedPolicy;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryNodePolicy;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryServerMgr;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoverySubServer;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryTopicNameAnalyzer;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.PtpRmmNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.QueueTHandler;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.QueueTHandlerCreationListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.QueueTHandlerListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.TransmitterThread;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DiscoveryTx
extends DiscoverySubServer
implements AlarmListener,
QueueTHandlerListener,
QueueTHandlerCreationListener {
    private static final TraceComponent TC = Tr.register(DiscoveryTx.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private final AddressResolver _addressResolver;
    private final int _version;
    private final int _maxTokenLength;
    private final String _myMemberName;
    private final boolean _iAmActive;
    private final RMTransmitter _rmt;
    private final long BASE_TIMEOUT;
    private final long HIGH_FREQ_TIMEOUT;
    private Map _liveTxNodesQueueT = new HashMap();
    private Map _deadTxNodesPolicies = new HashMap();
    private Set _attemptingNodes = new HashSet();
    private final TransmitterThread _transmitter;
    private final Map _pendingAccelerateDiscoveryRequests = new HashMap();
    private final Map _scheduledAlarms = new HashMap();
    private final DCSTraceContext _dtc;

    public DiscoveryTx(DiscoveryServerMgr discoveryServerMgr, long l, long l2, RMTransmitter rMTransmitter, String string, DiscoveryTopicNameAnalyzer discoveryTopicNameAnalyzer, TransmitterThread transmitterThread, MemberAuthenticator memberAuthenticator, String string2, int n, DCSLogicalChannel dCSLogicalChannel, int n2, boolean bl, AddressResolver addressResolver) {
        super(discoveryServerMgr, string2, string, memberAuthenticator, discoveryTopicNameAnalyzer, dCSLogicalChannel);
        this._dtc = new DCSTraceContextImpl(TC, string2, string, TransportAdapter.TA_LAYER_NAME);
        this._transmitter = transmitterThread;
        this._myMemberName = string;
        this.BASE_TIMEOUT = l;
        this.HIGH_FREQ_TIMEOUT = l2;
        this._rmt = rMTransmitter;
        this._maxTokenLength = n;
        this._version = n2;
        this._addressResolver = addressResolver;
        this._iAmActive = !bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        DiscoveryServerMgr discoveryServerMgr = this._dsm;
        synchronized (discoveryServerMgr) {
            if (object == null) {
                Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "alarm(): Null node"};
                Tr.warning(TC, "DCSV0003", objectArray);
                return;
            }
            PtpRmmNode ptpRmmNode = (PtpRmmNode)object;
            try {
                Object[] objectArray;
                Object[] objectArray2;
                boolean bl;
                if (this.isClosed()) {
                    return;
                }
                if (DCSTraceBuffer.isEntryEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this._dtc, "DiscoverTx.alarm()", "Starting");
                    dCSTraceBuffer.addProperty("ID", ptpRmmNode.getId());
                    dCSTraceBuffer.addProperty(ptpRmmNode);
                    dCSTraceBuffer.invoke();
                }
                if (!(bl = this.isNodeCurrent(ptpRmmNode))) {
                    if (DCSTraceBuffer.isExitEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._dtc, "DiscoverTx.alarm()", "node is not current - exit");
                        dCSTraceBuffer.addProperty(this.toTxNode(ptpRmmNode));
                        dCSTraceBuffer.invoke();
                    }
                    return;
                }
                PtpRmmNode ptpRmmNode2 = (PtpRmmNode)this._scheduledAlarms.remove(ptpRmmNode.getName());
                if (ptpRmmNode2 == null) {
                    objectArray2 = new Object[]{this._coreStackName, this._myMemberName, "alarm(): No scheduled alarm for node " + ptpRmmNode};
                    Tr.warning(TC, "DCSV0003", objectArray2);
                } else if (ptpRmmNode2 != ptpRmmNode) {
                    objectArray2 = new Object[]{this._coreStackName, this._myMemberName, "alarm(): scheduled alarm node does not match current " + ptpRmmNode};
                    Tr.warning(TC, "DCSV0003", objectArray2);
                }
                boolean bl2 = this._attemptingNodes.remove(ptpRmmNode);
                if (bl2) {
                    objectArray = new Object[]{this._coreStackName, this._myMemberName, "alarm(): A dispatched async connection request exists for node " + ptpRmmNode};
                    Tr.warning(TC, "DCSV0003", objectArray);
                }
                objectArray = (Object[])this._deadTxNodesPolicies.get(ptpRmmNode);
                boolean bl3 = this.createConnection(ptpRmmNode);
                if (!bl3) {
                    this.setAlarm(ptpRmmNode, (DiscoveryNodePolicy)objectArray);
                } else {
                    objectArray.setAlarm(null);
                }
                if (DCSTraceBuffer.isExitEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._dtc, "DiscoverTx.alarm()", "Exit, success = " + bl3);
                    dCSTraceBuffer.addProperty(ptpRmmNode);
                    dCSTraceBuffer.invoke();
                }
            }
            catch (Throwable throwable) {
                Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "alarm(): Got Exception for node " + ptpRmmNode, throwable};
                Tr.warning(TC, "DCSV0002", objectArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(PtpRmmNode ptpRmmNode) {
        DiscoveryServerMgr discoveryServerMgr = this._dsm;
        synchronized (discoveryServerMgr) {
            Object[] objectArray;
            DCSTraceBuffer dCSTraceBuffer;
            if (this.isClosed()) {
                return;
            }
            if (ptpRmmNode == null) {
                Object[] objectArray2 = new Object[]{this._coreStackName, this._myMemberName, "onFailure(): Null node"};
                Tr.warning(TC, "DCSV0003", objectArray2);
                return;
            }
            if (DCSTraceBuffer.isEntryEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.entry(this._dtc, "DiscoverTx.onFailure()", "Starting");
                dCSTraceBuffer.addProperty("IsNodeDefined", this.isDefined(ptpRmmNode));
                dCSTraceBuffer.addProperty("ID", ptpRmmNode.getId());
                dCSTraceBuffer.addProperty(ptpRmmNode);
                dCSTraceBuffer.invoke();
            }
            if (!this.isNodeCurrent(ptpRmmNode)) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.onFailure()", "node is not current, exit");
                    dCSTraceBuffer.addProperty(this.toTxNode(ptpRmmNode));
                    dCSTraceBuffer.invoke();
                }
                return;
            }
            boolean bl = this._attemptingNodes.remove(ptpRmmNode);
            if (!bl) {
                objectArray = new Object[]{this._coreStackName, this._myMemberName, "onFailure(): No entry in the attempting nodes " + ptpRmmNode};
                Tr.warning(TC, "DCSV0003", objectArray);
            }
            if ((objectArray = (Object[])this._scheduledAlarms.get(ptpRmmNode.getName())) != null) {
                Object[] objectArray3 = new Object[]{this._coreStackName, this._myMemberName, "onFailure(): Found a scheduled alarm for node " + ptpRmmNode};
                Tr.warning(TC, "DCSV0003", objectArray3);
            }
            boolean bl2 = false;
            PtpRmmNode ptpRmmNode2 = (PtpRmmNode)this._pendingAccelerateDiscoveryRequests.remove(ptpRmmNode.getName());
            DiscoveryNodePolicy discoveryNodePolicy = (DiscoveryNodePolicy)this._deadTxNodesPolicies.get(ptpRmmNode);
            if (ptpRmmNode2 != null) {
                this.acceleratePolicy(ptpRmmNode);
                bl2 = true;
            }
            this.setAlarm(ptpRmmNode, discoveryNodePolicy);
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this._dtc, "DiscoverTx.onFailure()", "accelerated = " + bl2);
                dCSTraceBuffer2.invoke();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(PtpRmmNode ptpRmmNode, QueueTHandler queueTHandler) {
        DiscoveryServerMgr discoveryServerMgr = this._dsm;
        synchronized (discoveryServerMgr) {
            Object object;
            Object[] objectArray;
            if (this.isClosed()) {
                queueTHandler.close(false);
                this.closeRmmConnection(queueTHandler.getConnection());
                return;
            }
            if (ptpRmmNode == null) {
                queueTHandler.close(false);
                this.closeRmmConnection(queueTHandler.getConnection());
                Tr.warning(TC, "DCSV0003", new Object[]{this._coreStackName, this._myMemberName, "onSuccess(): null node"});
                return;
            }
            if (DCSTraceBuffer.isEntryEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this._dtc, "DiscoverTx.onSuccess()", "Starting");
                dCSTraceBuffer.addProperty("IsNodeDefined", this.isDefined(ptpRmmNode));
                dCSTraceBuffer.addProperty("StreamId", queueTHandler.getStreamId());
                dCSTraceBuffer.addProperty("ID", ptpRmmNode.getId());
                dCSTraceBuffer.addProperty(ptpRmmNode);
                dCSTraceBuffer.addProperty("RmmConnection", queueTHandler.getConnection());
                dCSTraceBuffer.invoke();
            }
            if (!this.isNodeCurrent(ptpRmmNode)) {
                queueTHandler.close(false);
                this.closeRmmConnection(queueTHandler.getConnection());
                Tr.warning(TC, "DCSV0003", new Object[]{this._coreStackName, this._myMemberName, "onSuccess(): Node is not current " + ptpRmmNode});
                return;
            }
            boolean bl = this._attemptingNodes.remove(ptpRmmNode);
            if (!bl) {
                objectArray = new Object[]{this._coreStackName, this._myMemberName, "onSuccess(): No entry in attempting map for node " + ptpRmmNode};
                Tr.warning(TC, "DCSV0003", objectArray);
            }
            if ((objectArray = (Object[])this._scheduledAlarms.get(ptpRmmNode.getName())) != null) {
                object = new Object[]{this._coreStackName, this._myMemberName, "onSuccess(): Found a scheduled alarm for node " + ptpRmmNode};
                Tr.warning(TC, "DCSV0003", object);
            }
            ptpRmmNode.setRmmConnection(queueTHandler.getConnection());
            this.addNodeToLiveMap(ptpRmmNode, queueTHandler);
            this.removeNodeFromDeadMap(ptpRmmNode);
            this._pendingAccelerateDiscoveryRequests.remove(ptpRmmNode.getName());
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                object = DCSTraceBuffer.exit(this._dtc, "DiscoverTx.onSuccess()", "TxLive Exiting");
                ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
                ((DCSTraceBuffer)object).invoke();
            }
            this._dsm.live(ptpRmmNode.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTransmissionEvent(PtpRmmNode ptpRmmNode, Event event2) {
        DCSTraceContext dCSTraceContext;
        if (ptpRmmNode == null) {
            Tr.warning(TC, "DCSV0003", new Object[]{this._coreStackName, this._myMemberName, "onTransmissionEvent(): null node"});
            return;
        }
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceContext = DCSTraceBuffer.entry(this._dtc, "DiscoverTx.onTransmissionEvent()", "TX dead");
            ((DCSTraceBuffer)dCSTraceContext).addProperty("ID", ptpRmmNode.getId());
            ((DCSTraceBuffer)dCSTraceContext).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)dCSTraceContext).addProperty("RmmEvent", event2.getType());
            ((DCSTraceBuffer)dCSTraceContext).invoke();
        }
        dCSTraceContext = this._dsm;
        synchronized (dCSTraceContext) {
            Object object;
            if (this.isClosed()) {
                return;
            }
            boolean bl = this.isNodeCurrent(ptpRmmNode);
            if (bl) {
                this.removeNodeFromLiveMap(ptpRmmNode);
                this.addNodeToDeadMap(ptpRmmNode, true);
                object = new RmmQueueTransmitterEvent(event2, ptpRmmNode, this._channelName, this._dtc);
                this._dsm.dead(ptpRmmNode.getName(), ((RmmEvent)object).toSuspectEvent());
            }
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                object = DCSTraceBuffer.exit(this._dtc, "DiscoverTx.onTransmissionEvent()", "nodeIsCurrent = " + bl);
                ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
                ((DCSTraceBuffer)object).invoke();
            }
        }
    }

    public void ping(String string) {
        Object object;
        PtpRmmNode ptpRmmNode = this.toTxNode(string);
        if (ptpRmmNode == null) {
            Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "ping(): TX node is null "};
            Tr.warning(TC, "DCSV0003", objectArray);
            return;
        }
        QueueTHandler queueTHandler = (QueueTHandler)this._liveTxNodesQueueT.get(ptpRmmNode);
        if (queueTHandler == null) {
            Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "ping(): Cannot ping node " + ptpRmmNode};
            Tr.warning(TC, "DCSV0003", objectArray);
            return;
        }
        String string2 = "Sent ping";
        if (queueTHandler.getQueueT() == null) {
            string2 = "QT is null, no ping sent";
        } else {
            object = RmmUtils.getDCSHbt();
            this._transmitter.submitMessage(queueTHandler.getQueueT(), (byte[])object, 0, ((byte[])object).length);
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._dtc, "DiscoverTx.ping()", string);
            ((DCSTraceBuffer)object).addProperty("Report", string2);
            ((DCSTraceBuffer)object).addProperty("ID", ptpRmmNode.getId());
            ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)object).invoke();
        }
    }

    public String dump() {
        return "DiscoveryTX - no Data";
    }

    void addDefined(String string, UnicastConnectionIf unicastConnectionIf) {
        PtpRmmNode ptpRmmNode = this.toTxNode(string);
        if (ptpRmmNode != null) {
            Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "addDefined(): TX node is already defined " + ptpRmmNode};
            Tr.warning(TC, "DCSV0003", objectArray);
            return;
        }
        ptpRmmNode = new PtpRmmNode(string, unicastConnectionIf);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.addDefined", string);
            dCSTraceBuffer.addProperty("ID", ptpRmmNode.getId());
            dCSTraceBuffer.addProperty(ptpRmmNode);
            dCSTraceBuffer.invoke();
        }
        super.addDefined(ptpRmmNode);
        this.addNodeToDeadMap(ptpRmmNode, false);
    }

    void removeDefined(String string) {
        boolean bl;
        Object[] objectArray;
        Object object;
        PtpRmmNode ptpRmmNode = this.toTxNode(string);
        if (ptpRmmNode == null) {
            Object[] objectArray2 = new Object[]{this._coreStackName, this._myMemberName, "removeDefined(): TX node is not defined " + string};
            Tr.warning(TC, "DCSV0003", objectArray2);
            return;
        }
        boolean bl2 = this.isLive(string);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._dtc, "DiscoverTx.removeDefined", string);
            ((DCSTraceBuffer)object).addProperty("IsNodeLive", bl2);
            ((DCSTraceBuffer)object).addProperty("ID", ptpRmmNode.getId());
            ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)object).invoke();
        }
        this.removeNodeFromDeadMap(ptpRmmNode);
        object = this.removeNodeFromLiveMap(ptpRmmNode);
        if (object != null) {
            this.closeRmmConnection((UnicastConnectionIf)object);
        }
        super.removeDefined(ptpRmmNode);
        PtpRmmNode ptpRmmNode2 = (PtpRmmNode)this._pendingAccelerateDiscoveryRequests.remove(string);
        if (ptpRmmNode2 != null && bl2) {
            objectArray = new Object[]{this._coreStackName, this._myMemberName, "removeDefined(): Pending accelerate request for live node " + ptpRmmNode2};
            Tr.warning(TC, "DCSV0003", objectArray);
        }
        if ((ptpRmmNode2 = (PtpRmmNode)this._scheduledAlarms.remove(string)) != null && bl2) {
            objectArray = new Object[]{this._coreStackName, this._myMemberName, "removeDefined(): Pending alarm for live node " + ptpRmmNode2};
            Tr.warning(TC, "DCSV0003", objectArray);
        }
        if ((bl = this._attemptingNodes.remove(ptpRmmNode)) && bl2) {
            Object[] objectArray3 = new Object[]{this._coreStackName, this._myMemberName, "removeDefined(): Attempting for live node " + ptpRmmNode};
            Tr.warning(TC, "DCSV0003", objectArray3);
        }
    }

    Long getLifeId(String string) {
        Object object;
        PtpRmmNode ptpRmmNode = this.toTxNode(string);
        if (ptpRmmNode == null) {
            Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "getLifeId(): TX node is not defined"};
            Tr.warning(TC, "DCSV0003", objectArray);
            return null;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._dtc, "DiscoverTx.getLifeId()", string);
            ((DCSTraceBuffer)object).addProperty("ID", ptpRmmNode.getId());
            ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = (QueueTHandler)this._liveTxNodesQueueT.get(ptpRmmNode)) == null) {
            return null;
        }
        PtpRmmNode ptpRmmNode2 = ((QueueTHandler)object).getNode();
        boolean bl = this.isNodeCurrent(ptpRmmNode2);
        if (bl) {
            return ((QueueTHandler)object).getStreamId();
        }
        return null;
    }

    void sendLifeMessage(String string, Long l) {
        Object object;
        PtpRmmNode ptpRmmNode = this.toTxNode(string);
        if (ptpRmmNode == null) {
            Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "sendLifeMessage(): TX node is not defined"};
            Tr.warning(TC, "DCSV0003", objectArray);
            return;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._dtc, "DiscoverTx.sendLifeMessage()", string);
            ((DCSTraceBuffer)object).addProperty("LifeId", l);
            ((DCSTraceBuffer)object).addProperty("ID", ptpRmmNode.getId());
            ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = (QueueTHandler)this._liveTxNodesQueueT.get(ptpRmmNode)) == null) {
            Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "sendLifeMessage(): Got null QueueTHandler " + ptpRmmNode};
            Tr.warning(TC, "DCSV0003", objectArray);
            return;
        }
        if (((QueueTHandler)object).getQueueT() == null) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.sendLifeMessage()", string);
                dCSTraceBuffer.addProperty("Report", "No message sent. QT is null");
                dCSTraceBuffer.invoke();
            }
        } else {
            byte[] byArray = Utils.long2byteArray(l);
            this._transmitter.submitMessage(((QueueTHandler)object).getQueueT(), byArray, 0, byArray.length);
        }
    }

    boolean isLive(String string) {
        Object object;
        PtpRmmNode ptpRmmNode = this.toTxNode(string);
        if (ptpRmmNode == null) {
            return false;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._dtc, "DiscoverTx.isAlive()", string);
            ((DCSTraceBuffer)object).addProperty("ID", ptpRmmNode.getId());
            ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = (QueueTHandler)this._liveTxNodesQueueT.get(ptpRmmNode)) == null) {
            return false;
        }
        PtpRmmNode ptpRmmNode2 = ((QueueTHandler)object).getNode();
        boolean bl = this.isNodeCurrent(ptpRmmNode2);
        return bl;
    }

    void accelerateDiscovery(String string, UnicastConnectionIf unicastConnectionIf) {
        PtpRmmNode ptpRmmNode = this.toTxNode(string);
        if (ptpRmmNode == null) {
            Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "accelerateDiscovery(): TX node is not defined"};
            Tr.warning(TC, "DCSV0003", objectArray);
            return;
        }
        DiscoveryNodePolicy discoveryNodePolicy = (DiscoveryNodePolicy)this._deadTxNodesPolicies.get(ptpRmmNode);
        if (discoveryNodePolicy == null) {
            Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "accelerateDiscovery(): Accelerate node is not Dead " + ptpRmmNode};
            Tr.warning(TC, "DCSV0003", objectArray);
            return;
        }
        if (this._attemptingNodes.contains(ptpRmmNode)) {
            ptpRmmNode.setRmmConnection(unicastConnectionIf);
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.accelerateDiscovery()", string);
                dCSTraceBuffer.addProperty("Report", "Async request dispatched. Queue accelerate request.");
                dCSTraceBuffer.addProperty("ID", ptpRmmNode.getId());
                dCSTraceBuffer.addProperty(ptpRmmNode);
                dCSTraceBuffer.invoke();
            }
            this._pendingAccelerateDiscoveryRequests.put(string, ptpRmmNode);
            return;
        }
        this.removeDefined(string);
        this.addDefined(string, unicastConnectionIf);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.accelerateDiscovery()", "Reset member and alarm");
            dCSTraceBuffer.addProperty("ID", ptpRmmNode.getId());
            dCSTraceBuffer.addProperty(this.toTxNode(string));
            dCSTraceBuffer.invoke();
        }
    }

    void clearConnection(String string) {
        PtpRmmNode ptpRmmNode = this.toTxNode(string);
        if (ptpRmmNode == null) {
            Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "clearConnection(): TX node is not defined"};
            Tr.warning(TC, "DCSV0003", objectArray);
            return;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.clearConnection()", string);
            dCSTraceBuffer.addProperty("ID", ptpRmmNode.getId());
            dCSTraceBuffer.addProperty(ptpRmmNode);
            dCSTraceBuffer.invoke();
        }
        if (this._deadTxNodesPolicies.containsKey(ptpRmmNode)) {
            ptpRmmNode.resetRmmConnection();
        }
        this._pendingAccelerateDiscoveryRequests.remove(string);
    }

    UnicastConnectionIf getConnection(String string) {
        Object object;
        PtpRmmNode ptpRmmNode = this.toTxNode(string);
        if (ptpRmmNode == null) {
            Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "getConnection(): TX node is not defined"};
            Tr.warning(TC, "DCSV0003", objectArray);
            return null;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._dtc, "DiscoverTx.getConnection()", string);
            ((DCSTraceBuffer)object).addProperty("ID", ptpRmmNode.getId());
            ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = (QueueTHandler)this._liveTxNodesQueueT.get(ptpRmmNode)) == null) {
            return null;
        }
        PtpRmmNode ptpRmmNode2 = ((QueueTHandler)object).getNode();
        boolean bl = this.isNodeCurrent(ptpRmmNode2);
        if (bl) {
            return ((QueueTHandler)object).getConnection();
        }
        return null;
    }

    void close() {
        Object object;
        Iterator iterator;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            iterator = DCSTraceBuffer.event(this._dtc, "DiscoverTx.close()", null);
            ((DCSTraceBuffer)((Object)iterator)).invoke();
        }
        super.close();
        iterator = this._deadTxNodesPolicies.values().iterator();
        while (iterator.hasNext()) {
            object = (DiscoveryNodePolicy)iterator.next();
            ((DiscoveryNodePolicy)object).cancelAlarm();
        }
        this._deadTxNodesPolicies.clear();
        iterator = this._liveTxNodesQueueT.values().iterator();
        while (iterator.hasNext()) {
            object = (QueueTHandler)iterator.next();
            if (object == null) continue;
            UnicastConnectionIf unicastConnectionIf = ((QueueTHandler)object).getConnection();
            ((QueueTHandler)object).close(false);
            this.closeRmmConnection(unicastConnectionIf);
        }
        this._liveTxNodesQueueT.clear();
        this._attemptingNodes.clear();
    }

    private boolean acceleratePolicy(PtpRmmNode ptpRmmNode) {
        DiscoveryNodePolicy discoveryNodePolicy = (DiscoveryNodePolicy)this._deadTxNodesPolicies.get(ptpRmmNode);
        if (discoveryNodePolicy == null) {
            Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "acceleratePolicy(): Accelerate node is not Dead " + ptpRmmNode};
            Tr.warning(TC, "DCSV0003", objectArray);
            return false;
        }
        boolean bl = discoveryNodePolicy.accelerate();
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.acceleratePolicy", "accelerated = " + bl);
            dCSTraceBuffer.addProperty(ptpRmmNode);
            dCSTraceBuffer.invoke();
        }
        return true;
    }

    private void closeRmmConnection(UnicastConnectionIf unicastConnectionIf) {
        if (unicastConnectionIf == null) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.closeRmmConnection()", "null connection");
                dCSTraceBuffer.invoke();
            }
            return;
        }
        boolean bl = unicastConnectionIf.closeConnection(0);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.closeRmmConnection()", "closing connection");
            dCSTraceBuffer.addProperty("RmmConnection", unicastConnectionIf);
            dCSTraceBuffer.addProperty("Flag", bl);
            dCSTraceBuffer.invoke();
        }
    }

    private boolean createConnection(PtpRmmNode ptpRmmNode) {
        Object object;
        Object object2;
        byte[] byArray = this._authenticator.getToken(this._coreStackName, ptpRmmNode.getName());
        if (byArray == null) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.createConnection()", "null token - accelerate discovery");
                dCSTraceBuffer.addProperty(ptpRmmNode);
                dCSTraceBuffer.invoke();
            }
            this.acceleratePolicy(ptpRmmNode);
            return false;
        }
        if (byArray.length > this._maxTokenLength) {
            ReceivedIllegalTokenEvent receivedIllegalTokenEvent = new ReceivedIllegalTokenEvent(this._dtc, byArray.length, this._maxTokenLength, "createConnection");
            this._dsm.onError(receivedIllegalTokenEvent);
            return false;
        }
        byte[] byArray2 = this._topicAnalyzer.createTopicName(byArray, this._version);
        if (ptpRmmNode.hasRmmConnection()) {
            Object object3;
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object3 = DCSTraceBuffer.event(this._dtc, "DiscoverTx.createConnection()", "create over existing connection");
                ((DCSTraceBuffer)object3).addProperty(ptpRmmNode);
                ((DCSTraceBuffer)object3).addProperty("RmmConnection", ptpRmmNode.getRmmConnection());
                ((DCSTraceBuffer)object3).invoke();
            }
            object3 = new QueueTHandler(this._rmt, this._coreStackName, this._memberName, (QueueTHandlerListener)this);
            boolean bl = ((QueueTHandler)object3).openDiscoveryOverExistingConnection(ptpRmmNode, byArray2);
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.createConnection()", "success = " + bl);
                dCSTraceBuffer.addProperty(ptpRmmNode);
                dCSTraceBuffer.invoke();
            }
            if (!bl) {
                ptpRmmNode.setRmmConnection(null);
            } else {
                this.addNodeToLiveMap(ptpRmmNode, (QueueTHandler)object3);
                this.removeNodeFromDeadMap(ptpRmmNode);
                this._pendingAccelerateDiscoveryRequests.remove(ptpRmmNode.getName());
                this._dsm.live(ptpRmmNode.getName());
            }
            return bl;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.createConnection()", "ASYNC open connection");
            dCSTraceBuffer.addProperty(ptpRmmNode);
            dCSTraceBuffer.invoke();
        }
        boolean bl = false;
        try {
            object2 = new QueueTHandler(this._rmt, this._coreStackName, this._memberName, this._addressResolver, this);
            bl = ((QueueTHandler)object2).openDiscoveryAsync(ptpRmmNode, byArray2, this);
            if (bl) {
                this._attemptingNodes.add(ptpRmmNode);
            }
        }
        catch (DCSInvalidParametersException dCSInvalidParametersException) {
            object = new Object[]{this._coreStackName, this._myMemberName, "createConnection(): Error opening connection " + ptpRmmNode, dCSInvalidParametersException};
            Tr.warning(TC, "DCSV0002", object);
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object2 = DCSTraceBuffer.event(this._dtc, "DiscoverTx.createConnection()", "success = " + bl);
            ((DCSTraceBuffer)object2).addProperty(ptpRmmNode);
            object = (bl ? "Openning" : "Failed") + ", ";
            object = (String)object + (this._attemptingNodes.contains(ptpRmmNode) ? "still attempting" : "not attempting anymore");
            ((DCSTraceBuffer)object2).addProperty("QueueTAsyncStatus", object);
            ((DCSTraceBuffer)object2).invoke();
        }
        return bl;
    }

    private void addNodeToDeadMap(PtpRmmNode ptpRmmNode, boolean bl) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.addNodeToDeadMap()", null);
            dCSTraceBuffer.addProperty(ptpRmmNode);
            dCSTraceBuffer.addProperty("Flag", bl);
            dCSTraceBuffer.invoke();
        }
        long l = this.BASE_TIMEOUT;
        if (this.shouldDiscoverNodeFrequently(ptpRmmNode)) {
            l = this.HIGH_FREQ_TIMEOUT;
        }
        DiscoveryNodePolicy discoveryNodePolicy = new DiscoveryConstantPolicy(l);
        if (bl) {
            discoveryNodePolicy = new DiscoveryDisconnectedPolicy(discoveryNodePolicy);
        }
        this._deadTxNodesPolicies.put(ptpRmmNode, discoveryNodePolicy);
        this.setAlarm(ptpRmmNode, discoveryNodePolicy);
    }

    private void removeNodeFromDeadMap(PtpRmmNode ptpRmmNode) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._dtc, "DiscoverTx.removeNodeFromDeadMap()", null);
            ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = (DiscoveryNodePolicy)this._deadTxNodesPolicies.remove(ptpRmmNode)) != null) {
            this.cancelAlarm(ptpRmmNode, (DiscoveryNodePolicy)object);
        }
    }

    private UnicastConnectionIf removeNodeFromLiveMap(PtpRmmNode ptpRmmNode) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._dtc, "DiscoverTx.removeNodeFromLiveMap()", null);
            ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = (QueueTHandler)this._liveTxNodesQueueT.remove(ptpRmmNode)) == null) {
            return null;
        }
        UnicastConnectionIf unicastConnectionIf = ((QueueTHandler)object).getConnection();
        ((QueueTHandler)object).close(false);
        return unicastConnectionIf;
    }

    private void addNodeToLiveMap(PtpRmmNode ptpRmmNode, QueueTHandler queueTHandler) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._dtc, "DiscoverTx.addNodeToLiveMap()", null);
            ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = queueTHandler.getConnection()) == null) {
            Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "addNodeToLiveMap(): no connection " + ptpRmmNode};
            Tr.warning(TC, "DCSV0003", objectArray);
            return;
        }
        this._liveTxNodesQueueT.put(ptpRmmNode, queueTHandler);
    }

    private void setAlarm(PtpRmmNode ptpRmmNode, DiscoveryNodePolicy discoveryNodePolicy) {
        if (discoveryNodePolicy == null) {
            Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "setAlarm(): null policy " + ptpRmmNode};
            Tr.warning(TC, "DCSV0003", objectArray);
            return;
        }
        long l = discoveryNodePolicy.getNextTime();
        if (!this._scheduledAlarms.containsKey((ptpRmmNode = this.toNode(ptpRmmNode.getName())).getName())) {
            Object object;
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this._dtc, "DiscoverTx.setAlarm()", "Scheduling alarm");
                ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
                ((DCSTraceBuffer)object).addProperty("Timeout", l);
                ((DCSTraceBuffer)object).addProperty("DiscoveryPolicy", discoveryNodePolicy);
                ((DCSTraceBuffer)object).invoke();
            }
            object = AlarmManager.create(AlarmManager.DISCOVERY_ALARM, l, null, this, ptpRmmNode);
            discoveryNodePolicy.setAlarm((Alarm)object);
            this._scheduledAlarms.put(ptpRmmNode.getName(), ptpRmmNode);
        } else if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.setAlarm()", "Do NOT schedule alarm. Alarm already exists");
            dCSTraceBuffer.addProperty(ptpRmmNode);
            dCSTraceBuffer.addProperty("Timeout", l);
            dCSTraceBuffer.addProperty("DiscoveryPolicy", discoveryNodePolicy);
            dCSTraceBuffer.invoke();
        }
    }

    private void cancelAlarm(PtpRmmNode ptpRmmNode, DiscoveryNodePolicy discoveryNodePolicy) {
        boolean bl;
        if (discoveryNodePolicy == null) {
            Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "cancelAlarm(): null policy " + ptpRmmNode};
            Tr.warning(TC, "DCSV0003", objectArray);
            return;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.cancelAlarm()", null);
            dCSTraceBuffer.addProperty(ptpRmmNode);
            dCSTraceBuffer.addProperty("DiscoveryPolicy", discoveryNodePolicy);
            dCSTraceBuffer.invoke();
        }
        if (!(bl = this.isNodeCurrent(ptpRmmNode))) {
            Object[] objectArray = new Object[]{this._coreStackName, this._myMemberName, "cancelAlarm(): node is not current " + ptpRmmNode};
            Tr.warning(TC, "DCSV0003", objectArray);
            return;
        }
        this._scheduledAlarms.remove(ptpRmmNode.getName());
        discoveryNodePolicy.cancelAlarm();
    }

    private boolean isNodeCurrent(PtpRmmNode ptpRmmNode) {
        if (ptpRmmNode == null) {
            return false;
        }
        int n = ptpRmmNode.getId();
        PtpRmmNode ptpRmmNode2 = this.toTxNode(ptpRmmNode);
        int n2 = 0;
        if (ptpRmmNode2 != null) {
            n2 = ptpRmmNode2.getId();
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "DiscoverTx.isNodeCurrent()", null);
            dCSTraceBuffer.addProperty("Current", "ID", n2);
            dCSTraceBuffer.addProperty("Incoming", "ID", n);
            dCSTraceBuffer.addProperty(ptpRmmNode);
            dCSTraceBuffer.addProperty(ptpRmmNode2);
            dCSTraceBuffer.invoke();
        }
        return ptpRmmNode2 == ptpRmmNode;
    }

    private PtpRmmNode toTxNode(PtpRmmNode ptpRmmNode) {
        if (ptpRmmNode == null) {
            return null;
        }
        return this.toNode(ptpRmmNode.getName());
    }

    private PtpRmmNode toTxNode(String string) {
        if (string == null) {
            return null;
        }
        return this.toNode(string);
    }

    private boolean shouldDiscoverNodeFrequently(PtpRmmNode ptpRmmNode) {
        boolean bl = this._addressResolver.isPassiveDiscovery(ptpRmmNode.getName());
        return this._iAmActive && bl;
    }
}

