/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmm.transmitter.CreateQueueTListener;
import com.ibm.rmm.transmitter.Event;
import com.ibm.rmm.transmitter.EventListener;
import com.ibm.rmm.transmitter.QueueT;
import com.ibm.rmm.transmitter.RMTransmitter;
import com.ibm.rmm.util.UnicastConnectionIf;
import com.ibm.ws.dcs.common.AddressResolver;
import com.ibm.ws.dcs.common.MemberAddress;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import com.ibm.ws.dcs.vri.transportAdapter.TransportAdapter;
import com.ibm.ws.dcs.vri.transportAdapter.TransportInternalException;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.PtpRmmNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.QueueTHandlerCreationListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.QueueTHandlerListener;

public final class QueueTHandler
implements EventListener,
CreateQueueTListener {
    private final QueueTHandlerListener _eventsListener;
    private QueueTHandlerCreationListener _creationListener;
    private final AddressResolver _addressResolver;
    private static final TraceComponent TC = Tr.register(QueueTHandler.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private final DCSTraceContext _dtc;
    private final int ASYNC_TIMEOUT_SEC = 20;
    protected final RMTransmitter _rmt;
    private Object _queueName;
    private QueueT _queueT = null;
    private Long _sid = null;
    private UnicastConnectionIf _ucid = null;
    private PtpRmmNode _node;
    private int _state;
    private static final int NOT_ACTIVE = 1;
    private static final int OPENNING = 2;
    private static final int ACTIVE = 3;

    public QueueTHandler(RMTransmitter rMTransmitter, Object object, PtpRmmNode ptpRmmNode, QueueTHandlerListener queueTHandlerListener, AddressResolver addressResolver) {
        this._rmt = rMTransmitter;
        this._queueName = object;
        this._node = ptpRmmNode;
        this._eventsListener = queueTHandlerListener;
        this._state = 1;
        this._addressResolver = addressResolver;
        this._dtc = new DCSTraceContextImpl(TC, "unknown", "unknown", TransportAdapter.TA_LAYER_NAME);
    }

    public QueueTHandler(RMTransmitter rMTransmitter, Object object, PtpRmmNode ptpRmmNode, QueueTHandlerListener queueTHandlerListener) {
        this(rMTransmitter, object, ptpRmmNode, queueTHandlerListener, null);
    }

    public QueueTHandler(RMTransmitter rMTransmitter, String string, String string2, AddressResolver addressResolver, QueueTHandlerListener queueTHandlerListener) {
        this._rmt = rMTransmitter;
        this._eventsListener = queueTHandlerListener;
        this._state = 1;
        this._addressResolver = addressResolver;
        this._dtc = new DCSTraceContextImpl(TC, string, string2, TransportAdapter.TA_LAYER_NAME);
    }

    public QueueTHandler(RMTransmitter rMTransmitter, String string, String string2, QueueTHandlerListener queueTHandlerListener) {
        this._rmt = rMTransmitter;
        this._eventsListener = queueTHandlerListener;
        this._state = 1;
        this._addressResolver = null;
        this._dtc = new DCSTraceContextImpl(TC, string, string2, TransportAdapter.TA_LAYER_NAME);
    }

    public boolean open() throws DCSInvalidParametersException {
        this.checkState(1);
        String string = null;
        if (!(this._queueName instanceof String)) {
            throw new TransportInternalException("QueueTHandler.open: queue name should be String");
        }
        string = (String)this._queueName;
        if (this._node.hasRmmConnection()) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "QueueTHandler.open()", "Going to create a blocking QT using an existing connection");
                dCSTraceBuffer.addProperty(this._node);
                dCSTraceBuffer.invoke();
            }
            this._queueT = this._rmt.createQueueTransmitter(string, null, this._node.getRmmConnection());
            if (this._queueT != null) {
                this._sid = this._queueT.getStreamId();
                this._ucid = this._queueT.getUnicastConnection();
            }
        } else if (!this.openQTonIpPort(string, true)) {
            return false;
        }
        return this.doAfterCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openDiscoveryOverExistingConnection(PtpRmmNode ptpRmmNode, byte[] byArray) {
        this._queueName = byArray;
        this._node = ptpRmmNode;
        this._creationListener = null;
        Object object = this;
        synchronized (object) {
            this.checkState(1);
            this._state = 2;
        }
        if (!this._node.hasRmmConnection()) {
            object = "Required connection is null for Discovery";
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._dtc, (String)object, null);
            dCSTraceBuffer.addProperty(this._node);
            dCSTraceBuffer.addProperty("TopicName", this._queueName);
            dCSTraceBuffer.invoke();
            return false;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._dtc, "openDiscoveryOverExistingConnection", "Create QT over existing connection");
            ((DCSTraceBuffer)object).addProperty(this._node);
            ((DCSTraceBuffer)object).invoke();
        }
        this._queueT = this._rmt.createQueueTransmitter(null, byArray, this._node.getRmmConnection());
        if (this._queueT == null) {
            return false;
        }
        this._sid = this._queueT.getStreamId();
        this._ucid = this._queueT.getUnicastConnection();
        return this.doAfterCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openDiscoveryAsync(PtpRmmNode ptpRmmNode, byte[] byArray, QueueTHandlerCreationListener queueTHandlerCreationListener) throws DCSInvalidParametersException {
        this._queueName = byArray;
        this._node = ptpRmmNode;
        this._creationListener = queueTHandlerCreationListener;
        QueueTHandler queueTHandler = this;
        synchronized (queueTHandler) {
            this.checkState(1);
            this._state = 2;
        }
        return this.openQTonIpPort(byArray, false);
    }

    private boolean openQTonIpPort(Object object, boolean bl) throws DCSInvalidParametersException {
        String string;
        String string2 = string = bl ? "Blocking" : "Async";
        if (this._addressResolver == null) {
            throw new DCSInvalidParametersException();
        }
        MemberAddress memberAddress = this._addressResolver.getAddress(this._node.getName());
        if (memberAddress == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._dtc, "Can't open " + string + " QueueT because DCS got null member address from the AddressResolver", "QueueTHandler.openQTonIpPort()", null);
                dCSTraceBuffer.addProperty(this._node);
                dCSTraceBuffer.addProperty("TopicName", this._queueName);
                dCSTraceBuffer.invoke();
            }
            return false;
        }
        String string3 = memberAddress.getIp();
        int n = memberAddress.getPort();
        if (n <= 0) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._dtc, "Can't open " + string + " QueueT with illegal port - " + n, "QueueTHandler.openQTonIpPort()", null);
                dCSTraceBuffer.addProperty(this._node);
                dCSTraceBuffer.addProperty("TopicName", this._queueName);
                dCSTraceBuffer.invoke();
            }
            return false;
        }
        if (this._addressResolver.isIpPortConflicting(this._node.getName())) {
            if (TC.isEventEnabled()) {
                Tr.debug(TC, "openQTonIpPort", "Member " + this._node.getName() + " has conflicting ip:port at " + string3 + ":" + n + ", " + "connection creation was not attempted.");
            }
            return false;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "QueueTHandler.openQTonIpPort()", "Going to create a " + string + " QueueT using ip, port");
            dCSTraceBuffer.addProperty(this._node);
            dCSTraceBuffer.addProperty("InetAddress", string3);
            dCSTraceBuffer.addProperty("Port", n);
            dCSTraceBuffer.invoke();
        }
        boolean bl2 = true;
        if (bl) {
            this._queueT = this._rmt.createQueueTransmitter((String)object, string3, n, true);
            if (this._queueT == null) {
                bl2 = false;
            } else {
                this._sid = this._queueT.getStreamId();
                this._ucid = this._queueT.getUnicastConnection();
            }
        } else {
            bl2 = this._rmt.createQueueTransmitter((byte[])object, string3, n, (CreateQueueTListener)this, 20000);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doAfterCreation() {
        if (this._queueT == null) {
            this.close(false);
            return false;
        }
        if (!this._queueT.setEventListener(this)) {
            this.close(false);
            return false;
        }
        QueueTHandler queueTHandler = this;
        synchronized (queueTHandler) {
            this._state = 3;
        }
        return true;
    }

    public synchronized void close(boolean bl) {
        if (this._queueT != null) {
            if (bl) {
                this._queueT.close();
            } else {
                this._queueT.closeNow();
            }
            this._queueT = null;
        }
        this._state = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event event2) {
        QueueTHandler queueTHandler = this;
        synchronized (queueTHandler) {
            if (this._state != 3) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "QueueTHandler.onEvent()", "Ignore not active state");
                    dCSTraceBuffer.addProperty(this._node);
                    dCSTraceBuffer.addProperty("RmmEvent", event2);
                    dCSTraceBuffer.addProperty("State", this.getState(this._state));
                    dCSTraceBuffer.invoke();
                }
                return;
            }
            this.close(false);
        }
        this._eventsListener.onTransmissionEvent(this._node, event2);
    }

    public synchronized Long getStreamId() {
        return this._sid;
    }

    public PtpRmmNode getNode() {
        return this._node;
    }

    public synchronized boolean isActive() {
        return this._state == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(QueueT queueT) {
        QueueTHandler queueTHandler = this;
        synchronized (queueTHandler) {
            if (this._state != 2) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._dtc, "Ignore Illegal State", "QueueTHandler.onSuccess()", null);
                    dCSTraceBuffer.addProperty(this._node);
                    dCSTraceBuffer.addProperty("State", this.getState(this._state));
                    dCSTraceBuffer.invoke();
                }
                return;
            }
            this._state = 3;
            this._queueT = queueT;
            this._sid = queueT.getStreamId();
            this._ucid = queueT.getUnicastConnection();
            this._node.setRmmConnection(this._ucid);
        }
        if (this.doAfterCreation()) {
            this._creationListener.onSuccess(this._node, this);
        } else {
            this._creationListener.onFailure(this._node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(String string, String string2, int n) {
        QueueTHandler queueTHandler = this;
        synchronized (queueTHandler) {
            if (this._state != 2) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._dtc, "QueueTHandler.onFailure()", "Ignore Illegal state");
                    dCSTraceBuffer.addProperty("TopicName", string);
                    dCSTraceBuffer.addProperty("InetAddress", string2);
                    dCSTraceBuffer.addProperty("Port", n);
                    dCSTraceBuffer.addProperty(this._node);
                    dCSTraceBuffer.addProperty("State", this.getState(this._state));
                    dCSTraceBuffer.invoke();
                }
                return;
            }
            this._state = 1;
        }
        this._creationListener.onFailure(this._node);
    }

    public QueueT getQueueT() {
        return this._queueT;
    }

    private void checkState(int n) {
        this.checkState(new int[]{n});
    }

    private void checkState(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (this._state != n) continue;
            return;
        }
        throw new TransportInternalException("QueueHandler Illegal state. state is " + this.getState(this._state) + ", while it should be one of " + Utils.toString(this.getStates(nArray)));
    }

    private String[] getStates(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            stringArray[i] = this.getState(n);
        }
        return stringArray;
    }

    private String getState(int n) {
        switch (n) {
            case 1: {
                return "NOT_ACTIVE";
            }
            case 2: {
                return "OPENNING";
            }
            case 3: {
                return "ACTIVE";
            }
        }
        throw new TransportInternalException("Illegal state " + this._state);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("QTH").append("::").append(this._queueName).append("::").append(this._sid).append("::").append(this._ucid);
        return stringBuffer.toString();
    }

    public synchronized UnicastConnectionIf getConnection() {
        return this._ucid;
    }
}

