/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.htmt.rmm.RMM;
import com.ibm.ws.dcs.common.MemberAuthenticator;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.config.rmm.RMMMbuConfigMap;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.impl.BaseVRIMessageFactory;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.FFDCDumper;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.connected.PtpConnectedChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryServer;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryServerMgr;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.CoreToDataTransportInfo;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.MbuCoreToDataTransportInfo;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.RmmAdapter;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.RmmInstanceData;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view.PtpViewChannel;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;

public abstract class MbuRmmAdapter
extends RmmAdapter {
    private static final long TERMINATE_SLEEP_TIME_MSEC = 1000L;
    protected DiscoveryServer _discoveryServer;
    private static TraceComponent TC = Tr.register(MbuRmmAdapter.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");

    MbuRmmAdapter(Globals globals) throws UnknownHostException {
        super(globals);
        MbuCoreToDataTransportInfo mbuCoreToDataTransportInfo = (MbuCoreToDataTransportInfo)_coreToDataInfo.get(this._g.getCoreGroupName());
        this._discoveryServer = mbuCoreToDataTransportInfo.getDiscoveryServer();
    }

    public void start(ViewIdImpl viewIdImpl) {
        DCSTraceBuffer dCSTraceBuffer;
        DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.propertyList();
        dCSTraceBuffer2.addProperty(viewIdImpl);
        dCSTraceBuffer2.addProperty("ClassName", this.getClass().getName());
        dCSTraceBuffer2.addProperty("AddressResolver", this._addressResolver);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "MbuRmmAdapter.start()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
        this.focus("start", dCSTraceBuffer2);
        this._conChannel = new PtpConnectedChannel(this, this._mmgr, this._thisMember, this._thisStackName, this._stackMutex, this._rmt, this._rmr, this._g.getConfigParamAsInt("RMM_ADAPTER_TRANS_CLOSE_TIME"), this._transmitter, this._g.getMetaMessageFactory(), this._discoveryServer, this._g.isCoreStack(), this._hbtTimeoutPeriodMillis, this._myAddressResolver);
        this._viewChannel = new PtpViewChannel(this, this._thisStackName, this._stackMutex, this._rmt, this._rmr, viewIdImpl, this._mmgr, this._thisMember, this._g.getConfigParamAsInt("RMM_ADAPTER_TRANS_CLOSE_TIME"), this._transmitter, BaseVRIMessageFactory.getInstance(this._g), this._g.getMetaMessageFactory(), this._g.getConfigParamAsInt("TRANSPORT_ADAPTER_NEW_VIEW_MEMBER_TIMEOUT"), this._hbtTimeoutPeriodMillis, null);
        super.start(viewIdImpl);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "MbuRmmAdapter.start()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
    }

    protected void setRmmConfig(Properties properties, Map map) {
        super.setRmmConfig(properties, map);
        Map map2 = (Map)this._g.getConfigParam("TRANSPORT_CONFIGURATION");
        RMMMbuConfigMap rMMMbuConfigMap = this.getRmmConfigMap(map2);
        rMMMbuConfigMap.addConfigToMap(map);
        rMMMbuConfigMap.addConfigToProp(properties);
        String string = this._myAddressResolver.getMyIpAsString();
        if (string == "*") {
            string = "All";
        }
        properties.setProperty("NetworkInterface", string);
        properties.setProperty("NetworkingType", "EmulatedMulticast");
        properties.setProperty("UnicastServerSocketPort", this._myAddressResolver.getMyPortAsString());
    }

    protected RMMMbuConfigMap getRmmConfigMap(Map map) {
        return new RMMMbuConfigMap(map);
    }

    protected boolean shouldCreateRmmInstance() {
        return !this.isRmmInstanceAvailable();
    }

    private RmmInstanceData getRmmInstanceData() {
        int n = this._myAddressResolver.getMyPortAsInt();
        return _rmmInstancesMgr.getRmmInstance(this.getClass(), new Integer(n));
    }

    private boolean isRmmInstanceAvailable() {
        int n = this._myAddressResolver.getMyPortAsInt();
        return _rmmInstancesMgr.isRmmInstanceAvailable(this.getClass(), new Integer(n));
    }

    private DiscoveryServer createDiscoveryServer() {
        Map map = (Map)this._g.getConfigParam("TRANSPORT_CONFIGURATION");
        RMMMbuConfigMap rMMMbuConfigMap = this.getRmmConfigMap(map);
        Map map2 = rMMMbuConfigMap.setOptionalParams();
        Integer n = (Integer)map2.get("MbuBasicDiscoveryIntervalSec");
        Integer n2 = (Integer)map2.get("MbuFwDiscoveryIntervalSec");
        long l = n * 1000;
        long l2 = n2 * 1000;
        int n3 = (Integer)map2.get("MbuMaxTokenSize");
        DiscoveryServerMgr discoveryServerMgr = new DiscoveryServerMgr(l, l2, this._rmm.rMT, this._rmm.rMR, this._thisMemberName, this._transmitter, (MemberAuthenticator)map2.get("MbuMemberAuthenticator"), n3, this._hbtTimeoutPeriodMillis, this._addressResolver, this._myAddressResolver);
        return discoveryServerMgr;
    }

    protected void registerRmmInstance() {
        RmmInstanceData rmmInstanceData = new RmmInstanceData();
        rmmInstanceData.setRmm(this._rmm);
        _rmmInstancesMgr.register(this.getClass(), new Integer(this._myAddressResolver.getMyPortAsInt()), rmmInstanceData, this._thisMemberName);
    }

    public void terminate(boolean bl, DCSTerminationEvent dCSTerminationEvent) {
        super.terminate(bl, dCSTerminationEvent);
        if (this._g.isCoreStack()) {
            boolean bl2 = _rmmInstancesMgr.releaseRmmInstance(this.getClass(), new Integer(this._myAddressResolver.getMyPortAsInt()));
            if (bl2) {
                this.killRmm();
            } else {
                this.sleepRmm();
            }
        }
    }

    public void mcastMessage(VRIMessage vRIMessage, VRIMemberDescription[] vRIMemberDescriptionArray, QoS.QOSMulticast qOSMulticast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        boolean bl;
        if (this._terminated) {
            return;
        }
        if (this._g.statsModule != null) {
            this._g.statsModule.onMsgSent(vRIMessage.getLength());
        }
        int n = vRIMessage.prepareBuffer();
        byte[] byArray = vRIMessage.getDataBuffer();
        if (qOSMulticast.getChannelType() == QoS.CONNECTED) {
            this.filterTargets(byArray, n, vRIMemberDescriptionArray, false);
            bl = this._conChannel.mcastMessage(byArray, 0, n, vRIMemberDescriptionArray);
        } else {
            this.filterTargets(byArray, n, vRIMemberDescriptionArray, true);
            bl = this._viewChannel.mcastMessage(byArray, 0, n, vRIMemberDescriptionArray);
        }
        if (!bl) {
            throw new DCSTransportLayerException("TransportAdapter.mcastMessage:" + this._thisStackName + ":failed to mcast message");
        }
    }

    private void sleepRmm() {
        DCSTraceBuffer dCSTraceBuffer;
        block4: {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.event(this, "MbuRmmAdapter.sleepRmm()", "Going to sleep");
                dCSTraceBuffer.addProperty("Timeout", 1000L);
                dCSTraceBuffer.invoke();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                if (!DCSTraceBuffer.isEventEnabled(TC)) break block4;
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this, "MbuRmmAdapter.sleepRmm()", "Sleep interrupted");
                dCSTraceBuffer2.invoke();
            }
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "MbuRmmAdapter.sleepRmm()", "Waked up");
            dCSTraceBuffer.invoke();
        }
    }

    protected CoreToDataTransportInfo getCoreToDataInfoInstance() {
        return new MbuCoreToDataTransportInfo();
    }

    protected void setInfoForDataStack(CoreToDataTransportInfo coreToDataTransportInfo) {
        MbuCoreToDataTransportInfo mbuCoreToDataTransportInfo = (MbuCoreToDataTransportInfo)coreToDataTransportInfo;
        mbuCoreToDataTransportInfo.setDiscoveryServer(this.createDiscoveryServer());
        super.setInfoForDataStack(coreToDataTransportInfo);
    }

    protected RMM retrieveRmmInstance() {
        return this.getRmmInstanceData().getRmm();
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public void dump() {
        super.dump();
    }

    public void dumpAll(FFDCDumper fFDCDumper) {
        String string = "\n************ MbuRmmAdapter dump: *******************\n" + this._discoveryServer.dump();
        fFDCDumper.writeLine(string);
        super.dumpAll(fFDCDumper);
    }
}

