/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.htmt.rmm.RMM;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.config.DCSIllegalConfigurationException;
import com.ibm.ws.dcs.common.config.rmm.RMMMulticastConfigMap;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.impl.BaseVRIMessageFactory;
import com.ibm.ws.dcs.vri.common.impl.SubgroupMcastHeader;
import com.ibm.ws.dcs.vri.common.nls.FailedToJoinConnectedMcastGroup;
import com.ibm.ws.dcs.vri.common.nls.FailedToJoinViewMcastGroup;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.TransportNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.connected.McastConnectedChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.mcastUtils.JoinMcastGroupFailedException;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.mcastUtils.McastIpAllocator;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.mcastUtils.MulticastGroupTracker;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.CoreToDataTransportInfo;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.McastCoreToDataTransportInfo;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.RmmAdapter;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.RmmInstanceData;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view.McastPtpViewChannel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;

public final class McastRmmAdapter
extends RmmAdapter {
    private static TraceComponent TC = Tr.register(McastRmmAdapter.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private McastIpAllocator _mcastGroupAllocator;
    private static MulticastGroupTracker _mcastTracker = new MulticastGroupTracker();

    McastRmmAdapter(Globals globals) throws UnknownHostException {
        super(globals);
        McastCoreToDataTransportInfo mcastCoreToDataTransportInfo = (McastCoreToDataTransportInfo)_coreToDataInfo.get(this._g.getCoreGroupName());
        this._mcastGroupAllocator = mcastCoreToDataTransportInfo.getIpAllocator();
        if (this._addressResolver == null) {
            this._addressResolver = mcastCoreToDataTransportInfo.getAddressResolver();
        }
        _mcastTracker.start(this._rmr, this._thisMemberName, this._thisStackName);
        String string = this._mcastGroupAllocator.allocateFirstIp().getHostAddress();
        try {
            _mcastTracker.joinMulticastGroup(this._thisStackName, string);
        }
        catch (JoinMcastGroupFailedException joinMcastGroupFailedException) {
            FailedToJoinConnectedMcastGroup failedToJoinConnectedMcastGroup = new FailedToJoinConnectedMcastGroup(this, string, "McastRmmAdapter()", joinMcastGroupFailedException);
            failedToJoinConnectedMcastGroup.invokeNLSTrace();
            throw new DCSRuntimeException(joinMcastGroupFailedException);
        }
    }

    public void newConnectedMember(VRIMemberDescription vRIMemberDescription, TransportNode transportNode) {
        Object object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("memberName", vRIMemberDescription.getName());
        dCSTraceBuffer.addProperty(transportNode);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "McastRmmAdapter.newConnectedMember()", null);
            ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object).invoke();
        }
        object = null;
        try {
            object = this._mcastGroupAllocator.allocateIp(this._thisStackName + "/" + vRIMemberDescription.getName()).getHostAddress();
            _mcastTracker.joinMulticastGroup(this._thisStackName, (String)object);
        }
        catch (UnknownHostException unknownHostException) {
            FailedToJoinViewMcastGroup failedToJoinViewMcastGroup = new FailedToJoinViewMcastGroup((DCSTraceContext)this, (String)object, vRIMemberDescription.getName());
            failedToJoinViewMcastGroup.invokeNLSTrace();
            return;
        }
        catch (JoinMcastGroupFailedException joinMcastGroupFailedException) {
            FailedToJoinViewMcastGroup failedToJoinViewMcastGroup = new FailedToJoinViewMcastGroup((DCSTraceContext)this, (String)object, vRIMemberDescription.getName());
            failedToJoinViewMcastGroup.invokeNLSTrace();
            return;
        }
        super.newConnectedMember(vRIMemberDescription, transportNode);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.exit(this, "McastRmmAdapter.newConnectedMember()", null);
            dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer2.invoke();
        }
    }

    public void connectedMemberRemoved(VRIMemberDescription vRIMemberDescription, DCSSuspectEvent dCSSuspectEvent) {
        Object object;
        super.connectedMemberRemoved(vRIMemberDescription, dCSSuspectEvent);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this, "McastRmmAdapter.connectedMemberRemoved()", null);
            ((DCSTraceBuffer)object).addProperty("memberName", vRIMemberDescription.getName());
            ((DCSTraceBuffer)object).addProperty("Reason", dCSSuspectEvent);
            ((DCSTraceBuffer)object).invoke();
        }
        object = null;
        try {
            object = this._mcastGroupAllocator.allocateIp(this._thisStackName + "/" + vRIMemberDescription.getName()).getHostAddress();
            _mcastTracker.leaveMulticastGroup(this._thisStackName, (String)object);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
    }

    public void start(ViewIdImpl viewIdImpl) {
        DCSTraceBuffer dCSTraceBuffer;
        DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.propertyList();
        dCSTraceBuffer2.addProperty(viewIdImpl);
        dCSTraceBuffer2.addProperty("My", "Port", this._myAddressResolver.getMyPortAsString());
        dCSTraceBuffer2.addProperty("ClassName", this.getClass().getName());
        dCSTraceBuffer2.addProperty("AddressResolver", this._addressResolver);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "McastRmmAdapter.start()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
        this.focus("start", dCSTraceBuffer2);
        try {
            this._conChannel = new McastConnectedChannel(this, this._mmgr, this._thisMember, this._thisStackName, this._stackMutex, this._rmt, this._rmr, this._mcastGroupAllocator.allocateFirstIp().getHostAddress(), this._g.getConfigParamAsInt("RMM_ADAPTER_TRANS_CLOSE_TIME"), this._transmitter, this._g.getMetaMessageFactory(), this._hbtTimeoutPeriodMillis, this._myAddressResolver);
            this._viewChannel = new McastPtpViewChannel(this, this._thisStackName, this._stackMutex, this._rmt, this._rmr, viewIdImpl, this._mmgr, this._mcastGroupAllocator.allocateIp(this._thisStackName + "/" + this._thisMemberName).getHostAddress(), this._thisMember, this._g.getConfigParamAsInt("RMM_ADAPTER_TRANS_CLOSE_TIME"), this._transmitter, BaseVRIMessageFactory.getInstance(this._g), this._g.getMetaMessageFactory(), this._g.getConfigParamAsInt("TRANSPORT_ADAPTER_NEW_VIEW_MEMBER_TIMEOUT"), this._hbtTimeoutPeriodMillis, this._addressResolver);
        }
        catch (UnknownHostException unknownHostException) {
            this.requestTermination(unknownHostException, "start()");
        }
        super.start(viewIdImpl);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "McastRmmAdapter.start()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
    }

    protected void setRmmConfig(Properties properties, Map map) {
        super.setRmmConfig(properties, map);
        String string = this._myAddressResolver.getMyIpAsString();
        if (string == "*") {
            string = "None";
        }
        properties.setProperty("NetworkInterface", string);
        Map map2 = (Map)this._g.getConfigParam("TRANSPORT_CONFIGURATION");
        String string2 = this._g.getConfigParamAsString("TRANSPORT_TYPE");
        if (!string2.equals("RealMulticast")) {
            throw new DCSIllegalConfigurationException("Setting MCAST config with unknown transport type " + string2);
        }
        RMMMulticastConfigMap rMMMulticastConfigMap = new RMMMulticastConfigMap(map2);
        rMMMulticastConfigMap.addConfigToMap(map);
        rMMMulticastConfigMap.addConfigToProp(properties);
        properties.setProperty("NetworkingType", "RealMulticast");
        properties.setProperty("UnicastTransportType", "TCP");
        String string3 = this._myAddressResolver.getMyPortAsString();
        if (string3 != null) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "McastRmmAdapter.setRmmConfig()", "Setting Unicast port for Multicast");
                dCSTraceBuffer.addProperty("Port", string3);
                dCSTraceBuffer.invoke();
            }
            properties.setProperty("UnicastServerSocketPort", string3);
        } else if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "McastRmmAdapter.setRmmConfig()", "Not setting Unicast port for Multicast");
            dCSTraceBuffer.invoke();
        }
    }

    private static String[] getTargetsAsStrings(VRIMemberDescription[] vRIMemberDescriptionArray) {
        String[] stringArray = new String[vRIMemberDescriptionArray.length];
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            stringArray[i] = vRIMemberDescriptionArray[i].getName();
        }
        return stringArray;
    }

    public void mcastMessage(VRIMessage vRIMessage, VRIMemberDescription[] vRIMemberDescriptionArray, QoS.QOSMulticast qOSMulticast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (vRIMemberDescriptionArray == null || vRIMemberDescriptionArray.length == 0) {
            return;
        }
        SubgroupMcastHeader subgroupMcastHeader = new SubgroupMcastHeader(McastRmmAdapter.getTargetsAsStrings(vRIMemberDescriptionArray));
        subgroupMcastHeader.setLayer((byte)1);
        vRIMessage.addHeader(subgroupMcastHeader);
        this.mcastMessage(vRIMessage, qOSMulticast, viewIdImpl);
    }

    protected boolean shouldCreateRmmInstance() {
        return !_rmmInstancesMgr.isRmmInstanceAvailable(this.getClass());
    }

    protected CoreToDataTransportInfo getCoreToDataInfoInstance() {
        return new McastCoreToDataTransportInfo();
    }

    protected void setInfoForDataStack(CoreToDataTransportInfo coreToDataTransportInfo) {
        McastCoreToDataTransportInfo mcastCoreToDataTransportInfo = (McastCoreToDataTransportInfo)coreToDataTransportInfo;
        Map map = (Map)this._g.getConfigParam("TRANSPORT_CONFIGURATION");
        RMMMulticastConfigMap rMMMulticastConfigMap = new RMMMulticastConfigMap(map);
        Map map2 = rMMMulticastConfigMap.setOptionalParams();
        String string = (String)map2.get("MulticastGroupRangeStart");
        String string2 = (String)map2.get("MulticastGroupRangeEnd");
        try {
            McastIpAllocator mcastIpAllocator = new McastIpAllocator(InetAddress.getByName(string), InetAddress.getByName(string2), this._thisMemberName, this._thisStackName);
            mcastCoreToDataTransportInfo.setIpAllocator(mcastIpAllocator);
        }
        catch (UnknownHostException unknownHostException) {
            this.requestTermination(unknownHostException, "setInfoForDataStack");
        }
        mcastCoreToDataTransportInfo.setAddressResolver(this._addressResolver);
        super.setInfoForDataStack(mcastCoreToDataTransportInfo);
    }

    protected void registerRmmInstance() {
        RmmInstanceData rmmInstanceData = new RmmInstanceData();
        rmmInstanceData.setRmm(this._rmm);
        _rmmInstancesMgr.register(this.getClass(), rmmInstanceData, this.getMemberName());
    }

    public void terminate(boolean bl, DCSTerminationEvent dCSTerminationEvent) {
        super.terminate(bl, dCSTerminationEvent);
        _mcastTracker.leaveAllMcastGroups(this._thisStackName);
        if (this._g.isCoreStack() && _rmmInstancesMgr.releaseRmmInstance(this.getClass())) {
            this.killRmm();
        }
    }

    protected RMM retrieveRmmInstance() {
        return _rmmInstancesMgr.getRmmInstance(this.getClass()).getRmm();
    }

    protected String getTransportType() {
        return "RealMulticast";
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }
}

