/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.htmt.rmm.RMM;
import com.ibm.rmm.receiver.RMReceiver;
import com.ibm.rmm.transmitter.RMTransmitter;
import com.ibm.rmm.util.LogEventListener;
import com.ibm.ws.dcs.common.AddressResolver;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.config.DCSIllegalConfigurationException;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSIllegalParameterException;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.VRICheckFailedException;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.nls.AbstractNLSEvent;
import com.ibm.ws.dcs.vri.common.nls.CreatedRmmEvent;
import com.ibm.ws.dcs.vri.common.nls.LinkedRmmEvent;
import com.ibm.ws.dcs.vri.common.nls.RmmCreationFailedEvent;
import com.ibm.ws.dcs.vri.common.nls.RmmErrorEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.FFDCDumper;
import com.ibm.ws.dcs.vri.transportAdapter.TransportAdapter;
import com.ibm.ws.dcs.vri.transportAdapter.TransportInternalException;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.LogAdapter;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.LogAdapterListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.MyAddressResolver;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.CFRmmAdapter;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.CoreToDataTransportInfo;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.McastRmmAdapter;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.RMMInstancesMgr;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmAdapter.UnicastRmmAdapter;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.TransmitterThread;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.TransmitterThreadListener;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class RmmAdapter
extends TransportAdapter
implements TransmitterThreadListener,
LogAdapterListener {
    private final LogAdapter _rmmLogAdapter;
    static Map _coreToDataInfo = new HashMap();
    static RMMInstancesMgr _rmmInstancesMgr = RMMInstancesMgr.getRMMInstanceMgr();
    private static TraceComponent TC = Tr.register(RmmAdapter.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    protected RMM _rmm = null;
    protected RMReceiver _rmr;
    protected RMTransmitter _rmt;
    protected TransmitterThread _transmitter;
    protected AddressResolver _addressResolver;
    protected final int _hbtTimeoutPeriodMillis = this._g.getConfigParamAsInt("HBTTimeoutPeriod") * this._g.getConfigParamAsInt("HBTTransmissionIntervalMilliSec");
    protected MyAddressResolver _myAddressResolver;
    public static final int VERSION = 0x1000000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransportAdapter getInstance(Globals globals) throws UnknownHostException {
        String string = globals.getCoreGroupName();
        String string2 = null;
        Class clazz = RmmAdapter.class;
        synchronized (clazz) {
            if (globals.isCoreStack()) {
                if (_coreToDataInfo.containsKey(string)) {
                    throw new DCSIllegalParameterException("Core stack " + string + " has been started already");
                }
                string2 = globals.getConfigParamAsString("TRANSPORT_TYPE");
            } else {
                if (!_coreToDataInfo.containsKey(string)) {
                    throw new DCSIllegalParameterException("Core stack " + string + " has not been started for the data stack");
                }
                string2 = ((CoreToDataTransportInfo)_coreToDataInfo.get(string)).getTransportType();
            }
        }
        if (string2.equals("MulticastByUnicast")) {
            return new UnicastRmmAdapter(globals);
        }
        if (string2.equals("ChannelFramework")) {
            return new CFRmmAdapter(globals);
        }
        if (string2.equals("RealMulticast")) {
            return new McastRmmAdapter(globals);
        }
        throw new DCSIllegalConfigurationException("TransportAdapter.getInstance: Unknown transport type: " + string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmmAdapter(Globals globals) throws UnknownHostException {
        super(globals);
        if (globals.isCoreStack()) {
            this._addressResolver = (AddressResolver)this._g.getConfigParam("AddressResolver");
            this._myAddressResolver = new MyAddressResolver(this._addressResolver, this._thisMemberName);
        }
        this._transmitter = new TransmitterThread(this._thisMemberName, this._thisStackName, "Transmitter|" + this._thisStackName, this, this._g.getConfigParamAsInt("CONGESTION_SENDER_GREEN_LINE_KB") * 1024, this._g.getConfigParamAsInt("CONGESTION_SENDER_YELLOW_LINE_KB") * 1024, this._g.getConfigParamAsInt("CONGESTION_SENDER_RED_LINE_KB") * 1024, this._g.isCoreStack());
        boolean bl = globals.isCoreStack() && this.shouldCreateRmmInstance();
        Class clazz = RmmAdapter.class;
        synchronized (clazz) {
            Object object;
            Object object2;
            if (bl) {
                DCSTraceable dCSTraceable;
                object2 = new Properties();
                object = new HashMap();
                this.setRmmConfig((Properties)object2, (Map)object);
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    dCSTraceable = DCSTraceBuffer.event(this, "RmmAdapter.RmmAdapter()", "Creating RMM instance");
                    ((DCSTraceBuffer)dCSTraceable).addProperty("Configuration", "Properties", object2);
                    ((DCSTraceBuffer)dCSTraceable).addProperty("Configuration", "Map", object);
                    ((DCSTraceBuffer)dCSTraceable).invoke();
                }
                this.traceRmmCreation("Core stack going to create RMM instance");
                this._rmmLogAdapter = new LogAdapter(this, this._thisMemberName, this._thisStackName, globals);
                this._rmm = RMM.getInstance((Properties)object2, object, 2, 2, (LogEventListener)this._rmmLogAdapter);
                if (this._rmm == null) {
                    dCSTraceable = new RmmCreationFailedEvent((DCSTraceContext)this, this.getTransportType());
                    ((AbstractNLSEvent)dCSTraceable).invokeNLSTrace();
                    throw new TransportInternalException("Failed to create RMM instance");
                }
                this.traceRmmCreation("Core stack created RMM instance");
                this.registerRmmInstance();
            } else if (globals.isCoreStack()) {
                this.traceRmmCreation("Core stack sharing RMM instance ");
                this._rmm = this.retrieveRmmInstance();
                this._rmmLogAdapter = null;
            } else {
                this.traceRmmCreation("Data stack sharing RMM instance");
                object2 = (CoreToDataTransportInfo)_coreToDataInfo.get(globals.getCoreGroupName());
                this._rmm = ((CoreToDataTransportInfo)object2).getRmmInstance();
                this._myAddressResolver = ((CoreToDataTransportInfo)object2).getMyAddressResolver();
                this._rmmLogAdapter = null;
            }
            this._rmt = this._rmm.rMT;
            this._rmr = this._rmm.rMR;
            if (this._rmm == null) {
                throw new TransportInternalException("Failed to get RMM");
            }
            if (this._rmt == null) {
                throw new TransportInternalException("Failed to get RMT");
            }
            if (this._rmr == null) {
                throw new TransportInternalException("Failed to get RMR");
            }
            object2 = this._rmm.rMR.getVersion();
            if (bl) {
                object = new CreatedRmmEvent((DCSTraceContext)this, this.getTransportType(), (String)object2);
                ((AbstractNLSEvent)object).invokeNLSTrace();
            } else {
                object = new LinkedRmmEvent((DCSTraceContext)this, this.getTransportType(), (String)object2);
                ((AbstractNLSEvent)object).invokeNLSTrace();
            }
            if (this._g.isCoreStack()) {
                this.setInfoForDataStack(this.getCoreToDataInfoInstance());
            }
        }
    }

    protected abstract RMM retrieveRmmInstance();

    protected abstract void registerRmmInstance();

    protected abstract CoreToDataTransportInfo getCoreToDataInfoInstance();

    protected void setInfoForDataStack(CoreToDataTransportInfo coreToDataTransportInfo) {
        coreToDataTransportInfo.setRmmInstance(this._rmm);
        coreToDataTransportInfo.setTransportType(this._g.getConfigParamAsString("TRANSPORT_TYPE"));
        coreToDataTransportInfo.setMyAddressResolver(this._myAddressResolver);
        _coreToDataInfo.put(this._g.getCoreGroupName(), coreToDataTransportInfo);
    }

    protected abstract boolean shouldCreateRmmInstance();

    protected void setRmmConfig(Properties properties, Map map) {
        int n = (Integer)this._g.getConfigParam("HBTTransmissionIntervalMilliSec");
        properties.setProperty("HeartbeatIntervalMillis", Integer.toString(n));
        properties.setProperty("HeartbeatTimeoutMillis", Integer.toString(this._hbtTimeoutPeriodMillis));
        properties.setProperty("BindAllInterfaces", this._myAddressResolver.isBindAll());
    }

    public void terminate(boolean bl, DCSTerminationEvent dCSTerminationEvent) {
        super.terminate(bl, dCSTerminationEvent);
        this._transmitter.terminate();
        if (this._g.isCoreStack()) {
            _coreToDataInfo.remove(this._g.getCoreGroupName());
        }
    }

    public VRICheckFailedException check() {
        return super.check();
    }

    public void dump() {
        super.dump();
    }

    public void dumpAll(FFDCDumper fFDCDumper) {
        String string = "\n*************** RmmAdapter dump: *******************\n";
        string = string + "Transmitter thread: " + this._transmitter.dump();
        fFDCDumper.writeLine(string);
        super.dumpAll(fFDCDumper);
    }

    public void onError(Throwable throwable, String string) {
        this.requestTermination(throwable, string);
    }

    protected void killRmm() {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmAdapter.killRmm()", "Going to kill RMM transmitter");
            dCSTraceBuffer.invoke();
        }
        this._rmt.stop(false);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmAdapter.killRmm()", "Going to kill RMM receiver");
            dCSTraceBuffer.invoke();
        }
        this._rmr.stop();
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmAdapter.killRmm()", "Killed RMM");
            dCSTraceBuffer.invoke();
        }
    }

    private void traceRmmCreation(String string) {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("ClassName", this.getClass().getName());
        dCSTraceBuffer.addProperty("Report", string);
        this.focus("CreateRmm", dCSTraceBuffer);
    }

    protected abstract String getTransportType();

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public void onLogError(RmmErrorEvent rmmErrorEvent) {
        this.requestTermination(rmmErrorEvent);
    }

    public void start(ViewIdImpl viewIdImpl) {
        RmmErrorEvent rmmErrorEvent;
        super.start(viewIdImpl);
        if (this._rmmLogAdapter != null && (rmmErrorEvent = this._rmmLogAdapter.start()) != null) {
            this.onLogError(rmmErrorEvent);
        }
    }
}

