/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmm.receiver.RMReceiver;
import com.ibm.rmm.receiver.StreamSelector;
import com.ibm.rmm.transmitter.RMTransmitter;
import com.ibm.rmm.util.UnicastConnectionIf;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.vri.common.MetaMessageFactory;
import com.ibm.ws.dcs.vri.common.nls.AbstractNLSEvent;
import com.ibm.ws.dcs.vri.common.nls.ConnectivityWarningEvent;
import com.ibm.ws.dcs.vri.common.nls.RcvBadMemberEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.TransportInternalException;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RcvBadMemberListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RmmNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RmmUtils;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.connected.PtpConnectedChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmPtpTransmitterEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryCoreListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryFailEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpDiscovery.DiscoveryServer;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.PtpRmmNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.QueueTHandler;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.RmmGroupListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.RmmPtpGroup;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.TransmitterThread;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DiscoveryRmmPtpGroup
extends RmmPtpGroup
implements DiscoveryCoreListener {
    private static TraceComponent TC = Tr.register(DiscoveryRmmPtpGroup.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private final boolean _isCore;
    private final RcvBadMemberListener _rcvBadMemberListener;
    private DiscoveryServer _discoveryServer;
    private HashMap _candidatesMap;
    private final PtpConnectedChannel _asyncConTrigger;
    private final Map _activeConnections = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveryRmmPtpGroup(RmmGroupListener rmmGroupListener, DCSLogicalChannel dCSLogicalChannel, RMReceiver rMReceiver, RMTransmitter rMTransmitter, StreamSelector streamSelector, String string, long l, Set set, String string2, TransmitterThread transmitterThread, MetaMessageFactory metaMessageFactory, DiscoveryServer discoveryServer, boolean bl, RcvBadMemberListener rcvBadMemberListener, String string3, int n, PtpConnectedChannel ptpConnectedChannel) {
        super(rmmGroupListener, dCSLogicalChannel, rMReceiver, rMTransmitter, streamSelector, string, l, transmitterThread, metaMessageFactory, string3, n, null);
        this._asyncConTrigger = ptpConnectedChannel;
        this._topicName = string2;
        this._isCore = bl;
        this._rcvBadMemberListener = rcvBadMemberListener;
        this._candidatesMap = new HashMap();
        this._discoveryServer = discoveryServer;
        Set set2 = null;
        Object object = this._discoveryServer;
        synchronized (object) {
            if (bl) {
                this._discoveryServer.start(this, this._thisStackName);
            }
            set2 = this._discoveryServer.addListener(this, set);
        }
        object = set2.iterator();
        while (object.hasNext()) {
            PtpRmmNode ptpRmmNode = (PtpRmmNode)object.next();
            this.live(ptpRmmNode);
        }
    }

    public void alarm(Object object) {
        throw new TransportInternalException("DiscoveryRmmPtpGroup.alarm: method should not be called");
    }

    public RmmNode[] setNodes(RmmNode[] rmmNodeArray, String string) {
        throw new TransportInternalException("DiscoveryRmmPtpGroup.setNodes: method should not be called");
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public void rcvBadMember(RcvBadMemberEvent rcvBadMemberEvent) {
        this._rcvBadMemberListener.rcvBadMember(rcvBadMemberEvent);
    }

    public synchronized boolean contains(String string) {
        return this._candidatesMap.containsKey(string) || super.contains(string);
    }

    public synchronized UnicastConnectionIf getCurrentConnection(String string) {
        return (UnicastConnectionIf)this._activeConnections.get(string);
    }

    public String getListenerID() {
        return this._thisStackName;
    }

    public String toString() {
        return this.getListenerID();
    }

    public void onError(DCSTerminationEvent dCSTerminationEvent) {
        this._listener.onError(dCSTerminationEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.close()", null);
            ((DCSTraceBuffer)object).addProperty("Flag", this._isCore);
            ((DCSTraceBuffer)object).addProperty(this._channelName);
            ((DCSTraceBuffer)object).invoke();
        }
        object = this._discoveryServer;
        synchronized (object) {
            this._discoveryServer.removeListener(this);
            if (this._isCore) {
                this._discoveryServer.close();
            }
        }
        this.closeOldT(this._candidatesMap);
        super.close();
    }

    public synchronized void addDefinedNode(String string) {
        DCSTraceable dCSTraceable;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceable = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.addDefinedNode()", string);
            ((DCSTraceBuffer)dCSTraceable).addProperty(this._channelName);
            ((DCSTraceBuffer)dCSTraceable).invoke();
        }
        if ((dCSTraceable = this._discoveryServer.addDefined(this, string)) != null) {
            this.live((PtpRmmNode)dCSTraceable);
        }
    }

    public synchronized void removeDefinedNode(String string) {
        String string2 = null;
        this._discoveryServer.removeDefined(this, string);
        QueueTHandler queueTHandler = (QueueTHandler)this._candidatesMap.remove(string);
        if (queueTHandler != null) {
            string2 = "Removed QueueTHandler from candidates Map";
            queueTHandler.close(false);
        } else {
            queueTHandler = (QueueTHandler)this._activeReceiversQueueMap.remove(string);
            if (queueTHandler != null) {
                string2 = "Removed QueueTHandler from active Map";
                queueTHandler.close(false);
                this.updateActiveSubmitters();
            } else {
                string2 = "No QueueTHandler found";
            }
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.removeDefinedNode()", string);
            dCSTraceBuffer.addProperty("Report", string2);
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.invoke();
        }
    }

    public synchronized void ping(String string) {
        QueueTHandler queueTHandler = (QueueTHandler)this._candidatesMap.get(string);
        if (queueTHandler == null) {
            queueTHandler = (QueueTHandler)this._activeReceiversQueueMap.get(string);
        }
        if (queueTHandler != null && queueTHandler.getQueueT() != null) {
            byte[] byArray = RmmUtils.getDCSHbt();
            this._transmitter.submitMessage(queueTHandler.getQueueT(), byArray, 0, byArray.length);
        }
    }

    public synchronized void live(PtpRmmNode ptpRmmNode) {
        Object object;
        boolean bl;
        String string = "";
        String string2 = ptpRmmNode.getName();
        if (!this._discoveryServer.isDefined(this, string2)) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.live", null);
                dCSTraceBuffer.addProperty("Report", "Race Condition: Node is not defined anymore. Ignore call");
                dCSTraceBuffer.addProperty(ptpRmmNode);
                dCSTraceBuffer.invoke();
            }
            return;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.live", null);
            dCSTraceBuffer.addProperty(ptpRmmNode);
            dCSTraceBuffer.invoke();
        }
        this._activeConnections.put(string2, ptpRmmNode.getConnectionId());
        boolean bl2 = false;
        QueueTHandler queueTHandler = (QueueTHandler)this._candidatesMap.remove(string2);
        if (queueTHandler != null) {
            if (queueTHandler.getQueueT() == null) {
                string = "Dead node in candidates map being removed and recreated. " + string2;
                Tr.warning(TC, "DCSV0003", new Object[]{this._thisStackName, this._thisMemberName, string});
                bl = true;
            } else if (ptpRmmNode.getRmmConnection().equals(queueTHandler.getConnection())) {
                string = "Node is already a candidate. Sending dedicated HBT to it " + string2;
                Tr.warning(TC, "DCSV0003", new Object[]{this._thisStackName, this._thisMemberName, string});
                this._candidatesMap.put(string2, queueTHandler);
                object = RmmUtils.getDCSHbt();
                this._transmitter.submitMessage(queueTHandler.getQueueT(), (byte[])object, 0, ((Object)object).length);
                bl = false;
            } else {
                string = "Node is a candidate but connections do not match. Close and recreate";
                Tr.warning(TC, "DCSV0003", new Object[]{this._thisStackName, this._thisMemberName, string});
                queueTHandler.close(false);
                bl = true;
            }
        } else {
            queueTHandler = (QueueTHandler)this._activeReceiversQueueMap.get(string2);
            if (queueTHandler == null) {
                bl = true;
            } else if (queueTHandler.getQueueT() == null) {
                this._activeReceiversQueueMap.remove(string2);
                bl = true;
                bl2 = true;
            } else if (ptpRmmNode.getRmmConnection().equals(queueTHandler.getConnection())) {
                string = "Node is already active";
                bl = false;
            } else {
                string = "Node is active but connections do not match. Close and recreate";
                this._activeReceiversQueueMap.remove(string2);
                queueTHandler.close(false);
                Tr.warning(TC, "DCSV0003", new Object[]{this._thisStackName, this._thisMemberName, string});
                bl = true;
                bl2 = true;
            }
        }
        if (bl) {
            queueTHandler = new QueueTHandler(this._rmt, (Object)this._topicName, ptpRmmNode, this, null);
            try {
                if (queueTHandler.open()) {
                    if (bl2) {
                        string = string + " Created qth added it to active";
                        this._activeReceiversQueueMap.put(string2, queueTHandler);
                    } else {
                        string = string + " Created qth added it to candidates";
                        this._candidatesMap.put(string2, queueTHandler);
                    }
                } else {
                    object = new ConnectivityWarningEvent((DCSTraceContext)this, string2, "Failed to open Stream: " + ptpRmmNode.toString());
                    ((AbstractNLSEvent)object).invokeNLSTrace();
                    string = string + " WARNING: Failed to open qth";
                }
            }
            catch (DCSInvalidParametersException dCSInvalidParametersException) {
                string = string + " WARNING: The connection on which a qth was to be opened, seems to have vanished";
            }
        }
        if (bl2) {
            this.updateActiveSubmitters();
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.live", null);
            ((DCSTraceBuffer)object).addProperty("Report", string);
            ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)object).invoke();
        }
        this._asyncConTrigger.triggerAsymConCheck(string2);
    }

    public synchronized void dead(PtpRmmNode ptpRmmNode, DCSSuspectEvent dCSSuspectEvent) {
        Object object;
        String string = ptpRmmNode.getName();
        UnicastConnectionIf unicastConnectionIf = ptpRmmNode.getRmmConnection();
        try {
            this._activeConnections.remove(string);
            if (this._activeReceiversQueueMap.containsKey(ptpRmmNode.getName())) {
                object = (QueueTHandler)this._activeReceiversQueueMap.get(string);
                if (object != null && ((QueueTHandler)object).getConnection() != null && !((QueueTHandler)object).getConnection().equals(unicastConnectionIf)) {
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.dead", null);
                        dCSTraceBuffer.addProperty("Report", "Ignore QT in active map due to connection mismatch");
                        dCSTraceBuffer.addProperty(ptpRmmNode);
                        dCSTraceBuffer.addProperty("Connection", ((QueueTHandler)object).getConnection());
                        dCSTraceBuffer.addProperty("Reason", dCSSuspectEvent);
                        dCSTraceBuffer.invoke();
                    }
                    return;
                }
            } else if (this._candidatesMap.containsKey(ptpRmmNode.getName()) && (object = (QueueTHandler)this._candidatesMap.get(ptpRmmNode.getName())) != null && ((QueueTHandler)object).getConnection() != null && !((QueueTHandler)object).getConnection().equals(unicastConnectionIf)) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.dead", null);
                    dCSTraceBuffer.addProperty("Report", "Ignore QT in candidates map due to connection mismatch");
                    dCSTraceBuffer.addProperty(ptpRmmNode);
                    dCSTraceBuffer.addProperty("Connection", ((QueueTHandler)object).getConnection());
                    dCSTraceBuffer.addProperty("Reason", dCSSuspectEvent);
                    dCSTraceBuffer.invoke();
                }
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty(ptpRmmNode);
            dCSTraceBuffer.addProperty("Reason", dCSSuspectEvent);
            this._listener.focus("Dead", "got a null pointer. A qth must have been pulled off our feet", dCSTraceBuffer);
        }
        if (this._discoveryServer.isDefined(this, ptpRmmNode.getName())) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.dead", null);
                ((DCSTraceBuffer)object).addProperty("Report", "Defined member died");
                ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
                ((DCSTraceBuffer)object).invoke();
            }
            this.onLocalEvent(new DiscoveryFailEvent(ptpRmmNode, this, dCSSuspectEvent));
        } else if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.dead", null);
            ((DCSTraceBuffer)object).addProperty("Report", "WARNING Undefined member died. Ignore");
            ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)object).invoke();
        }
    }

    public synchronized boolean removeNode(String string, UnicastConnectionIf unicastConnectionIf) {
        Object object;
        Object object2;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object2 = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.removeNode()", string);
            ((DCSTraceBuffer)object2).addProperty("Received", "Connection", unicastConnectionIf);
            ((DCSTraceBuffer)object2).invoke();
        }
        if ((object2 = (QueueTHandler)this._candidatesMap.get(string)) != null) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.removeNode", string);
                ((DCSTraceBuffer)object).addProperty("Report", "Found QT in the candidates map");
                ((DCSTraceBuffer)object).addProperty("Connection", ((QueueTHandler)object2).getConnection());
                ((DCSTraceBuffer)object).invoke();
            }
            if (!unicastConnectionIf.equals(((QueueTHandler)object2).getConnection())) {
                return false;
            }
            if (unicastConnectionIf.equals(((QueueTHandler)object2).getConnection())) {
                object = "DiscoveryRmmPtpGroup.removeNode - found QT in the candidate map for member " + string;
                Tr.warning(TC, "DCSV0003", new Object[]{this._thisStackName, this._thisMemberName, object});
                return false;
            }
        }
        if ((object2 = (QueueTHandler)this._activeReceiversQueueMap.get(string)) == null) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.removeNode", string);
                ((DCSTraceBuffer)object).addProperty("Report", "No QT found in either map.");
                ((DCSTraceBuffer)object).invoke();
            }
            return false;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.removeNode", string);
            ((DCSTraceBuffer)object).addProperty("Report", "Found QT in the active map");
            ((DCSTraceBuffer)object).addProperty("Connection", ((QueueTHandler)object2).getConnection());
            ((DCSTraceBuffer)object).invoke();
        }
        if (!unicastConnectionIf.equals(((QueueTHandler)object2).getConnection())) {
            return false;
        }
        if (((QueueTHandler)object2).getQueueT() != null) {
            object2 = (QueueTHandler)this._activeReceiversQueueMap.remove(string);
            this._candidatesMap.put(string, object2);
            this.updateActiveSubmitters();
            return true;
        }
        this._activeReceiversQueueMap.remove(string);
        this.updateActiveSubmitters();
        return true;
    }

    protected void closeActiveQth(PtpRmmNode ptpRmmNode, QueueTHandler queueTHandler) {
        String string;
        if (queueTHandler.isActive()) {
            if (ptpRmmNode.getConnectionId().equals(queueTHandler.getConnection())) {
                string = "Qth is still active, added it to candidates";
                this._candidatesMap.put(ptpRmmNode.getName(), queueTHandler);
            } else {
                string = "Qth connection and node connection did not match. Close QT";
                queueTHandler.close(true);
            }
        } else {
            string = "Qth is closed, call super to remove it";
            super.closeActiveQth(ptpRmmNode, queueTHandler);
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.closeActiveQth()", null);
            dCSTraceBuffer.addProperty("Report", string);
            dCSTraceBuffer.addProperty(ptpRmmNode);
            dCSTraceBuffer.addProperty("Connection", queueTHandler.getConnection());
            dCSTraceBuffer.invoke();
        }
    }

    protected QueueTHandler createActiveQth(PtpRmmNode ptpRmmNode) {
        DCSTraceBuffer dCSTraceBuffer;
        String string = null;
        QueueTHandler queueTHandler = (QueueTHandler)this._candidatesMap.remove(ptpRmmNode.getName());
        if (queueTHandler != null) {
            if (queueTHandler.getQueueT() == null) {
                queueTHandler = null;
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.createActiveQth()", null);
                    dCSTraceBuffer.addProperty("Report", "removed dead QT from candidates map");
                    dCSTraceBuffer.addProperty(ptpRmmNode);
                    dCSTraceBuffer.invoke();
                }
            } else {
                string = "Found live QT in candidates.";
            }
        }
        if (queueTHandler == null) {
            queueTHandler = super.createActiveQth(ptpRmmNode);
            string = "No active QT found, have super create one";
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.createActiveQth()", null);
            dCSTraceBuffer.addProperty("Report", string);
            dCSTraceBuffer.addProperty(ptpRmmNode);
            dCSTraceBuffer.invoke();
        }
        return queueTHandler;
    }

    protected synchronized void onLocalEvent(RmmPtpTransmitterEvent rmmPtpTransmitterEvent) {
        DCSTraceBuffer dCSTraceBuffer;
        String string;
        Object object;
        PtpRmmNode ptpRmmNode = rmmPtpTransmitterEvent.getSourceNode();
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.onLocalEvent()", null);
            ((DCSTraceBuffer)object).addProperty("RmmEvent", rmmPtpTransmitterEvent.getDescription());
            ((DCSTraceBuffer)object).addProperty(ptpRmmNode);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = (QueueTHandler)this._activeReceiversQueueMap.get(ptpRmmNode.getName())) != null) {
            if (!ptpRmmNode.getConnectionId().equals(((QueueTHandler)object).getConnection())) {
                string = "Node is active, but connections do not match. Do nothing";
            } else {
                ((QueueTHandler)object).close(false);
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.onLocalEvent()", "Node is active, let super handle it");
                    dCSTraceBuffer.addProperty(ptpRmmNode);
                    dCSTraceBuffer.invoke();
                }
                string = "Completed";
                super.onLocalEvent(rmmPtpTransmitterEvent);
            }
        } else {
            object = (QueueTHandler)this._candidatesMap.remove(ptpRmmNode.getName());
            if (object == null) {
                string = "Node was not located - apparently we removed it";
            } else if (!ptpRmmNode.getConnectionId().equals(((QueueTHandler)object).getConnection())) {
                string = "Node is candidate, but connections do not match. Do nothing";
            } else {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.onLocalEvent()", "Close candidate QT");
                    dCSTraceBuffer.addProperty(ptpRmmNode);
                    dCSTraceBuffer.invoke();
                }
                string = "Completed";
                ((QueueTHandler)object).close(false);
            }
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.onLocalEvent()", null);
            dCSTraceBuffer.addProperty("Report", string);
            dCSTraceBuffer.addProperty(ptpRmmNode);
            dCSTraceBuffer.invoke();
        }
    }

    public String dump() {
        return "\n*************** DiscoveryRmmPtpGroup::dump *******************\n\n Candidates map: \n" + this._candidatesMap.toString() + super.dump();
    }

    public synchronized boolean removeFromCandidatesMap(String string, long l) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.removeFromCandidatesMap()", string);
            ((DCSTraceBuffer)object).addProperty("StreamId", l);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = (QueueTHandler)this._candidatesMap.get(string)) == null) {
            return false;
        }
        boolean bl = new Long(l).equals(((QueueTHandler)object).getStreamId());
        if (bl) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "DiscoveryRmmPtpGroup.removeFromCandidatesMap()", string);
                dCSTraceBuffer.addProperty("Flag", true);
                dCSTraceBuffer.invoke();
            }
            this._candidatesMap.remove(string);
        }
        return bl;
    }
}

