/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmm.receiver.AdvancedMessageListener;
import com.ibm.rmm.receiver.Event;
import com.ibm.rmm.receiver.Message;
import com.ibm.rmm.receiver.RMReceiver;
import com.ibm.rmm.receiver.StreamSelector;
import com.ibm.rmm.transmitter.RMTransmitter;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSMessageCorruptedException;
import com.ibm.ws.dcs.utils.Alarm;
import com.ibm.ws.dcs.utils.AlarmListener;
import com.ibm.ws.dcs.utils.AlarmManager;
import com.ibm.ws.dcs.vri.common.MetaMessageFactory;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.impl.BaseVRIMessage;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.TransportGroup;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RmmNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RmmUtils;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.RmmGroupListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.TransmitterThread;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class RMMGroup
extends TransportGroup
implements AdvancedMessageListener,
AlarmListener {
    private static TraceComponent TC = Tr.register(RMMGroup.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    protected final int _hbtTimeoutMilliSec;
    String _topicName;
    final RMReceiver _rmr;
    final RMTransmitter _rmt;
    final StreamSelector _selector;
    final RmmGroupListener _listener;
    private final long _closeWaitTime;
    protected TransmitterThread _transmitter;
    private final MetaMessageFactory _inMsgFactory;
    protected final DCSLogicalChannel _channelName;
    protected final Map _closeWaitingMap;
    protected int _waitForCloseCounter = 0;
    private int _alarmsCounter = 0;

    protected RMMGroup(RmmGroupListener rmmGroupListener, DCSLogicalChannel dCSLogicalChannel, RMReceiver rMReceiver, RMTransmitter rMTransmitter, StreamSelector streamSelector, String string, long l, TransmitterThread transmitterThread, MetaMessageFactory metaMessageFactory, String string2, int n) {
        super(rmmGroupListener, dCSLogicalChannel.toString() + "|" + string, string, string2);
        this._rmr = rMReceiver;
        this._rmt = rMTransmitter;
        this._selector = streamSelector;
        this._listener = rmmGroupListener;
        this._closeWaitTime = l;
        this._transmitter = transmitterThread;
        this._inMsgFactory = metaMessageFactory;
        this._hbtTimeoutMilliSec = n;
        this._channelName = dCSLogicalChannel;
        this._closeWaitingMap = new HashMap();
    }

    public abstract void refreshReceiver();

    public abstract void refreshReceiverRejectedStreams();

    public abstract void rejectReceiverStream(long var1);

    public boolean addNode(RmmNode rmmNode) {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty(rmmNode);
        this._listener.focus("addNode", dCSTraceBuffer);
        return false;
    }

    public void removeNode(RmmNode rmmNode) {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty(rmmNode);
        this._listener.focus("removeNode", dCSTraceBuffer);
    }

    protected RmmNode[] setNodes(RmmNode[] rmmNodeArray, String string) {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("TopicName", string);
        dCSTraceBuffer.addProperty("RmmNodes", Utils.toString(rmmNodeArray));
        this._listener.focus("setNodes", dCSTraceBuffer);
        if (string.equals(this._topicName)) {
            return rmmNodeArray;
        }
        this._topicName = string;
        return null;
    }

    public final void onMessage(Message message) {
        BaseVRIMessage baseVRIMessage = null;
        try {
            if (RmmUtils.isDCSHbt(message.getData())) {
                return;
            }
            baseVRIMessage = RmmUtils.rmmMsg2vriMsg(message, this._inMsgFactory);
        }
        catch (DCSMessageCorruptedException dCSMessageCorruptedException) {
            this._listener.onError(new TerminationEvent((DCSTraceContext)this, "onMessage()", dCSMessageCorruptedException));
        }
        this._inEventsMsgsThread.queueObject(baseVRIMessage);
    }

    protected abstract boolean contains(RmmNode var1);

    public void onEvent(Event event2) {
        String string;
        String string2;
        String string3;
        try {
            string3 = event2.getTopicName();
        }
        catch (Throwable throwable) {
            string3 = null;
        }
        try {
            string2 = "" + event2.getSourceAddress();
        }
        catch (Throwable throwable) {
            string2 = null;
        }
        try {
            string = "" + event2.getSourcePort();
        }
        catch (Throwable throwable) {
            string = null;
        }
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("RmmEvent", event2.getDescription());
        dCSTraceBuffer.addProperty("InetAddress", string2);
        dCSTraceBuffer.addProperty("TopicName", string3);
        dCSTraceBuffer.addProperty("Port", string);
        this._listener.focus("onEvent", dCSTraceBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAlarm(Object object) {
        Map map = this._closeWaitingMap;
        synchronized (map) {
            Object object2;
            Integer n = new Integer(this._alarmsCounter++);
            Alarm alarm = AlarmManager.create(AlarmManager.GENERAL_ALARM, this._closeWaitTime, null, this, n);
            if (alarm == null) {
                this._listener.onError(new TerminationEvent((DCSTraceContext)this, "setAlarm()", new DCSException("RMMGroup.setAlarm: Alarm creation failed")));
                return;
            }
            this._closeWaitingMap.put(n, new AlarmData(alarm, object));
            if (object instanceof Map) {
                object2 = (Map)object;
                this._waitForCloseCounter += object2.size();
            } else {
                ++this._waitForCloseCounter;
            }
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object2 = DCSTraceBuffer.event(this, "RMMGroup.setAlarm()", "Created Alarm");
                ((DCSTraceBuffer)object2).addProperty("AlarmContext", object);
                ((DCSTraceBuffer)object2).addProperty("Timeout", this._closeWaitTime);
                ((DCSTraceBuffer)object2).addProperty("closeWaitingMapSize", this._closeWaitingMap.size());
                ((DCSTraceBuffer)object2).addProperty("waitForCloseCounter", this._waitForCloseCounter);
                ((DCSTraceBuffer)object2).invoke();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        Object object2;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("AlarmContext", object);
        dCSTraceBuffer.addProperty(this._channelName);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object2 = DCSTraceBuffer.event(this, "RMMGroup.alarm()", "Alarm is up");
            ((DCSTraceBuffer)object2).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object2).invoke();
        }
        if (object == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object2 = DCSTraceBuffer.internalWarning(this, "Alarm Context is null", "RMMGroup.alarm()", null);
                ((DCSTraceBuffer)object2).mergePropertyList(dCSTraceBuffer);
                ((DCSTraceBuffer)object2).invoke();
            }
            return;
        }
        Object object3 = this._closeWaitingMap;
        synchronized (object3) {
            object2 = (AlarmData)this._closeWaitingMap.remove(object);
            if (object2 != null) {
                if (((AlarmData)object2)._alarmContext instanceof Map) {
                    Map map = (Map)((AlarmData)object2)._alarmContext;
                    this._waitForCloseCounter -= map.size();
                } else {
                    --this._waitForCloseCounter;
                }
            }
            dCSTraceBuffer.addProperty("closeWaitingMapSize", this._closeWaitingMap.size());
            dCSTraceBuffer.addProperty("waitForCloseCounter", this._waitForCloseCounter);
        }
        if (object2 != null) {
            this.closeOldT(((AlarmData)object2)._alarmContext);
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object3 = DCSTraceBuffer.event(this, "RMMGroup.alarm()", "Alarm ends");
            dCSTraceBuffer.addProperty("Flag", object2 != null);
            ((DCSTraceBuffer)object3).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object3).invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        HashSet<Object> hashSet = new HashSet<Object>();
        Object object = this._closeWaitingMap;
        synchronized (object) {
            Set set = this._closeWaitingMap.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                AlarmData alarmData = (AlarmData)entry.getValue();
                hashSet.add(alarmData._alarmContext);
                alarmData._alarm.cancel();
            }
            this._closeWaitingMap.clear();
            this._waitForCloseCounter = 0;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "RMMGroup.close()", "Going to close transmitter objects waiting for the alarm");
            ((DCSTraceBuffer)object).addProperty("Queued", hashSet);
            ((DCSTraceBuffer)object).invoke();
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            this.closeOldT(object.next());
        }
    }

    protected abstract void closeOldT(Object var1);

    protected static final class AlarmData {
        protected final Object _alarmContext;
        protected final Alarm _alarm;

        private AlarmData(Alarm alarm, Object object) {
            this._alarm = alarm;
            this._alarmContext = object;
        }
    }
}

