/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmm.ptl.admin.AckReporter;
import com.ibm.rmm.receiver.Event;
import com.ibm.rmm.receiver.RMReceiver;
import com.ibm.rmm.receiver.StreamSelector;
import com.ibm.rmm.receiver.StreamSetR;
import com.ibm.rmm.transmitter.EventListener;
import com.ibm.rmm.transmitter.LJETopicT;
import com.ibm.rmm.transmitter.RMTransmitter;
import com.ibm.rmm.util.AckListener;
import com.ibm.rmm.util.AckReporterIf;
import com.ibm.rmm.util.FullBufferListener;
import com.ibm.rmm.util.RmmAddressIf;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.vri.common.MetaMessageFactory;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.nls.FailedToSendUdp;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.TransportInternalException;
import com.ibm.ws.dcs.vri.transportAdapter.TransportUtils;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RmmNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.connected.McastConnectedChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmLazyRcvTransmitterEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmMcastReceiverEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.mcastUtils.McastRmmNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.RMMGroup;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.RmmGroupListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.TransmitterThread;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class RMMMcastGroup
extends RMMGroup
implements AckListener,
FullBufferListener,
EventListener {
    private static final int MIN_PACKETS_GAP_TO_REMOVE = 5;
    private static TraceComponent TC = Tr.register(RMMMcastGroup.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    long _streamId;
    LJETopicT _topicT;
    StreamSetR _topicR;
    int _lastLjMark;
    private String _mcastGroup;
    private HashSet _receivers;
    private final Object _ljLock;
    private final boolean _doEmptySend;

    public RMMMcastGroup(RmmGroupListener rmmGroupListener, DCSLogicalChannel dCSLogicalChannel, String string, RMReceiver rMReceiver, RMTransmitter rMTransmitter, StreamSelector streamSelector, String string2, Object object, String string3, long l, TransmitterThread transmitterThread, MetaMessageFactory metaMessageFactory, boolean bl, String string4, int n) {
        super(rmmGroupListener, dCSLogicalChannel, rMReceiver, rMTransmitter, streamSelector, string3, l, transmitterThread, metaMessageFactory, string4, n);
        DCSTraceBuffer dCSTraceBuffer;
        DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.propertyList();
        dCSTraceBuffer2.addProperty(this._channelName);
        dCSTraceBuffer2.addProperty("RMReceiver", rMReceiver);
        dCSTraceBuffer2.addProperty("RMTransmitter", rMTransmitter);
        dCSTraceBuffer2.addProperty("McastAddress", string2);
        dCSTraceBuffer2.addProperty("Mutex", object);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "RMMMcastGroup.RMMMcastGroup()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
        this._doEmptySend = bl;
        this._mcastGroup = string2;
        this._transmitter = transmitterThread;
        this._ljLock = new Object();
        this._topicR = this._rmr.createStreamSetReceiver(this._selector, true, true);
        if (this._topicR == null) {
            throw new TransportInternalException("RMMMcastGroup:" + this._dbgName + ": Failed to open topic R with topic name " + string);
        }
        this._topicR.setAdvancedMessageListener(this);
        this._receivers = new HashSet();
        this.setNodes(new McastRmmNode[0], string);
        this._rmt.addFullBufferListener(this);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "RMMMcastGroup.RMMMcastGroup()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
    }

    public void refreshReceiver() {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RMMMcastGroup.refreshReceiver()", "Before Refresh");
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.invoke();
        }
        this._topicR.refreshStreamList();
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RMMMcastGroup.refreshReceiver()", "After Refresh");
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.invoke();
        }
    }

    public void refreshReceiverRejectedStreams() {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RMMMcastGroup.refreshReceiverRejectedStreams()", "Before Refresh");
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.invoke();
        }
        this._topicR.clearRejectedStreamList();
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RMMMcastGroup.refreshReceiverRejectedStreams()", "After Refresh");
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.invoke();
        }
    }

    public void rejectReceiverStream(long l) {
        DCSTraceBuffer dCSTraceBuffer;
        String string;
        boolean bl = l != 0L;
        String string2 = string = bl ? "" : "got no stream";
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RMMMcastGroup.rejectReceiverStream()", "Before Refresh " + string);
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.invoke();
        }
        if (bl) {
            this._topicR.rejectStream(l);
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RMMMcastGroup.rejectReceiverStream()", "After Refresh " + string);
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.invoke();
        }
    }

    public boolean mcast(byte[] byArray, int n, int n2) {
        if (!this._receivers.isEmpty() || this._doEmptySend) {
            this._transmitter.submitMessage(this._topicT, byArray, n, n2);
        }
        return true;
    }

    public void close() {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "RMMMcastGroup.close()", null);
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.invoke();
        }
        super.close();
        if (this._topicT != null) {
            this._topicT.closeNow();
        }
        if (this._topicR != null) {
            this._topicR.close();
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "RMMMcastGroup.close()", null);
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.invoke();
        }
    }

    public boolean addNode(RmmNode rmmNode) {
        DCSTraceable dCSTraceable;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceable = DCSTraceBuffer.entry(this, "RMMMcastGroup.addNode()", null);
            ((DCSTraceBuffer)dCSTraceable).addProperty(this._channelName);
            ((DCSTraceBuffer)dCSTraceable).addProperty(rmmNode);
            ((DCSTraceBuffer)dCSTraceable).invoke();
        }
        super.addNode(rmmNode);
        dCSTraceable = (McastRmmNode)rmmNode;
        this._topicT.addReceiver((RmmAddressIf)((Object)dCSTraceable));
        this._receivers.add(dCSTraceable);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "RMMMcastGroup.addNode()", null);
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.addProperty(rmmNode);
            dCSTraceBuffer.invoke();
        }
        return true;
    }

    public void removeNode(RmmNode rmmNode) {
        DCSTraceable dCSTraceable;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceable = DCSTraceBuffer.entry(this, "RMMMcastGroup.removeNode()", null);
            ((DCSTraceBuffer)dCSTraceable).addProperty(this._channelName);
            ((DCSTraceBuffer)dCSTraceable).addProperty(rmmNode);
            ((DCSTraceBuffer)dCSTraceable).invoke();
        }
        super.removeNode(rmmNode);
        if (rmmNode == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                dCSTraceable = DCSTraceBuffer.internalWarning(this, "Null node", "RMMMcastGroup.removeNode()", null);
                ((DCSTraceBuffer)dCSTraceable).addProperty(this._channelName);
                ((DCSTraceBuffer)dCSTraceable).invoke();
            }
            return;
        }
        dCSTraceable = (McastRmmNode)rmmNode;
        boolean bl = this._topicT.removeReceiver((RmmAddressIf)((Object)dCSTraceable));
        this._receivers.remove(dCSTraceable);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this, "RMMMcastGroup.removeNode()", null);
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.addProperty(rmmNode);
            dCSTraceBuffer.addProperty("MethodResult", bl);
            dCSTraceBuffer.invoke();
        }
    }

    public void onEvent(Event event2) {
        DCSTraceBuffer dCSTraceBuffer;
        DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.propertyList();
        dCSTraceBuffer2.addProperty("RmmEvent", event2.getDescription());
        dCSTraceBuffer2.addProperty(this._channelName);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "RMMMcastGroup.onEvent()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
        try {
            super.onEvent(event2);
        }
        catch (Throwable throwable) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.internalWarning(this, "Ignore event as got exception", "RMMMcastGroup.onEvent()", throwable);
                dCSTraceBuffer3.mergePropertyList(dCSTraceBuffer2);
                dCSTraceBuffer3.invoke();
            }
            return;
        }
        if (event2.getType() == 18) {
            this.handleUdpSendFailure(event2.getSourceAddress(), event2.getSourcePort(), (Throwable)event2.getObjectField());
            return;
        }
        this._inEventsMsgsThread.queueObject(new RmmMcastReceiverEvent(event2, this._channelName, this, this._hbtTimeoutMilliSec));
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "RMMMcastGroup.onEvent()", null);
            dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayer(int n, int n2, RmmAddressIf rmmAddressIf, long l) {
        Object object = this._ljLock;
        synchronized (object) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.addProperty("Ack", "RmmEvent", this.printAckEvent(n));
            dCSTraceBuffer.addProperty("Seq", n2);
            dCSTraceBuffer.addProperty("Delayer", rmmAddressIf);
            dCSTraceBuffer.addProperty("Received", "StreamId", l);
            dCSTraceBuffer.addProperty("Current", "StreamId", this._streamId);
            dCSTraceBuffer.addProperty("LateJoinMark", this._lastLjMark);
            if (DCSTraceBuffer.isEventEnabled(TC) && (n != 2 || this.printDelayer(n2))) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this, "RMMMcastGroup.delayer()", "Method Start");
                dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer2.invoke();
            }
            if (n == 1 || n == 0) {
                return;
            }
            if (l != this._streamId) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.event(this, "RMMMcastGroup.delayer()", "Ignore report as it was received on an old topic");
                    dCSTraceBuffer3.mergePropertyList(dCSTraceBuffer);
                    dCSTraceBuffer3.invoke();
                }
                return;
            }
            if (rmmAddressIf == null) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer4 = DCSTraceBuffer.internalWarning(this, "Delayer is null", "RMMMcastGroup.delayer()", null);
                    dCSTraceBuffer4.mergePropertyList(dCSTraceBuffer);
                    dCSTraceBuffer4.invoke();
                }
                return;
            }
            int n3 = n2 - this._lastLjMark;
            if (n3 <= 0) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer5 = DCSTraceBuffer.event(this, "RMMMcastGroup.delayer()", "Ignore reported ack which is smaller than or equal to the last ack reported.");
                    dCSTraceBuffer5.mergePropertyList(dCSTraceBuffer);
                    dCSTraceBuffer5.invoke();
                }
                return;
            }
            this._lastLjMark = n2;
            this._topicT.setMark(n2);
        }
    }

    private String printAckEvent(int n) {
        switch (n) {
            case 2: {
                return "ACK_EVENT_HEAP_UPDATED";
            }
            case 1: {
                return "ACK_EVENT_RCV_ACTIVE";
            }
            case 0: {
                return "ACK_EVENT_RCV_LISTENING";
            }
        }
        return "Unknown Ack Event Type";
    }

    private boolean printDelayer(int n) {
        return n < 2 || n % 10 == 1 || this._listener instanceof McastConnectedChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmmNode[] setNodes(RmmNode[] rmmNodeArray, String string) {
        Object object;
        if (super.setNodes(rmmNodeArray, string) != null) {
            return rmmNodeArray;
        }
        if (this._topicT != null) {
            if (this._receivers.isEmpty()) {
                object = "now quickly";
                this._topicT.closeNow();
            } else {
                object = "later softly";
                this.setAlarm(this._topicT);
            }
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "RMMMcastGroup.setNodes()", "Closing Topic");
                dCSTraceBuffer.addProperty(this._channelName);
                dCSTraceBuffer.addProperty("Report", object);
                dCSTraceBuffer.addProperty("TopicName", string);
                dCSTraceBuffer.invoke();
            }
        }
        object = this._ljLock;
        synchronized (object) {
            this._topicT = this._rmt.createLJETopicTransmitter(string, this._mcastGroup);
            if (this._topicT == null) {
                throw new TransportInternalException("RMMMcastGroup: Failed to open topic T with topic name " + this._topicName);
            }
            if (this._topicT.getStreamId() == null) {
                throw new TransportInternalException("RMMMcastGroup: Failed to get stream id of " + this._topicName);
            }
            this._streamId = this._topicT.getStreamId();
            this._lastLjMark = 0;
            this._topicT.setMark(this._lastLjMark);
            this._topicT.startAckedDelivery(new HashSet(), this);
            this._topicT.setReceivers(TransportUtils.toHashSet(rmmNodeArray));
            this._topicT.setEventListener(this);
        }
        this._receivers.clear();
        this._receivers.addAll(TransportUtils.toHashSet(rmmNodeArray));
        return new McastRmmNode[0];
    }

    public boolean contains(RmmNode rmmNode) {
        return this._receivers.contains(rmmNode);
    }

    public void onFullBuffer(int n) {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("AckRequiredPackets", n);
        dCSTraceBuffer.addProperty(this._channelName);
        String string = null;
        if (this._topicT == null) {
            string = "TopicT is null!";
            this._listener.focus("onFullBuffer", string, dCSTraceBuffer);
            return;
        }
        dCSTraceBuffer.addProperty("StreamId", this._topicT.getStreamId());
        dCSTraceBuffer.addProperty("FrontSequenceNumber", this._topicT.getFrontSeqNum());
        List list = this._topicT.getReceivers();
        if (list == null) {
            string = "Receivers are null!";
            this._listener.focus("onFullBuffer", string, dCSTraceBuffer);
            return;
        }
        dCSTraceBuffer.addProperty("AckersInfo", this.getAckersInfo());
        AckReporter ackReporter = this.getLazyAcker();
        if (ackReporter == null) {
            string = "Failed to find a lazy member";
            this._listener.focus("onFullBuffer", string, dCSTraceBuffer);
            return;
        }
        dCSTraceBuffer.addProperty("LazyAcker", ackReporter);
        int n2 = this._topicT.getFrontSeqNum();
        int n3 = n2 - ackReporter.getSeq();
        dCSTraceBuffer.addProperty("AckGap", n3);
        if (n3 > Math.max(n, 5)) {
            McastRmmNode mcastRmmNode = this.getRmmNodeFromReceivers(ackReporter.getInetAddress(), ackReporter.getPort());
            if (mcastRmmNode != null) {
                dCSTraceBuffer.addProperty(mcastRmmNode);
                this._listener.focus("onFullBuffer", "Raising event against lazy node", dCSTraceBuffer);
                RmmLazyRcvTransmitterEvent rmmLazyRcvTransmitterEvent = new RmmLazyRcvTransmitterEvent(mcastRmmNode, n3, (DCSTraceContext)this);
                this._inEventsMsgsThread.queueObject(rmmLazyRcvTransmitterEvent);
            } else {
                this._listener.focus("onFullBuffer", "WARNING: Did not raised event, can't find lazy node ", dCSTraceBuffer);
            }
        } else {
            this._listener.focus("onFullBuffer", "Did not raised event. gap is too small", dCSTraceBuffer);
        }
    }

    private String getAckersInfo() {
        if (this._topicT == null || this._topicT.getReceivers() == null) {
            return null;
        }
        String string = "";
        Iterator iterator = this._topicT.getReceivers().iterator();
        while (iterator.hasNext()) {
            AckReporterIf ackReporterIf = (AckReporterIf)iterator.next();
            string = string + "Node " + ackReporterIf + " Sent Ack " + ackReporterIf.getSeq() + (iterator.hasNext() ? ", " : ".");
        }
        return string;
    }

    public void onEvent(com.ibm.rmm.transmitter.Event event2) {
        if (event2.getType() == 4) {
            InetAddress inetAddress = event2.getAddress();
            int n = event2.getPort();
            Throwable throwable = (Throwable)event2.getObjectField();
            this.handleUdpSendFailure(inetAddress, n, throwable);
        } else if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Unknown com.ibm.rmm.transmitter.Event", "RMMMcastGroup.onEvent()", null);
            dCSTraceBuffer.addProperty("ClassName", event2.getClass().getName());
            dCSTraceBuffer.addProperty("TypeCode", event2.getType());
            dCSTraceBuffer.invoke();
        }
    }

    private void handleUdpSendFailure(InetAddress inetAddress, int n, Throwable throwable) {
        FailedToSendUdp failedToSendUdp = new FailedToSendUdp(this, inetAddress.toString() + ":" + n, this._channelName, throwable);
        failedToSendUdp.invokeNLSTrace();
    }

    private AckReporter getLazyAcker() {
        List list = this._topicT.getReceivers();
        if (list == null || list.isEmpty()) {
            return null;
        }
        int n = 0;
        AckReporter ackReporter = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AckReporter ackReporter2 = (AckReporter)iterator.next();
            int n2 = ackReporter2.getSeq();
            if (ackReporter != null && n - n2 <= 0) continue;
            n = n2;
            ackReporter = ackReporter2;
        }
        return ackReporter;
    }

    private McastRmmNode getRmmNodeFromReceivers(InetAddress inetAddress, int n) {
        Iterator iterator = this._receivers.iterator();
        while (iterator.hasNext()) {
            McastRmmNode mcastRmmNode = (McastRmmNode)iterator.next();
            if (!mcastRmmNode.getInetAddress().equals(inetAddress) || mcastRmmNode.getPort() != n) continue;
            return mcastRmmNode;
        }
        return null;
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    protected void closeOldT(Object object) {
        ((LJETopicT)object).close();
    }

    public boolean mcast(byte[] byArray, int n, int n2, VRIMemberDescription[] vRIMemberDescriptionArray) {
        throw new RuntimeException("RMMMcastGroup::mcastMessage() should not be called");
    }
}

