/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmm.receiver.Event;
import com.ibm.rmm.receiver.QueueR;
import com.ibm.rmm.receiver.RMReceiver;
import com.ibm.rmm.receiver.StreamSelector;
import com.ibm.rmm.transmitter.QueueT;
import com.ibm.rmm.transmitter.RMTransmitter;
import com.ibm.rmm.transmitter.Submitter;
import com.ibm.ws.dcs.common.AddressResolver;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.vri.common.MetaMessageFactory;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.TransportInternalException;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RmmNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RmmUtils;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmPtpReceiverEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmPtpTransmitterEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmQueueTransmitterEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.PtpRmmNode;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.QueueTHandler;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.ptpUtils.QueueTHandlerListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.RMMGroup;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.RmmGroupListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.TransmitterThread;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class RmmPtpGroup
extends RMMGroup
implements QueueTHandlerListener {
    private static TraceComponent TC = Tr.register(RmmPtpGroup.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    final QueueR _queueR;
    private final AddressResolver _addressResolver;
    protected HashMap _activeReceiversQueueMap = new HashMap();
    protected Submitter[] _activeSubmitters = new Submitter[0];

    public RmmPtpGroup(RmmGroupListener rmmGroupListener, DCSLogicalChannel dCSLogicalChannel, RMReceiver rMReceiver, RMTransmitter rMTransmitter, StreamSelector streamSelector, String string, long l, TransmitterThread transmitterThread, MetaMessageFactory metaMessageFactory, String string2, int n, AddressResolver addressResolver) {
        super(rmmGroupListener, dCSLogicalChannel, rMReceiver, rMTransmitter, streamSelector, string, l, transmitterThread, metaMessageFactory, string2, n);
        this._addressResolver = addressResolver;
        this._queueR = this._rmr.createQueueReceiver(this._selector);
        if (this._queueR == null) {
            throw new TransportInternalException("RMMP2pGroup: Failed to open queue R");
        }
        this._queueR.setAdvancedMessageListener(this);
    }

    public void refreshReceiver() {
        DCSTraceBuffer dCSTraceBuffer;
        if (this._queueR == null) {
            throw new TransportInternalException("RmmPtpGroup.refreshReceiver: QueueR is null");
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmPtpGroup.refreshReceiver()", "Before Refresh");
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.invoke();
        }
        this._queueR.refreshStreamList();
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmPtpGroup.refreshReceiver()", "After Refresh");
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.invoke();
        }
    }

    public void refreshReceiverRejectedStreams() {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmPtpGroup.refreshReceiverRejectedStreams()", "Before Refresh");
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.invoke();
        }
        this._queueR.clearRejectedStreamList();
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmPtpGroup.refreshReceiverRejectedStreams()", "After Refresh");
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.invoke();
        }
    }

    public void rejectReceiverStream(long l) {
        DCSTraceBuffer dCSTraceBuffer;
        String string;
        boolean bl = l != 0L;
        String string2 = string = bl ? "" : "got no stream";
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmPtpGroup.rejectReceiverStream()", "Before Reject " + string);
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.invoke();
        }
        if (bl) {
            this._queueR.rejectStream(l);
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmPtpGroup.rejectReceiverStream()", "After Reject " + string);
            dCSTraceBuffer.addProperty(this._channelName);
            dCSTraceBuffer.invoke();
        }
    }

    public synchronized boolean addNode(RmmNode rmmNode) {
        boolean bl;
        Object object;
        super.addNode(rmmNode);
        PtpRmmNode ptpRmmNode = (PtpRmmNode)rmmNode;
        boolean bl2 = false;
        QueueTHandler queueTHandler = (QueueTHandler)this._activeReceiversQueueMap.get(ptpRmmNode.getName());
        if (queueTHandler != null && queueTHandler.getQueueT() == null) {
            this._activeReceiversQueueMap.remove(ptpRmmNode.getName());
            queueTHandler = null;
            bl2 = true;
        }
        if (queueTHandler != null) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this, "RmmPtpGroup.addNode()", "Node is already in the group");
                ((DCSTraceBuffer)object).addProperty(rmmNode);
                ((DCSTraceBuffer)object).addProperty(this._channelName);
                ((DCSTraceBuffer)object).invoke();
            }
            bl = false;
        } else {
            bl = true;
            queueTHandler = this.createActiveQth(ptpRmmNode);
        }
        if (queueTHandler != null && queueTHandler.getQueueT() != null) {
            if (bl) {
                this._activeReceiversQueueMap.put(ptpRmmNode.getName(), queueTHandler);
                this.updateActiveSubmitters();
            }
            object = RmmUtils.getDCSHbt();
            this._transmitter.submitMessage(queueTHandler.getQueueT(), (byte[])object, 0, ((Object)object).length);
            return true;
        }
        if (bl2) {
            this.updateActiveSubmitters();
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "RmmPtpGroup.addNode()", "addNode failed");
            ((DCSTraceBuffer)object).addProperty(rmmNode);
            ((DCSTraceBuffer)object).addProperty(this._channelName);
            ((DCSTraceBuffer)object).invoke();
        }
        return false;
    }

    protected void updateActiveSubmitters() {
        QueueTHandler[] queueTHandlerArray;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            queueTHandlerArray = DCSTraceBuffer.event(this, "updateActiveSubmitters", "");
            queueTHandlerArray.addProperty("activeReceiversQueueMap", (Object)this._activeReceiversQueueMap);
            queueTHandlerArray.invoke();
        }
        queueTHandlerArray = this._activeReceiversQueueMap.values().toArray(new QueueTHandler[this._activeReceiversQueueMap.size()]);
        this._activeSubmitters = new Submitter[queueTHandlerArray.length];
        for (int i = 0; i < queueTHandlerArray.length; ++i) {
            this._activeSubmitters[i] = queueTHandlerArray[i].getQueueT();
        }
    }

    protected QueueTHandler createActiveQth(PtpRmmNode ptpRmmNode) {
        QueueTHandler queueTHandler = new QueueTHandler(this._rmt, (Object)this._topicName, ptpRmmNode, this, this._addressResolver);
        try {
            if (queueTHandler.open()) {
                return queueTHandler;
            }
            return null;
        }
        catch (DCSInvalidParametersException dCSInvalidParametersException) {
            if (this._addressResolver == null) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "The connection on which we tried to open a qth: " + ptpRmmNode.toString() + " has vanished", "RmmPtpGroup.createActiveQth()", null);
                    dCSTraceBuffer.addProperty(ptpRmmNode);
                    dCSTraceBuffer.invoke();
                }
            } else if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "The address resolver was null when trying to open a qth: " + ptpRmmNode.toString(), "RmmPtpGroup.createActiveQth()", null);
                dCSTraceBuffer.addProperty(ptpRmmNode);
                dCSTraceBuffer.invoke();
            }
            return null;
        }
    }

    public synchronized void removeNode(RmmNode rmmNode) {
        super.removeNode(rmmNode);
        PtpRmmNode ptpRmmNode = (PtpRmmNode)rmmNode;
        if (rmmNode == null || !this._activeReceiversQueueMap.containsKey(ptpRmmNode.getName())) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "RmmPtpGroup.removeNode()", "Does not actually remove node");
                dCSTraceBuffer.addProperty(rmmNode);
                dCSTraceBuffer.addProperty(this._channelName);
                dCSTraceBuffer.invoke();
            }
            return;
        }
        QueueTHandler queueTHandler = (QueueTHandler)this._activeReceiversQueueMap.remove(rmmNode.getName());
        this.closeActiveQth(ptpRmmNode, queueTHandler);
        this.updateActiveSubmitters();
    }

    protected void closeActiveQth(PtpRmmNode ptpRmmNode, QueueTHandler queueTHandler) {
        queueTHandler.close(true);
    }

    public synchronized RmmNode[] setNodes(RmmNode[] rmmNodeArray, String string) {
        if (super.setNodes(rmmNodeArray, string) != null) {
            return rmmNodeArray;
        }
        if (this._activeReceiversQueueMap != null && this._activeReceiversQueueMap.size() > 0) {
            this.setAlarm(this._activeReceiversQueueMap);
        }
        this._activeReceiversQueueMap = new HashMap();
        this._activeSubmitters = new Submitter[0];
        HashSet<PtpRmmNode> hashSet = new HashSet<PtpRmmNode>();
        for (int i = 0; i < rmmNodeArray.length; ++i) {
            PtpRmmNode ptpRmmNode = (PtpRmmNode)rmmNodeArray[i];
            if (this.addNode(ptpRmmNode)) continue;
            hashSet.add(ptpRmmNode);
        }
        return hashSet.toArray(new PtpRmmNode[hashSet.size()]);
    }

    public synchronized boolean mcast(byte[] byArray, int n, int n2) {
        this._transmitter.submitMessage(this._activeSubmitters, byArray, n, n2);
        return true;
    }

    public synchronized boolean mcast(byte[] byArray, int n, int n2, VRIMemberDescription[] vRIMemberDescriptionArray) {
        Submitter[] submitterArray = new Submitter[vRIMemberDescriptionArray.length];
        int n3 = 0;
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            QueueT queueT;
            QueueTHandler queueTHandler;
            if (vRIMemberDescriptionArray[i] == null || (queueTHandler = (QueueTHandler)this._activeReceiversQueueMap.get(vRIMemberDescriptionArray[i].getName())) == null || (queueT = queueTHandler.getQueueT()) == null) continue;
            submitterArray[n3++] = queueT;
        }
        if (n3 < vRIMemberDescriptionArray.length) {
            Submitter[] submitterArray2 = new Submitter[n3];
            System.arraycopy(submitterArray, 0, submitterArray2, 0, n3);
            submitterArray = submitterArray2;
        }
        if (submitterArray.length > 0) {
            this._transmitter.submitMessage(submitterArray, byArray, n, n2);
        }
        return true;
    }

    public synchronized boolean send(byte[] byArray, int n, int n2, PtpRmmNode ptpRmmNode) {
        QueueTHandler queueTHandler = (QueueTHandler)this._activeReceiversQueueMap.get(ptpRmmNode.getName());
        if (queueTHandler == null) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "send", "Fail to send message - QueueTHandler is null");
                dCSTraceBuffer.addProperty("memberName", ptpRmmNode.getName());
                dCSTraceBuffer.invoke();
            }
            return false;
        }
        QueueT queueT = queueTHandler.getQueueT();
        if (queueT == null) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "send", "Fail to send message - Submitter is null");
                dCSTraceBuffer.addProperty("memberName", ptpRmmNode.getName());
                dCSTraceBuffer.invoke();
            }
            return true;
        }
        this._transmitter.submitMessage(queueT, byArray, n, n2);
        return true;
    }

    public void close() {
        super.close();
        this.closeOldT(this._activeReceiversQueueMap);
        if (this._queueR != null) {
            this._queueR.close();
        }
    }

    public void onEvent(Event event2) {
        try {
            super.onEvent(event2);
        }
        catch (Throwable throwable) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Ignore event as got exception", "RmmPtpGroup.onEvent()", throwable);
                dCSTraceBuffer.addProperty("RmmEvent", event2.getDescription());
                dCSTraceBuffer.addProperty(this._channelName);
                dCSTraceBuffer.invoke();
            }
            return;
        }
        this._inEventsMsgsThread.queueObject(new RmmPtpReceiverEvent(event2, this._channelName, this, this._hbtTimeoutMilliSec));
    }

    protected void closeOldT(Object object) {
        Map map = (Map)object;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            QueueTHandler queueTHandler = (QueueTHandler)iterator.next();
            if (queueTHandler == null) continue;
            queueTHandler.close(true);
        }
        map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeFromClosed(String string, long l) {
        Object object;
        Object object2;
        Long l2 = new Long(l);
        Object object3 = this._closeWaitingMap;
        synchronized (object3) {
            object2 = this._closeWaitingMap.entrySet().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                RMMGroup.AlarmData alarmData = (RMMGroup.AlarmData)object.getValue();
                Map map = (Map)alarmData._alarmContext;
                QueueTHandler queueTHandler = (QueueTHandler)map.get(string);
                if (queueTHandler == null || !l2.equals(queueTHandler.getStreamId())) continue;
                queueTHandler.close(true);
                map.remove(string);
                --this._waitForCloseCounter;
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "closeFromClosed", "Stream removed from toBeClosed map and closed immediately");
                    dCSTraceBuffer.addProperty("memberName", string);
                    dCSTraceBuffer.addProperty("StreamId", l);
                    dCSTraceBuffer.addProperty("waitForCloseCounter", this._waitForCloseCounter);
                    dCSTraceBuffer.invoke();
                }
                return true;
            }
        }
        object3 = this;
        synchronized (object3) {
            object2 = (QueueTHandler)this._activeReceiversQueueMap.get(string);
            if (object2 == null) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    object = DCSTraceBuffer.event(this, "closeFromClosed", "Member is not a member of the group");
                    ((DCSTraceBuffer)object).addProperty("memberName", string);
                    ((DCSTraceBuffer)object).addProperty("StreamId", l);
                    ((DCSTraceBuffer)object).addProperty("RC", true);
                    ((DCSTraceBuffer)object).invoke();
                }
                return true;
            }
            if (l2.equals(((QueueTHandler)object2).getStreamId())) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    object = DCSTraceBuffer.event(this, "closeFromClosed", "The stream is an active stream for the member");
                    ((DCSTraceBuffer)object).addProperty("memberName", string);
                    ((DCSTraceBuffer)object).addProperty("StreamId", l);
                    ((DCSTraceBuffer)object).addProperty("RC", false);
                    ((DCSTraceBuffer)object).invoke();
                }
                return false;
            }
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this, "closeFromClosed", "The stream is NOT an active stream for the member");
                ((DCSTraceBuffer)object).addProperty("memberName", string);
                ((DCSTraceBuffer)object).addProperty("Closed", "StreamId", l);
                ((DCSTraceBuffer)object).addProperty("Active", "StreamId", ((QueueTHandler)object2).getStreamId());
                ((DCSTraceBuffer)object).addProperty("RC", true);
                ((DCSTraceBuffer)object).invoke();
            }
            return true;
        }
    }

    public synchronized boolean contains(RmmNode rmmNode) {
        return this.contains(rmmNode.getName());
    }

    public synchronized boolean contains(String string) {
        return this._activeReceiversQueueMap.keySet().contains(string);
    }

    public synchronized void onTransmissionEvent(PtpRmmNode ptpRmmNode, com.ibm.rmm.transmitter.Event event2) {
        RmmQueueTransmitterEvent rmmQueueTransmitterEvent = new RmmQueueTransmitterEvent(event2, ptpRmmNode, this._channelName, (DCSTraceContext)this);
        this.onLocalEvent(rmmQueueTransmitterEvent);
    }

    protected synchronized void onLocalEvent(RmmPtpTransmitterEvent rmmPtpTransmitterEvent) {
        PtpRmmNode ptpRmmNode = rmmPtpTransmitterEvent.getSourceNode();
        boolean bl = this._activeReceiversQueueMap.containsKey(ptpRmmNode.getName());
        if (bl) {
            this._inEventsMsgsThread.queueObject(rmmPtpTransmitterEvent);
        }
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("RmmEvent", rmmPtpTransmitterEvent.getDescription());
        dCSTraceBuffer.addProperty(ptpRmmNode);
        dCSTraceBuffer.addProperty("Flag", bl);
        String string = bl ? "Event for active node was queued" : "Event for inactive node was ignored";
        this._listener.focus("onPtpEvent", string, dCSTraceBuffer);
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String dump() {
        return "\n****************** RmmPtpGroup::dump() *******************\nTopic name: \n" + this._topicName + "\n Active receivers map: \n" + this._activeReceiversQueueMap.toString() + super.dump();
    }
}

