/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmm.transmitter.Submitter;
import com.ibm.ws.dcs.common.event.DCSTransmitterCongestionEvent;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.Job;
import com.ibm.ws.dcs.vri.common.JobsProcessorThread;
import com.ibm.ws.dcs.vri.common.ThreadManager;
import com.ibm.ws.dcs.vri.common.event.CongestionControlEvent;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.nls.TransmitterCongestionEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.TransportAdapter;
import com.ibm.ws.dcs.vri.transportAdapter.TransportInternalException;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.TransmitterThreadListener;

public final class TransmitterThread
implements DCSTraceContext {
    private boolean _terminated = false;
    private static TraceComponent TC = Tr.register(TransmitterThread.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private TransmitterThreadListener _listener;
    private JobsProcessorThread _msgsThread;
    private JobsProcessorThread _congestionEventsThread;
    private final String _msgsThreadName;
    private final String _congestionEventsThreadName;
    private final String _thisMemberName;
    private final String _thisStackName;
    private int _storedBytes;
    private int _redMark;
    private int _yellowMark;
    private int _greenMark;
    private int _congestionState;
    public static final int GREEN = 1;
    public static final int YELLOW = 2;
    public static final int RED = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransmitterThread(String string, String string2, String string3, TransmitterThreadListener transmitterThreadListener, int n, int n2, int n3, boolean bl) {
        TransmitterThread transmitterThread = this;
        synchronized (transmitterThread) {
            this._thisMemberName = string;
            this._thisStackName = string2;
            this._msgsThreadName = string3 + "|Msgs";
            this._congestionEventsThreadName = string3 + "|Events";
            this._listener = transmitterThreadListener;
            this._storedBytes = 0;
            this._congestionState = 1;
            this._redMark = n3;
            this._yellowMark = n2;
            this._greenMark = n;
            this._msgsThread = ThreadManager.getThread(this._msgsThreadName, ThreadManager.RMM_THREAD, 7, bl);
            if (this._msgsThread == null) {
                throw new TransportInternalException("TransmitterThread.TransmitterThread: " + string2 + ": Failed to create messages thread");
            }
            this._congestionEventsThread = ThreadManager.getThread(this._congestionEventsThreadName, ThreadManager.INTERNAL_THREAD, 1);
            if (this._congestionEventsThread == null) {
                throw new TransportInternalException("TransmitterThread.TransmitterThread: " + string2 + ": Failed to create congestion events thread");
            }
        }
    }

    protected void msgToRmmNoCon(Submitter submitter, byte[] byArray, int n, int n2) {
        try {
            boolean bl = submitter.submitMessage(byArray, n, n2);
            if (!bl && DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "Return value of submit message is false", "TransmitterThread.msgToRmmNoCon()", null);
                dCSTraceBuffer.invoke();
            }
        }
        catch (Throwable throwable) {
            this._listener.requestTermination(new TerminationEvent((DCSTraceContext)this, "msgToRmmNoCon()", throwable));
        }
    }

    public void submitMessage(Submitter submitter, byte[] byArray, int n, int n2) {
        this.updateCongestionState(byArray.length);
        this._msgsThread.enqueueJob(new OutMsgJobSingleTatget(submitter, byArray, n, n2, this));
    }

    public void submitMessage(Submitter[] submitterArray, byte[] byArray, int n, int n2) {
        this.updateCongestionState(byArray.length);
        this._msgsThread.enqueueJob(new OutMsgJobMultipleTatgets(submitterArray, byArray, n, n2, this));
    }

    private synchronized void updateCongestionState(int n) {
        this._storedBytes += n;
        if (n > 0) {
            if (this._congestionState == 1 && this._storedBytes < this._yellowMark) {
                return;
            }
            if (this._congestionState != 3 && this._storedBytes >= this._redMark) {
                this._congestionState = 3;
                this._congestionEventsThread.enqueueJob(new CongestionEventJob(this.createCongestionControlEvent(DCSTransmitterCongestionEvent.RED_LINE, this.getCurrentInfo()), this));
            } else if (this._congestionState == 1 && this._storedBytes >= this._yellowMark) {
                this._congestionState = 2;
                this._congestionEventsThread.enqueueJob(new CongestionEventJob(this.createCongestionControlEvent(DCSTransmitterCongestionEvent.YELLOW_LINE, this.getCurrentInfo()), this));
            }
        } else if (this._congestionState != 1 && this._storedBytes < this._greenMark) {
            this._congestionState = 1;
            this._congestionEventsThread.enqueueJob(new CongestionEventJob(this.createCongestionControlEvent(DCSTransmitterCongestionEvent.GREEN_LINE, null), this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        String string;
        TransmitterThread transmitterThread = this;
        synchronized (transmitterThread) {
            string = "\n************** TransmitterThread.dump: *******************\n Congestion state " + this._congestionState + "\n current info:" + this.getCurrentInfo();
        }
        return string;
    }

    public void terminate() {
        this._terminated = true;
        ThreadManager.releaseThread(this._msgsThreadName);
        ThreadManager.releaseThread(this._congestionEventsThreadName);
    }

    private CongestionControlEvent createCongestionControlEvent(DCSTransmitterCongestionEvent.CongestionWaterMark congestionWaterMark, String string) {
        TransmitterCongestionEvent transmitterCongestionEvent = new TransmitterCongestionEvent(TC, TransportAdapter.TA_LAYER_NAME, this._thisStackName, this._thisMemberName, string, congestionWaterMark);
        transmitterCongestionEvent.invokeNLSTrace();
        CongestionControlEvent congestionControlEvent = new CongestionControlEvent(transmitterCongestionEvent);
        return congestionControlEvent;
    }

    private String getCurrentInfo() {
        return "Total stored bytes: " + this._storedBytes + ", Red mark is " + this._redMark + ", Yellow mark is " + this._yellowMark + ", Green mark is " + this._greenMark;
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._thisStackName;
    }

    public String getMemberName() {
        return this._thisMemberName;
    }

    public String getLayerName() {
        return DCSConstants.TRACE_LAYER_NAMES[1];
    }

    protected final class CongestionEventJob
    implements Job {
        private final CongestionControlEvent _event;
        private final DCSTraceContext _dtc;

        public CongestionEventJob(CongestionControlEvent congestionControlEvent, DCSTraceContext dCSTraceContext) {
            this._event = congestionControlEvent;
            this._dtc = dCSTraceContext;
        }

        public void process() {
            TransmitterThread.this._listener.onCongestionControlEvent(this._event);
        }

        public void cancel() {
            if (!TransmitterThread.this._terminated && DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._dtc, "Job was canceled", "CongestionEventJob.cancel()", null);
                dCSTraceBuffer.invoke();
            }
        }

        public void handleError(Throwable throwable) {
            TransmitterThread.this._listener.requestTermination(new TerminationEvent(this._dtc, "CongestionEventJob.handleError()", throwable));
        }

        public String getOwner() {
            return TransmitterThread.this._congestionEventsThreadName;
        }
    }

    protected final class OutMsgJobMultipleTatgets
    extends OutMsgJob {
        private final Submitter[] _submitters;

        public OutMsgJobMultipleTatgets(Submitter[] submitterArray, byte[] byArray, int n, int n2, DCSTraceContext dCSTraceContext) {
            super(byArray, n, n2, dCSTraceContext);
            this._submitters = submitterArray;
        }

        public void process() {
            int n;
            try {
                for (n = 0; n < this._submitters.length; ++n) {
                    boolean bl = false;
                    if (this._submitters[n] != null) {
                        bl = this._submitters[n].submitMessage(this._buffer, 0, this._length);
                    }
                    if (bl || !DCSTraceBuffer.isEventEnabled(TC)) continue;
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(TransmitterThread.this, "OutMsgJobMultipleTatgets.process", "Return value of submit message is false");
                    dCSTraceBuffer.invoke();
                }
            }
            catch (Throwable throwable) {
                TransmitterThread.this._listener.requestTermination(new TerminationEvent((DCSTraceContext)TransmitterThread.this, "msgToRmm()", throwable));
            }
            n = this._buffer.length;
            this._buffer = null;
            TransmitterThread.this.updateCongestionState(-n);
        }
    }

    protected final class OutMsgJobSingleTatget
    extends OutMsgJob {
        private final Submitter _submitter;

        public OutMsgJobSingleTatget(Submitter submitter, byte[] byArray, int n, int n2, DCSTraceContext dCSTraceContext) {
            super(byArray, n, n2, dCSTraceContext);
            this._submitter = submitter;
        }

        public void process() {
            try {
                boolean bl = true;
                if (this._submitter != null) {
                    bl = this._submitter.submitMessage(this._buffer, 0, this._length);
                }
                if (!bl && DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(TransmitterThread.this, "OutMsgJobSingleTatget.process", "Return value of submit message is false");
                    dCSTraceBuffer.invoke();
                }
            }
            catch (Throwable throwable) {
                TransmitterThread.this._listener.requestTermination(new TerminationEvent((DCSTraceContext)TransmitterThread.this, "OutMsgJobSingleTatget.process()", throwable));
            }
            int n = this._buffer.length;
            this._buffer = null;
            TransmitterThread.this.updateCongestionState(-n);
        }
    }

    protected abstract class OutMsgJob
    implements Job {
        protected byte[] _buffer;
        protected int _length;
        private final DCSTraceContext _dtc;

        public OutMsgJob(byte[] byArray, int n, int n2, DCSTraceContext dCSTraceContext) {
            if (n != 0) {
                this._buffer = new byte[byArray.length];
                System.arraycopy(byArray, n, this._buffer, 0, n2);
            } else {
                this._buffer = byArray;
            }
            this._length = n2;
            this._dtc = dCSTraceContext;
        }

        public void cancel() {
            if (!TransmitterThread.this._terminated && DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._dtc, "Job was canceled", "OutMsgJob.cancel()", null);
                dCSTraceBuffer.invoke();
            }
        }

        public void handleError(Throwable throwable) {
            TransmitterThread.this._listener.requestTermination(new TerminationEvent(this._dtc, "OutMsgJob.handleError()", throwable));
        }

        public String getOwner() {
            return TransmitterThread.this._msgsThreadName;
        }
    }
}

