/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.ViewId;
import com.ibm.ws.dcs.utils.Alarm;
import com.ibm.ws.dcs.utils.AlarmListener;
import com.ibm.ws.dcs.utils.AlarmManager;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view.MemberData;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view.RcvMembersStatus;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view.RcvMembersViewMapListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class RcvMembersViewMap
implements AlarmListener,
DCSTraceContext {
    private static final int UNKNOWN_STATE = -1;
    private static final int NORMAL_STATE = 1;
    private static final int CC_STATE = 2;
    private static final int NV_STATE = 3;
    private static final int NV_CC_STATE = 4;
    private int _state = -1;
    private final String _thisStackName;
    private final String _thisMemberName;
    private final Object _stackMutex;
    private final DCSLogicalChannel _channel;
    private static TraceComponent TC = Tr.register(RcvMembersViewMap.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private final HashMap _sendersViewMap = new HashMap();
    private ViewIdImpl _currentViewId;
    private final RcvMembersViewMapListener _listener;
    private final Map _cachedAcceptableStreams = new HashMap();
    private final Map _candidatesMap = new HashMap();
    private Alarm _newViewAlarm;

    RcvMembersViewMap(Object object, String string, String string2, ViewIdImpl viewIdImpl, RcvMembersViewMapListener rcvMembersViewMapListener, DCSLogicalChannel dCSLogicalChannel) {
        this._currentViewId = viewIdImpl;
        this._stackMutex = object;
        this._listener = rcvMembersViewMapListener;
        this._thisMemberName = string;
        this._thisStackName = string2;
        this._channel = dCSLogicalChannel;
        this._newViewAlarm = null;
    }

    void completeCurrent() {
        this._state = this._state == 1 ? 2 : (this._state == 3 || this._state == 4 ? 4 : 2);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "RcvMembersViewMap.completeCurrent()", "");
            dCSTraceBuffer.addProperty("State", this._state);
            dCSTraceBuffer.invoke();
        }
    }

    Set newView(Set set, ViewIdImpl viewIdImpl, Map map, long l) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n = 0;
        HashSet<Long> hashSet = new HashSet<Long>();
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("New", "Senders", set);
        dCSTraceBuffer.addProperty(viewIdImpl);
        dCSTraceBuffer.addProperty("Timeout", l);
        dCSTraceBuffer.addProperty(this._channel);
        dCSTraceBuffer.addProperty("Old", "Senders", this._sendersViewMap.keySet());
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object4 = DCSTraceBuffer.event(this, "RcvMembersViewMap.newView()", "Method Start");
            ((DCSTraceBuffer)object4).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object4).invoke();
        }
        object4 = new HashSet(set);
        this._currentViewId = viewIdImpl;
        HashSet hashSet2 = new HashSet(this._sendersViewMap.keySet());
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            object3 = (String)iterator.next();
            if (((HashSet)object4).contains(object3)) {
                Object object5;
                object2 = (MemberData)this._sendersViewMap.get(object3);
                object = ((MemberData)object2).viewId;
                if (object == null) {
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        object5 = DCSTraceBuffer.event(this, "RcvMembersViewMap.newView()", "Member in O <inter> N and sent LAST msg");
                        ((DCSTraceBuffer)object5).mergePropertyList(dCSTraceBuffer);
                        ((DCSTraceBuffer)object5).addProperty("Sender", object3);
                        ((DCSTraceBuffer)object5).invoke();
                    }
                    if ((object5 = this.getCandidateStream((String)object3, this._currentViewId)) != null) {
                        ++n;
                    }
                    this._sendersViewMap.put(object3, new MemberData((String)object3, this._currentViewId, (Long)object5));
                } else if (DCSTraceBuffer.isEventEnabled(TC)) {
                    object5 = DCSTraceBuffer.event(this, "RcvMembersViewMap.newView()", "Member in O <inter> N and didn't send LAST msg");
                    ((DCSTraceBuffer)object5).mergePropertyList(dCSTraceBuffer);
                    ((DCSTraceBuffer)object5).addProperty("Sender", object3);
                    ((DCSTraceBuffer)object5).invoke();
                }
                ((HashSet)object4).remove(object3);
                continue;
            }
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object2 = DCSTraceBuffer.event(this, "RcvMembersViewMap.newView()", "Member in O/N");
                ((DCSTraceBuffer)object2).mergePropertyList(dCSTraceBuffer);
                ((DCSTraceBuffer)object2).addProperty("Sender", object3);
                ((DCSTraceBuffer)object2).invoke();
            }
            object2 = (MemberData)this._sendersViewMap.remove(object3);
            if (((MemberData)object2).streamId == null) continue;
            this._cachedAcceptableStreams.remove(((MemberData)object2).streamId);
            hashSet.add(((MemberData)object2).streamId);
        }
        object3 = ((HashSet)object4).iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this, "RcvMembersViewMap.newView()", "Member in N/O");
                ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
                ((DCSTraceBuffer)object).addProperty("Sender", object2);
                ((DCSTraceBuffer)object).invoke();
            }
            if ((object = this.getCandidateStream((String)object2, this._currentViewId)) != null) {
                ++n;
            }
            this._sendersViewMap.put(object2, new MemberData((String)object2, this._currentViewId, (Long)object));
        }
        this.cancelAlarm();
        this._newViewAlarm = n < set.size() ? AlarmManager.create(AlarmManager.GENERAL_ALARM, l, this._stackMutex, this, this._currentViewId) : AlarmManager.create(AlarmManager.GENERAL_ALARM, 1L, this._stackMutex, this, this._currentViewId);
        this._state = 3;
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object2 = DCSTraceBuffer.exit(this, "RcvMembersViewMap.newView()", null);
            ((DCSTraceBuffer)object2).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object2).addProperty("allMembersReady", n == set.size());
            ((DCSTraceBuffer)object2).addProperty("ReturnCode", hashSet);
            ((DCSTraceBuffer)object2).invoke();
        }
        return hashSet;
    }

    private Long getCandidateStream(String string, ViewId viewId) {
        Long l = null;
        Set set = this._candidatesMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Long l2 = (Long)iterator.next();
            MemberData memberData = (MemberData)this._candidatesMap.get(l2);
            if (!string.equals(memberData.name) || !viewId.equals(memberData.viewId)) continue;
            l = l2;
            break;
        }
        return l;
    }

    private boolean cancelAlarm() {
        if (this._newViewAlarm != null) {
            this._newViewAlarm.cancel();
            this._newViewAlarm = null;
            return true;
        }
        return false;
    }

    Set removeMember(String string) {
        Object object;
        Object object2;
        HashSet<Object> hashSet = new HashSet<Object>();
        MemberData memberData = (MemberData)this._sendersViewMap.remove(string);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object2 = DCSTraceBuffer.event(this, "RcvMembersViewMap.removeMember()", "Method Start");
            ((DCSTraceBuffer)object2).addProperty(this._channel);
            ((DCSTraceBuffer)object2).addProperty("Sender", string);
            ((DCSTraceBuffer)object2).addProperty("Flag", memberData != null);
            ((DCSTraceBuffer)object2).invoke();
        }
        if (memberData == null) {
            return hashSet;
        }
        if (memberData.streamId != null) {
            this._cachedAcceptableStreams.remove(memberData.streamId);
            hashSet.add(memberData.streamId);
        }
        object2 = this._candidatesMap.keySet();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (Long)iterator.next();
            String string2 = ((MemberData)this._candidatesMap.get((Object)object)).name;
            if (!string.equals(string2)) continue;
            hashSet.add(object);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (Long)iterator.next();
            this._candidatesMap.remove(object);
        }
        if (this._state == 3 || this._state == 4) {
            object = this.getStatus();
            if (((RcvMembersStatus)object).badMembers.isEmpty()) {
                this.cancelAlarm();
                this._newViewAlarm = AlarmManager.create(AlarmManager.GENERAL_ALARM, 1L, this._stackMutex, this, this._currentViewId);
            }
        }
        return hashSet;
    }

    StreamStatus getStreamStatus(Long l) {
        StreamStatus streamStatus = new StreamStatus(l);
        String string = (String)this._cachedAcceptableStreams.get(l);
        if (string != null) {
            streamStatus.sender = string;
            streamStatus.state = 1;
            return streamStatus;
        }
        MemberData memberData = (MemberData)this._candidatesMap.get(l);
        if (memberData != null) {
            streamStatus.sender = memberData.name;
            streamStatus.state = 2;
            streamStatus.vid = memberData.viewId;
        }
        return streamStatus;
    }

    void senderSentLastMsg(String string, long l) {
        DCSTraceBuffer dCSTraceBuffer;
        Object object;
        DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.propertyList();
        dCSTraceBuffer2.addProperty("Sender", string);
        dCSTraceBuffer2.addProperty("StreamId", l);
        dCSTraceBuffer2.addProperty("State", this._state);
        dCSTraceBuffer2.addProperty(this._channel);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.event(this, "RcvMembersViewMap.senderSentLastMsg()", "");
            dCSTraceBuffer3.mergePropertyList(dCSTraceBuffer2);
            dCSTraceBuffer3.invoke();
        }
        boolean bl = this._cachedAcceptableStreams.remove(new Long(l)) != null;
        MemberData memberData = (MemberData)this._sendersViewMap.get(string);
        if (this._state == 1 || !bl || memberData == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer4 = DCSTraceBuffer.internalWarning(this, "We do not wait for last message from the sender", "RcvMembersViewMap.senderSentLastMsg()", null);
                dCSTraceBuffer4.mergePropertyList(dCSTraceBuffer2);
                dCSTraceBuffer4.addProperty("inMap", memberData != null);
                dCSTraceBuffer4.addProperty("state", this._state);
                dCSTraceBuffer4.addProperty("isAcceptableStream", bl);
                dCSTraceBuffer4.invoke();
            }
            return;
        }
        ViewIdImpl viewIdImpl = memberData.viewId;
        if (this._currentViewId.equals(viewIdImpl)) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this, "RcvMembersViewMap.senderSentLastMsg()", "Last message for current view was received before NV. update view id to null, return false");
                ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer2);
                ((DCSTraceBuffer)object).invoke();
            }
            this._sendersViewMap.put(string, new MemberData(string, null, null));
        } else {
            object = this.getCandidateStream(string, this._currentViewId);
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.event(this, "RcvMembersViewMap.senderSentLastMsg()", "Last message for NOT current view. received after NV. update view id to current, return true");
                dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
                dCSTraceBuffer.addProperty("Candidate", "StreamId", object);
                dCSTraceBuffer.invoke();
            }
            this._sendersViewMap.put(string, new MemberData(string, this._currentViewId, (Long)object));
        }
        if (this._state == 3 || this._state == 4) {
            object = this.getStatus();
            if (((RcvMembersStatus)object).badMembers.isEmpty()) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    dCSTraceBuffer = DCSTraceBuffer.event(this, "RcvMembersViewMap.senderSentLastMsg()", "All members ready - reset alarm");
                    dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
                    dCSTraceBuffer.invoke();
                }
                this.cancelAlarm();
                this._newViewAlarm = AlarmManager.create(AlarmManager.GENERAL_ALARM, 1L, this._stackMutex, this, this._currentViewId);
            } else if (DCSTraceBuffer.isEventEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.event(this, "RcvMembersViewMap.senderSentLastMsg()", "Not all members ready - continue to wait");
                dCSTraceBuffer.mergePropertyList(dCSTraceBuffer2);
                dCSTraceBuffer.addProperty("memberNames", ((RcvMembersStatus)object).badMembers);
                dCSTraceBuffer.invoke();
            }
        }
    }

    private void updateStreamRelatedInfo() {
        Object object;
        this._cachedAcceptableStreams.clear();
        Set set = this._sendersViewMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            Long l = ((MemberData)this._sendersViewMap.get(object)).streamId;
            if (l == null) continue;
            this._cachedAcceptableStreams.put(l, object);
            this._candidatesMap.remove(l);
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "RcvMembersViewMap.updateStreamRelatedInfo()", "Setting cached streams");
            ((DCSTraceBuffer)object).addProperty(this._channel);
            ((DCSTraceBuffer)object).addProperty("CashedStreams", (Object)this._cachedAcceptableStreams);
            ((DCSTraceBuffer)object).invoke();
        }
    }

    synchronized String dump() {
        String string = "\n************** RcvMembersViewMap.dump: *******************\n";
        string = string + "Name=" + this._thisStackName + " : " + this._thisMemberName + ".cur vid=" + this._currentViewId + "\n";
        string = string + "Senders Map=" + this._sendersViewMap + "\n";
        string = string + "Cached Streams=" + this._cachedAcceptableStreams + "\n";
        return string;
    }

    public void alarm(Object object) {
        HashSet hashSet;
        ViewIdImpl viewIdImpl = (ViewIdImpl)object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("Alarm", viewIdImpl);
        dCSTraceBuffer.addProperty(this._channel);
        dCSTraceBuffer.addProperty("Current", this._currentViewId);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            hashSet = DCSTraceBuffer.event(this, "RcvMembersViewMap.alarm()", "Alarm is up");
            ((DCSTraceBuffer)((Object)hashSet)).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)((Object)hashSet)).addProperty("state", this._state);
            ((DCSTraceBuffer)((Object)hashSet)).invoke();
        }
        if (!this._currentViewId.equals(viewIdImpl)) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                hashSet = DCSTraceBuffer.internalWarning(this, "View Ids at confirm new view timer are not compatible", "RcvMembersViewMap.alarm()", null);
                ((DCSTraceBuffer)((Object)hashSet)).mergePropertyList(dCSTraceBuffer);
                ((DCSTraceBuffer)((Object)hashSet)).invoke();
            }
            return;
        }
        if (this._state != 3 && this._state != 4) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                hashSet = DCSTraceBuffer.internalWarning(this, "State is not NV_STATE", "RcvMembersViewMap.alarm()", null);
                ((DCSTraceBuffer)((Object)hashSet)).mergePropertyList(dCSTraceBuffer);
                ((DCSTraceBuffer)((Object)hashSet)).invoke();
            }
            return;
        }
        this._state = this._state == 3 ? 1 : 2;
        this._newViewAlarm = null;
        this.updateStreamRelatedInfo();
        if (this._state == 1) {
            hashSet = new HashSet(this._candidatesMap.keySet());
            this._candidatesMap.clear();
        } else {
            hashSet = new HashSet();
        }
        RcvMembersStatus rcvMembersStatus = this.getStatus();
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this, "RcvMembersViewMap.alarm()", "");
            dCSTraceBuffer2.addProperty("cachedStreams", (Object)this._cachedAcceptableStreams);
            dCSTraceBuffer2.addProperty("sendersViewMap", (Object)this._sendersViewMap);
            dCSTraceBuffer2.addProperty("candidatesMap", (Object)this._candidatesMap);
            dCSTraceBuffer2.addProperty("Bad", "Senders", rcvMembersStatus.badMembers);
            dCSTraceBuffer2.invoke();
        }
        this._listener.newViewOK(rcvMembersStatus.goodMembers, rcvMembersStatus.badMembers, this._currentViewId, hashSet);
    }

    boolean addCandidate(String string, ViewIdImpl viewIdImpl, long l) {
        switch (this._state) {
            case 1: {
                return this.addCandidateNormalState(string, viewIdImpl, l);
            }
            case 2: {
                return this.addCandidateCCState(string, viewIdImpl, l);
            }
            case 4: {
                return this.addCandidateNVCCState(string, viewIdImpl, l);
            }
            case 3: {
                return this.addCandidateNVState(string, viewIdImpl, l);
            }
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "addCandidate", "Unknown state - Ignore");
            dCSTraceBuffer.addProperty("state", this._state);
            dCSTraceBuffer.addProperty("memberName", string);
            dCSTraceBuffer.addProperty("StreamId", l);
            dCSTraceBuffer.addProperty("ReturnCode", false);
            dCSTraceBuffer.invoke();
        }
        return false;
    }

    private boolean addCandidateNormalState(String string, ViewIdImpl viewIdImpl, long l) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "addCandidate", "Ignore");
            dCSTraceBuffer.addProperty("state", this._state);
            dCSTraceBuffer.addProperty("memberName", string);
            dCSTraceBuffer.addProperty("StreamId", l);
            dCSTraceBuffer.addProperty("ReturnCode", false);
            dCSTraceBuffer.invoke();
        }
        return false;
    }

    private boolean addCandidateCCState(String string, ViewIdImpl viewIdImpl, long l) {
        Object object;
        boolean bl;
        String string2;
        if (this._currentViewId.compareTo(viewIdImpl) >= 0) {
            string2 = "Stream is not from future";
            bl = false;
        } else {
            object = new MemberData(string, viewIdImpl, new Long(l));
            this._candidatesMap.put(((MemberData)object).streamId, object);
            string2 = "Add stream to candidates map";
            bl = true;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "addCandidate", string2);
            ((DCSTraceBuffer)object).addProperty("state", this._state);
            ((DCSTraceBuffer)object).addProperty("memberName", string);
            ((DCSTraceBuffer)object).addProperty("StreamId", l);
            ((DCSTraceBuffer)object).addProperty("Current", this._currentViewId);
            ((DCSTraceBuffer)object).addProperty("Stream", viewIdImpl);
            ((DCSTraceBuffer)object).addProperty("ReturnCode", bl);
            ((DCSTraceBuffer)object).invoke();
        }
        return bl;
    }

    private boolean addCandidateNVState(String string, ViewIdImpl viewIdImpl, long l) {
        Object object;
        boolean bl = false;
        String string2 = "Candidate added successfully";
        if (!this._currentViewId.equals(viewIdImpl)) {
            string2 = "Stream not from current view";
        } else {
            object = (MemberData)this._sendersViewMap.get(string);
            if (object == null) {
                string2 = "Member is unknown";
            } else {
                MemberData memberData = new MemberData(string, viewIdImpl, new Long(l));
                if (((MemberData)object).streamId != null) {
                    if (((MemberData)object).viewId.equals(viewIdImpl)) {
                        string2 = "Second stream for the same view";
                    } else {
                        this._candidatesMap.put(memberData.streamId, memberData);
                        string2 = "Add stream to candidates map";
                        bl = true;
                    }
                } else {
                    this._sendersViewMap.put(string, memberData);
                    this._candidatesMap.put(memberData.streamId, memberData);
                    string2 = "Add stream to sendersViewMap";
                    RcvMembersStatus rcvMembersStatus = this.getStatus();
                    if (rcvMembersStatus.badMembers.isEmpty()) {
                        this.cancelAlarm();
                        this._newViewAlarm = AlarmManager.create(AlarmManager.GENERAL_ALARM, 1L, this._stackMutex, this, this._currentViewId);
                    }
                    bl = true;
                }
            }
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "addCandidate", string2);
            ((DCSTraceBuffer)object).addProperty("memberName", string);
            ((DCSTraceBuffer)object).addProperty("StreamId", l);
            ((DCSTraceBuffer)object).addProperty("Current", this._currentViewId);
            ((DCSTraceBuffer)object).addProperty("Stream", viewIdImpl);
            ((DCSTraceBuffer)object).addProperty("state", this._state);
            ((DCSTraceBuffer)object).addProperty("ReturnCode", bl);
            ((DCSTraceBuffer)object).invoke();
        }
        return bl;
    }

    private boolean addCandidateNVCCState(String string, ViewIdImpl viewIdImpl, long l) {
        int n = this._currentViewId.compareTo(viewIdImpl);
        if (n > 0) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "addCandidate", "State is NV_CC_STATE and Stream is from the past");
                dCSTraceBuffer.addProperty("state", this._state);
                dCSTraceBuffer.addProperty("memberName", string);
                dCSTraceBuffer.addProperty("StreamId", l);
                dCSTraceBuffer.addProperty("Current", this._currentViewId);
                dCSTraceBuffer.addProperty("Stream", viewIdImpl);
                dCSTraceBuffer.addProperty("ReturnCode", false);
                dCSTraceBuffer.invoke();
            }
            return false;
        }
        if (n == 0) {
            return this.addCandidateNVState(string, viewIdImpl, l);
        }
        return this.addCandidateCCState(string, viewIdImpl, l);
    }

    private RcvMembersStatus getStatus() {
        RcvMembersStatus rcvMembersStatus = new RcvMembersStatus();
        Set set = this._sendersViewMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Long l = ((MemberData)this._sendersViewMap.get((Object)string)).streamId;
            ViewIdImpl viewIdImpl = ((MemberData)this._sendersViewMap.get((Object)string)).viewId;
            if (!this._currentViewId.equals(viewIdImpl) || l == null) {
                rcvMembersStatus.badMembers.add(string);
                continue;
            }
            rcvMembersStatus.goodMembers.add(string);
        }
        return rcvMembersStatus;
    }

    public void close() {
        this.cancelAlarm();
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._thisStackName;
    }

    public String getMemberName() {
        return this._thisMemberName;
    }

    public String getLayerName() {
        return DCSConstants.TRACE_LAYER_NAMES[1];
    }

    static final class StreamStatus {
        static final int ACTIVE = 1;
        static final int CANDIDATE = 2;
        static final int UNKNOWN = -1;
        Long sid;
        String sender;
        ViewIdImpl vid;
        int state;

        StreamStatus(Long l) {
            this.sid = l;
            this.sender = null;
            this.vid = null;
            this.state = -1;
        }
    }
}

