/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.TransportUtils;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;

final class Repository
implements DCSTraceContext {
    private static TraceComponent TC = Tr.register(Repository.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private HashMap _repositories;
    private final String _thisMemberName;
    private final String _thisStackName;
    private final DCSLogicalChannel _channelType;

    public Repository(String string, String string2, DCSLogicalChannel dCSLogicalChannel) {
        DCSTraceBuffer dCSTraceBuffer;
        this._thisMemberName = string;
        this._thisStackName = string2;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this, "Repository.Repository()", null);
            dCSTraceBuffer.addProperty(dCSLogicalChannel);
            dCSTraceBuffer.invoke();
        }
        this._channelType = dCSLogicalChannel;
        this._repositories = new HashMap();
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this, "Repository.Repository()", null);
            dCSTraceBuffer.addProperty(dCSLogicalChannel);
            dCSTraceBuffer.invoke();
        }
    }

    void add(String string, ViewIdImpl viewIdImpl, Object object) {
        Object object2;
        if (DCSTraceBuffer.isDebugEnabled(TC)) {
            object2 = DCSTraceBuffer.debug(this, "Repository.add()", "Method Start");
            ((DCSTraceBuffer)object2).addProperty("Sender", string);
            ((DCSTraceBuffer)object2).addProperty(viewIdImpl);
            ((DCSTraceBuffer)object2).addProperty("RepositoryObject", object.getClass());
            ((DCSTraceBuffer)object2).addProperty(this._channelType);
            ((DCSTraceBuffer)object2).invoke();
        }
        object2 = new Queued(viewIdImpl, object);
        if (this._repositories.containsKey(string)) {
            LinkedList linkedList = (LinkedList)this._repositories.get(string);
            linkedList.addLast(object2);
        } else {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            linkedList.addLast(object2);
            this._repositories.put(string, linkedList);
        }
    }

    boolean contains(String string) {
        return this._repositories.containsKey(string);
    }

    LinkedList getQueued(Object[] objectArray, ViewIdImpl viewIdImpl, StringBuffer stringBuffer) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "Repository.getQueued()", null);
            dCSTraceBuffer.addProperty("Senders", Utils.toString(objectArray));
            dCSTraceBuffer.addProperty(viewIdImpl);
            dCSTraceBuffer.addProperty("RepositoryState", this.toString());
            dCSTraceBuffer.addProperty(this._channelType);
            dCSTraceBuffer.invoke();
        }
        stringBuffer.append(" Nodes are " + Utils.toString(objectArray) + ", View Id is " + viewIdImpl + ", ");
        for (int i = 0; i < objectArray.length; ++i) {
            LinkedList linkedList = (LinkedList)this._repositories.get(objectArray[i]);
            object = " Total queued from " + objectArray[i] + ": " + (linkedList == null ? 0 : linkedList.size()) + ".";
            stringBuffer.append((String)object);
        }
        stringBuffer.append("   ");
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i];
            int n = 0;
            stringBuffer.append("From node " + object + ": ");
            LinkedList linkedList2 = (LinkedList)this._repositories.get(object);
            if (linkedList2 != null) {
                ListIterator listIterator = linkedList2.listIterator();
                while (listIterator.hasNext()) {
                    Queued queued = (Queued)listIterator.next();
                    if (viewIdImpl.equals(queued.viewId)) {
                        linkedList.addLast(queued.object);
                        ++n;
                        stringBuffer.append(" " + queued.object.getClass() + " ");
                        listIterator.remove();
                        continue;
                    }
                    stringBuffer.append(" queued object not from requested view " + queued);
                }
            }
            stringBuffer.append(" Total retrieved objects from " + object + ":" + n + ". ");
            if (linkedList2 == null || !linkedList2.isEmpty()) continue;
            this._repositories.remove(object);
        }
        return linkedList;
    }

    void clean(String[] stringArray, ViewIdImpl viewIdImpl) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "Repository.clean()", null);
            ((DCSTraceBuffer)object).addProperty("Senders", Utils.toString(stringArray));
            ((DCSTraceBuffer)object).addProperty(viewIdImpl);
            ((DCSTraceBuffer)object).addProperty(this._channelType);
            ((DCSTraceBuffer)object).addProperty("RepositoryState", this.toString());
            ((DCSTraceBuffer)object).invoke();
        }
        object = TransportUtils.toHashSet(stringArray);
        Set set = this._repositories.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            LinkedList linkedList = (LinkedList)this._repositories.get(k);
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                Queued queued = (Queued)listIterator.next();
                if (object.contains(k) && viewIdImpl.equals(queued.viewId) || viewIdImpl.isPossibleFromFuture(queued.viewId)) continue;
                listIterator.remove();
            }
            if (!linkedList.isEmpty()) continue;
            iterator.remove();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Repository state:\n{\n");
        Set set = this._repositories.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            stringBuffer.append("  Node:" + k + ":");
            LinkedList linkedList = (LinkedList)this._repositories.get(k);
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                Queued queued = (Queued)listIterator.next();
                stringBuffer.append("[" + queued.viewId + ", " + queued.object.getClass() + "] ");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._thisStackName;
    }

    public String getMemberName() {
        return this._thisMemberName;
    }

    public String getLayerName() {
        return DCSConstants.TRACE_LAYER_NAMES[1];
    }

    private static class Queued {
        private ViewIdImpl viewId;
        private Object object;

        private Queued(ViewIdImpl viewIdImpl, Object object) {
            this.viewId = viewIdImpl;
            this.object = object;
        }

        public String toString() {
            return "View id=" + this.viewId + ". Object=" + this.object;
        }
    }
}

