/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmm.receiver.RMReceiver;
import com.ibm.rmm.util.MemoryReport;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.impl.BaseVRIMessage;
import com.ibm.ws.dcs.vri.common.nls.ConfirmedNewViewEvent;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.transportAdapter.TransportAdapter;
import com.ibm.ws.dcs.vri.transportAdapter.TransportGroupEvent;
import com.ibm.ws.dcs.vri.transportAdapter.TransportInternalException;
import com.ibm.ws.dcs.vri.transportAdapter.TransportUtils;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.DCSLogicalChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.common.RMMHeader;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmReceiverEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.events.RmmTransmitterEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.RMMGroup;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.rmmGroup.RmmGroupListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view.PtpViewChannel;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view.RcvMembersViewMap;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view.RcvMembersViewMapListener;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view.Repository;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view.ViewReceiverEvent;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view.ViewSelector;
import com.ibm.ws.dcs.vri.transportAdapter.rmmImpl.view.ViewTopicNameAnalyzer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class ViewReceiver
implements RmmGroupListener,
RcvMembersViewMapListener,
DCSTraceContext {
    private final DCSLogicalChannel _channelType;
    private final String _thisStackName;
    private boolean _memoryAlertOn;
    private final RMReceiver _rmr;
    private final long NEW_VIEW_SYNC_TIMEOUT;
    private final VRIMembersMGR _mmgr;
    protected final Object _stackMutex;
    private boolean _inCompleteCurrent;
    private final ViewSelector _viewSelector;
    protected final RcvMembersViewMap _rcvMembersView;
    private static TraceComponent TC = Tr.register(ViewReceiver.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    protected final PtpViewChannel _viewChannel;
    private final Repository _repository;
    private final ViewTopicNameAnalyzer _topicAnalyzer;
    static final int LAST_MSG_TYPE = 1;
    private RMMGroup _group;
    private final VRIMemberDescription _thisMember;
    private ViewIdImpl _curViewId;

    ViewReceiver(PtpViewChannel ptpViewChannel, Object object, ViewTopicNameAnalyzer viewTopicNameAnalyzer, DCSLogicalChannel dCSLogicalChannel, String string, VRIMemberDescription vRIMemberDescription, VRIMembersMGR vRIMembersMGR, ViewIdImpl viewIdImpl, ViewSelector viewSelector, long l, RMReceiver rMReceiver) {
        this._rmr = rMReceiver;
        this._memoryAlertOn = false;
        this._curViewId = viewIdImpl;
        this._viewChannel = ptpViewChannel;
        this._rcvMembersView = new RcvMembersViewMap(object, vRIMemberDescription.getName(), string, viewIdImpl, this, dCSLogicalChannel);
        this._stackMutex = object;
        this._channelType = dCSLogicalChannel;
        this._thisStackName = string;
        this._topicAnalyzer = viewTopicNameAnalyzer;
        this._repository = new Repository(vRIMemberDescription.getName(), string, dCSLogicalChannel);
        this._thisMember = vRIMemberDescription;
        this._mmgr = vRIMembersMGR;
        this._group = null;
        this._viewSelector = viewSelector;
        this._inCompleteCurrent = false;
        this.NEW_VIEW_SYNC_TIMEOUT = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(BaseVRIMessage baseVRIMessage) {
        Object object = this._stackMutex;
        synchronized (object) {
            try {
                Long l = new Long(baseVRIMessage.getSourceStreamID());
                RcvMembersViewMap.StreamStatus streamStatus = this._rcvMembersView.getStreamStatus(l);
                this.deliverMsg(baseVRIMessage, streamStatus);
            }
            catch (RuntimeException runtimeException) {
                this._viewChannel.onError(new TerminationEvent((DCSTraceContext)this, "onMessage()", runtimeException));
            }
        }
    }

    private void deliverMsg(BaseVRIMessage baseVRIMessage, RcvMembersViewMap.StreamStatus streamStatus) {
        switch (streamStatus.state) {
            case 1: {
                baseVRIMessage.changeSender(streamStatus.sender);
                if (this.handleLastMsg(baseVRIMessage, streamStatus.sender)) break;
                baseVRIMessage.changeSender(streamStatus.sender);
                this._viewChannel.onMessage(baseVRIMessage);
                break;
            }
            case 2: {
                if (DCSTraceBuffer.isDebugEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.debug(this, "deliverMsg", "");
                    dCSTraceBuffer.addProperty("StreamId", streamStatus.sid);
                    dCSTraceBuffer.addProperty("memberName", streamStatus.sender);
                    dCSTraceBuffer.addProperty("MemberStatus", streamStatus.state);
                    dCSTraceBuffer.invoke();
                }
                baseVRIMessage.changeSender(streamStatus.sender);
                this._repository.add(streamStatus.sender, streamStatus.vid, baseVRIMessage);
                break;
            }
            default: {
                if (!DCSTraceBuffer.isEventEnabled(TC)) break;
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "deliverMsg", "Got message on unknown stream");
                dCSTraceBuffer.addProperty("StreamId", streamStatus.sid);
                dCSTraceBuffer.invoke();
            }
        }
    }

    private boolean handleLastMsg(BaseVRIMessage baseVRIMessage, String string) {
        if (baseVRIMessage.getOriginatorLayer() != 1 || baseVRIMessage.getMessageType() != 1) {
            return false;
        }
        RMMHeader rMMHeader = (RMMHeader)baseVRIMessage.extractHeader(new RMMHeader(this._mmgr));
        if (rMMHeader == null) {
            ViewReceiverEvent viewReceiverEvent = new ViewReceiverEvent(1, baseVRIMessage.getSourceStreamID(), string, this._channelType, this, this._curViewId, (int)this.NEW_VIEW_SYNC_TIMEOUT);
            this._viewChannel.onEvent(viewReceiverEvent);
            return true;
        }
        Object[] objectArray = rMMHeader.getNewViewMembers();
        if (!VRIMemberUtils.contains((VRIMemberDescription[])objectArray, this._thisMember)) {
            ViewReceiverEvent viewReceiverEvent = new ViewReceiverEvent(2, baseVRIMessage.getSourceStreamID(), string, this._channelType, this, this._curViewId, (int)this.NEW_VIEW_SYNC_TIMEOUT);
            this._viewChannel.onEvent(viewReceiverEvent);
            return true;
        }
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty(this._channelType);
        dCSTraceBuffer.addProperty("Sender", string);
        dCSTraceBuffer.addProperty("viewMembers", Utils.toString(objectArray));
        this.focus("handleLastMsg", dCSTraceBuffer);
        this._rcvMembersView.senderSentLastMsg(string, baseVRIMessage.getSourceStreamID());
        this._group.rejectReceiverStream(baseVRIMessage.getSourceStreamID());
        return true;
    }

    String dump() {
        String string = "\n*************** ViewReceiver.dump: *******************\n";
        string = string + "Channel type: " + this._channelType + "\n";
        string = string + "Rcv Mem View=" + this._rcvMembersView.dump() + "\n";
        string = string + this._viewSelector.dump() + "\n";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(TransportGroupEvent transportGroupEvent) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "onEvent", "");
            ((DCSTraceBuffer)object).addProperty("Event", transportGroupEvent);
            ((DCSTraceBuffer)object).invoke();
        }
        object = null;
        RmmTransmitterEvent rmmTransmitterEvent = null;
        if (transportGroupEvent instanceof RmmReceiverEvent) {
            object = (RmmReceiverEvent)transportGroupEvent;
        } else if (transportGroupEvent instanceof RmmTransmitterEvent) {
            rmmTransmitterEvent = (RmmTransmitterEvent)transportGroupEvent;
        } else {
            this._viewChannel.onError(new TerminationEvent((DCSTraceContext)this, "onEvent", new TransportInternalException("ViewReceiver.onEvent:" + this._channelType + ":unknown event" + transportGroupEvent)));
            return;
        }
        Object object2 = this._stackMutex;
        synchronized (object2) {
            try {
                if (rmmTransmitterEvent != null) {
                    this._viewChannel.onEvent(rmmTransmitterEvent);
                    return;
                }
                if (((RmmReceiverEvent)object).isCongestion()) {
                    if (this.handleCongestionEvent((RmmReceiverEvent)object)) {
                        this._viewChannel.onEvent((TransportGroupEvent)object);
                    }
                    return;
                }
                this.handle((RmmReceiverEvent)object);
            }
            catch (RuntimeException runtimeException) {
                this._viewChannel.onError(new TerminationEvent((DCSTraceContext)this, "onEvent()", runtimeException));
            }
        }
    }

    private void handle(RmmReceiverEvent rmmReceiverEvent) {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("StreamId", rmmReceiverEvent.getStreamId());
        dCSTraceBuffer.addProperty("TopicName", rmmReceiverEvent.getTopicName());
        dCSTraceBuffer.addProperty(this._channelType);
        Long l = new Long(rmmReceiverEvent.getStreamId());
        RcvMembersViewMap.StreamStatus streamStatus = this._rcvMembersView.getStreamStatus(l);
        switch (streamStatus.state) {
            case 1: {
                rmmReceiverEvent.setSource(streamStatus.sender);
                this._viewChannel.onEvent(rmmReceiverEvent);
                break;
            }
            case 2: {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this, "ViewReceiver.handle()", "Save Future object");
                    dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                    dCSTraceBuffer2.invoke();
                }
                this._repository.add(streamStatus.sender, streamStatus.vid, rmmReceiverEvent);
                break;
            }
            default: {
                if (rmmReceiverEvent.getType() == 10) {
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.event(this, "handle", "Got NEW_SOURCE event");
                        dCSTraceBuffer3.addProperty("StreamId", streamStatus.sid);
                        dCSTraceBuffer3.invoke();
                    }
                    if (!this.handleNewSourceEvent(rmmReceiverEvent)) {
                        this._group.rejectReceiverStream(rmmReceiverEvent.getStreamId());
                        break;
                    }
                    this._viewChannel.onEvent(rmmReceiverEvent);
                    break;
                }
                if (!DCSTraceBuffer.isEventEnabled(TC)) break;
                DCSTraceBuffer dCSTraceBuffer4 = DCSTraceBuffer.event(this, "handle", "Got event on unknown stream");
                dCSTraceBuffer4.addProperty("StreamId", streamStatus.sid);
                dCSTraceBuffer4.invoke();
            }
        }
    }

    private boolean handleNewSourceEvent(RmmReceiverEvent rmmReceiverEvent) {
        DCSTraceable dCSTraceable;
        String string = rmmReceiverEvent.getTopicName();
        long l = rmmReceiverEvent.getStreamId();
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("StreamId", l);
        dCSTraceBuffer.addProperty("TopicName", string);
        dCSTraceBuffer.addProperty(this._channelType);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceable = DCSTraceBuffer.event(this, "handleNewSourceEvent", "");
            ((DCSTraceBuffer)dCSTraceable).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)dCSTraceable).invoke();
        }
        if ((dCSTraceable = this._topicAnalyzer.parseViewId(string)) == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.internalWarning(this, "View Receiver handles null view id", "ViewReceiver.handleNewSourceEvent()", null);
                dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer2.invoke();
            }
            return false;
        }
        dCSTraceBuffer.addProperty(dCSTraceable);
        String string2 = this._topicAnalyzer.parseSenderName(string);
        if (string2 == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.internalWarning(this, "View Receiver handles null sender", "ViewReceiver.handleNewSourceEvent()", null);
                dCSTraceBuffer3.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer3.invoke();
            }
            return false;
        }
        rmmReceiverEvent.setSource(string2);
        dCSTraceBuffer.addProperty("Sender", string2);
        boolean bl = this._rcvMembersView.addCandidate(string2, (ViewIdImpl)dCSTraceable, l);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer4 = DCSTraceBuffer.event(this, "handleNewSourceEvent", "");
            dCSTraceBuffer4.mergePropertyList(dCSTraceBuffer);
            dCSTraceBuffer4.addProperty("ReturnCode", bl);
            dCSTraceBuffer4.invoke();
        }
        return bl;
    }

    void deliverRepository(String[] stringArray, ViewIdImpl viewIdImpl) {
        Object object;
        Object object2;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("Senders", stringArray);
        dCSTraceBuffer.addProperty(viewIdImpl);
        dCSTraceBuffer.addProperty(this._channelType);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object2 = DCSTraceBuffer.event(this, "ViewReceiver.deliverRepository()", "Start Method");
            ((DCSTraceBuffer)object2).mergePropertyList(dCSTraceBuffer);
            ((DCSTraceBuffer)object2).addProperty("RepositoryState", this._repository);
            ((DCSTraceBuffer)object2).invoke();
        }
        if (viewIdImpl == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object2 = DCSTraceBuffer.internalWarning(this, "View Receiver ignores null view id in deliver repository", "ViewReceiver.deliverRepository()", null);
                ((DCSTraceBuffer)object2).mergePropertyList(dCSTraceBuffer);
                ((DCSTraceBuffer)object2).invoke();
            }
            return;
        }
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        object2 = new StringBuffer();
        LinkedList linkedList = this._repository.getQueued(stringArray, viewIdImpl, (StringBuffer)object2);
        dCSTraceBuffer.addProperty("Report", object2);
        dCSTraceBuffer.addProperty("NumOfQueuedObjects", linkedList.size());
        this.focus("deliverRepository", dCSTraceBuffer);
        while (!linkedList.isEmpty()) {
            Object object3;
            object = linkedList.removeFirst();
            if (object instanceof BaseVRIMessage) {
                object3 = (BaseVRIMessage)object;
                this.onMessage((BaseVRIMessage)object3);
                continue;
            }
            if (object instanceof RmmReceiverEvent) {
                object3 = (RmmReceiverEvent)object;
                this.onEvent((TransportGroupEvent)object3);
                continue;
            }
            this._viewChannel.onError(new TerminationEvent((DCSTraceContext)this, "deliverRepository()", new TransportInternalException("ViewReceiver.deliverRepository:" + this._channelType + ":unknown object" + object)));
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "ViewReceiver.deliverRepository()", "End Method");
            ((DCSTraceBuffer)object).invoke();
        }
    }

    void newView(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        this._curViewId = viewIdImpl;
        VRIMemberDescription[] vRIMemberDescriptionArray2 = VRIMemberUtils.minus(vRIMemberDescriptionArray, this._thisMember);
        Object[] objectArray = VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray2);
        this._viewSelector.newView((String[])objectArray, viewIdImpl);
        this._inCompleteCurrent = false;
        Set set = this._rcvMembersView.newView(TransportUtils.toHashSet(objectArray), viewIdImpl, map, this.NEW_VIEW_SYNC_TIMEOUT);
        if (this._group != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Long l = (Long)iterator.next();
                this._group.rejectReceiverStream(l);
            }
        }
    }

    public void onError(DCSTerminationEvent dCSTerminationEvent) {
        this._viewChannel.onError(dCSTerminationEvent);
    }

    public void synced() {
        this._viewChannel.synced();
    }

    public void setRmmGroup(RMMGroup rMMGroup) {
        this._group = rMMGroup;
    }

    void completeCurrent() {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "ViewReceiver.completeCurrent()", null);
            dCSTraceBuffer.addProperty("Flag", this._inCompleteCurrent);
            dCSTraceBuffer.addProperty(this._channelType);
            dCSTraceBuffer.invoke();
        }
        this._inCompleteCurrent = true;
        this._viewSelector.completeCurrent();
        this._rcvMembersView.completeCurrent();
    }

    void removeMember(String string) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this, "ViewReceiver.removeMemeber()", null);
            ((DCSTraceBuffer)object).addProperty("memberName", string);
            ((DCSTraceBuffer)object).invoke();
        }
        this._viewSelector.removeMember(string);
        object = this._rcvMembersView.removeMember(string);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            this._group.rejectReceiverStream(l);
        }
    }

    public void close() {
        this._rcvMembersView.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendersFailedConfirmNewView(ViewIdImpl viewIdImpl, Set set) {
        Object object = this._stackMutex;
        synchronized (object) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty(viewIdImpl);
            dCSTraceBuffer.addProperty("failedMembers", set.toString());
            dCSTraceBuffer.addProperty(this._channelType);
            dCSTraceBuffer.addProperty("Current", this._curViewId);
            this.focus("SendersFailedInNv", dCSTraceBuffer);
            if (!this._curViewId.equals(viewIdImpl)) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this, "ViewReceiver.sendersFailedConfirmNewView()", "Ignore not current view id");
                    dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                    dCSTraceBuffer2.invoke();
                }
                return;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this._viewChannel.onEvent(new ViewReceiverEvent(3, string, this._channelType, this, this._curViewId, (int)this.NEW_VIEW_SYNC_TIMEOUT));
            }
        }
    }

    private String getHeaviestSender(MemoryReport memoryReport) {
        MemoryReport.MemorySource memorySource = memoryReport.getHeaviestUser();
        String string = memorySource.getTopicName();
        return this._topicAnalyzer.parseSenderName(string);
    }

    private boolean handleCongestionEvent(RmmReceiverEvent rmmReceiverEvent) {
        Object object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty("RmmEvent", rmmReceiverEvent.getDescription());
        dCSTraceBuffer.addProperty(this._channelType);
        if (!rmmReceiverEvent.isCongestion()) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.internalWarning(this, "the View Receiver Handle congestion event got a non-congestion event", "ViewReceiver.handleCongestionEvent()", null);
                dCSTraceBuffer2.mergePropertyList(dCSTraceBuffer);
                dCSTraceBuffer2.invoke();
            }
            return false;
        }
        String string = null;
        boolean bl = false;
        switch (rmmReceiverEvent.getType()) {
            case 101: {
                bl = true;
            }
            case 100: {
                object = this._rmr.checkMemoryConsumption();
                string = this.getHeaviestSender((MemoryReport)object);
                this.setMemoryInternalDetails((MemoryReport)object, rmmReceiverEvent);
                break;
            }
            case 103: {
                string = this._topicAnalyzer.parseSenderName(rmmReceiverEvent.getTopicName());
                object = this._rmr.checkMemoryConsumption();
                this.setMemoryInternalDetails((MemoryReport)object, rmmReceiverEvent);
                break;
            }
            case 102: {
                if (this._memoryAlertOn) {
                    this._memoryAlertOn = false;
                    return true;
                }
                return false;
            }
            default: {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.internalWarning(this, "Unknown congestion event", "ViewReceiver.handleCongestionEvent()", null);
                    dCSTraceBuffer3.mergePropertyList(dCSTraceBuffer);
                    dCSTraceBuffer3.addProperty("TypeCode", rmmReceiverEvent.getType());
                    dCSTraceBuffer3.invoke();
                }
                return false;
            }
        }
        if (string == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                object = DCSTraceBuffer.internalWarning(this, "ViewReceiver.handleCongestionEvent: Cant get source name of congestion event", "ViewReceiver.handleCongestionEvent()", null);
                ((DCSTraceBuffer)object).mergePropertyList(dCSTraceBuffer);
                ((DCSTraceBuffer)object).invoke();
            }
            return false;
        }
        rmmReceiverEvent.setSource(string);
        if (bl) {
            this._memoryAlertOn = true;
        }
        return true;
    }

    private void setMemoryInternalDetails(MemoryReport memoryReport, RmmReceiverEvent rmmReceiverEvent) {
        long l = memoryReport.getDynamicMemoryLimit();
        long l2 = memoryReport.getStaticMemoryLimit();
        MemoryReport.MemoryUsed memoryUsed = memoryReport.getHeaviestUserMemory();
        long l3 = memoryUsed.getCurrentUsageFifoQ();
        long l4 = memoryUsed.getCurrentUsageMessageQ();
        Properties properties = new Properties();
        properties.put("DynamicMemoryLimit", new Long(l));
        properties.put("StaticMemoryLimit", new Long(l2));
        properties.put("HeaviestUserFifoQ", new Long(l3));
        properties.put("HeaviestUserMsgQ", new Long(l4));
        properties.put("ReceiverChannel", this._channelType.toString());
        rmmReceiverEvent.setDetails(properties);
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._thisStackName;
    }

    public String getMemberName() {
        return this._thisMember.getName();
    }

    public String getLayerName() {
        return TransportAdapter.TA_LAYER_NAME;
    }

    private void sendersConfirmedNewView(ViewIdImpl viewIdImpl) {
        ConfirmedNewViewEvent confirmedNewViewEvent = new ConfirmedNewViewEvent((DCSTraceContext)this, viewIdImpl, this._channelType);
        confirmedNewViewEvent.invokeNLSTrace();
    }

    public void focus(String string, DCSTraceBuffer dCSTraceBuffer) {
        this._viewChannel.focus(string, dCSTraceBuffer);
    }

    public void focus(String string) {
        this._viewChannel.focus(string);
    }

    public void focus(String string, String string2, DCSTraceBuffer dCSTraceBuffer) {
        this._viewChannel.focus(string, string2, dCSTraceBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newViewOK(Set set, Set set2, ViewIdImpl viewIdImpl, Set set3) {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.addProperty(viewIdImpl);
        dCSTraceBuffer.addProperty("nvMembersSucceed", set);
        dCSTraceBuffer.addProperty("nvMembersFailed", set2);
        this.focus("newViewOK", dCSTraceBuffer);
        set.add(this._thisMember.getName());
        String[] stringArray = new String[set.size()];
        stringArray = set.toArray(stringArray);
        Object object = this._stackMutex;
        synchronized (object) {
            if (set2.isEmpty()) {
                this.sendersConfirmedNewView(viewIdImpl);
            } else {
                this.sendersFailedConfirmNewView(viewIdImpl, set2);
            }
            this._repository.clean(stringArray, viewIdImpl);
            this._viewChannel.newViewOK(viewIdImpl, stringArray);
        }
    }
}

